/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMReadFromForeignObjectNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMWriteToForeignObjectNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

abstract class LLVMManagedAccessDefaults {
    LLVMManagedAccessDefaults() {
    }

    @ExportLibrary.Repeat(value={@ExportLibrary(value=LLVMManagedReadLibrary.class, receiverType=byte[].class, useForAOT=false), @ExportLibrary(value=LLVMManagedWriteLibrary.class, receiverType=byte[].class, useForAOT=false)})
    static class VirtualAlloc {
        VirtualAlloc() {
        }

        private static int checkOffset(long offset) throws IndexOutOfBoundsException {
            int io = (int)offset;
            if ((long)io == offset) {
                return io;
            }
            throw new IndexOutOfBoundsException();
        }

        @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
        static boolean isAccessible(byte[] obj) {
            return true;
        }

        @ExportMessage
        static byte readI8(byte[] obj, long offset, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            try {
                return LLVMLanguage.get((Node)self).getByteArraySupport().getByte(obj, VirtualAlloc.checkOffset(offset));
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)self, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
            }
        }

        @ExportMessage
        static short readI16(byte[] obj, long offset, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            try {
                return LLVMLanguage.get((Node)self).getByteArraySupport().getShort(obj, VirtualAlloc.checkOffset(offset));
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)self, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
            }
        }

        @ExportMessage
        static int readI32(byte[] obj, long offset, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            try {
                return LLVMLanguage.get((Node)self).getByteArraySupport().getInt(obj, VirtualAlloc.checkOffset(offset));
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)self, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
            }
        }

        @ExportMessage(name="readGenericI64")
        static long readI64(byte[] obj, long offset, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            try {
                return LLVMLanguage.get((Node)self).getByteArraySupport().getLong(obj, VirtualAlloc.checkOffset(offset));
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)self, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
            }
        }

        @ExportMessage
        static float readFloat(byte[] obj, long offset, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            try {
                return LLVMLanguage.get((Node)self).getByteArraySupport().getFloat(obj, VirtualAlloc.checkOffset(offset));
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)self, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
            }
        }

        @ExportMessage
        static double readDouble(byte[] obj, long offset, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            try {
                return LLVMLanguage.get((Node)self).getByteArraySupport().getDouble(obj, VirtualAlloc.checkOffset(offset));
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)self, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
            }
        }

        @ExportMessage
        static LLVMPointer readPointer(byte[] obj, long offset, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            return LLVMNativePointer.create(VirtualAlloc.readI64(obj, offset, self, exception));
        }

        @ExportMessage
        static void writeI8(byte[] obj, long offset, byte value, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            try {
                LLVMLanguage.get((Node)self).getByteArraySupport().putByte(obj, VirtualAlloc.checkOffset(offset), value);
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)self, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
            }
        }

        @ExportMessage
        static void writeI16(byte[] obj, long offset, short value, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            try {
                LLVMLanguage.get((Node)self).getByteArraySupport().putShort(obj, VirtualAlloc.checkOffset(offset), value);
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)self, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
            }
        }

        @ExportMessage
        static void writeI32(byte[] obj, long offset, int value, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            try {
                LLVMLanguage.get((Node)self).getByteArraySupport().putInt(obj, VirtualAlloc.checkOffset(offset), value);
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)self, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
            }
        }

        @ExportMessage
        static void writeI64(byte[] obj, long offset, long value, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            try {
                LLVMLanguage.get((Node)self).getByteArraySupport().putLong(obj, VirtualAlloc.checkOffset(offset), value);
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)self, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
            }
        }

        @ExportMessage
        static void writeFloat(byte[] obj, long offset, float value, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            try {
                LLVMLanguage.get((Node)self).getByteArraySupport().putFloat(obj, VirtualAlloc.checkOffset(offset), value);
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)self, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
            }
        }

        @ExportMessage
        static void writeDouble(byte[] obj, long offset, double value, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
            try {
                LLVMLanguage.get((Node)self).getByteArraySupport().putDouble(obj, VirtualAlloc.checkOffset(offset), value);
            }
            catch (IndexOutOfBoundsException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)self, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
            }
        }

        @ExportMessage
        static class WriteGenericI64 {
            WriteGenericI64() {
            }

            private static void writeLong(byte[] obj, long offset, long value, Node pos, BranchProfile exception, LLVMLanguage language) {
                try {
                    language.getByteArraySupport().putLong(obj, VirtualAlloc.checkOffset(offset), value);
                }
                catch (IndexOutOfBoundsException ex) {
                    exception.enter();
                    throw new LLVMPolyglotException(pos, "Out-of-bounds access: offset=%d, size=%d", offset, obj.length);
                }
            }

            @Specialization
            static void writeI64(byte[] obj, long offset, long value, @CachedLibrary(value="obj") LLVMManagedWriteLibrary self, @Cached.Shared(value="exception") @Cached BranchProfile exception) {
                WriteGenericI64.writeLong(obj, offset, value, (Node)self, exception, LLVMLanguage.get((Node)self));
            }

            @Specialization
            static void writePointer(byte[] obj, long offset, LLVMPointer value, @Cached LLVMNativePointerSupport.ToNativePointerNode toNativePointer, @Cached.Exclusive @Cached BranchProfile exception) {
                LLVMNativePointer nativeValue = toNativePointer.execute(value);
                WriteGenericI64.writeLong(obj, offset, nativeValue.asNative(), toNativePointer, exception, LLVMLanguage.get(toNativePointer));
            }
        }
    }

    @ExportLibrary(value=LLVMManagedWriteLibrary.class, receiverType=Object.class, useForAOT=false)
    static class FallbackWrite {
        FallbackWrite() {
        }

        @ExportMessage
        static boolean isWritable(Object obj, @CachedLibrary(limit="5") InteropLibrary interop) {
            return interop.accepts(obj);
        }

        @ExportMessage
        static void writeI8(Object obj, long offset, byte value, @Cached LLVMWriteToForeignObjectNode.ForeignWriteI8Node write) {
            write.execute(obj, offset, value);
        }

        @ExportMessage
        static void writeI16(Object obj, long offset, short value, @Cached LLVMWriteToForeignObjectNode.ForeignWriteI16Node write) {
            write.execute(obj, offset, value);
        }

        @ExportMessage
        static void writeI32(Object obj, long offset, int value, @Cached LLVMWriteToForeignObjectNode.ForeignWriteI32Node write) {
            write.execute(obj, offset, value);
        }

        @ExportMessage
        static void writeI64(Object obj, long offset, long value, @Cached.Shared(value="writeI64") @Cached LLVMWriteToForeignObjectNode.ForeignWriteI64Node write) {
            write.executeLong(obj, offset, value);
        }

        @ExportMessage
        static void writeGenericI64(Object obj, long offset, Object value, @Cached.Shared(value="writeI64") @Cached LLVMWriteToForeignObjectNode.ForeignWriteI64Node write) {
            write.execute(obj, offset, value);
        }

        @ExportMessage
        static void writeFloat(Object obj, long offset, float value, @Cached LLVMWriteToForeignObjectNode.ForeignWriteFloatNode write) {
            write.execute(obj, offset, value);
        }

        @ExportMessage
        static void writeDouble(Object obj, long offset, double value, @Cached LLVMWriteToForeignObjectNode.ForeignWriteDoubleNode write) {
            write.execute(obj, offset, value);
        }

        @ExportMessage
        static void writePointer(Object obj, long offset, LLVMPointer value, @Cached.Shared(value="writeI64") @Cached LLVMWriteToForeignObjectNode.ForeignWriteI64Node write) {
            write.executePointer(obj, offset, value);
        }
    }

    @ExportLibrary(value=LLVMManagedReadLibrary.class, receiverType=Object.class, useForAOT=false)
    static class FallbackRead {
        FallbackRead() {
        }

        @ExportMessage
        static boolean isReadable(Object obj, @CachedLibrary(value="obj") InteropLibrary interop) {
            return interop.accepts(obj);
        }

        @ExportMessage
        static byte readI8(Object obj, long offset, @Cached LLVMReadFromForeignObjectNode.ForeignReadI8Node readNode) {
            return readNode.execute(obj, offset);
        }

        @ExportMessage
        static short readI16(Object obj, long offset, @Cached LLVMReadFromForeignObjectNode.ForeignReadI16Node readNode) {
            return readNode.execute(obj, offset);
        }

        @ExportMessage
        static int readI32(Object obj, long offset, @Cached LLVMReadFromForeignObjectNode.ForeignReadI32Node readNode) {
            return readNode.execute(obj, offset);
        }

        @ExportMessage
        static long readI64(Object obj, long offset, @Cached.Shared(value="readI64") @Cached LLVMReadFromForeignObjectNode.ForeignReadI64Node readNode) throws UnexpectedResultException {
            return readNode.executeLong(obj, offset);
        }

        @ExportMessage
        static Object readGenericI64(Object obj, long offset, @Cached.Shared(value="readI64") @Cached LLVMReadFromForeignObjectNode.ForeignReadI64Node readNode) {
            return readNode.execute(obj, offset);
        }

        @ExportMessage
        static float readFloat(Object obj, long offset, @Cached LLVMReadFromForeignObjectNode.ForeignReadFloatNode readNode) {
            return readNode.execute(obj, offset);
        }

        @ExportMessage
        static double readDouble(Object obj, long offset, @Cached LLVMReadFromForeignObjectNode.ForeignReadDoubleNode readNode) {
            return readNode.execute(obj, offset);
        }

        @ExportMessage
        static LLVMPointer readPointer(Object obj, long offset, @Cached LLVMReadFromForeignObjectNode.ForeignReadPointerNode readNode) {
            return readNode.execute(obj, offset);
        }
    }
}

