/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.value;

public final class LLVMDebugTypeConstants {
    public static final int BOOLEAN_SIZE = 1;
    public static final int BYTE_SIZE = 8;
    public static final int SHORT_SIZE = 16;
    public static final int INTEGER_SIZE = 32;
    public static final int LONG_SIZE = 64;
    public static final String BOOLEAN_NAME = "boolean";
    public static final String BYTE_NAME = "byte";
    public static final String SHORT_NAME = "short";
    public static final String INTEGER_NAME = "integer";
    public static final String LONG_NAME = "long";
    public static final int ADDRESS_SIZE = 64;
    public static final String ADDRESS_NAME = "address";
    public static final int FLOAT_SIZE = 32;
    public static final int DOUBLE_SIZE = 64;
    public static final int LLVM80BIT_SIZE_SUGGESTED = 128;
    public static final int LLVM80BIT_SIZE_ACTUAL = 80;
    public static final String FLOAT_NAME = "float";
    public static final String DOUBLE_NAME = "double";
    public static final String LLVM80BIT_NAME = "80bit float";

    public static String getIntegerKind(int size, boolean signed) {
        Object typeName = switch (size) {
            case 8 -> BYTE_NAME;
            case 16 -> SHORT_NAME;
            case 64 -> LONG_NAME;
            default -> INTEGER_NAME;
        };
        typeName = "signed " + (String)typeName;
        if (!signed) {
            typeName = "un" + (String)typeName;
        }
        return typeName;
    }

    private LLVMDebugTypeConstants() {
    }
}

