/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

public abstract class DebugExprTypeofNode
extends LLVMExpressionNode {
    private final String name;
    private final Node location;

    public DebugExprTypeofNode(String name, Node location) {
        this.name = name;
        this.location = location;
    }

    @Specialization
    public LLVMSourceType getLLVMSourceType(VirtualFrame frame) {
        NodeLibrary nodeLibrary = NodeLibrary.getUncached();
        InteropLibrary interopLibrary = InteropLibrary.getUncached();
        try {
            LLVMDebuggerValue entries = (LLVMDebuggerValue)nodeLibrary.getScope((Object)this.location, (Frame)frame, false);
            if (interopLibrary.isMemberReadable((Object)entries, this.name)) {
                Object member = interopLibrary.readMember((Object)entries, this.name);
                LLVMDebuggerValue ldv = (LLVMDebuggerValue)member;
                Object metaObj = ldv.resolveMetaObject();
                return (LLVMSourceType)metaObj;
            }
        }
        catch (ClassCastException e) {
            throw DebugExprException.create(this, "\"%s\" cannot be casted to a LLVMDebuggerValue", this.name);
        }
        catch (UnsupportedMessageException e) {
            throw DebugExprException.symbolNotFound(this, this.name, null);
        }
        catch (UnknownIdentifierException e) {
            throw DebugExprException.symbolNotFound(this, e.getUnknownIdentifier(), null);
        }
        return LLVMSourceType.UNKNOWN;
    }

    public DebugExprType getType(VirtualFrame frame) {
        return DebugExprType.getTypeFromSymbolTableMetaObject(this.getLLVMSourceType(frame));
    }

    public String getName() {
        return this.name;
    }
}

