/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprTernaryNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=DebugExprTernaryNode.class)
public final class DebugExprTernaryNodeGen
extends DebugExprTernaryNode
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMExpressionNode condition_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private DebugExprTernaryNodeGen(LLVMExpressionNode thenNode, LLVMExpressionNode elseNode, LLVMExpressionNode condition) {
        super(thenNode, elseNode);
        this.condition_ = condition;
    }

    private boolean fallbackGuard_(int state_0, Object conditionValue) {
        if ((state_0 & 2) == 0 && conditionValue instanceof Boolean) {
            return false;
        }
        if ((state_0 & 4) == 0 && conditionValue instanceof Integer) {
            return false;
        }
        return (state_0 & 8) != 0 || !(conditionValue instanceof Long);
    }

    @Override
    public Object executeWithTarget(VirtualFrame frameValue, Object conditionValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(frameValue, conditionValue);
        }
        if ((state_0 & 0x1E) != 0) {
            if ((state_0 & 2) != 0 && conditionValue instanceof Boolean) {
                boolean conditionValue_ = (Boolean)conditionValue;
                return this.doTernary(frameValue, conditionValue_);
            }
            if ((state_0 & 4) != 0 && conditionValue instanceof Integer) {
                int conditionValue_ = (Integer)conditionValue;
                return this.doTernary(frameValue, conditionValue_);
            }
            if ((state_0 & 8) != 0 && conditionValue instanceof Long) {
                long conditionValue_ = (Long)conditionValue;
                return this.doTernary(frameValue, conditionValue_);
            }
            if ((state_0 & 0x10) != 0 && this.fallbackGuard_(state_0, conditionValue)) {
                return this.doError(conditionValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, conditionValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1C) == 0 && (state_0 & 0x1E) != 0) {
            return this.executeGeneric_boolean0(state_0, frameValue);
        }
        if ((state_0 & 0x1A) == 0 && (state_0 & 0x1E) != 0) {
            return this.executeGeneric_int1(state_0, frameValue);
        }
        if ((state_0 & 0x16) == 0 && (state_0 & 0x1E) != 0) {
            return this.executeGeneric_long2(state_0, frameValue);
        }
        return this.executeGeneric_generic3(state_0, frameValue);
    }

    private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
        boolean conditionValue_;
        int state_0 = state_0__;
        try {
            conditionValue_ = this.condition_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(frameValue, conditionValue_);
        }
        assert ((state_0 & 2) != 0);
        return this.doTernary(frameValue, conditionValue_);
    }

    private Object executeGeneric_int1(int state_0__, VirtualFrame frameValue) {
        int conditionValue_;
        int state_0 = state_0__;
        try {
            conditionValue_ = this.condition_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(frameValue, conditionValue_);
        }
        assert ((state_0 & 4) != 0);
        return this.doTernary(frameValue, conditionValue_);
    }

    private Object executeGeneric_long2(int state_0__, VirtualFrame frameValue) {
        long conditionValue_;
        int state_0 = state_0__;
        try {
            conditionValue_ = this.condition_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(frameValue, conditionValue_);
        }
        assert ((state_0 & 8) != 0);
        return this.doTernary(frameValue, conditionValue_);
    }

    private Object executeGeneric_generic3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object conditionValue_ = this.condition_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(frameValue, conditionValue_);
        }
        if ((state_0 & 0x1E) != 0) {
            if ((state_0 & 2) != 0 && conditionValue_ instanceof Boolean) {
                boolean conditionValue__ = (Boolean)conditionValue_;
                return this.doTernary(frameValue, conditionValue__);
            }
            if ((state_0 & 4) != 0 && conditionValue_ instanceof Integer) {
                int conditionValue__ = (Integer)conditionValue_;
                return this.doTernary(frameValue, conditionValue__);
            }
            if ((state_0 & 8) != 0 && conditionValue_ instanceof Long) {
                long conditionValue__ = (Long)conditionValue_;
                return this.doTernary(frameValue, conditionValue__);
            }
            if ((state_0 & 0x10) != 0 && this.fallbackGuard_(state_0, conditionValue_)) {
                return this.doError(conditionValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, conditionValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object conditionValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (conditionValue instanceof Boolean) {
            boolean conditionValue_ = (Boolean)conditionValue;
            this.state_0_ = state_0 |= 2;
            return this.doTernary(frameValue, conditionValue_);
        }
        if (conditionValue instanceof Integer) {
            int conditionValue_ = (Integer)conditionValue;
            this.state_0_ = state_0 |= 4;
            return this.doTernary(frameValue, conditionValue_);
        }
        if (conditionValue instanceof Long) {
            long conditionValue_ = (Long)conditionValue;
            this.state_0_ = state_0 |= 8;
            return this.doTernary(frameValue, conditionValue_);
        }
        this.state_0_ = state_0 |= 0x10;
        return this.doError(conditionValue);
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1E) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x1E & (state_0 & 0x1E) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        this.state_0_ |= 8;
        this.state_0_ |= 0x10;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static DebugExprTernaryNode create(LLVMExpressionNode thenNode, LLVMExpressionNode elseNode, LLVMExpressionNode condition) {
        return new DebugExprTernaryNodeGen(thenNode, elseNode, condition);
    }
}

