/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public class LLVMThreadLocalPointer {
    private final LLVMSymbol symbol;
    private final int offset;

    public LLVMThreadLocalPointer(LLVMSymbol symbol, int offset) {
        this.symbol = symbol;
        this.offset = offset;
    }

    public LLVMSymbol getSymbol() {
        return this.symbol;
    }

    public boolean isManaged() {
        return this.offset < 0;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return this.symbol.toString();
    }

    public LLVMPointer resolve(LLVMLanguage language, BranchProfile exception) {
        return this.resolveWithThreadContext((LLVMLanguage.LLVMThreadLocalValue)language.contextThreadLocal.get(), exception);
    }

    public LLVMPointer resolveWithThreadContext(LLVMLanguage.LLVMThreadLocalValue contextThreadLocal, BranchProfile exception) {
        IDGenerater.BitcodeID bitcodeID = this.getSymbol().getBitcodeID(exception);
        if (this.isManaged()) {
            LLVMGlobalContainer container = contextThreadLocal.getGlobalContainer(Math.abs(this.offset), bitcodeID);
            return LLVMManagedPointer.create(container);
        }
        LLVMPointer base = contextThreadLocal.getSectionBase(bitcodeID);
        if (base == null) {
            throw new LLVMIllegalSymbolIndexException("Section base for thread local global is null");
        }
        return base.increment(this.getOffset());
    }
}

