/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;

@CompilerDirectives.ValueType
public final class LLVMIVarBitLarge
extends LLVMIVarBit {
    private final int bits;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] array;

    private LLVMIVarBitLarge(int bits, byte[] arr) {
        this.bits = bits;
        this.array = arr;
        assert (bits > 64);
        assert (this.getByteSize() == arr.length);
    }

    LLVMIVarBitLarge(int bits, byte[] arr, int arrBits, boolean signExtend) {
        this.bits = bits;
        this.array = new byte[this.getByteSize()];
        if (this.getByteSize() >= arr.length) {
            System.arraycopy(arr, 0, this.array, this.getByteSize() - arr.length, arr.length);
        } else {
            System.arraycopy(arr, arr.length - this.getByteSize(), this.array, 0, this.array.length);
        }
        if (bits > arrBits && bits % 8 != 0) {
            boolean isNegative = signExtend && (arr[0] & 1 << (bits - 1) % 8) != 0;
            this.array[0] = isNegative ? (byte)(this.array[0] | (byte)(255 << bits % 8)) : (byte)(this.array[0] & (byte)(255 >>> 8 - bits % 8));
        }
        assert (bits > 64);
        assert (this.getByteSize() == this.array.length);
    }

    @Override
    public LLVMIVarBitLarge copy() {
        if (CompilerDirectives.inCompiledCode()) {
            return new LLVMIVarBitLarge(this.bits, this.array);
        }
        return this;
    }

    private int getByteSize() {
        return LLVMIVarBitLarge.getByteSize(this.bits);
    }

    public static int getByteSize(int bits) {
        assert (bits > 0);
        return (bits + 8 - 1) / 8;
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger asBigInteger(LLVMIVarBit right) {
        return ((LLVMIVarBitLarge)right).asBigInteger();
    }

    @CompilerDirectives.TruffleBoundary
    public BigInteger asUnsignedBigInteger() {
        if (this.array.length == 0) {
            return BigInteger.ZERO;
        }
        byte[] newArr = new byte[this.array.length + 1];
        System.arraycopy(this.array, 0, newArr, 1, this.array.length);
        return new BigInteger(newArr);
    }

    @CompilerDirectives.TruffleBoundary
    public BigInteger asBigInteger() {
        if (this.array.length != 0) {
            return new BigInteger(this.array);
        }
        return BigInteger.ZERO;
    }

    @CompilerDirectives.TruffleBoundary
    private ByteBuffer getByteBuffer(int minSizeBytes, boolean signExtend) {
        boolean shouldAddLeadingOnes;
        int allocationSize = Math.max(minSizeBytes, this.getByteSize());
        ByteBuffer bb = ByteBuffer.allocate(allocationSize).order(ByteOrder.BIG_ENDIAN);
        boolean truncation = this.bits > minSizeBytes * 8;
        boolean bl = shouldAddLeadingOnes = signExtend && this.mostSignificantBit();
        if (!truncation) {
            int bytesToFillUp = minSizeBytes - this.getByteSize();
            if (shouldAddLeadingOnes) {
                for (i = 0; i < bytesToFillUp; ++i) {
                    bb.put((byte)-1);
                }
            } else {
                for (i = 0; i < bytesToFillUp; ++i) {
                    bb.put((byte)0);
                }
            }
        }
        if (this.bits % 8 == 0) {
            bb.put(this.array, 0, this.getByteSize());
        } else {
            int i;
            BitSet bitSet = new BitSet(8);
            int bitsToSet = this.bits % 8;
            for (i = 0; i < bitsToSet; ++i) {
                boolean isBitSet;
                boolean bl2 = isBitSet = (this.array[0] >> i & 1) == 1;
                if (!isBitSet) continue;
                bitSet.set(i);
            }
            if (shouldAddLeadingOnes) {
                for (i = bitsToSet; i < 8; ++i) {
                    bitSet.set(i);
                }
            }
            byte firstByteResult = bitSet.isEmpty() ? (byte)0 : bitSet.toByteArray()[0];
            bb.put(firstByteResult);
            for (int i2 = 1; i2 < this.array.length; ++i2) {
                bb.put(this.array[i2]);
            }
        }
        bb.position(Math.max(0, this.getByteSize() - minSizeBytes));
        return bb;
    }

    private boolean mostSignificantBit() {
        return this.getBit(this.bits - 1);
    }

    private boolean getBit(int pos) {
        int selectedBytePos = this.array.length - 1 - pos / 8;
        byte selectedByte = this.array[selectedBytePos];
        int selectedBitPos = pos % 8;
        return (selectedByte >> selectedBitPos & 1) == 1;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public byte getByteValue() {
        return this.getByteBuffer(1, true).get();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public byte getZeroExtendedByteValue() {
        return this.getByteBuffer(1, false).get();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public short getShortValue() {
        return this.getByteBuffer(2, true).getShort();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public short getZeroExtendedShortValue() {
        return this.getByteBuffer(2, false).getShort();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getIntValue() {
        return this.getByteBuffer(4, true).getInt();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getZeroExtendedIntValue() {
        return this.getByteBuffer(4, false).getInt();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long getLongValue() {
        return this.getByteBuffer(8, true).getLong();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long getZeroExtendedLongValue() {
        return this.getByteBuffer(8, false).getLong();
    }

    @Override
    public int getBitSize() {
        return this.bits;
    }

    @Override
    public byte[] getBytes() {
        assert (this.array.length == this.getByteSize()) : this.array.length + " " + this.getByteSize();
        return this.array;
    }

    @CompilerDirectives.TruffleBoundary
    public byte[] getSignExtendedBytes() {
        return this.getByteBuffer(this.array.length, true).array();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitLarge add(LLVMIVarBit right) {
        return this.asIVar(this.asBigInteger().add(LLVMIVarBitLarge.asBigInteger(right)));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitLarge mul(LLVMIVarBit right) {
        return this.asIVar(this.asBigInteger().multiply(LLVMIVarBitLarge.asBigInteger(right)));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitLarge sub(LLVMIVarBit right) {
        return this.asIVar(this.asBigInteger().subtract(LLVMIVarBitLarge.asBigInteger(right)));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitLarge div(LLVMIVarBit right) {
        return this.asIVar(this.asBigInteger().divide(LLVMIVarBitLarge.asBigInteger(right)));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitLarge rem(LLVMIVarBit right) {
        return this.asIVar(this.asBigInteger().remainder(LLVMIVarBitLarge.asBigInteger(right)));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitLarge unsignedRem(LLVMIVarBit right) {
        return this.asIVar(this.asUnsignedBigInteger().remainder(LLVMIVarBitLarge.asBigInteger(right)));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitLarge unsignedDiv(LLVMIVarBit right) {
        return this.asIVar(this.asUnsignedBigInteger().divide(LLVMIVarBitLarge.asBigInteger(right)));
    }

    @Override
    public boolean isEqual(LLVMIVarBit o) {
        LLVMIVarBitLarge other = (LLVMIVarBitLarge)o;
        int thisWidth = this.bits;
        int otherWidth = other.bits;
        if (thisWidth != otherWidth) {
            return false;
        }
        byte[] otherArr = other.getBytes();
        for (int i = 0; i < this.getByteSize() - 1; ++i) {
            int diff = this.array[i] - otherArr[i];
            if (diff == 0) continue;
            return false;
        }
        byte thisByte = this.array[this.getByteSize() - 1];
        byte otherByte = otherArr[this.getByteSize() - 1];
        int maskLength = 8 - (this.getByteSize() * 8 - this.bits);
        byte mask = (byte)((1 << maskLength) - 1 & 0xFF);
        return (thisByte & mask) == (otherByte & mask);
    }

    private LLVMIVarBitLarge performOp(LLVMIVarBit r, SimpleOp op) {
        LLVMIVarBitLarge right = (LLVMIVarBitLarge)r;
        assert (this.bits == right.bits);
        byte[] newArr = new byte[this.getByteSize()];
        byte[] other = right.getBytes();
        assert (this.array.length == other.length) : Arrays.toString(this.array) + " " + Arrays.toString(other);
        for (int i = 0; i < newArr.length; ++i) {
            newArr[i] = op.op(this.array[i], other[i]);
        }
        return new LLVMIVarBitLarge(this.bits, newArr);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitLarge and(LLVMIVarBit right) {
        return this.performOp(right, (a, b) -> (byte)(a & b));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitLarge or(LLVMIVarBit right) {
        return this.performOp(right, (a, b) -> (byte)(a | b));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitLarge xor(LLVMIVarBit right) {
        return this.performOp(right, (a, b) -> (byte)(a ^ b));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitLarge leftShift(LLVMIVarBit right) {
        BigInteger result = this.asBigInteger().shiftLeft(right.getIntValue());
        return LLVMIVarBitLarge.asIVar(this.bits, result);
    }

    @CompilerDirectives.TruffleBoundary
    private LLVMIVarBitLarge asIVar(BigInteger result) {
        return LLVMIVarBitLarge.asIVar(this.bits, result);
    }

    static LLVMIVarBitLarge asIVar(int bitSize, BigInteger result) {
        byte[] bigIntArr;
        byte[] newArr = new byte[LLVMIVarBitLarge.getByteSize(bitSize)];
        if (newArr.length > (bigIntArr = result.toByteArray()).length) {
            int j;
            for (j = diff = newArr.length - bigIntArr.length; j < newArr.length; ++j) {
                newArr[j] = bigIntArr[j - diff];
            }
            for (j = 0; j < diff; ++j) {
                newArr[j] = bigIntArr[0] < 0 ? -1 : 0;
            }
        } else {
            diff = bigIntArr.length - newArr.length;
            for (int j = 0; j < newArr.length; ++j) {
                newArr[j] = bigIntArr[j + diff];
            }
        }
        int resultLengthIncludingSign = result.bitLength() + (result.signum() == -1 ? 1 : 0);
        return new LLVMIVarBitLarge(bitSize, newArr, resultLengthIncludingSign, result.signum() == -1);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBit logicalRightShift(LLVMIVarBit right) {
        int shiftAmount = right.getIntValue();
        BigInteger mask = BigInteger.valueOf(-1L).shiftLeft(this.bits - shiftAmount).not();
        BigInteger result = new BigInteger(this.array).shiftRight(shiftAmount).and(mask);
        return this.asIVar(result);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBit arithmeticRightShift(LLVMIVarBit right) {
        BigInteger result = this.asBigInteger().shiftRight(right.getIntValue());
        return this.asIVar(result);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int signedCompare(LLVMIVarBit other) {
        return this.asBigInteger().compareTo(((LLVMIVarBitLarge)other).asBigInteger());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int unsignedCompare(LLVMIVarBit other) {
        return this.asUnsignedBigInteger().compareTo(((LLVMIVarBitLarge)other).asUnsignedBigInteger());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isZero() {
        return this.array.length == 0 || BigInteger.ZERO.equals(this.asBigInteger());
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (this.isZero()) {
            return Integer.toString(0);
        }
        return String.format("i%d %s", this.getBitSize(), this.asBigInteger().toString());
    }

    @Override
    public BigInteger getDebugValue(boolean signed) {
        if (signed) {
            return this.asBigInteger();
        }
        return this.asUnsignedBigInteger();
    }

    private static interface SimpleOp {
        public byte op(byte var1, byte var2);
    }
}

