/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalSymbol;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.function.Supplier;

public final class LLVMElemPtrSymbol
extends LLVMSymbol {
    private final Type type;
    private final Supplier<LLVMExpressionNode> createGetElementPtrNode;

    public LLVMElemPtrSymbol(String name, IDGenerater.BitcodeID bitcodeID, int symbolIndex, boolean exported, Type type, LLVMSymbol base, Supplier<LLVMExpressionNode> createGetElementPtrNode) {
        super(name, bitcodeID, symbolIndex, exported, base.isExternalWeak());
        this.type = type;
        this.createGetElementPtrNode = createGetElementPtrNode;
    }

    @Override
    public boolean isGlobalVariable() {
        return false;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isAlias() {
        return false;
    }

    @Override
    public LLVMFunction asFunction() {
        throw new IllegalStateException("GetElementPointerConstant " + this.getName() + " has to be resolved and might not be a function.");
    }

    @Override
    public LLVMGlobal asGlobalVariable() {
        throw new IllegalStateException("GetElementPointerConstant " + this.getName() + " has to be resolved and might not be a global variable.");
    }

    public Type getType() {
        return this.type;
    }

    public Supplier<LLVMExpressionNode> createGetElementPtrNode() {
        return this.createGetElementPtrNode;
    }

    @Override
    public boolean isElemPtrExpression() {
        return true;
    }

    @Override
    public LLVMElemPtrSymbol asElemPtrExpression() {
        return this;
    }

    @Override
    public boolean isThreadLocalSymbol() {
        return false;
    }

    @Override
    public LLVMThreadLocalSymbol asThreadLocalSymbol() {
        throw new IllegalStateException("GetElementPointerConstant " + this.getName() + " has to be resolved and might not be a thread local global variable.");
    }
}

