/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class FreezeInstruction
extends ValueInstruction {
    private SymbolImpl value;

    private FreezeInstruction(Type type) {
        super(type);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getValue() {
        return this.value;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.value == original) {
            this.value = replacement;
        }
    }

    public static FreezeInstruction fromSymbols(SymbolTable symbols, Type type, int value) {
        FreezeInstruction inst = new FreezeInstruction(type);
        inst.value = symbols.getForwardReferenced(value, inst);
        return inst;
    }

    public String toString() {
        return String.format("FREEZE %s", this.value);
    }
}

