/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.enums.AtomicOrdering;
import com.oracle.truffle.llvm.parser.model.enums.SynchronizationScope;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;

public final class FenceInstruction
extends VoidInstruction {
    private final AtomicOrdering atomicOrdering;
    private final SynchronizationScope synchronizationScope;

    private FenceInstruction(AtomicOrdering atomicOrdering, SynchronizationScope synchronizationScope) {
        this.atomicOrdering = atomicOrdering;
        this.synchronizationScope = synchronizationScope;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public AtomicOrdering getAtomicOrdering() {
        return this.atomicOrdering;
    }

    public SynchronizationScope getSynchronizationScope() {
        return this.synchronizationScope;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    public static FenceInstruction generate(long atomicOrdering, long synchronizationScope) {
        return new FenceInstruction(AtomicOrdering.decode(atomicOrdering), SynchronizationScope.decode(synchronizationScope));
    }
}

