/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDName;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;

public final class MDMacro
extends MDName
implements MDBaseNode {
    private final long type;
    private final long line;
    private MDBaseNode value;
    private static final int ARGINDEX_TYPE = 1;
    private static final int ARGINDEX_LINE = 2;
    private static final int ARGINDEX_NAME = 3;
    private static final int ARGINDEX_VALUE = 4;

    private MDMacro(long type, long line) {
        this.type = type;
        this.line = line;
        this.value = MDVoidNode.INSTANCE;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public long getType() {
        return this.type;
    }

    public long getLine() {
        return this.line;
    }

    public MDBaseNode getValue() {
        return this.value;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.value == oldValue) {
            this.value = newValue;
        }
    }

    public static MDMacro create38(long[] args, MetadataValueList md) {
        long type = args[1];
        long line = args[2];
        MDMacro macro = new MDMacro(type, line);
        macro.value = md.getNullable(args[4], macro);
        macro.setName(md.getNullable(args[3], macro));
        return macro;
    }
}

