/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.listeners;

import com.oracle.truffle.llvm.parser.listeners.Constants;
import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.listeners.ParameterAttributes;
import com.oracle.truffle.llvm.parser.listeners.ParserListener;
import com.oracle.truffle.llvm.parser.listeners.Types;
import com.oracle.truffle.llvm.parser.listeners.ValueSymbolTable;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDLocation;
import com.oracle.truffle.llvm.parser.metadata.MDSubprogram;
import com.oracle.truffle.llvm.parser.metadata.MDValue;
import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesCodeEntry;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.AllocateInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.BinaryOperationInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.BranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CallInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CastInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CatchPadInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CatchRetInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CatchSwitchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CleanupPadInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CleanupRetInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CompareExchangeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CompareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ConditionalBranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ExtractElementInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ExtractValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.FenceInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.FreezeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.GetElementPointerInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.IndirectBranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.InsertElementInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.InsertValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.InvokeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.LandingpadInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.LoadInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.OperandBundle;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.PhiInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ReadModifyWriteInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ResumeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ReturnInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SelectInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ShuffleVectorInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.StoreInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SwitchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SwitchOldInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.UnaryOperationInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.UnreachableInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VaArgInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidCallInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInvokeInstruction;
import com.oracle.truffle.llvm.parser.scanner.Block;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Function
implements ParserListener {
    private static final int INSTRUCTION_DECLAREBLOCKS = 1;
    private static final int INSTRUCTION_BINOP = 2;
    private static final int INSTRUCTION_CAST = 3;
    private static final int INSTRUCTION_GEP_OLD = 4;
    private static final int INSTRUCTION_SELECT = 5;
    private static final int INSTRUCTION_EXTRACTELT = 6;
    private static final int INSTRUCTION_INSERTELT = 7;
    private static final int INSTRUCTION_SHUFFLEVEC = 8;
    private static final int INSTRUCTION_CMP = 9;
    private static final int INSTRUCTION_RET = 10;
    private static final int INSTRUCTION_BR = 11;
    private static final int INSTRUCTION_SWITCH = 12;
    private static final int INSTRUCTION_INVOKE = 13;
    private static final int INSTRUCTION_UNREACHABLE = 15;
    private static final int INSTRUCTION_PHI = 16;
    private static final int INSTRUCTION_ALLOCA = 19;
    private static final int INSTRUCTION_LOAD = 20;
    private static final int INSTRUCTION_VAARG = 23;
    private static final int INSTRUCTION_STORE_OLD = 24;
    private static final int INSTRUCTION_EXTRACTVAL = 26;
    private static final int INSTRUCTION_INSERTVAL = 27;
    private static final int INSTRUCTION_CMP2 = 28;
    private static final int INSTRUCTION_VSELECT = 29;
    private static final int INSTRUCTION_INBOUNDS_GEP_OLD = 30;
    private static final int INSTRUCTION_INDIRECTBR = 31;
    private static final int INSTRUCTION_DEBUG_LOC_AGAIN = 33;
    private static final int INSTRUCTION_CALL = 34;
    private static final int INSTRUCTION_DEBUG_LOC = 35;
    private static final int INSTRUCTION_FENCE = 36;
    private static final int INSTRUCTION_CMPXCHG_OLD = 37;
    private static final int INSTRUCTION_ATOMICRMW_OLD = 38;
    private static final int INSTRUCTION_RESUME = 39;
    private static final int INSTRUCTION_LANDINGPAD_OLD = 40;
    private static final int INSTRUCTION_LOADATOMIC = 41;
    private static final int INSTRUCTION_STOREATOMIC_OLD = 42;
    private static final int INSTRUCTION_GEP = 43;
    private static final int INSTRUCTION_STORE = 44;
    private static final int INSTRUCTION_STOREATOMIC = 45;
    private static final int INSTRUCTION_CMPXCHG = 46;
    private static final int INSTRUCTION_LANDINGPAD = 47;
    private static final int INSTRUCTION_CLEANUPRET = 48;
    private static final int INSTRUCTION_CATCHRET = 49;
    private static final int INSTRUCTION_CATCHPAD = 50;
    private static final int INSTRUCTION_CLEANUPPAD = 51;
    private static final int INSTRUCTION_CATCHSWITCH = 52;
    private static final int INSTRUCTION_OPERAND_BUNDLE = 55;
    private static final int INSTRUCTION_UNOP = 56;
    private static final int INSTRUCTION_CALLBR = 57;
    private static final int INSTRUCTION_FREEZE = 58;
    private static final int INSTRUCTION_ATOMICRMW = 59;
    private final FunctionDefinition function;
    private final Types types;
    private final int mode;
    private InstructionBlock instructionBlock = null;
    private boolean isLastBlockTerminated = true;
    private OperandBundle operandBundle = null;
    private MDLocation lastLocation = null;
    private final List<Integer> implicitIndices = new ArrayList<Integer>();
    private final ParameterAttributes paramAttributes;
    private final IRScope scope;
    private static final int INVOKE_HASEXPLICITFUNCTIONTYPE_SHIFT = 13;
    private static final int CALL_HAS_FMF_SHIFT = 17;
    private static final int CALL_HAS_EXPLICITTYPE_SHIFT = 15;
    private static final long SWITCH_CASERANGE_SHIFT = 16L;
    private static final long SWITCH_CASERANGE_FLAG = 1205L;
    private static final long ALLOCA_INMASK = 32L;
    private static final long ALLOCA_EXPLICITTYPEMASK = 64L;
    private static final long ALLOCA_SWIFTERRORMASK = 128L;
    private static final long ALLOCA_FLAGSMASK = 224L;
    private static final int LOAD_ARGS_EXPECTED_AFTER_TYPE = 3;
    private static final int LOADATOMIC_ARGS_EXPECTED_AFTER_TYPE = 5;
    private static final int CMPXCHG_TYPE_LENGTH = 2;
    private static final int CMPXCHG_TYPE_ELEMENTTYPE = 0;
    private static final int CMPXCHG_TYPE_BOOLTYPE = 1;

    public Function(IRScope scope, Types types, FunctionDefinition function, int mode, ParameterAttributes paramAttributes) {
        this.scope = scope;
        this.types = types;
        this.function = function;
        this.mode = mode;
        this.paramAttributes = paramAttributes;
    }

    public void setupScope() {
        this.scope.startLocalScope(this.function);
        FunctionType functionType = this.function.getType();
        for (int i = 0; i < functionType.getNumberOfArguments(); ++i) {
            Type argType = functionType.getArgumentType(i);
            this.scope.addSymbol(this.function.createParameter(argType), argType);
        }
    }

    @Override
    public ParserListener enter(Block block) {
        switch (block) {
            case CONSTANTS: {
                return new Constants(this.types, this.scope);
            }
            case VALUE_SYMTAB: {
                return new ValueSymbolTable(this.scope);
            }
            case METADATA: 
            case METADATA_ATTACHMENT: 
            case METADATA_KIND: {
                return new Metadata(this.types, this.scope);
            }
        }
        return ParserListener.DEFAULT;
    }

    @Override
    public void exit() {
        MDBaseNode md;
        if (this.function.hasAttachedMetadata() && (md = this.function.getMetadataAttachment("dbg")) instanceof MDSubprogram) {
            ((MDSubprogram)md).setFunction(MDValue.create(this.function));
        }
        if (this.operandBundle != null) {
            throw new LLVMParserException("Operand bundle found with no consumer");
        }
        this.scope.exitLocalScope();
    }

    @Override
    public void record(RecordBuffer buffer) {
        int opCode = buffer.getId();
        switch (opCode) {
            case 35: {
                this.parseDebugLocation(buffer);
            }
            case 33: {
                this.applyDebugLocation();
                return;
            }
            case 1: {
                this.function.allocateBlocks(buffer.readInt());
                return;
            }
        }
        if (this.isLastBlockTerminated) {
            this.instructionBlock = this.function.generateBlock();
            this.isLastBlockTerminated = false;
        }
        switch (opCode) {
            case 2: {
                this.createBinaryOperation(buffer);
                break;
            }
            case 56: {
                this.createUnaryOperation(buffer);
                break;
            }
            case 3: {
                this.createCast(buffer);
                break;
            }
            case 4: {
                this.createGetElementPointerOld(buffer, false);
                break;
            }
            case 6: {
                this.createExtractElement(buffer);
                break;
            }
            case 7: {
                this.createInsertElement(buffer);
                break;
            }
            case 8: {
                this.createShuffleVector(buffer);
                break;
            }
            case 10: {
                this.createReturn(buffer);
                break;
            }
            case 11: {
                this.createBranch(buffer);
                break;
            }
            case 12: {
                this.createSwitch(buffer);
                break;
            }
            case 15: {
                this.createUnreachable(buffer);
                break;
            }
            case 16: {
                this.createPhi(buffer);
                break;
            }
            case 19: {
                this.createAlloca(buffer);
                break;
            }
            case 20: {
                this.createLoad(buffer);
                break;
            }
            case 24: {
                this.createStoreOld(buffer);
                break;
            }
            case 26: {
                this.createExtractValue(buffer);
                break;
            }
            case 27: {
                this.createInsertValue(buffer);
                break;
            }
            case 28: {
                this.createCompare2(buffer);
                break;
            }
            case 29: {
                this.createSelect(buffer);
                break;
            }
            case 30: {
                this.createGetElementPointerOld(buffer, true);
                break;
            }
            case 31: {
                this.createIndirectBranch(buffer);
                break;
            }
            case 34: {
                this.createFunctionCall(buffer);
                break;
            }
            case 13: {
                this.createInvoke(buffer);
                break;
            }
            case 47: {
                this.createLandingpad(buffer);
                break;
            }
            case 40: {
                this.createLandingpadOld(buffer);
                break;
            }
            case 39: {
                this.createResume(buffer);
                break;
            }
            case 43: {
                this.createGetElementPointer(buffer);
                break;
            }
            case 44: {
                this.createStore(buffer);
                break;
            }
            case 41: {
                this.createLoadAtomic(buffer);
                break;
            }
            case 45: {
                this.createAtomicStore(buffer);
                break;
            }
            case 37: 
            case 46: {
                this.createCompareExchange(buffer, opCode);
                break;
            }
            case 38: {
                this.createAtomicReadModifyWriteOld(buffer);
                break;
            }
            case 59: {
                this.createAtomicReadModifyWrite(buffer);
                break;
            }
            case 36: {
                this.createFence(buffer);
                break;
            }
            case 23: {
                this.createVaArg(buffer);
                break;
            }
            case 55: {
                this.attachOperandBundle(buffer);
                break;
            }
            case 58: {
                this.createFreeze(buffer);
                break;
            }
            case 51: {
                this.createCleanupPad(buffer);
                break;
            }
            case 48: {
                this.createCleanupRet(buffer);
                break;
            }
            case 52: {
                this.createCatchSwitch(buffer);
                break;
            }
            case 50: {
                this.createCatchPad(buffer);
                break;
            }
            case 49: {
                this.createCatchRet(buffer);
                break;
            }
            default: {
                switch (opCode) {
                    case 5: 
                    case 9: 
                    case 42: 
                    case 57: {
                        throw new LLVMParserException("Unsupported opCode in function block: " + opCode);
                    }
                }
                throw new LLVMParserException("Unknown opCode in function block: " + opCode);
            }
        }
        if (this.operandBundle != null && opCode != 55) {
            throw new LLVMParserException("Operand bundle found with no consumer");
        }
    }

    private void emit(ValueInstruction instruction) {
        this.instructionBlock.append(instruction);
        this.scope.addSymbol(instruction, instruction.getType());
        this.scope.addInstruction(instruction);
    }

    private void emit(VoidInstruction instruction) {
        this.instructionBlock.append(instruction);
        this.scope.addInstruction(instruction);
    }

    private void attachOperandBundle(RecordBuffer buffer) {
        String tag = this.function.getOperandBundleTags().getTag(buffer.readInt());
        int nargs = 0;
        while (buffer.remaining() > 0) {
            this.readIndexSkipType(buffer);
            ++nargs;
        }
        buffer.setIndex(2);
        Type[] argTypes = new Type[nargs];
        int[] argValues = new int[nargs];
        for (int i = 0; i < nargs; ++i) {
            argValues[i] = this.readIndex(buffer);
            argTypes[i] = this.readValueType(buffer, argValues[i]);
        }
        this.operandBundle = new OperandBundle(tag, argTypes, argValues);
    }

    private void createInvoke(RecordBuffer buffer) {
        Type returnType;
        AttributesCodeEntry paramAttr = this.paramAttributes.getCodeEntry(buffer.read());
        long ccInfo = buffer.read();
        InstructionBlock normalSuccessor = this.function.getBlock(buffer.read());
        InstructionBlock unwindSuccessor = this.function.getBlock(buffer.read());
        FunctionType functionType = null;
        if ((ccInfo >> 13 & 1L) != 0L) {
            functionType = Types.castToFunction(this.readType(buffer));
        }
        int target = this.readIndex(buffer);
        Type calleeType = this.readValueType(buffer, target);
        if (functionType == null) {
            if (calleeType instanceof PointerType) {
                functionType = Types.castToFunction(((PointerType)calleeType).getPointeeType());
            } else if (calleeType instanceof FunctionType) {
                functionType = (FunctionType)calleeType;
            } else {
                throw new LLVMParserException("Cannot find Type of invoked function: " + calleeType);
            }
        }
        int[] args = new int[buffer.remaining()];
        int j = 0;
        while (j < functionType.getNumberOfArguments() && buffer.remaining() > 0) {
            args[j++] = this.readIndex(buffer);
        }
        while (buffer.remaining() > 0) {
            args[j++] = this.readIndexSkipType(buffer);
        }
        if (args.length != j) {
            args = Arrays.copyOf(args, j);
        }
        if ((returnType = functionType.getReturnType()) == VoidType.INSTANCE) {
            this.emit(VoidInvokeInstruction.fromSymbols(this.scope, target, args, normalSuccessor, unwindSuccessor, paramAttr, this.operandBundle, functionType));
        } else {
            this.emit(InvokeInstruction.fromSymbols(this.scope, returnType, target, args, normalSuccessor, unwindSuccessor, paramAttr, this.operandBundle, functionType));
        }
        this.operandBundle = null;
        this.isLastBlockTerminated = true;
    }

    private void createResume(RecordBuffer buffer) {
        int val = this.readIndexSkipType(buffer);
        this.emit(ResumeInstruction.fromSymbols(this.scope.getSymbols(), val));
        this.isLastBlockTerminated = true;
    }

    private void createCleanupPad(RecordBuffer buffer) {
        int index = this.readIndex(buffer);
        int num = buffer.readInt();
        Type[] argTypes = new Type[num];
        int[] argValues = new int[num];
        for (int i = 0; i < num; ++i) {
            argValues[i] = this.readIndex(buffer);
            argTypes[i] = this.readValueType(buffer, argValues[i]);
        }
        this.emit(CleanupPadInstruction.generate(this.scope.getSymbols(), index, argTypes, argValues));
    }

    private void createCleanupRet(RecordBuffer buffer) {
        int fromIndex = this.readIndex(buffer);
        InstructionBlock unwindSuccessor = null;
        if (buffer.size() > 1) {
            unwindSuccessor = this.function.getBlock(buffer.read());
        }
        this.emit(CleanupRetInstruction.generate(this.scope.getSymbols(), fromIndex, unwindSuccessor));
        this.isLastBlockTerminated = true;
    }

    private void createCatchSwitch(RecordBuffer buffer) {
        int withinIndex = this.readIndex(buffer);
        int num = buffer.readInt();
        InstructionBlock[] cases = new InstructionBlock[num];
        for (int i = 0; i < num; ++i) {
            cases[i] = this.function.getBlock(buffer.read());
        }
        InstructionBlock unwind = null;
        if (buffer.remaining() > 0) {
            assert (buffer.remaining() == 1);
            unwind = this.function.getBlock(buffer.read());
        }
        this.emit(CatchSwitchInstruction.generate(this.scope.getSymbols(), this.instructionBlock, withinIndex, cases, unwind));
        this.isLastBlockTerminated = true;
    }

    private void createCatchPad(RecordBuffer buffer) {
        int withinIndex = this.readIndex(buffer);
        int num = buffer.readInt();
        Type[] argTypes = new Type[num];
        int[] argValues = new int[num];
        for (int i = 0; i < num; ++i) {
            argValues[i] = this.readIndex(buffer);
            argTypes[i] = this.readValueType(buffer, argValues[i]);
        }
        this.emit(CatchPadInstruction.generate(this.scope.getSymbols(), withinIndex, argTypes, argValues));
    }

    private void createCatchRet(RecordBuffer buffer) {
        int fromIndex = this.readIndex(buffer);
        InstructionBlock unwindSuccessor = this.function.getBlock(buffer.read());
        this.emit(CatchRetInstruction.generate(this.scope.getSymbols(), fromIndex, unwindSuccessor));
        this.isLastBlockTerminated = true;
    }

    private void createLandingpad(RecordBuffer buffer) {
        Type type = this.readType(buffer);
        boolean isCleanup = buffer.readBoolean();
        int numClauses = buffer.readInt();
        long[] clauseKinds = new long[numClauses];
        long[] clauseTypes = new long[numClauses];
        for (int j = 0; j < numClauses; ++j) {
            clauseKinds[j] = buffer.read();
            clauseTypes[j] = this.readIndexSkipType(buffer);
        }
        this.emit(LandingpadInstruction.generate(this.scope.getSymbols(), type, isCleanup, clauseKinds, clauseTypes));
    }

    private void createLandingpadOld(RecordBuffer buffer) {
        Type type = this.readType(buffer);
        this.readIndexSkipType(buffer);
        boolean isCleanup = buffer.readBoolean();
        int numClauses = buffer.readInt();
        long[] clauseKinds = new long[numClauses];
        long[] clauseTypes = new long[numClauses];
        for (int j = 0; j < numClauses; ++j) {
            clauseKinds[j] = buffer.read();
            clauseTypes[j] = this.readIndexSkipType(buffer);
        }
        this.emit(LandingpadInstruction.generate(this.scope.getSymbols(), type, isCleanup, clauseKinds, clauseTypes));
    }

    private void createFunctionCall(RecordBuffer buffer) {
        Type returnType;
        AttributesCodeEntry paramAttr = this.paramAttributes.getCodeEntry(buffer.read());
        long ccinfo = buffer.read();
        if ((ccinfo >> 17 & 1L) != 0L) {
            buffer.read();
        }
        FunctionType functionType = null;
        if ((ccinfo >> 15 & 1L) != 0L) {
            functionType = Types.castToFunction(this.readType(buffer));
        }
        int callee = this.readIndex(buffer);
        Type calleeType = this.readValueType(buffer, callee);
        if (functionType == null) {
            functionType = calleeType instanceof FunctionType ? (FunctionType)calleeType : Types.castToFunction(Types.castToPointer(calleeType).getPointeeType());
        }
        int[] args = new int[buffer.remaining()];
        int j = 0;
        while (j < functionType.getNumberOfArguments() && buffer.remaining() > 0) {
            args[j++] = this.readIndex(buffer);
        }
        while (buffer.remaining() > 0) {
            args[j++] = this.readIndexSkipType(buffer);
        }
        if (j != args.length) {
            args = Arrays.copyOf(args, j);
        }
        if ((returnType = functionType.getReturnType()) == VoidType.INSTANCE) {
            this.emit(VoidCallInstruction.fromSymbols(this.scope, callee, args, paramAttr, this.operandBundle, functionType));
        } else {
            this.emit(CallInstruction.fromSymbols(this.scope, returnType, callee, args, paramAttr, this.operandBundle, functionType));
        }
        this.operandBundle = null;
    }

    private void createSwitch(RecordBuffer buffer) {
        long first = buffer.read();
        if (first >> 16 == 1205L) {
            buffer.read();
            int cond = this.readIndex(buffer);
            int defaultBlock = buffer.readInt();
            int count = buffer.readInt();
            long[] caseConstants = new long[count];
            int[] caseBlocks = new int[count];
            for (int j = 0; j < count; ++j) {
                buffer.read();
                buffer.read();
                caseConstants[j] = buffer.readSignedValue();
                caseBlocks[j] = buffer.readInt();
            }
            this.emit(SwitchOldInstruction.generate(this.function, this.scope.getSymbols(), cond, defaultBlock, caseConstants, caseBlocks));
        } else {
            int cond = this.readIndex(buffer);
            int defaultBlock = buffer.readInt();
            int count = buffer.remaining() >> 1;
            int[] caseValues = new int[count];
            int[] caseBlocks = new int[count];
            for (int j = 0; j < count; ++j) {
                caseValues[j] = this.getIndexAbsolute(buffer.read());
                caseBlocks[j] = buffer.readInt();
            }
            this.emit(SwitchInstruction.generate(this.function, this.scope.getSymbols(), cond, defaultBlock, caseValues, caseBlocks));
        }
        this.isLastBlockTerminated = true;
    }

    private void createAlloca(RecordBuffer buffer) {
        long typeRecord = buffer.read();
        buffer.read();
        int count = this.getIndexAbsolute(buffer.read());
        long alignRecord = buffer.read();
        int align = Function.getAlign(alignRecord & 0xFFFFFFFFFFFFFF1FL);
        Type type = this.types.get(typeRecord);
        if ((alignRecord & 0x40L) != 0L) {
            type = new PointerType(type);
        } else if (!(type instanceof PointerType)) {
            throw new LLVMParserException("Alloca with unexpected type: " + type);
        }
        this.emit(AllocateInstruction.fromSymbols(this.scope.getSymbols(), type, count, align));
    }

    private void createLoad(RecordBuffer buffer) {
        int src = this.readIndex(buffer);
        Type srcType = this.readValueType(buffer, src);
        Type opType = buffer.remaining() == 3 ? this.readType(buffer) : Types.castToPointer(srcType).getPointeeType();
        buffer.read();
        boolean isVolatile = buffer.readBoolean();
        this.emit(LoadInstruction.fromSymbols(this.scope.getSymbols(), opType, src, isVolatile));
    }

    private void createLoadAtomic(RecordBuffer buffer) {
        int src = this.readIndex(buffer);
        Type srcType = this.readValueType(buffer, src);
        Type opType = buffer.remaining() == 5 ? this.readType(buffer) : Types.castToPointer(srcType).getPointeeType();
        buffer.read();
        boolean isVolatile = buffer.readBoolean();
        long atomicOrdering = buffer.read();
        long synchronizationScope = buffer.read();
        this.emit(LoadInstruction.fromSymbols(this.scope.getSymbols(), opType, src, isVolatile, atomicOrdering, synchronizationScope));
    }

    private void createCompareExchange(RecordBuffer buffer, int record) {
        Type cmpType;
        int cmp;
        int ptr = this.readIndex(buffer);
        Type ptrType = this.readValueType(buffer, ptr);
        if (record == 46) {
            cmp = this.readIndex(buffer);
            cmpType = this.readValueType(buffer, cmp);
        } else {
            assert (record == 37);
            cmp = this.readIndex(buffer);
            cmpType = Types.castToPointer(ptrType).getPointeeType();
        }
        int replace = this.readIndex(buffer);
        boolean isVolatile = buffer.readBoolean();
        long successOrdering = buffer.read();
        long synchronizationScope = buffer.read();
        long failureOrdering = buffer.remaining() > 0 ? buffer.read() : -1L;
        boolean addExtractValue = buffer.remaining() == 0;
        boolean isWeak = addExtractValue || buffer.readBoolean();
        AggregateType type = this.findCmpxchgResultType(cmpType);
        CompareExchangeInstruction inst = CompareExchangeInstruction.fromSymbols(this.scope.getSymbols(), type, ptr, cmp, replace, isVolatile, successOrdering, synchronizationScope, failureOrdering, isWeak);
        this.emit(inst);
        if (addExtractValue) {
            Type elementType = inst.getAggregateType().getElementType(0L);
            this.emit(ExtractValueInstruction.create(inst, elementType, 0));
            this.implicitIndices.add(this.scope.getNextValueIndex() - 1);
        }
    }

    private AggregateType findCmpxchgResultType(Type elementType) {
        for (Type t : this.types) {
            StructureType st;
            if (!(t instanceof StructureType) || (st = (StructureType)t).getNumberOfElementsInt() != 2 || elementType != st.getElementType(0L) || PrimitiveType.I1 != st.getElementType(1L)) continue;
            return st;
        }
        return StructureType.createUnnamed(true, elementType, PrimitiveType.I1);
    }

    private void parseDebugLocation(RecordBuffer buffer) {
        this.lastLocation = MDLocation.createFromFunctionArgs(buffer, this.scope.getMetadata());
    }

    private void applyDebugLocation() {
        int lastInstructionIndex = this.instructionBlock.getInstructionCount() - 1;
        this.instructionBlock.getInstruction(lastInstructionIndex).setDebugLocation(this.lastLocation);
    }

    private void createAtomicStore(RecordBuffer buffer) {
        int destination = this.readIndexSkipType(buffer);
        int source = this.readIndexSkipType(buffer);
        int align = Function.getAlign(buffer.read());
        boolean isVolatile = buffer.readBoolean();
        long atomicOrdering = buffer.read();
        long synchronizationScope = buffer.read();
        this.emit(StoreInstruction.fromSymbols(this.scope.getSymbols(), destination, source, align, isVolatile, atomicOrdering, synchronizationScope));
    }

    private void createAtomicReadModifyWriteOld(RecordBuffer buffer) {
        int ptr = this.readIndex(buffer);
        Type ptrType = this.readValueType(buffer, ptr);
        int value = this.readIndex(buffer);
        int opcode = buffer.readInt();
        boolean isVolatile = buffer.readBoolean();
        long atomicOrdering = buffer.read();
        long synchronizationScope = buffer.read();
        Type type = Types.castToPointer(ptrType).getPointeeType();
        this.emit(ReadModifyWriteInstruction.fromSymbols(this.scope.getSymbols(), type, ptr, null, value, opcode, isVolatile, atomicOrdering, synchronizationScope));
    }

    private void createAtomicReadModifyWrite(RecordBuffer buffer) {
        int ptr = this.readIndexSkipType(buffer);
        int value = this.readIndex(buffer);
        Type valType = this.readValueType(buffer, value);
        int opcode = buffer.readInt();
        boolean isVolatile = buffer.readBoolean();
        long atomicOrdering = buffer.read();
        long synchronizationScope = buffer.read();
        this.emit(ReadModifyWriteInstruction.fromSymbols(this.scope.getSymbols(), valType, ptr, valType, value, opcode, isVolatile, atomicOrdering, synchronizationScope));
    }

    private void createFence(RecordBuffer buffer) {
        long atomicOrdering = buffer.read();
        long synchronizationScope = buffer.read();
        this.emit(FenceInstruction.generate(atomicOrdering, synchronizationScope));
    }

    private void createFreeze(RecordBuffer buffer) {
        int value = this.readIndex(buffer);
        Type type = this.readValueType(buffer, value);
        this.emit(FreezeInstruction.fromSymbols(this.scope.getSymbols(), type, value));
    }

    private void createVaArg(RecordBuffer buffer) {
        this.readType(buffer);
        int source = this.readIndex(buffer);
        Type type = this.readType(buffer);
        this.emit(VaArgInstruction.fromSymbols(this.scope.getSymbols(), type, source));
    }

    private void createBinaryOperation(RecordBuffer buffer) {
        int lhs = this.readIndex(buffer);
        Type type = this.readValueType(buffer, lhs);
        int rhs = this.readIndex(buffer);
        int opcode = buffer.readInt();
        int flags = buffer.remaining() > 0 ? buffer.readInt() : 0;
        this.emit(BinaryOperationInstruction.fromSymbols(this.scope.getSymbols(), type, opcode, flags, lhs, rhs));
    }

    private void createUnaryOperation(RecordBuffer buffer) {
        int operand = this.readIndex(buffer);
        Type type = this.readValueType(buffer, operand);
        int opcode = buffer.readInt();
        int flags = buffer.remaining() > 0 ? buffer.readInt() : 0;
        this.emit(UnaryOperationInstruction.fromSymbols(this.scope.getSymbols(), type, opcode, flags, operand));
    }

    private void createBranch(RecordBuffer buffer) {
        if (buffer.size() == 1) {
            this.emit(BranchInstruction.fromTarget(this.function.getBlock(buffer.read())));
        } else {
            InstructionBlock trueSuccessor = this.function.getBlock(buffer.read());
            InstructionBlock falseSuccessor = this.function.getBlock(buffer.read());
            int condition = this.readIndex(buffer);
            this.emit(ConditionalBranchInstruction.fromSymbols(this.scope.getSymbols(), condition, trueSuccessor, falseSuccessor));
        }
        this.isLastBlockTerminated = true;
    }

    private void createCast(RecordBuffer buffer) {
        int value = this.readIndexSkipType(buffer);
        Type type = this.readType(buffer);
        int opcode = buffer.readInt();
        this.emit(CastInstruction.fromSymbols(this.scope.getSymbols(), type, opcode, value));
    }

    private void createCompare2(RecordBuffer buffer) {
        int lhs = this.readIndex(buffer);
        Type operandType = this.readValueType(buffer, lhs);
        int rhs = this.readIndex(buffer);
        int opcode = buffer.readInt();
        Type type = operandType instanceof VectorType ? new VectorType(PrimitiveType.I1, Types.castToVector(operandType).getNumberOfElementsInt()) : PrimitiveType.I1;
        this.emit(CompareInstruction.fromSymbols(this.scope.getSymbols(), type, opcode, lhs, rhs));
    }

    private void createExtractElement(RecordBuffer buffer) {
        int vector = this.readIndex(buffer);
        Type vectorType = this.readValueType(buffer, vector);
        int index = this.readIndex(buffer);
        Type elementType = Types.castToVector(vectorType).getElementType();
        this.emit(ExtractElementInstruction.fromSymbols(this.scope.getSymbols(), elementType, vector, index));
    }

    private void createExtractValue(RecordBuffer buffer) {
        int aggregate = this.readIndex(buffer);
        Type elementType = this.readValueType(buffer, aggregate);
        ArrayDeque<Long> indicesList = new ArrayDeque<Long>();
        while (buffer.remaining() > 0) {
            int index = buffer.readInt();
            elementType = Types.castToAggregate(elementType).getElementType(index);
            indicesList.addFirst(Long.valueOf(index));
        }
        this.emit(ExtractValueInstruction.fromSymbols(this.scope.getSymbols(), elementType, aggregate, indicesList));
    }

    private void createGetElementPointer(RecordBuffer buffer) {
        boolean isInbounds = buffer.readBoolean();
        Type baseType = this.readType(buffer);
        int pointer = this.readIndex(buffer);
        Type pointerType = this.readValueType(buffer, pointer);
        int[] indices = this.readIndices(buffer);
        Type type = this.getElementPointerType(baseType, pointerType, indices);
        this.emit(GetElementPointerInstruction.fromSymbols(this.scope.getSymbols(), type, baseType, pointer, indices, isInbounds));
    }

    private void createGetElementPointerOld(RecordBuffer buffer, boolean isInbounds) {
        int pointer = this.readIndex(buffer);
        Type pointerType = this.readValueType(buffer, pointer);
        int[] indices = this.readIndices(buffer);
        Type type = this.getElementPointerType(null, pointerType, indices);
        this.emit(GetElementPointerInstruction.fromSymbols(this.scope.getSymbols(), type, null, pointer, indices, isInbounds));
    }

    private void createIndirectBranch(RecordBuffer buffer) {
        buffer.read();
        int address = this.readIndex(buffer);
        int[] successors = new int[buffer.size() - 2];
        for (int i = 0; i < successors.length; ++i) {
            successors[i] = buffer.readInt();
        }
        this.emit(IndirectBranchInstruction.generate(this.function, this.scope.getSymbols(), address, successors));
        this.isLastBlockTerminated = true;
    }

    private void createInsertElement(RecordBuffer buffer) {
        int vector = this.readIndex(buffer);
        Type type = this.readValueType(buffer, vector);
        int value = this.readIndex(buffer);
        int index = this.readIndex(buffer);
        this.emit(InsertElementInstruction.fromSymbols(this.scope.getSymbols(), type, vector, index, value));
    }

    private void createInsertValue(RecordBuffer buffer) {
        int aggregate = this.readIndex(buffer);
        Type type = this.readValueType(buffer, aggregate);
        int value = this.readIndexSkipType(buffer);
        int index = buffer.readInt();
        buffer.checkEnd("Multiple indices for insertvalue are not yet supported!");
        this.emit(InsertValueInstruction.fromSymbols(this.scope.getSymbols(), type, aggregate, index, value));
    }

    private void createPhi(RecordBuffer buffer) {
        Type type = this.readType(buffer);
        int count = buffer.size() - 1 >> 1;
        int[] values = new int[count];
        InstructionBlock[] blocks = new InstructionBlock[count];
        for (int i = 0; i < count; ++i) {
            values[i] = this.getIndex(buffer.readSignedValue());
            blocks[i] = this.function.getBlock(buffer.read());
        }
        this.emit(PhiInstruction.generate(this.scope.getSymbols(), type, values, blocks));
    }

    private void createReturn(RecordBuffer buffer) {
        if (buffer.size() == 0 || buffer.getAt(0) == 0L) {
            this.emit(ReturnInstruction.generate());
        } else {
            int value = this.readIndex(buffer);
            this.emit(ReturnInstruction.generate(this.scope.getSymbols(), value));
        }
        this.isLastBlockTerminated = true;
    }

    private void createSelect(RecordBuffer buffer) {
        int trueValue = this.readIndex(buffer);
        Type type = this.readValueType(buffer, trueValue);
        int falseValue = this.readIndex(buffer);
        int condition = this.readIndex(buffer);
        this.emit(SelectInstruction.fromSymbols(this.scope.getSymbols(), type, condition, trueValue, falseValue));
    }

    private void createShuffleVector(RecordBuffer buffer) {
        int vector1 = this.readIndex(buffer);
        Type vectorType = this.readValueType(buffer, vector1);
        int vector2 = this.readIndex(buffer);
        int mask = this.readIndex(buffer);
        Type subtype = Types.castToVector(vectorType).getElementType();
        int length = Types.castToVector(this.scope.getValueType(mask)).getNumberOfElementsInt();
        VectorType type = new VectorType(subtype, length);
        this.emit(ShuffleVectorInstruction.fromSymbols(this.scope.getSymbols(), type, vector1, vector2, mask));
    }

    private void createStore(RecordBuffer buffer) {
        int destination = this.readIndexSkipType(buffer);
        int source = this.readIndexSkipType(buffer);
        int align = Function.getAlign(buffer.read());
        boolean isVolatile = buffer.readBoolean();
        this.emit(StoreInstruction.fromSymbols(this.scope.getSymbols(), destination, source, align, isVolatile));
    }

    private void createStoreOld(RecordBuffer buffer) {
        int destination = this.readIndexSkipType(buffer);
        int source = this.readIndex(buffer);
        int align = Function.getAlign(buffer.read());
        boolean isVolatile = buffer.readBoolean();
        this.emit(StoreInstruction.fromSymbols(this.scope.getSymbols(), destination, source, align, isVolatile));
    }

    private void createUnreachable(RecordBuffer buffer) {
        this.emit(UnreachableInstruction.generate());
        this.isLastBlockTerminated = true;
    }

    private static int getAlign(long argument) {
        return (int)argument & 0x3F;
    }

    private Type getElementPointerType(Type baseType, Type ptrType, int[] indices) {
        Type elementType;
        int length;
        boolean vectorized = ptrType instanceof VectorType;
        int n = length = vectorized ? ((VectorType)ptrType).getNumberOfElementsInt() : 0;
        if (baseType == null) {
            Type type = elementType = vectorized ? ((VectorType)ptrType).getElementType() : ptrType;
            assert (elementType instanceof PointerType);
            elementType = ((PointerType)elementType).getPointeeType();
        } else {
            elementType = baseType;
        }
        for (int i = 0; i < indices.length; ++i) {
            int indexIndex = indices[i];
            Type indexType = this.scope.getValueType(indexIndex);
            if (i > 0) {
                if (elementType instanceof PointerType) {
                    elementType = ((PointerType)elementType).getPointeeType();
                } else if (elementType instanceof ArrayType) {
                    elementType = ((ArrayType)elementType).getElementType();
                } else if (elementType instanceof VectorType) {
                    elementType = ((VectorType)elementType).getElementType();
                } else if (elementType instanceof StructureType) {
                    StructureType structure = (StructureType)elementType;
                    if (!(indexType instanceof PrimitiveType)) {
                        throw new LLVMParserException("Cannot infer structure element from " + indexType);
                    }
                    Number indexNumber = (Number)((PrimitiveType)indexType).getConstant();
                    assert (((PrimitiveType)indexType).getPrimitiveKind() == PrimitiveType.PrimitiveKind.I32);
                    elementType = structure.getElementType(indexNumber.intValue());
                } else {
                    throw new LLVMParserException("Cannot index type: " + elementType);
                }
            }
            if (!(indexType instanceof VectorType)) continue;
            int indexVectorLength = ((VectorType)indexType).getNumberOfElementsInt();
            if (vectorized) {
                if (indexVectorLength == length) continue;
                throw new LLVMParserException(String.format("Vectors of different lengths are not supported: %d != %d", indexVectorLength, length));
            }
            vectorized = true;
            length = indexVectorLength;
        }
        PointerType pointer = new PointerType(elementType);
        if (vectorized) {
            return new VectorType(pointer, length);
        }
        return pointer;
    }

    private int readIndex(RecordBuffer buffer) {
        return this.getIndex(buffer.read());
    }

    private int readIndexSkipType(RecordBuffer buffer) {
        int value = this.getIndex(buffer.read());
        if (this.scope.isValueForwardRef(value)) {
            buffer.read();
        }
        return value;
    }

    private Type readValueType(RecordBuffer buffer, int valueIndex) {
        if (this.scope.isValueForwardRef(valueIndex)) {
            return this.types.get(buffer.read());
        }
        return this.scope.getValueType(valueIndex);
    }

    private int getIndex(long index) {
        if (this.mode >= 1) {
            return this.getIndexRelative(index);
        }
        return this.getIndexAbsolute(index);
    }

    private int getIndexAbsolute(long index) {
        long actualIndex = index;
        for (int i = 0; i < this.implicitIndices.size() && (long)this.implicitIndices.get(i).intValue() <= actualIndex; ++actualIndex, ++i) {
        }
        return (int)actualIndex;
    }

    private int getIndexRelative(long index) {
        long actualIndex = (long)this.scope.getNextValueIndex() - index;
        for (int i = this.implicitIndices.size() - 1; i >= 0 && (long)this.implicitIndices.get(i).intValue() > actualIndex; --actualIndex, --i) {
        }
        return (int)actualIndex;
    }

    private int[] readIndices(RecordBuffer buffer) {
        int[] indices = new int[buffer.remaining()];
        int pos = 0;
        while (buffer.remaining() > 0) {
            indices[pos++] = this.readIndexSkipType(buffer);
        }
        return pos == indices.length ? indices : Arrays.copyOf(indices, pos);
    }

    private Type readType(RecordBuffer buffer) {
        return this.types.get(buffer.read());
    }

    public FunctionDefinition getFunction() {
        return this.function;
    }

    public IRScope getScope() {
        return this.scope;
    }
}

