/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.binary;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.binary.BinaryParserResult;
import com.oracle.truffle.llvm.parser.coff.CoffFile;
import com.oracle.truffle.llvm.parser.coff.PEExportSymbolsMapper;
import com.oracle.truffle.llvm.parser.coff.PEFile;
import com.oracle.truffle.llvm.parser.coff.WindowsLibraryLocator;
import com.oracle.truffle.llvm.parser.elf.ElfDynamicSection;
import com.oracle.truffle.llvm.parser.elf.ElfFile;
import com.oracle.truffle.llvm.parser.elf.ElfLibraryLocator;
import com.oracle.truffle.llvm.parser.elf.ElfSectionHeaderTable;
import com.oracle.truffle.llvm.parser.macho.MachOFile;
import com.oracle.truffle.llvm.parser.macho.MachOLibraryLocator;
import com.oracle.truffle.llvm.parser.macho.Xar;
import com.oracle.truffle.llvm.parser.scanner.BitStream;
import com.oracle.truffle.llvm.runtime.DefaultLibraryLocator;
import com.oracle.truffle.llvm.runtime.ExportSymbolsMapper;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.Magic;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.polyglot.io.ByteSequence;

public final class BinaryParser {
    private ArrayList<String> libraries = new ArrayList();
    private String libraryName = null;
    private ArrayList<String> paths = new ArrayList();
    private LibraryLocator locator = DefaultLibraryLocator.INSTANCE;
    private ExportSymbolsMapper exportSymbolsMapper = ExportSymbolsMapper.DEFAULT;

    public static Magic getMagic(BitStream b) {
        try {
            return Magic.get(Integer.toUnsignedLong((int)b.read(0L, 32)));
        }
        catch (Exception e) {
            return Magic.UNKNOWN;
        }
    }

    public static BinaryParserResult parse(ByteSequence bytes, Source bcSource, LLVMContext context) {
        return new BinaryParser().parseInternal(bytes, bcSource, context);
    }

    private BinaryParserResult parseInternal(ByteSequence bytes, Source bcSource, LLVMContext context) {
        assert (bytes != null);
        ByteSequence bitcode = this.parseBitcode(bytes, bcSource);
        if (bitcode == null) {
            return null;
        }
        if (bcSource != null) {
            LibraryLocator.traceParseBitcode(context, bcSource.getPath());
        }
        return new BinaryParserResult(this.libraries, this.paths, bitcode, this.locator, this.exportSymbolsMapper, bcSource, this.libraryName);
    }

    public static String getOrigin(Source source) {
        if (source == null) {
            return null;
        }
        String sourcePath = source.getPath();
        if (sourcePath == null) {
            return null;
        }
        try {
            Path parent = Paths.get(sourcePath, new String[0]).getParent();
            if (parent == null) {
                return null;
            }
            return parent.toString();
        }
        catch (InvalidPathException ex) {
            return null;
        }
    }

    private ByteSequence parseBitcode(ByteSequence bytes, Source source) {
        BitStream b = BitStream.create(bytes);
        Magic magicWord = BinaryParser.getMagic(b);
        if (source != null) {
            this.libraryName = source.getName();
        }
        switch (magicWord) {
            case BC_MAGIC_WORD: {
                return bytes;
            }
            case WRAPPER_MAGIC_WORD: {
                long offset = b.read(64L, 32);
                long size = b.read(96L, 32);
                return bytes.subSequence((int)offset, (int)(offset + size));
            }
            case ELF_MAGIC_WORD: {
                ElfFile elfFile = ElfFile.create(bytes);
                ElfSectionHeaderTable.Entry llvmbc = elfFile.getSectionHeaderTable().getEntry(".llvmbc");
                if (llvmbc == null) {
                    return null;
                }
                ElfDynamicSection dynamicSection = elfFile.getDynamicSection();
                if (dynamicSection != null) {
                    List<String> elfLibraries = dynamicSection.getDTNeeded();
                    this.libraries.addAll(elfLibraries);
                    String soName = dynamicSection.getDTSOName();
                    if (soName != null) {
                        this.libraryName = soName;
                    }
                    this.locator = new ElfLibraryLocator(elfFile, source);
                }
                long elfOffset = llvmbc.getOffset();
                long elfSize = llvmbc.getSize();
                return bytes.subSequence((int)elfOffset, (int)(elfOffset + elfSize));
            }
            case MH_MAGIC: 
            case MH_CIGAM: 
            case MH_MAGIC_64: 
            case MH_CIGAM_64: {
                MachOFile machOFile = MachOFile.create(bytes);
                String origin = BinaryParser.getOrigin(source);
                List<String> machoLibraries = machOFile.getDyLibs(origin);
                this.locator = new MachOLibraryLocator(machOFile, source);
                this.libraries.addAll(machoLibraries);
                ByteSequence machoBitcode = machOFile.extractBitcode();
                if (machoBitcode == null) {
                    return null;
                }
                return this.parseBitcode(machoBitcode, source);
            }
            case XAR_MAGIC: {
                Xar xarFile = Xar.create(bytes);
                ByteSequence xarBitcode = xarFile.extractBitcode();
                if (xarBitcode == null) {
                    return null;
                }
                return this.parseBitcode(xarBitcode, source);
            }
            case COFF_INTEL_AMD64: {
                CoffFile coffFile = CoffFile.create(source, bytes);
                CoffFile.ImageSectionHeader coffBcSection = coffFile.getSection(".llvmbc");
                if (coffBcSection == null) {
                    return null;
                }
                return this.parseBitcode(coffBcSection.getData(), source);
            }
            case MS_DOS: {
                PEFile peFile = PEFile.create(source, bytes);
                CoffFile.ImageSectionHeader peBcSection = peFile.getCoffFile().getSection(".llvmbc");
                if (peBcSection == null) {
                    return null;
                }
                this.libraries.addAll(peFile.getImportLibraries());
                this.exportSymbolsMapper = new PEExportSymbolsMapper(peFile);
                this.locator = new WindowsLibraryLocator(source);
                return this.parseBitcode(peBcSection.getData(), source);
            }
        }
        return null;
    }
}

