// CheckStyle: start generated
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.lang.invoke.MethodHandles;

/**
 * Debug Info: <pre>
 *   Specialization {@link CeilNode#ceilInt}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link CeilNode#ceilSafeInt}
 *     Activation probability: 0.29500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link CeilNode#ceilDouble}
 *     Activation probability: 0.20500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link CeilNode#ceilToDouble}
 *     Activation probability: 0.11500
 *     With/without class size: 5/0 bytes
 * </pre> */
@GeneratedBy(CeilNode.class)
@SuppressWarnings("javadoc")
public final class CeilNodeGen extends CeilNode {

    private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link CeilNode#ceilDouble}
     *   Parameter: {@link InlinedConditionProfile} isZero
     *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
    private static final InlinedConditionProfile INLINED_IS_ZERO = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(7, 2)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link CeilNode#ceilDouble}
     *   Parameter: {@link InlinedConditionProfile} requiresNegativeZero
     *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
    private static final InlinedConditionProfile INLINED_REQUIRES_NEGATIVE_ZERO = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(9, 2)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link CeilNode#ceilDouble}
     *   Parameter: {@link InlinedConditionProfile} fitsInt
     *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
    private static final InlinedConditionProfile INLINED_FITS_INT = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(11, 2)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link CeilNode#ceilDouble}
     *   Parameter: {@link InlinedConditionProfile} fitsSafeLong
     *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
    private static final InlinedConditionProfile INLINED_FITS_SAFE_LONG = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(13, 2)));

    @Child private JavaScriptNode arguments0_;
    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link CeilNode#ceilInt}
     *   1: SpecializationActive {@link CeilNode#ceilSafeInt}
     *   2: SpecializationActive {@link CeilNode#ceilDouble}
     *   3: SpecializationActive {@link CeilNode#ceilToDouble}
     *   4-6: ImplicitCast[type=double, index=0]
     *   7-8: InlinedCache
     *        Specialization: {@link CeilNode#ceilDouble}
     *        Parameter: {@link InlinedConditionProfile} isZero
     *        Inline method: {@link InlinedConditionProfile#inline}
     *   9-10: InlinedCache
     *        Specialization: {@link CeilNode#ceilDouble}
     *        Parameter: {@link InlinedConditionProfile} requiresNegativeZero
     *        Inline method: {@link InlinedConditionProfile#inline}
     *   11-12: InlinedCache
     *        Specialization: {@link CeilNode#ceilDouble}
     *        Parameter: {@link InlinedConditionProfile} fitsInt
     *        Inline method: {@link InlinedConditionProfile#inline}
     *   13-14: InlinedCache
     *        Specialization: {@link CeilNode#ceilDouble}
     *        Parameter: {@link InlinedConditionProfile} fitsSafeLong
     *        Inline method: {@link InlinedConditionProfile#inline}
     * </pre> */
    @CompilationFinal @UnsafeAccessedField private int state_0_;

    private CeilNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[] {this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[CeilNode.ceilInt(int)] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[CeilNode.ceilInt(int)] && SpecializationActive[CeilNode.ceilSafeInt(SafeInteger)] && SpecializationActive[CeilNode.ceilDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] && SpecializationActive[CeilNode.ceilToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */)) {
            return execute_int0(state_0, frameValue);
        } else if ((state_0 & 0b1011) == 0 /* only-active SpecializationActive[CeilNode.ceilDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[CeilNode.ceilInt(int)] && SpecializationActive[CeilNode.ceilSafeInt(SafeInteger)] && SpecializationActive[CeilNode.ceilDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] && SpecializationActive[CeilNode.ceilToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */)) {
            return execute_double1(state_0, frameValue);
        } else {
            return execute_generic2(state_0, frameValue);
        }
    }

    private Object execute_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[CeilNode.ceilInt(int)] */;
        return CeilNode.ceilInt(arguments0Value_);
    }

    private Object execute_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int arguments0Value_int = 0;
        double arguments0Value_;
        try {
            if ((state_0 & 0b1100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[CeilNode.ceilInt(int)] && SpecializationActive[CeilNode.ceilSafeInt(SafeInteger)] && SpecializationActive[CeilNode.ceilDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] && SpecializationActive[CeilNode.ceilToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */)) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else if ((state_0 & 0b1010000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b1111) != 0  /* is-not SpecializationActive[CeilNode.ceilInt(int)] && SpecializationActive[CeilNode.ceilSafeInt(SafeInteger)] && SpecializationActive[CeilNode.ceilDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] && SpecializationActive[CeilNode.ceilToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */)) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[CeilNode.ceilDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
        return ceilDouble(arguments0Value_, INLINED_IS_ZERO, INLINED_REQUIRES_NEGATIVE_ZERO, INLINED_FITS_INT, INLINED_FITS_SAFE_LONG);
    }

    private Object execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state_0 & 0b1111) != 0 /* is SpecializationActive[CeilNode.ceilInt(int)] || SpecializationActive[CeilNode.ceilSafeInt(SafeInteger)] || SpecializationActive[CeilNode.ceilDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[CeilNode.ceilToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[CeilNode.ceilInt(int)] */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                return CeilNode.ceilInt(arguments0Value__);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[CeilNode.ceilSafeInt(SafeInteger)] */ && arguments0Value_ instanceof SafeInteger) {
                SafeInteger arguments0Value__ = (SafeInteger) arguments0Value_;
                return CeilNode.ceilSafeInt(arguments0Value__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[CeilNode.ceilDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                return ceilDouble(arguments0Value__, INLINED_IS_ZERO, INLINED_REQUIRES_NEGATIVE_ZERO, INLINED_FITS_INT, INLINED_FITS_SAFE_LONG);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[CeilNode.ceilToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
                return ceilToDouble(arguments0Value_, INLINED_IS_ZERO, INLINED_REQUIRES_NEGATIVE_ZERO, INLINED_FITS_INT, INLINED_FITS_SAFE_LONG);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arguments0Value_);
    }

    private Object executeAndSpecialize(Object arguments0Value) {
        int state_0 = this.state_0_;
        if (arguments0Value instanceof Integer) {
            int arguments0Value_ = (int) arguments0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[CeilNode.ceilInt(int)] */;
            this.state_0_ = state_0;
            return CeilNode.ceilInt(arguments0Value_);
        }
        if (arguments0Value instanceof SafeInteger) {
            SafeInteger arguments0Value_ = (SafeInteger) arguments0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[CeilNode.ceilSafeInt(SafeInteger)] */;
            this.state_0_ = state_0;
            return CeilNode.ceilSafeInt(arguments0Value_);
        }
        if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[CeilNode.ceilToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */) {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                state_0 = (state_0 | (doubleCast0 << 4) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b100 /* add SpecializationActive[CeilNode.ceilDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
                this.state_0_ = state_0;
                return ceilDouble(arguments0Value_, INLINED_IS_ZERO, INLINED_REQUIRES_NEGATIVE_ZERO, INLINED_FITS_INT, INLINED_FITS_SAFE_LONG);
            }
        }
        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[CeilNode.ceilDouble(double, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
        state_0 = state_0 | 0b1000 /* add SpecializationActive[CeilNode.ceilToDouble(Object, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile)] */;
        this.state_0_ = state_0;
        return ceilToDouble(arguments0Value, INLINED_IS_ZERO, INLINED_REQUIRES_NEGATIVE_ZERO, INLINED_FITS_INT, INLINED_FITS_SAFE_LONG);
    }

    @NeverDefault
    public static CeilNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new CeilNodeGen(context, builtin, arguments);
    }

}
