/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalDurationPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.temporal.UnsupportedValueOfNodeGen;
import com.oracle.truffle.js.nodes.cast.JSNumberToBigIntNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.DifferencePlainDateTimeWithRoundingNode;
import com.oracle.truffle.js.nodes.temporal.DifferenceZonedDateTimeNode;
import com.oracle.truffle.js.nodes.temporal.DifferenceZonedDateTimeWithRoundingNode;
import com.oracle.truffle.js.nodes.temporal.GetRoundingIncrementOptionNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalUnitNode;
import com.oracle.truffle.js.nodes.temporal.TemporalAddDateNode;
import com.oracle.truffle.js.nodes.temporal.TemporalAddZonedDateTimeNode;
import com.oracle.truffle.js.nodes.temporal.TemporalDifferenceDateNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToFractionalSecondDigitsNode;
import com.oracle.truffle.js.nodes.temporal.ToRelativeTemporalObjectNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalPartialDurationRecordNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPrecisionRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.NormalizedDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TemporalDurationWithTotalRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;

public class TemporalDurationPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalDurationPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalDurationPrototypeBuiltins();

    protected TemporalDurationPrototypeBuiltins() {
        super(JSTemporalDuration.PROTOTYPE_NAME, TemporalDurationPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalDurationPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationGetterNodeGen.create(context, builtin, builtinEnum, TemporalDurationPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 12: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationWithNodeGen.create(context, builtin, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 13: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationNegatedNodeGen.create(context, builtin, TemporalDurationPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 14: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationAbsNodeGen.create(context, builtin, TemporalDurationPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 15: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationAddSubNodeGen.create(context, builtin, 1, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 16: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationAddSubNodeGen.create(context, builtin, -1, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 17: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationRoundNodeGen.create(context, builtin, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 18: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationTotalNodeGen.create(context, builtin, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 19: 
            case 21: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationToLocaleStringNodeGen.create(context, builtin, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 20: {
                return TemporalDurationPrototypeBuiltinsFactory.JSTemporalDurationToStringNodeGen.create(context, builtin, TemporalDurationPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 22: {
                return UnsupportedValueOfNodeGen.create(context, builtin, TemporalDurationPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalDurationPrototype implements BuiltinEnum<TemporalDurationPrototype>
    {
        years(0),
        months(0),
        weeks(0),
        days(0),
        hours(0),
        minutes(0),
        seconds(0),
        milliseconds(0),
        microseconds(0),
        nanoseconds(0),
        sign(0),
        blank(0),
        with(1),
        negated(0),
        abs(0),
        add(1),
        subtract(1),
        round(1),
        total(1),
        toJSON(0),
        toString(0),
        toLocaleString(0),
        valueOf(0);

        private final int length;

        private TemporalDurationPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(hours, new TemporalDurationPrototype[]{minutes, seconds, milliseconds, microseconds, nanoseconds, years, months, weeks, days, sign, blank}).contains(this);
        }
    }

    public static abstract class JSTemporalDurationGetterNode
    extends JSBuiltinNode {
        public final TemporalDurationPrototype property;

        public JSTemporalDurationGetterNode(JSContext context, JSBuiltin builtin, TemporalDurationPrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @Specialization
        protected Object durationGetter(JSTemporalDurationObject temporalD) {
            switch (this.property.ordinal()) {
                case 4: {
                    return temporalD.getHours();
                }
                case 5: {
                    return temporalD.getMinutes();
                }
                case 6: {
                    return temporalD.getSeconds();
                }
                case 7: {
                    return temporalD.getMilliseconds();
                }
                case 8: {
                    return temporalD.getMicroseconds();
                }
                case 9: {
                    return temporalD.getNanoseconds();
                }
                case 0: {
                    return temporalD.getYears();
                }
                case 1: {
                    return temporalD.getMonths();
                }
                case 2: {
                    return temporalD.getWeeks();
                }
                case 3: {
                    return temporalD.getDays();
                }
                case 10: {
                    return TemporalUtil.durationSign(temporalD.getYears(), temporalD.getMonths(), temporalD.getWeeks(), temporalD.getDays(), temporalD.getHours(), temporalD.getMinutes(), temporalD.getSeconds(), temporalD.getMilliseconds(), temporalD.getMicroseconds(), temporalD.getNanoseconds());
                }
                case 11: {
                    int sign = TemporalUtil.durationSign(temporalD.getYears(), temporalD.getMonths(), temporalD.getWeeks(), temporalD.getDays(), temporalD.getHours(), temporalD.getMinutes(), temporalD.getSeconds(), temporalD.getMilliseconds(), temporalD.getMicroseconds(), temporalD.getNanoseconds());
                    return sign == 0;
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationWith
    extends JSTemporalBuiltinOperation {
        protected JSTemporalDurationWith(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalDurationObject with(JSTemporalDurationObject duration, Object temporalDurationLike, @Cached ToTemporalPartialDurationRecordNode toTemporalPartialDurationRecord, @Cached InlinedBranchProfile errorBranch) {
            JSTemporalDurationRecord r = toTemporalPartialDurationRecord.execute(temporalDurationLike, JSTemporalDurationRecord.create(duration));
            return JSTemporalDuration.createTemporalDuration(this.getContext(), this.getRealm(), r.getYears(), r.getMonths(), r.getWeeks(), r.getDays(), r.getHours(), r.getMinutes(), r.getSeconds(), r.getMilliseconds(), r.getMicroseconds(), r.getNanoseconds(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDurationLike) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationNegated
    extends JSBuiltinNode {
        protected JSTemporalDurationNegated(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalDurationObject negated(JSTemporalDurationObject duration) {
            return JSTemporalDuration.createNegatedTemporalDuration(this.getContext(), this.getRealm(), duration);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationAbs
    extends JSBuiltinNode {
        protected JSTemporalDurationAbs(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalDurationObject abs(JSTemporalDurationObject duration, @Cached InlinedBranchProfile errorBranch) {
            return JSTemporalDuration.createTemporalDuration(this.getContext(), this.getRealm(), Math.abs(duration.getYears()), Math.abs(duration.getMonths()), Math.abs(duration.getWeeks()), Math.abs(duration.getDays()), Math.abs(duration.getHours()), Math.abs(duration.getMinutes()), Math.abs(duration.getSeconds()), Math.abs(duration.getMilliseconds()), Math.abs(duration.getMicroseconds()), Math.abs(duration.getNanoseconds()), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalDurationAddSubNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected JSTemporalDurationObject addDurations(JSTemporalDurationObject duration, Object other, Object options, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached ToRelativeTemporalObjectNode toRelativeTemporalObjectNode, @Cached TemporalAddDateNode addDateNode, @Cached TemporalDifferenceDateNode differenceDateNode, @Cached DifferenceZonedDateTimeNode differenceZonedDateTimeNode, @Cached TemporalAddZonedDateTimeNode addZonedDateTimeNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined, @Cached InlinedBranchProfile relativeToUndefinedBranch, @Cached InlinedBranchProfile relativeToPlainDateBranch, @Cached InlinedBranchProfile relativeToZonedDateTimeBranch) {
            JSTemporalDurationObject otherDuration = toTemporalDurationNode.execute(other);
            JSDynamicObject normalizedOptions = this.getOptionsObject(options, this, errorBranch, optionUndefined);
            ToRelativeTemporalObjectNode.Result relativeToRec = toRelativeTemporalObjectNode.execute(normalizedOptions);
            JSTemporalPlainDateObject plainRelativeTo = relativeToRec.plainRelativeTo();
            JSTemporalZonedDateTimeObject zonedRelativeTo = relativeToRec.zonedRelativeTo();
            JSContext ctx = this.getJSContext();
            JSRealm realm = this.getRealm();
            double y1 = duration.getYears();
            double mon1 = duration.getMonths();
            double w1 = duration.getWeeks();
            double d1 = duration.getDays();
            double h1 = duration.getHours();
            double min1 = duration.getMinutes();
            double s1 = duration.getSeconds();
            double ms1 = duration.getMilliseconds();
            double mus1 = duration.getMicroseconds();
            double ns1 = duration.getNanoseconds();
            double y2 = (double)this.sign * otherDuration.getYears();
            double mon2 = (double)this.sign * otherDuration.getMonths();
            double w2 = (double)this.sign * otherDuration.getWeeks();
            double d2 = (double)this.sign * otherDuration.getDays();
            double h2 = (double)this.sign * otherDuration.getHours();
            double min2 = (double)this.sign * otherDuration.getMinutes();
            double s2 = (double)this.sign * otherDuration.getSeconds();
            double ms2 = (double)this.sign * otherDuration.getMilliseconds();
            double mus2 = (double)this.sign * otherDuration.getMicroseconds();
            double ns2 = (double)this.sign * otherDuration.getNanoseconds();
            TemporalUtil.Unit largestUnit1 = TemporalUtil.defaultTemporalLargestUnit(y1, mon1, w1, d1, h1, min1, s1, ms1, mus1);
            TemporalUtil.Unit largestUnit2 = TemporalUtil.defaultTemporalLargestUnit(y2, mon2, w2, d2, h2, min2, s2, ms2, mus2);
            TemporalUtil.Unit largestUnit = TemporalUtil.largerOfTwoTemporalUnits(largestUnit1, largestUnit2);
            BigInt norm1 = TemporalUtil.normalizeTimeDuration(h1, min1, s1, ms1, mus1, ns1);
            BigInt norm2 = TemporalUtil.normalizeTimeDuration(h2, min2, s2, ms2, mus2, ns2);
            if (zonedRelativeTo == null && plainRelativeTo == null) {
                relativeToUndefinedBranch.enter((Node)this);
                if (largestUnit.isCalendarUnit()) {
                    errorBranch.enter((Node)this);
                    throw Errors.createRangeError("Largest unit allowed with no relativeTo is 'days'.");
                }
                BigInt normResult = TemporalUtil.addNormalizedTimeDuration(norm1, norm2);
                normResult = TemporalUtil.add24HourDaysToNormalizedTimeDuration(normResult, d1 + d2);
                TimeDurationRecord result = TemporalUtil.balanceTimeDuration(normResult, largestUnit);
                return JSTemporalDuration.createTemporalDuration(ctx, realm, 0.0, 0.0, 0.0, result.days(), result.hours(), result.minutes(), result.seconds(), result.milliseconds(), result.microseconds(), result.nanoseconds(), this, errorBranch);
            }
            if (plainRelativeTo != null) {
                relativeToPlainDateBranch.enter((Node)this);
                TruffleString calendar = plainRelativeTo.getCalendar();
                JSTemporalDurationObject dateDuration1 = JSTemporalDuration.createTemporalDuration(ctx, realm, y1, mon1, w1, d1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
                JSTemporalDurationObject dateDuration2 = JSTemporalDuration.createTemporalDuration(ctx, realm, y2, mon2, w2, d2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
                JSTemporalPlainDateObject intermediate = addDateNode.execute(calendar, plainRelativeTo, dateDuration1, TemporalUtil.Overflow.CONSTRAIN);
                JSTemporalPlainDateObject end = addDateNode.execute(calendar, intermediate, dateDuration2, TemporalUtil.Overflow.CONSTRAIN);
                TemporalUtil.Unit dateLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(TemporalUtil.Unit.DAY, largestUnit);
                JSTemporalDurationObject dateDifference = differenceDateNode.execute(calendar, plainRelativeTo, end, dateLargestUnit);
                BigInt norm1WithDays = TemporalUtil.add24HourDaysToNormalizedTimeDuration(norm1, dateDifference.getDays());
                BigInt normResult = TemporalUtil.addNormalizedTimeDuration(norm1WithDays, norm2);
                TimeDurationRecord result = TemporalUtil.balanceTimeDuration(normResult, largestUnit);
                return JSTemporalDuration.createTemporalDuration(ctx, realm, dateDifference.getYears(), dateDifference.getMonths(), dateDifference.getWeeks(), result.days(), result.hours(), result.minutes(), result.seconds(), result.milliseconds(), result.microseconds(), result.nanoseconds(), this, errorBranch);
            }
            assert (zonedRelativeTo != null);
            TruffleString calendar = zonedRelativeTo.getCalendar();
            TruffleString timeZone = zonedRelativeTo.getTimeZone();
            relativeToZonedDateTimeBranch.enter((Node)this);
            JSTemporalPlainDateTimeObject startDateTime = null;
            if (largestUnit.isDateUnit()) {
                JSTemporalInstantObject relativeToInstant = JSTemporalInstant.create(ctx, realm, zonedRelativeTo.getNanoseconds());
                startDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZone, relativeToInstant, calendar);
            }
            BigInt intermediateNs = addZonedDateTimeNode.execute(zonedRelativeTo.getNanoseconds(), timeZone, calendar, y1, mon1, w1, d1, norm1, startDateTime);
            BigInt endNs = addZonedDateTimeNode.execute(intermediateNs, timeZone, calendar, y2, mon2, w2, d2, norm2, null);
            if (largestUnit.isTimeUnit()) {
                BigInt norm = TemporalUtil.normalizedTimeDurationFromEpochNanosecondsDifference(endNs, zonedRelativeTo.getNanoseconds());
                TimeDurationRecord result = TemporalUtil.balanceTimeDuration(norm, largestUnit);
                return JSTemporalDuration.createTemporalDuration(ctx, realm, 0.0, 0.0, 0.0, 0.0, result.hours(), result.minutes(), result.seconds(), result.milliseconds(), result.microseconds(), result.nanoseconds(), this, errorBranch);
            }
            NormalizedDurationRecord diffResult = differenceZonedDateTimeNode.execute(zonedRelativeTo.getNanoseconds(), endNs, timeZone, calendar, largestUnit, startDateTime);
            TimeDurationRecord timeResult = TemporalUtil.balanceTimeDuration(diffResult.normalizedTimeTotalNanoseconds(), TemporalUtil.Unit.HOUR);
            return JSTemporalDuration.createTemporalDuration(ctx, realm, diffResult.years(), diffResult.months(), diffResult.weeks(), diffResult.days(), timeResult.hours(), timeResult.minutes(), timeResult.seconds(), timeResult.milliseconds(), timeResult.microseconds(), timeResult.nanoseconds(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object other, Object options) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationRound
    extends JSTemporalBuiltinOperation {
        protected JSTemporalDurationRound(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalDurationObject round(JSTemporalDurationObject duration, Object roundToParam, @Bind Node node, @Cached TruffleString.EqualNode equalNode, @Cached InlinedConditionProfile roundToIsTString, @Cached InlinedConditionProfile relativeToIsZonedDateTime, @Cached ToRelativeTemporalObjectNode toRelativeTemporalObjectNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalUnitNode getLargestUnit, @Cached GetTemporalUnitNode getSmallestUnit, @Cached GetRoundingIncrementOptionNode getRoundingIncrementOption, @Cached TemporalAddDateNode addDate, @Cached DifferencePlainDateTimeWithRoundingNode differencePlainDateTimeWithRounding, @Cached DifferenceZonedDateTimeWithRoundingNode differenceZonedDateTimeWithRounding, @Cached TemporalAddZonedDateTimeNode addZonedDateTimeNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalDurationRecord roundResult;
            boolean plainDateTimeOrRelativeToWillBeUsed;
            boolean hoursToDaysConversionMayOccur;
            JSDynamicObject roundTo;
            if (roundToParam == Undefined.instance) {
                throw TemporalErrors.createTypeErrorOptionsUndefined();
            }
            JSContext ctx = this.getContext();
            if (roundToIsTString.profile(node, Strings.isTString(roundToParam))) {
                roundTo = JSOrdinary.createWithNullPrototype(ctx);
                JSRuntime.createDataPropertyOrThrow(roundTo, TemporalConstants.SMALLEST_UNIT, roundToParam);
            } else {
                roundTo = this.getOptionsObject(roundToParam, node, errorBranch, optionUndefined);
            }
            boolean smallestUnitPresent = true;
            boolean largestUnitPresent = true;
            TemporalUtil.Unit largestUnit = getLargestUnit.execute(roundTo, TemporalConstants.LARGEST_UNIT, TemporalUtil.unitMappingDateTimeOrAuto, TemporalUtil.Unit.EMPTY);
            ToRelativeTemporalObjectNode.Result relativeToRec = toRelativeTemporalObjectNode.execute(roundTo);
            JSTemporalZonedDateTimeObject zonedRelativeTo = relativeToRec.zonedRelativeTo();
            JSTemporalPlainDateObject plainRelativeTo = relativeToRec.plainRelativeTo();
            int roundingIncrement = getRoundingIncrementOption.execute((Object)roundTo);
            TemporalUtil.RoundingMode roundingMode = JSTemporalDurationRound.toTemporalRoundingMode(roundTo, TemporalConstants.HALF_EXPAND, equalNode, getOptionNode);
            TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(roundTo, TemporalConstants.SMALLEST_UNIT, TemporalUtil.unitMappingDateTime, TemporalUtil.Unit.EMPTY);
            if (smallestUnit == TemporalUtil.Unit.EMPTY) {
                smallestUnitPresent = false;
                smallestUnit = TemporalUtil.Unit.NANOSECOND;
            }
            TemporalUtil.Unit existingLargestUnit = TemporalUtil.defaultTemporalLargestUnit(duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds());
            TemporalUtil.Unit defaultLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(existingLargestUnit, smallestUnit);
            if (largestUnit == TemporalUtil.Unit.EMPTY) {
                largestUnitPresent = false;
                largestUnit = defaultLargestUnit;
            } else if (TemporalUtil.Unit.AUTO == largestUnit) {
                largestUnit = defaultLargestUnit;
            }
            if (!smallestUnitPresent && !largestUnitPresent) {
                errorBranch.enter(node);
                throw Errors.createRangeError("at least one of smallestUnit or largestUnit is required");
            }
            JSRealm realm = this.getRealm();
            TemporalUtil.validateTemporalUnitRange(largestUnit, smallestUnit);
            Integer maximum = TemporalUtil.maximumTemporalDurationRoundingIncrement(smallestUnit);
            if (maximum != null) {
                TemporalUtil.validateTemporalRoundingIncrement(roundingIncrement, maximum.intValue(), false, node, errorBranch);
            }
            boolean roundingGranularityIsNoop = smallestUnit == TemporalUtil.Unit.NANOSECOND && roundingIncrement == 1;
            boolean calendarUnitsPresent = duration.getYears() != 0.0 || duration.getMonths() != 0.0 || duration.getWeeks() != 0.0;
            boolean bl = hoursToDaysConversionMayOccur = duration.getDays() != 0.0 && zonedRelativeTo != null || Math.abs(duration.getHours()) >= 24.0;
            if (roundingGranularityIsNoop && largestUnit == existingLargestUnit && !calendarUnitsPresent && !hoursToDaysConversionMayOccur && Math.abs(duration.getMinutes()) < 60.0 && Math.abs(duration.getSeconds()) < 60.0 && Math.abs(duration.getMilliseconds()) < 1000.0 && Math.abs(duration.getMicroseconds()) < 1000.0 && Math.abs(duration.getNanoseconds()) < 1000.0) {
                return JSTemporalDuration.createTemporalDuration(ctx, realm, duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds(), this, errorBranch);
            }
            JSTemporalPlainDateTimeObject precalculatedPlainDateTime = null;
            boolean bl2 = plainDateTimeOrRelativeToWillBeUsed = largestUnit.isCalendarUnit() || largestUnit == TemporalUtil.Unit.DAY || calendarUnitsPresent || duration.getDays() != 0.0;
            if (zonedRelativeTo != null && plainDateTimeOrRelativeToWillBeUsed) {
                JSTemporalInstantObject instant = JSTemporalInstant.create(ctx, realm, zonedRelativeTo.getNanoseconds());
                precalculatedPlainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, zonedRelativeTo.getTimeZone(), instant, zonedRelativeTo.getCalendar());
                plainRelativeTo = JSTemporalPlainDate.create(ctx, realm, precalculatedPlainDateTime.getYear(), precalculatedPlainDateTime.getMonth(), precalculatedPlainDateTime.getDay(), zonedRelativeTo.getCalendar(), node, errorBranch);
            }
            BigInt norm = TemporalUtil.normalizeTimeDuration(duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds());
            if (relativeToIsZonedDateTime.profile(node, zonedRelativeTo != null)) {
                TruffleString calendar = zonedRelativeTo.getCalendar();
                TruffleString timeZone = zonedRelativeTo.getTimeZone();
                BigInt relativeEpochNs = zonedRelativeTo.getNanoseconds();
                BigInt targetEpochNs = addZonedDateTimeNode.execute(relativeEpochNs, timeZone, calendar, duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), norm, precalculatedPlainDateTime);
                TemporalDurationWithTotalRecord roundRecord = differenceZonedDateTimeWithRounding.execute(relativeEpochNs, targetEpochNs, calendar, timeZone, precalculatedPlainDateTime, largestUnit, roundingIncrement, smallestUnit, roundingMode);
                roundResult = roundRecord.duration();
            } else if (relativeToIsZonedDateTime.profile(node, plainRelativeTo != null)) {
                TruffleString calendar = plainRelativeTo.getCalendar();
                TimeRecord targetTime = TemporalUtil.addTime(0, 0, 0, 0, 0, 0.0, norm, node, errorBranch);
                JSTemporalDurationObject dateDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays() + targetTime.days(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
                JSTemporalPlainDateObject targetDate = addDate.execute(calendar, plainRelativeTo, dateDuration, TemporalUtil.Overflow.CONSTRAIN);
                TemporalDurationWithTotalRecord roundRecord = differencePlainDateTimeWithRounding.execute(plainRelativeTo, 0, 0, 0, 0, 0, 0, targetDate.getYear(), targetDate.getMonth(), targetDate.getDay(), targetTime.hour(), targetTime.minute(), targetTime.second(), targetTime.millisecond(), targetTime.microsecond(), targetTime.nanosecond(), calendar, largestUnit, roundingIncrement, smallestUnit, roundingMode);
                roundResult = roundRecord.duration();
            } else {
                if (calendarUnitsPresent || largestUnit.isCalendarUnit() || smallestUnit.isCalendarUnit()) {
                    throw Errors.createRangeError("a starting point is required for years, months, or weeks balancing and rounding");
                }
                TemporalUtil.NormalizedDurationWithTotalRecord roundRecord = TemporalUtil.roundTimeDuration(duration.getDays(), norm, roundingIncrement, smallestUnit, roundingMode);
                BigInt normWithDays = TemporalUtil.add24HourDaysToNormalizedTimeDuration(roundRecord.normalizedDuration().normalizedTimeTotalNanoseconds(), roundRecord.normalizedDuration().days());
                TimeDurationRecord balanceResult = TemporalUtil.balanceTimeDuration(normWithDays, largestUnit);
                roundResult = JSTemporalDurationRecord.createWeeks(0.0, 0.0, 0.0, balanceResult.days(), balanceResult.hours(), balanceResult.minutes(), balanceResult.seconds(), balanceResult.milliseconds(), balanceResult.microseconds(), balanceResult.nanoseconds());
            }
            return JSTemporalDuration.createTemporalDuration(ctx, realm, roundResult.getYears(), roundResult.getMonths(), roundResult.getWeeks(), roundResult.getDays(), roundResult.getHours(), roundResult.getMinutes(), roundResult.getSeconds(), roundResult.getMilliseconds(), roundResult.getMicroseconds(), roundResult.getNanoseconds(), node, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object roundToParam) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationTotal
    extends JSTemporalBuiltinOperation {
        protected JSTemporalDurationTotal(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final double total(JSTemporalDurationObject duration, Object totalOfParam, @Bind Node node, @Cached ToRelativeTemporalObjectNode toRelativeTemporalObjectNode, @Cached GetTemporalUnitNode getTemporalUnit, @Cached TemporalAddDateNode addDate, @Cached DifferencePlainDateTimeWithRoundingNode differencePlainDateTimeWithRounding, @Cached DifferenceZonedDateTimeWithRoundingNode differenceZonedDateTimeWithRounding, @Cached TemporalAddZonedDateTimeNode addZonedDateTimeNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            double total;
            boolean plainDateTimeOrRelativeToWillBeUsed;
            JSDynamicObject totalOf;
            if (totalOfParam == Undefined.instance) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorOptionsUndefined();
            }
            JSRealm realm = this.getRealm();
            if (Strings.isTString(totalOfParam)) {
                totalOf = JSOrdinary.createWithNullPrototype(this.getContext());
                JSRuntime.createDataPropertyOrThrow(totalOf, TemporalConstants.UNIT, totalOfParam);
            } else {
                totalOf = this.getOptionsObject(totalOfParam, node, errorBranch, optionUndefined);
            }
            ToRelativeTemporalObjectNode.Result relativeToRec = toRelativeTemporalObjectNode.execute(totalOf);
            JSTemporalZonedDateTimeObject zonedRelativeTo = relativeToRec.zonedRelativeTo();
            JSTemporalPlainDateObject plainRelativeTo = relativeToRec.plainRelativeTo();
            TemporalUtil.Unit unit = getTemporalUnit.execute(totalOf, TemporalConstants.UNIT, TemporalUtil.unitMappingDateTime, TemporalUtil.Unit.REQUIRED);
            JSTemporalPlainDateTimeObject precalculatedPlainDateTime = null;
            boolean bl = plainDateTimeOrRelativeToWillBeUsed = unit == TemporalUtil.Unit.YEAR || unit == TemporalUtil.Unit.MONTH || unit == TemporalUtil.Unit.WEEK || unit == TemporalUtil.Unit.DAY || duration.getYears() != 0.0 || duration.getMonths() != 0.0 || duration.getWeeks() != 0.0;
            if (zonedRelativeTo != null && plainDateTimeOrRelativeToWillBeUsed) {
                JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedRelativeTo.getNanoseconds());
                precalculatedPlainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, zonedRelativeTo.getTimeZone(), instant, zonedRelativeTo.getCalendar());
                plainRelativeTo = JSTemporalPlainDate.create(this.getContext(), realm, precalculatedPlainDateTime.getYear(), precalculatedPlainDateTime.getMonth(), precalculatedPlainDateTime.getDay(), zonedRelativeTo.getCalendar(), node, errorBranch);
            }
            BigInt norm = TemporalUtil.normalizeTimeDuration(duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds());
            if (zonedRelativeTo != null) {
                TruffleString calendar = zonedRelativeTo.getCalendar();
                TruffleString timeZone = zonedRelativeTo.getTimeZone();
                BigInt relativeEpochNs = zonedRelativeTo.getNanoseconds();
                BigInt targetEpochNs = addZonedDateTimeNode.execute(relativeEpochNs, timeZone, calendar, duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), norm, precalculatedPlainDateTime);
                TemporalDurationWithTotalRecord roundRecord = differenceZonedDateTimeWithRounding.execute(relativeEpochNs, targetEpochNs, calendar, timeZone, precalculatedPlainDateTime, unit, 1, unit, TemporalUtil.RoundingMode.TRUNC);
                total = roundRecord.total();
            } else if (plainRelativeTo != null) {
                TruffleString calendar = plainRelativeTo.getCalendar();
                TimeRecord targetTime = TemporalUtil.addTime(0, 0, 0, 0, 0, 0.0, norm, node, errorBranch);
                JSTemporalDurationObject dateDuration = JSTemporalDuration.createTemporalDuration(this.getContext(), realm, duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays() + targetTime.days(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
                JSTemporalPlainDateObject targetDate = addDate.execute(calendar, plainRelativeTo, dateDuration, TemporalUtil.Overflow.CONSTRAIN);
                TemporalDurationWithTotalRecord roundRecord = differencePlainDateTimeWithRounding.execute(plainRelativeTo, 0, 0, 0, 0, 0, 0, targetDate.getYear(), targetDate.getMonth(), targetDate.getDay(), targetTime.hour(), targetTime.minute(), targetTime.second(), targetTime.millisecond(), targetTime.microsecond(), targetTime.nanosecond(), calendar, unit, 1, unit, TemporalUtil.RoundingMode.TRUNC);
                total = roundRecord.total();
            } else {
                if (duration.getYears() != 0.0 || duration.getMonths() != 0.0 || duration.getWeeks() != 0.0 || unit.isCalendarUnit()) {
                    throw Errors.createRangeError("a starting point is required for years, months, or weeks total");
                }
                BigInt normWithDays = TemporalUtil.add24HourDaysToNormalizedTimeDuration(norm, duration.getDays());
                TemporalUtil.NormalizedDurationWithTotalRecord roundRecord = TemporalUtil.roundTimeDuration(0.0, normWithDays, 1, unit, TemporalUtil.RoundingMode.TRUNC);
                total = roundRecord.total();
            }
            return total;
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object totalOfParam) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalDurationToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static TruffleString toString(JSTemporalDurationObject duration, @Cached JSNumberToBigIntNode toBigIntNode) {
            return JSTemporalDuration.temporalDurationToString(TemporalUtil.dtol(duration.getYears()), TemporalUtil.dtol(duration.getMonths()), TemporalUtil.dtol(duration.getWeeks()), TemporalUtil.dtol(duration.getDays()), TemporalUtil.dtol(duration.getHours()), TemporalUtil.dtol(duration.getMinutes()), TemporalUtil.dtol(duration.getSeconds()), TemporalUtil.dtol(duration.getMilliseconds()), TemporalUtil.dtol(duration.getMicroseconds()), TemporalUtil.dtol(duration.getNanoseconds()), TemporalConstants.AUTO, toBigIntNode);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }

    public static abstract class JSTemporalDurationToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalDurationToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalDurationObject duration, Object opt, @Cached ToFractionalSecondDigitsNode toFractionalSecondDigitsNode, @Cached JSNumberToBigIntNode toBigIntNode, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalUnitNode getSmallestUnit, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalDurationRecord result;
            JSDynamicObject options = this.getOptionsObject(opt, this, errorBranch, optionUndefined);
            int digits = toFractionalSecondDigitsNode.execute((Object)options);
            TemporalUtil.RoundingMode roundingMode = JSTemporalDurationToString.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(options, TemporalConstants.SMALLEST_UNIT, TemporalUtil.unitMappingTime, TemporalUtil.Unit.EMPTY);
            if (smallestUnit == TemporalUtil.Unit.HOUR || smallestUnit == TemporalUtil.Unit.MINUTE) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorSmallestUnitOutOfRange();
            }
            JSTemporalPrecisionRecord precision = TemporalUtil.toSecondsStringPrecisionRecord(smallestUnit, digits);
            if (precision.getUnit() != TemporalUtil.Unit.NANOSECOND || precision.getIncrement() != 1) {
                BigInt norm = TemporalUtil.normalizeTimeDuration(duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds());
                TemporalUtil.Unit largestUnit = TemporalUtil.defaultTemporalLargestUnit(duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds());
                TemporalUtil.NormalizedDurationWithTotalRecord roundRecord = TemporalUtil.roundTimeDuration(0.0, norm, precision.getIncrement(), precision.getUnit(), roundingMode);
                norm = roundRecord.normalizedDuration().normalizedTimeTotalNanoseconds();
                TimeDurationRecord time = TemporalUtil.balanceTimeDuration(norm, TemporalUtil.largerOfTwoTemporalUnits(largestUnit, TemporalUtil.Unit.SECOND));
                result = JSTemporalDurationRecord.createWeeks(duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays() + time.days(), time.hours(), time.minutes(), time.seconds(), time.milliseconds(), time.microseconds(), time.nanoseconds());
            } else {
                result = JSTemporalDurationRecord.create(duration);
            }
            return JSTemporalDuration.temporalDurationToString(result.getYears(), result.getMonths(), result.getWeeks(), result.getDays(), result.getHours(), result.getMinutes(), result.getSeconds(), result.getMilliseconds(), result.getMicroseconds(), result.getNanoseconds(), precision.getPrecision(), toBigIntNode);
        }

        @Specialization(guards={"!isJSTemporalDuration(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object opt) {
            throw TemporalErrors.createTypeErrorTemporalDurationExpected();
        }
    }
}

