// CheckStyle: start generated
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString.FromJavaStringNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNode;
import com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNodeGen;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.nodes.interop.KeyInfoNodeGen;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(JSObject.class)
@SuppressWarnings("javadoc")
public final class JSObjectGen {

    static  {
        LibraryExport.register(JSObject.class, new InteropLibraryExports());
    }

    private JSObjectGen() {
    }

    @GeneratedBy(JSObject.class)
    public static class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, JSObject.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof JSObject;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof JSObject;
            return new Cached(receiver);
        }

        @GeneratedBy(JSObject.class)
        public static class Cached extends JSDynamicObjectGen.InteropLibraryExports.Cached {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link JSObject#readMember(JSObject, String, InteropLibrary, ReadElementNode, boolean, FromJavaStringNode, ExportValueNode)}
             *   1: SpecializationActive {@link JSObject#isMemberReadable(JSObject, String, KeyInfoNode)}
             *   2: SpecializationActive {@link JSObject#writeMember(JSObject, String, Object, InteropLibrary, KeyInfoNode, ImportValueNode, WriteElementNode, FromJavaStringNode)}
             *   3: SpecializationActive {@link JSObject#isMemberModifiable(JSObject, String, KeyInfoNode)}
             *   4: SpecializationActive {@link JSObject#isMemberInsertable(JSObject, String, KeyInfoNode)}
             *   5: SpecializationActive {@link JSObject#removeMember(JSObject, String, FromJavaStringNode)}
             *   6: SpecializationActive {@link JSObject#isMemberRemovable(JSObject, String, KeyInfoNode)}
             *   7: SpecializationActive {@link JSObject#invokeMember(JSObject, String, Object[], InteropLibrary, JSInteropInvokeNode, FromJavaStringNode, ExportValueNode)}
             *   8: SpecializationActive {@link JSObject#isMemberInvocable(JSObject, String, KeyInfoNode)}
             *   9: SpecializationActive {@link JSObject#hasMemberReadSideEffects(JSObject, String, KeyInfoNode)}
             *   10: SpecializationActive {@link JSObject#hasMemberWriteSideEffects(JSObject, String, KeyInfoNode)}
             *   11: SpecializationActive {@link JSObject#hasIterator(JSObject, InteropLibrary, JSInteropGetIteratorNode)}
             *   12: SpecializationActive {@link JSObject#getIterator(JSObject, InteropLibrary, JSInteropGetIteratorNode)}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link JSObject#readMember}
             *   Parameter: {@link FromJavaStringNode} fromJavaString</pre> */
            @Child private FromJavaStringNode fromJavaString;
            /**
             * Source Info: <pre>
             *   Specialization: {@link JSObject#isMemberReadable}
             *   Parameter: {@link KeyInfoNode} keyInfo</pre> */
            @Child private KeyInfoNode keyInfo;
            /**
             * Source Info: <pre>
             *   Specialization: {@link JSObject#hasIterator}
             *   Parameter: {@link JSInteropGetIteratorNode} getIteratorNode</pre> */
            @Child private JSInteropGetIteratorNode getIteratorNode;
            @Child private ReadMemberNode_ReadMemberData readMemberNode__readMember_cache;
            @Child private WriteMemberNode_WriteMemberData writeMemberNode__writeMember_cache;
            @Child private InvokeMemberNode_InvokeMemberData invokeMemberNode__invokeMember_cache;

            protected Cached(Object receiver) {
                super(receiver);
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((JSObject) receiver)).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((JSObject) receiver)).getMembers(includeInternal);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#readMember(JSObject, String, InteropLibrary, ReadElementNode, boolean, FromJavaStringNode, ExportValueNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 5/9 bytes
             * </pre> */
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSObject.readMember(JSObject, String, InteropLibrary, ReadElementNode, boolean, FromJavaStringNode, ExportValueNode)] */) {
                    ReadMemberNode_ReadMemberData s0_ = this.readMemberNode__readMember_cache;
                    if (s0_ != null) {
                        {
                            FromJavaStringNode fromJavaString_ = this.fromJavaString;
                            if (fromJavaString_ != null) {
                                InteropLibrary self__ = (this);
                                return arg0Value.readMember(arg1Value, self__, s0_.readNode_, s0_.bindMemberFunctions_, fromJavaString_, s0_.exportNode_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(JSObject arg0Value, String arg1Value) throws UnknownIdentifierException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary self__ = null;
                    ReadMemberNode_ReadMemberData s0_ = this.insert(new ReadMemberNode_ReadMemberData());
                    self__ = (this);
                    ReadElementNode readNode__ = s0_.insert((ReadElementNode.create(JSObject.language(self__).getJSContext())));
                    Objects.requireNonNull(readNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s0_.readNode_ = readNode__;
                    s0_.bindMemberFunctions_ = (JSObject.language(self__).bindMemberFunctions());
                    FromJavaStringNode fromJavaString_;
                    FromJavaStringNode fromJavaString__shared = this.fromJavaString;
                    if (fromJavaString__shared != null) {
                        fromJavaString_ = fromJavaString__shared;
                    } else {
                        fromJavaString_ = s0_.insert((FromJavaStringNode.create()));
                        if (fromJavaString_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.fromJavaString == null) {
                        this.fromJavaString = fromJavaString_;
                    }
                    ExportValueNode exportNode__ = s0_.insert((ExportValueNode.create()));
                    Objects.requireNonNull(exportNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s0_.exportNode_ = exportNode__;
                    VarHandle.storeStoreFence();
                    this.readMemberNode__readMember_cache = s0_;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[JSObject.readMember(JSObject, String, InteropLibrary, ReadElementNode, boolean, FromJavaStringNode, ExportValueNode)] */;
                    this.state_0_ = state_0;
                    return arg0Value.readMember(arg1Value, self__, readNode__, s0_.bindMemberFunctions_, fromJavaString_, exportNode__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#isMemberReadable(JSObject, String, KeyInfoNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre> */
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSObject.isMemberReadable(JSObject, String, KeyInfoNode)] */) {
                    {
                        KeyInfoNode keyInfo_ = this.keyInfo;
                        if (keyInfo_ != null) {
                            return arg0Value.isMemberReadable(arg1Value, keyInfo_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = this.insert((KeyInfoNodeGen.create()));
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[JSObject.isMemberReadable(JSObject, String, KeyInfoNode)] */;
                this.state_0_ = state_0;
                return arg0Value.isMemberReadable(arg1Value, keyInfo_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#writeMember(JSObject, String, Object, InteropLibrary, KeyInfoNode, ImportValueNode, WriteElementNode, FromJavaStringNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 5/8 bytes
             * </pre> */
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSObject.writeMember(JSObject, String, Object, InteropLibrary, KeyInfoNode, ImportValueNode, WriteElementNode, FromJavaStringNode)] */) {
                    WriteMemberNode_WriteMemberData s0_ = this.writeMemberNode__writeMember_cache;
                    if (s0_ != null) {
                        {
                            KeyInfoNode keyInfo_ = this.keyInfo;
                            if (keyInfo_ != null) {
                                FromJavaStringNode fromJavaString_ = this.fromJavaString;
                                if (fromJavaString_ != null) {
                                    InteropLibrary self__ = (this);
                                    arg0Value.writeMember(arg1Value, arg2Value, self__, keyInfo_, s0_.castValueNode_, s0_.writeNode_, fromJavaString_);
                                    return;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeMemberNode_AndSpecialize(JSObject arg0Value, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary self__ = null;
                    WriteMemberNode_WriteMemberData s0_ = this.insert(new WriteMemberNode_WriteMemberData());
                    self__ = (this);
                    KeyInfoNode keyInfo_;
                    KeyInfoNode keyInfo__shared = this.keyInfo;
                    if (keyInfo__shared != null) {
                        keyInfo_ = keyInfo__shared;
                    } else {
                        keyInfo_ = s0_.insert((KeyInfoNodeGen.create()));
                        if (keyInfo_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.keyInfo == null) {
                        this.keyInfo = keyInfo_;
                    }
                    ImportValueNode castValueNode__ = s0_.insert((ImportValueNode.create()));
                    Objects.requireNonNull(castValueNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s0_.castValueNode_ = castValueNode__;
                    WriteElementNode writeNode__ = s0_.insert((WriteElementNode.createCachedInterop()));
                    Objects.requireNonNull(writeNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s0_.writeNode_ = writeNode__;
                    FromJavaStringNode fromJavaString_;
                    FromJavaStringNode fromJavaString__shared = this.fromJavaString;
                    if (fromJavaString__shared != null) {
                        fromJavaString_ = fromJavaString__shared;
                    } else {
                        fromJavaString_ = s0_.insert((FromJavaStringNode.create()));
                        if (fromJavaString_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.fromJavaString == null) {
                        this.fromJavaString = fromJavaString_;
                    }
                    VarHandle.storeStoreFence();
                    this.writeMemberNode__writeMember_cache = s0_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[JSObject.writeMember(JSObject, String, Object, InteropLibrary, KeyInfoNode, ImportValueNode, WriteElementNode, FromJavaStringNode)] */;
                    this.state_0_ = state_0;
                    arg0Value.writeMember(arg1Value, arg2Value, self__, keyInfo_, castValueNode__, writeNode__, fromJavaString_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#isMemberModifiable(JSObject, String, KeyInfoNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre> */
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSObject.isMemberModifiable(JSObject, String, KeyInfoNode)] */) {
                    {
                        KeyInfoNode keyInfo_ = this.keyInfo;
                        if (keyInfo_ != null) {
                            return arg0Value.isMemberModifiable(arg1Value, keyInfo_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = this.insert((KeyInfoNodeGen.create()));
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[JSObject.isMemberModifiable(JSObject, String, KeyInfoNode)] */;
                this.state_0_ = state_0;
                return arg0Value.isMemberModifiable(arg1Value, keyInfo_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#isMemberInsertable(JSObject, String, KeyInfoNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre> */
            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSObject.isMemberInsertable(JSObject, String, KeyInfoNode)] */) {
                    {
                        KeyInfoNode keyInfo_ = this.keyInfo;
                        if (keyInfo_ != null) {
                            return arg0Value.isMemberInsertable(arg1Value, keyInfo_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInsertableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = this.insert((KeyInfoNodeGen.create()));
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[JSObject.isMemberInsertable(JSObject, String, KeyInfoNode)] */;
                this.state_0_ = state_0;
                return arg0Value.isMemberInsertable(arg1Value, keyInfo_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#removeMember(JSObject, String, FromJavaStringNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre> */
            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSObject.removeMember(JSObject, String, FromJavaStringNode)] */) {
                    {
                        FromJavaStringNode fromJavaString_ = this.fromJavaString;
                        if (fromJavaString_ != null) {
                            arg0Value.removeMember(arg1Value, fromJavaString_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                removeMemberNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void removeMemberNode_AndSpecialize(JSObject arg0Value, String arg1Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                FromJavaStringNode fromJavaString_;
                FromJavaStringNode fromJavaString__shared = this.fromJavaString;
                if (fromJavaString__shared != null) {
                    fromJavaString_ = fromJavaString__shared;
                } else {
                    fromJavaString_ = this.insert((FromJavaStringNode.create()));
                    if (fromJavaString_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.fromJavaString == null) {
                    VarHandle.storeStoreFence();
                    this.fromJavaString = fromJavaString_;
                }
                state_0 = state_0 | 0b100000 /* add SpecializationActive[JSObject.removeMember(JSObject, String, FromJavaStringNode)] */;
                this.state_0_ = state_0;
                arg0Value.removeMember(arg1Value, fromJavaString_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#isMemberRemovable(JSObject, String, KeyInfoNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre> */
            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSObject.isMemberRemovable(JSObject, String, KeyInfoNode)] */) {
                    {
                        KeyInfoNode keyInfo_ = this.keyInfo;
                        if (keyInfo_ != null) {
                            return arg0Value.isMemberRemovable(arg1Value, keyInfo_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberRemovableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = this.insert((KeyInfoNodeGen.create()));
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[JSObject.isMemberRemovable(JSObject, String, KeyInfoNode)] */;
                this.state_0_ = state_0;
                return arg0Value.isMemberRemovable(arg1Value, keyInfo_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#invokeMember(JSObject, String, Object[], InteropLibrary, JSInteropInvokeNode, FromJavaStringNode, ExportValueNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 5/8 bytes
             * </pre> */
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSObject.invokeMember(JSObject, String, Object[], InteropLibrary, JSInteropInvokeNode, FromJavaStringNode, ExportValueNode)] */) {
                    InvokeMemberNode_InvokeMemberData s0_ = this.invokeMemberNode__invokeMember_cache;
                    if (s0_ != null) {
                        {
                            FromJavaStringNode fromJavaString_ = this.fromJavaString;
                            if (fromJavaString_ != null) {
                                InteropLibrary self__ = (this);
                                return arg0Value.invokeMember(arg1Value, arg2Value, self__, s0_.callNode_, fromJavaString_, s0_.exportNode_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(JSObject arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary self__ = null;
                    InvokeMemberNode_InvokeMemberData s0_ = this.insert(new InvokeMemberNode_InvokeMemberData());
                    self__ = (this);
                    JSInteropInvokeNode callNode__ = s0_.insert((JSInteropInvokeNodeGen.create()));
                    Objects.requireNonNull(callNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s0_.callNode_ = callNode__;
                    FromJavaStringNode fromJavaString_;
                    FromJavaStringNode fromJavaString__shared = this.fromJavaString;
                    if (fromJavaString__shared != null) {
                        fromJavaString_ = fromJavaString__shared;
                    } else {
                        fromJavaString_ = s0_.insert((FromJavaStringNode.create()));
                        if (fromJavaString_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.fromJavaString == null) {
                        this.fromJavaString = fromJavaString_;
                    }
                    ExportValueNode exportNode__ = s0_.insert((ExportValueNode.create()));
                    Objects.requireNonNull(exportNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s0_.exportNode_ = exportNode__;
                    VarHandle.storeStoreFence();
                    this.invokeMemberNode__invokeMember_cache = s0_;
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[JSObject.invokeMember(JSObject, String, Object[], InteropLibrary, JSInteropInvokeNode, FromJavaStringNode, ExportValueNode)] */;
                    this.state_0_ = state_0;
                    return arg0Value.invokeMember(arg1Value, arg2Value, self__, callNode__, fromJavaString_, exportNode__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#isMemberInvocable(JSObject, String, KeyInfoNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre> */
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSObject.isMemberInvocable(JSObject, String, KeyInfoNode)] */) {
                    {
                        KeyInfoNode keyInfo_ = this.keyInfo;
                        if (keyInfo_ != null) {
                            return arg0Value.isMemberInvocable(arg1Value, keyInfo_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = this.insert((KeyInfoNodeGen.create()));
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[JSObject.isMemberInvocable(JSObject, String, KeyInfoNode)] */;
                this.state_0_ = state_0;
                return arg0Value.isMemberInvocable(arg1Value, keyInfo_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#hasMemberReadSideEffects(JSObject, String, KeyInfoNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre> */
            @Override
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSObject.hasMemberReadSideEffects(JSObject, String, KeyInfoNode)] */) {
                    {
                        KeyInfoNode keyInfo_ = this.keyInfo;
                        if (keyInfo_ != null) {
                            return arg0Value.hasMemberReadSideEffects(arg1Value, keyInfo_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasMemberReadSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean hasMemberReadSideEffectsNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = this.insert((KeyInfoNodeGen.create()));
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[JSObject.hasMemberReadSideEffects(JSObject, String, KeyInfoNode)] */;
                this.state_0_ = state_0;
                return arg0Value.hasMemberReadSideEffects(arg1Value, keyInfo_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#hasMemberWriteSideEffects(JSObject, String, KeyInfoNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre> */
            @Override
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSObject.hasMemberWriteSideEffects(JSObject, String, KeyInfoNode)] */) {
                    {
                        KeyInfoNode keyInfo_ = this.keyInfo;
                        if (keyInfo_ != null) {
                            return arg0Value.hasMemberWriteSideEffects(arg1Value, keyInfo_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasMemberWriteSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean hasMemberWriteSideEffectsNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = this.insert((KeyInfoNodeGen.create()));
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[JSObject.hasMemberWriteSideEffects(JSObject, String, KeyInfoNode)] */;
                this.state_0_ = state_0;
                return arg0Value.hasMemberWriteSideEffects(arg1Value, keyInfo_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#hasIterator(JSObject, InteropLibrary, JSInteropGetIteratorNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre> */
            @Override
            public boolean hasIterator(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSObject.hasIterator(JSObject, InteropLibrary, JSInteropGetIteratorNode)] */) {
                    {
                        JSInteropGetIteratorNode getIteratorNode_ = this.getIteratorNode;
                        if (getIteratorNode_ != null) {
                            InteropLibrary self__ = (this);
                            return arg0Value.hasIterator(self__, getIteratorNode_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasIteratorNode_AndSpecialize(arg0Value);
            }

            private boolean hasIteratorNode_AndSpecialize(JSObject arg0Value) {
                int state_0 = this.state_0_;
                {
                    InteropLibrary self__ = null;
                    self__ = (this);
                    JSInteropGetIteratorNode getIteratorNode_;
                    JSInteropGetIteratorNode getIteratorNode__shared = this.getIteratorNode;
                    if (getIteratorNode__shared != null) {
                        getIteratorNode_ = getIteratorNode__shared;
                    } else {
                        getIteratorNode_ = this.insert((JSInteropGetIteratorNodeGen.create()));
                        if (getIteratorNode_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.getIteratorNode == null) {
                        VarHandle.storeStoreFence();
                        this.getIteratorNode = getIteratorNode_;
                    }
                    state_0 = state_0 | 0b100000000000 /* add SpecializationActive[JSObject.hasIterator(JSObject, InteropLibrary, JSInteropGetIteratorNode)] */;
                    this.state_0_ = state_0;
                    return arg0Value.hasIterator(self__, getIteratorNode_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JSObject#getIterator(JSObject, InteropLibrary, JSInteropGetIteratorNode)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre> */
            @Override
            public Object getIterator(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSObject arg0Value = ((JSObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[JSObject.getIterator(JSObject, InteropLibrary, JSInteropGetIteratorNode)] */) {
                    {
                        JSInteropGetIteratorNode getIteratorNode_ = this.getIteratorNode;
                        if (getIteratorNode_ != null) {
                            InteropLibrary self__ = (this);
                            return arg0Value.getIterator(self__, getIteratorNode_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getIteratorNode_AndSpecialize(arg0Value);
            }

            private Object getIteratorNode_AndSpecialize(JSObject arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary self__ = null;
                    self__ = (this);
                    JSInteropGetIteratorNode getIteratorNode_;
                    JSInteropGetIteratorNode getIteratorNode__shared = this.getIteratorNode;
                    if (getIteratorNode__shared != null) {
                        getIteratorNode_ = getIteratorNode__shared;
                    } else {
                        getIteratorNode_ = this.insert((JSInteropGetIteratorNodeGen.create()));
                        if (getIteratorNode_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.getIteratorNode == null) {
                        VarHandle.storeStoreFence();
                        this.getIteratorNode = getIteratorNode_;
                    }
                    state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[JSObject.getIterator(JSObject, InteropLibrary, JSInteropGetIteratorNode)] */;
                    this.state_0_ = state_0;
                    return arg0Value.getIterator(self__, getIteratorNode_);
                }
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((JSObject) receiver)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((JSObject) receiver)).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((JSObject) receiver)).toDisplayString(allowSideEffects);
            }

            @GeneratedBy(JSObject.class)
            @DenyReplace
            private static final class ReadMemberNode_ReadMemberData extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link JSObject#readMember(JSObject, String, InteropLibrary, ReadElementNode, boolean, FromJavaStringNode, ExportValueNode)}
                 *   Parameter: {@link ReadElementNode} readNode</pre> */
                @Child ReadElementNode readNode_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link JSObject#readMember(JSObject, String, InteropLibrary, ReadElementNode, boolean, FromJavaStringNode, ExportValueNode)}
                 *   Parameter: boolean bindMemberFunctions</pre> */
                @CompilationFinal boolean bindMemberFunctions_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link JSObject#readMember(JSObject, String, InteropLibrary, ReadElementNode, boolean, FromJavaStringNode, ExportValueNode)}
                 *   Parameter: {@link ExportValueNode} exportNode</pre> */
                @Child ExportValueNode exportNode_;

                ReadMemberNode_ReadMemberData() {
                }

            }
            @GeneratedBy(JSObject.class)
            @DenyReplace
            private static final class WriteMemberNode_WriteMemberData extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link JSObject#writeMember(JSObject, String, Object, InteropLibrary, KeyInfoNode, ImportValueNode, WriteElementNode, FromJavaStringNode)}
                 *   Parameter: {@link ImportValueNode} castValueNode</pre> */
                @Child ImportValueNode castValueNode_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link JSObject#writeMember(JSObject, String, Object, InteropLibrary, KeyInfoNode, ImportValueNode, WriteElementNode, FromJavaStringNode)}
                 *   Parameter: {@link WriteElementNode} writeNode</pre> */
                @Child WriteElementNode writeNode_;

                WriteMemberNode_WriteMemberData() {
                }

            }
            @GeneratedBy(JSObject.class)
            @DenyReplace
            private static final class InvokeMemberNode_InvokeMemberData extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link JSObject#invokeMember(JSObject, String, Object[], InteropLibrary, JSInteropInvokeNode, FromJavaStringNode, ExportValueNode)}
                 *   Parameter: {@link JSInteropInvokeNode} callNode</pre> */
                @Child JSInteropInvokeNode callNode_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link JSObject#invokeMember(JSObject, String, Object[], InteropLibrary, JSInteropInvokeNode, FromJavaStringNode, ExportValueNode)}
                 *   Parameter: {@link ExportValueNode} exportNode</pre> */
                @Child ExportValueNode exportNode_;

                InvokeMemberNode_InvokeMemberData() {
                }

            }
        }
        @GeneratedBy(JSObject.class)
        public static class Uncached extends JSDynamicObjectGen.InteropLibraryExports.Uncached {

            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException, UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                return arg0Value.readMember(arg1Value, (this), (JSObject.getUncachedRead()), (JSObject.language((this)).bindMemberFunctions()), (FromJavaStringNode.getUncached()), (ExportValueNode.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                return arg0Value.isMemberReadable(arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException, UnsupportedTypeException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                arg0Value.writeMember(arg1Value, arg2Value, (this), (KeyInfoNodeGen.getUncached()), (ImportValueNode.getUncached()), (JSObject.getUncachedWrite()), (FromJavaStringNode.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                return arg0Value.isMemberModifiable(arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                return arg0Value.isMemberInsertable(arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                arg0Value.removeMember(arg1Value, (FromJavaStringNode.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                return arg0Value.isMemberRemovable(arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, ArityException, UnsupportedTypeException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                return arg0Value.invokeMember(arg1Value, arg2Value, (this), (JSInteropInvokeNodeGen.getUncached()), (FromJavaStringNode.getUncached()), (ExportValueNode.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                return arg0Value.isMemberInvocable(arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                return arg0Value.hasMemberReadSideEffects(arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                return arg0Value.hasMemberWriteSideEffects(arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasIterator(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                return arg0Value.hasIterator((this), (JSInteropGetIteratorNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object getIterator(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = ((JSObject) arg0Value_);
                return arg0Value.getIterator((this), (JSInteropGetIteratorNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject) receiver) .toDisplayString(allowSideEffects);
            }

        }
    }
}
