// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSToDoubleNode#doInteger}
 *     Activation probability: 0.15909
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToDoubleNode#doBoolean}
 *     Activation probability: 0.14545
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToDoubleNode#doDouble}
 *     Activation probability: 0.13182
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToDoubleNode#doLong}
 *     Activation probability: 0.11818
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToDoubleNode#doBigInt}
 *     Activation probability: 0.10455
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToDoubleNode#doNull}
 *     Activation probability: 0.09091
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToDoubleNode#doUndefined}
 *     Activation probability: 0.07727
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToDoubleNode#doStringDouble}
 *     Activation probability: 0.06364
 *     With/without class size: 5/4 bytes
 *   Specialization {@link JSToDoubleNode#doJSObject}
 *     Activation probability: 0.05000
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToDoubleNode#doSymbol}
 *     Activation probability: 0.03636
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToDoubleNode#doForeignObject}
 *     Activation probability: 0.02273
 *     With/without class size: 4/0 bytes
 * </pre> */
@GeneratedBy(JSToDoubleNode.class)
@SuppressWarnings("javadoc")
public final class JSToDoubleNodeGen extends JSToDoubleNode {

    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSToDoubleNode#doInteger}
     *   1: SpecializationActive {@link JSToDoubleNode#doBoolean}
     *   2: SpecializationActive {@link JSToDoubleNode#doDouble}
     *   3: SpecializationActive {@link JSToDoubleNode#doLong}
     *   4: SpecializationActive {@link JSToDoubleNode#doBigInt}
     *   5: SpecializationActive {@link JSToDoubleNode#doNull}
     *   6: SpecializationActive {@link JSToDoubleNode#doUndefined}
     *   7: SpecializationActive {@link JSToDoubleNode#doStringDouble}
     *   8: SpecializationActive {@link JSToDoubleNode#doJSObject}
     *   9: SpecializationActive {@link JSToDoubleNode#doForeignObject}
     *   10: SpecializationActive {@link JSToDoubleNode#doSymbol}
     *   11-13: ImplicitCast[type=double, index=0]
     * </pre> */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSToDoubleNode#doJSObject}
     *   Parameter: {@link JSToDoubleNode} recursiveToDouble</pre> */
    @Child private JSToDoubleNode recursiveToDouble;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSToDoubleNode#doJSObject}
     *   Parameter: {@link JSToPrimitiveNode} toPrimitiveNode</pre> */
    @Child private JSToPrimitiveNode toPrimitiveNode;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSToDoubleNode#doStringDouble}
     *   Parameter: {@link JSStringToNumberNode} stringToNumberNode</pre> */
    @Child private JSStringToNumberNode stringDouble_stringToNumberNode_;

    private JSToDoubleNodeGen() {
    }

    @Override
    public double executeDouble(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111111111) != 0 /* is SpecializationActive[JSToDoubleNode.doInteger(int)] || SpecializationActive[JSToDoubleNode.doBoolean(boolean)] || SpecializationActive[JSToDoubleNode.doDouble(double)] || SpecializationActive[JSToDoubleNode.doLong(long)] || SpecializationActive[JSToDoubleNode.doBigInt(BigInt)] || SpecializationActive[JSToDoubleNode.doNull(Object)] || SpecializationActive[JSToDoubleNode.doUndefined(Object)] || SpecializationActive[JSToDoubleNode.doStringDouble(TruffleString, JSStringToNumberNode)] || SpecializationActive[JSToDoubleNode.doJSObject(JSObject, JSToDoubleNode, JSToPrimitiveNode)] || SpecializationActive[JSToDoubleNode.doSymbol(Symbol)] || SpecializationActive[JSToDoubleNode.doForeignObject(Object, JSToDoubleNode, JSToPrimitiveNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSToDoubleNode.doInteger(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return JSToDoubleNode.doInteger(arg0Value_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSToDoubleNode.doBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return JSToDoubleNode.doBoolean(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSToDoubleNode.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                return JSToDoubleNode.doDouble(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSToDoubleNode.doLong(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return JSToDoubleNode.doLong(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSToDoubleNode.doBigInt(BigInt)] */ && arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                return doBigInt(arg0Value_);
            }
            if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[JSToDoubleNode.doNull(Object)] || SpecializationActive[JSToDoubleNode.doUndefined(Object)] */) {
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSToDoubleNode.doNull(Object)] */) {
                    if ((JSGuards.isJSNull(arg0Value))) {
                        return JSToDoubleNode.doNull(arg0Value);
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSToDoubleNode.doUndefined(Object)] */) {
                    if ((JSGuards.isUndefined(arg0Value))) {
                        return JSToDoubleNode.doUndefined(arg0Value);
                    }
                }
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSToDoubleNode.doStringDouble(TruffleString, JSStringToNumberNode)] */ && arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                {
                    JSStringToNumberNode stringToNumberNode__ = this.stringDouble_stringToNumberNode_;
                    if (stringToNumberNode__ != null) {
                        return JSToDoubleNode.doStringDouble(arg0Value_, stringToNumberNode__);
                    }
                }
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSToDoubleNode.doJSObject(JSObject, JSToDoubleNode, JSToPrimitiveNode)] */ && arg0Value instanceof JSObject) {
                JSObject arg0Value_ = (JSObject) arg0Value;
                {
                    JSToDoubleNode recursiveToDouble_ = this.recursiveToDouble;
                    if (recursiveToDouble_ != null) {
                        JSToPrimitiveNode toPrimitiveNode_ = this.toPrimitiveNode;
                        if (toPrimitiveNode_ != null) {
                            return doJSObject(arg0Value_, recursiveToDouble_, toPrimitiveNode_);
                        }
                    }
                }
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSToDoubleNode.doSymbol(Symbol)] */ && arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol) arg0Value;
                return doSymbol(arg0Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSToDoubleNode.doForeignObject(Object, JSToDoubleNode, JSToPrimitiveNode)] */) {
                {
                    JSToDoubleNode recursiveToDouble_1 = this.recursiveToDouble;
                    if (recursiveToDouble_1 != null) {
                        JSToPrimitiveNode toPrimitiveNode_1 = this.toPrimitiveNode;
                        if (toPrimitiveNode_1 != null) {
                            if ((JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObjectOrNumber(arg0Value))) {
                                return doForeignObject(arg0Value, recursiveToDouble_1, toPrimitiveNode_1);
                            }
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private double executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[JSToDoubleNode.doInteger(int)] */;
            this.state_0_ = state_0;
            return JSToDoubleNode.doInteger(arg0Value_);
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (boolean) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[JSToDoubleNode.doBoolean(boolean)] */;
            this.state_0_ = state_0;
            return JSToDoubleNode.doBoolean(arg0Value_);
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state_0 = (state_0 | (doubleCast0 << 11) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b100 /* add SpecializationActive[JSToDoubleNode.doDouble(double)] */;
                this.state_0_ = state_0;
                return JSToDoubleNode.doDouble(arg0Value_);
            }
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[JSToDoubleNode.doLong(long)] */;
            this.state_0_ = state_0;
            return JSToDoubleNode.doLong(arg0Value_);
        }
        if (arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt) arg0Value;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[JSToDoubleNode.doBigInt(BigInt)] */;
            this.state_0_ = state_0;
            return doBigInt(arg0Value_);
        }
        if ((JSGuards.isJSNull(arg0Value))) {
            state_0 = state_0 | 0b100000 /* add SpecializationActive[JSToDoubleNode.doNull(Object)] */;
            this.state_0_ = state_0;
            return JSToDoubleNode.doNull(arg0Value);
        }
        if ((JSGuards.isUndefined(arg0Value))) {
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[JSToDoubleNode.doUndefined(Object)] */;
            this.state_0_ = state_0;
            return JSToDoubleNode.doUndefined(arg0Value);
        }
        if (arg0Value instanceof TruffleString) {
            TruffleString arg0Value_ = (TruffleString) arg0Value;
            JSStringToNumberNode stringToNumberNode__ = this.insert((JSStringToNumberNode.create()));
            Objects.requireNonNull(stringToNumberNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.stringDouble_stringToNumberNode_ = stringToNumberNode__;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[JSToDoubleNode.doStringDouble(TruffleString, JSStringToNumberNode)] */;
            this.state_0_ = state_0;
            return JSToDoubleNode.doStringDouble(arg0Value_, stringToNumberNode__);
        }
        if (((state_0 & 0b1000000000)) == 0 /* is-not SpecializationActive[JSToDoubleNode.doForeignObject(Object, JSToDoubleNode, JSToPrimitiveNode)] */ && arg0Value instanceof JSObject) {
            JSObject arg0Value_ = (JSObject) arg0Value;
            JSToDoubleNode recursiveToDouble_;
            JSToDoubleNode recursiveToDouble__shared = this.recursiveToDouble;
            if (recursiveToDouble__shared != null) {
                recursiveToDouble_ = recursiveToDouble__shared;
            } else {
                recursiveToDouble_ = this.insert((JSToDoubleNode.create()));
                if (recursiveToDouble_ == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.recursiveToDouble == null) {
                VarHandle.storeStoreFence();
                this.recursiveToDouble = recursiveToDouble_;
            }
            JSToPrimitiveNode toPrimitiveNode_;
            JSToPrimitiveNode toPrimitiveNode__shared = this.toPrimitiveNode;
            if (toPrimitiveNode__shared != null) {
                toPrimitiveNode_ = toPrimitiveNode__shared;
            } else {
                toPrimitiveNode_ = this.insert((JSToPrimitiveNode.createHintNumber()));
                if (toPrimitiveNode_ == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.toPrimitiveNode == null) {
                VarHandle.storeStoreFence();
                this.toPrimitiveNode = toPrimitiveNode_;
            }
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[JSToDoubleNode.doJSObject(JSObject, JSToDoubleNode, JSToPrimitiveNode)] */;
            this.state_0_ = state_0;
            return doJSObject(arg0Value_, recursiveToDouble_, toPrimitiveNode_);
        }
        if (arg0Value instanceof Symbol) {
            Symbol arg0Value_ = (Symbol) arg0Value;
            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[JSToDoubleNode.doSymbol(Symbol)] */;
            this.state_0_ = state_0;
            return doSymbol(arg0Value_);
        }
        if ((JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObjectOrNumber(arg0Value))) {
            JSToDoubleNode recursiveToDouble_1;
            JSToDoubleNode recursiveToDouble_1_shared = this.recursiveToDouble;
            if (recursiveToDouble_1_shared != null) {
                recursiveToDouble_1 = recursiveToDouble_1_shared;
            } else {
                recursiveToDouble_1 = this.insert((JSToDoubleNode.create()));
                if (recursiveToDouble_1 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.recursiveToDouble == null) {
                VarHandle.storeStoreFence();
                this.recursiveToDouble = recursiveToDouble_1;
            }
            JSToPrimitiveNode toPrimitiveNode_1;
            JSToPrimitiveNode toPrimitiveNode_1_shared = this.toPrimitiveNode;
            if (toPrimitiveNode_1_shared != null) {
                toPrimitiveNode_1 = toPrimitiveNode_1_shared;
            } else {
                toPrimitiveNode_1 = this.insert((JSToPrimitiveNode.createHintNumber()));
                if (toPrimitiveNode_1 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.toPrimitiveNode == null) {
                VarHandle.storeStoreFence();
                this.toPrimitiveNode = toPrimitiveNode_1;
            }
            state_0 = state_0 & 0xfffffeff /* remove SpecializationActive[JSToDoubleNode.doJSObject(JSObject, JSToDoubleNode, JSToPrimitiveNode)] */;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[JSToDoubleNode.doForeignObject(Object, JSToDoubleNode, JSToPrimitiveNode)] */;
            this.state_0_ = state_0;
            return doForeignObject(arg0Value, recursiveToDouble_1, toPrimitiveNode_1);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value);
    }

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object arg0Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value);
    }

    @NeverDefault
    public static JSToDoubleNode create() {
        return new JSToDoubleNodeGen();
    }

    @NeverDefault
    public static JSToDoubleNode getUncached() {
        return JSToDoubleNodeGen.UNCACHED;
    }

    @GeneratedBy(JSToDoubleNode.class)
    @DenyReplace
    private static final class Uncached extends JSToDoubleNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public double executeDouble(Object arg0Value) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return JSToDoubleNode.doInteger(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return JSToDoubleNode.doBoolean(arg0Value_);
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(arg0Value);
                return JSToDoubleNode.doDouble(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return JSToDoubleNode.doLong(arg0Value_);
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                return doBigInt(arg0Value_);
            }
            if ((JSGuards.isJSNull(arg0Value))) {
                return JSToDoubleNode.doNull(arg0Value);
            }
            if ((JSGuards.isUndefined(arg0Value))) {
                return JSToDoubleNode.doUndefined(arg0Value);
            }
            if (arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                return JSToDoubleNode.doStringDouble(arg0Value_, (JSStringToNumberNodeGen.getUncached()));
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol) arg0Value;
                return doSymbol(arg0Value_);
            }
            if ((JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObjectOrNumber(arg0Value))) {
                return doForeignObject(arg0Value, (JSToDoubleNodeGen.getUncached()), (JSToPrimitiveNode.getUncachedHintNumber()));
            }
            throw newUnsupportedSpecializationException1(this, arg0Value);
        }

    }
}
