// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.runtime.SafeInteger;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSWriteScopeFrameSlotNode#doBoolean}
 *     Activation probability: 0.27381
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSWriteScopeFrameSlotNode#doInteger}
 *     Activation probability: 0.23095
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSWriteScopeFrameSlotNode#doSafeInteger}
 *     Activation probability: 0.18810
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSWriteScopeFrameSlotNode#doLong}
 *     Activation probability: 0.14524
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSWriteScopeFrameSlotNode#doDouble}
 *     Activation probability: 0.10238
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSWriteScopeFrameSlotNode#doObject}
 *     Activation probability: 0.05952
 *     With/without class size: 4/0 bytes
 * </pre> */
@GeneratedBy(JSWriteScopeFrameSlotNode.class)
@SuppressWarnings("javadoc")
final class JSWriteScopeFrameSlotNodeGen extends JSWriteScopeFrameSlotNode {

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSWriteScopeFrameSlotNode#doBoolean}
     *   1: SpecializationActive {@link JSWriteScopeFrameSlotNode#doObject}
     *   2: SpecializationActive {@link JSWriteScopeFrameSlotNode#doInteger}
     *   3: SpecializationActive {@link JSWriteScopeFrameSlotNode#doDouble}
     *   4: SpecializationActive {@link JSWriteScopeFrameSlotNode#doSafeInteger}
     *   5: SpecializationActive {@link JSWriteScopeFrameSlotNode#doLong}
     *   6-8: ImplicitCast[type=double, index=1]
     * </pre> */
    @CompilationFinal private int state_0_;

    private JSWriteScopeFrameSlotNodeGen(int slot, Object identifier, ScopeFrameNode scopeFrameNode, JavaScriptNode rhsNode) {
        super(slot, identifier, scopeFrameNode, rhsNode);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Frame scopeFrameNodeValue_ = super.scopeFrameNode.executeFrame(frameValue);
        if ((state_0 & 0b111110) == 0 /* only-active SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] && SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] && SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] && SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] && SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */)) {
            return execute_boolean0(state_0, frameValue, scopeFrameNodeValue_);
        } else if ((state_0 & 0b111011) == 0 /* only-active SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] && SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] && SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] && SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] && SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */)) {
            return execute_int1(state_0, frameValue, scopeFrameNodeValue_);
        } else if ((state_0 & 0b110111) == 0 /* only-active SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] && SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] && SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] && SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] && SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */)) {
            return execute_double2(state_0, frameValue, scopeFrameNodeValue_);
        } else {
            return execute_generic3(state_0, frameValue, scopeFrameNodeValue_);
        }
    }

    private Object execute_boolean0(int state_0__, VirtualFrame frameValue, Frame scopeFrameNodeValue_) {
        int state_0 = state_0__;
        boolean rhsNodeValue_;
        try {
            rhsNodeValue_ = super.rhsNode.executeBoolean(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(scopeFrameNodeValue_, ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] */;
        if ((isBooleanKind(scopeFrameNodeValue_))) {
            return doBoolean(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_);
    }

    private Object execute_int1(int state_0__, VirtualFrame frameValue, Frame scopeFrameNodeValue_) {
        int state_0 = state_0__;
        int rhsNodeValue_;
        try {
            rhsNodeValue_ = super.rhsNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(scopeFrameNodeValue_, ex.getResult());
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] */;
        {
            FrameSlotKind kind__ = (getFrameDescriptor(scopeFrameNodeValue_).getSlotKind(slot));
            if ((isIntegerKind(scopeFrameNodeValue_, kind__) || isLongKind(scopeFrameNodeValue_, kind__) || isDoubleKind(scopeFrameNodeValue_, kind__))) {
                return doInteger(scopeFrameNodeValue_, rhsNodeValue_, kind__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_);
    }

    private Object execute_double2(int state_0__, VirtualFrame frameValue, Frame scopeFrameNodeValue_) {
        int state_0 = state_0__;
        int rhsNodeValue_int = 0;
        double rhsNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] && SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] && SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] && SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] && SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */)) {
                rhsNodeValue_ = super.rhsNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] && SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] && SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] && SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] && SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */)) {
                rhsNodeValue_int = super.rhsNode.executeInt(frameValue);
                rhsNodeValue_ = JSTypes.intToDouble(rhsNodeValue_int);
            } else {
                Object rhsNodeValue__ = super.rhsNode.execute(frameValue);
                rhsNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rhsNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(scopeFrameNodeValue_, ex.getResult());
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] */;
        if ((isDoubleKind(scopeFrameNodeValue_))) {
            return doDouble(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(scopeFrameNodeValue_, ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] && SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] && SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] && SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] && SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */) ? (Object) rhsNodeValue_int : (Object) rhsNodeValue_));
    }

    private Object execute_generic3(int state_0__, VirtualFrame frameValue, Frame scopeFrameNodeValue_) {
        int state_0 = state_0__;
        Object rhsNodeValue_ = super.rhsNode.execute(frameValue);
        if ((state_0 & 0b111111) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] || SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] || SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] || SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] || SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] || SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] */ && rhsNodeValue_ instanceof Boolean) {
                boolean rhsNodeValue__ = (boolean) rhsNodeValue_;
                if ((isBooleanKind(scopeFrameNodeValue_))) {
                    return doBoolean(scopeFrameNodeValue_, rhsNodeValue__);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] */ && rhsNodeValue_ instanceof Integer) {
                int rhsNodeValue__ = (int) rhsNodeValue_;
                {
                    FrameSlotKind kind__ = (getFrameDescriptor(scopeFrameNodeValue_).getSlotKind(slot));
                    if ((isIntegerKind(scopeFrameNodeValue_, kind__) || isLongKind(scopeFrameNodeValue_, kind__) || isDoubleKind(scopeFrameNodeValue_, kind__))) {
                        return doInteger(scopeFrameNodeValue_, rhsNodeValue__, kind__);
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] */ && rhsNodeValue_ instanceof SafeInteger) {
                SafeInteger rhsNodeValue__ = (SafeInteger) rhsNodeValue_;
                if ((isLongKind(scopeFrameNodeValue_))) {
                    return doSafeInteger(scopeFrameNodeValue_, rhsNodeValue__);
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] */ && rhsNodeValue_ instanceof Long) {
                long rhsNodeValue__ = (long) rhsNodeValue_;
                return doLong(scopeFrameNodeValue_, rhsNodeValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rhsNodeValue_)) {
                double rhsNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rhsNodeValue_);
                if ((isDoubleKind(scopeFrameNodeValue_))) {
                    return doDouble(scopeFrameNodeValue_, rhsNodeValue__);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */) {
                return doObject(scopeFrameNodeValue_, rhsNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */) {
            return JSTypesGen.expectBoolean(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = super.scopeFrameNode.executeFrame(frameValue);
        boolean rhsNodeValue_;
        try {
            rhsNodeValue_ = super.rhsNode.executeBoolean(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectBoolean(executeAndSpecialize(scopeFrameNodeValue_, ex.getResult()));
        }
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] */) {
            if ((isBooleanKind(scopeFrameNodeValue_))) {
                return doBoolean(scopeFrameNodeValue_, rhsNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_));
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = super.scopeFrameNode.executeFrame(frameValue);
        int rhsNodeValue_int = 0;
        double rhsNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] && SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] && SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] && SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] && SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */)) {
                rhsNodeValue_ = super.rhsNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] && SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] && SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] && SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] && SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */)) {
                rhsNodeValue_int = super.rhsNode.executeInt(frameValue);
                rhsNodeValue_ = JSTypes.intToDouble(rhsNodeValue_int);
            } else {
                Object rhsNodeValue__ = super.rhsNode.execute(frameValue);
                rhsNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rhsNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(executeAndSpecialize(scopeFrameNodeValue_, ex.getResult()));
        }
        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] */) {
            if ((isDoubleKind(scopeFrameNodeValue_))) {
                return doDouble(scopeFrameNodeValue_, rhsNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(executeAndSpecialize(scopeFrameNodeValue_, ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] && SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] && SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] && SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] && SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */) ? (Object) rhsNodeValue_int : (Object) rhsNodeValue_)));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = super.scopeFrameNode.executeFrame(frameValue);
        int rhsNodeValue_;
        try {
            rhsNodeValue_ = super.rhsNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(scopeFrameNodeValue_, ex.getResult()));
        }
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] */) {
            {
                FrameSlotKind kind__ = (getFrameDescriptor(scopeFrameNodeValue_).getSlotKind(slot));
                if ((isIntegerKind(scopeFrameNodeValue_, kind__) || isLongKind(scopeFrameNodeValue_, kind__) || isDoubleKind(scopeFrameNodeValue_, kind__))) {
                    return doInteger(scopeFrameNodeValue_, rhsNodeValue_, kind__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_));
    }

    @Override
    void executeEvaluated(VirtualFrame frameValue, Frame scopeFrameNodeValue, Object rhsNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111111) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] || SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] || SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] || SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] || SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] || SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] */ && rhsNodeValue instanceof Boolean) {
                boolean rhsNodeValue_ = (boolean) rhsNodeValue;
                if ((isBooleanKind(scopeFrameNodeValue))) {
                    doBoolean(scopeFrameNodeValue, rhsNodeValue_);
                    return;
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] */ && rhsNodeValue instanceof Integer) {
                int rhsNodeValue_ = (int) rhsNodeValue;
                {
                    FrameSlotKind kind__ = (getFrameDescriptor(scopeFrameNodeValue).getSlotKind(slot));
                    if ((isIntegerKind(scopeFrameNodeValue, kind__) || isLongKind(scopeFrameNodeValue, kind__) || isDoubleKind(scopeFrameNodeValue, kind__))) {
                        doInteger(scopeFrameNodeValue, rhsNodeValue_, kind__);
                        return;
                    }
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] */ && rhsNodeValue instanceof SafeInteger) {
                SafeInteger rhsNodeValue_ = (SafeInteger) rhsNodeValue;
                if ((isLongKind(scopeFrameNodeValue))) {
                    doSafeInteger(scopeFrameNodeValue, rhsNodeValue_);
                    return;
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] */ && rhsNodeValue instanceof Long) {
                long rhsNodeValue_ = (long) rhsNodeValue;
                doLong(scopeFrameNodeValue, rhsNodeValue_);
                return;
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rhsNodeValue)) {
                double rhsNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rhsNodeValue);
                if ((isDoubleKind(scopeFrameNodeValue))) {
                    doDouble(scopeFrameNodeValue, rhsNodeValue_);
                    return;
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */) {
                doObject(scopeFrameNodeValue, rhsNodeValue);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(scopeFrameNodeValue, rhsNodeValue);
        return;
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b111011) == 0 /* only-active SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] && SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] && SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] && SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] && SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */)) {
                this.executeInt(frameValue);
                return;
            } else if ((state_0 & 0b110111) == 0 /* only-active SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] && SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] && SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] && SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] && SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */)) {
                this.executeDouble(frameValue);
                return;
            } else if ((state_0 & 0b111110) == 0 /* only-active SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] && SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] && SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] && SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] && SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */)) {
                this.executeBoolean(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(Frame scopeFrameNodeValue, Object rhsNodeValue) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */ && rhsNodeValue instanceof Boolean) {
            boolean rhsNodeValue_ = (boolean) rhsNodeValue;
            if ((isBooleanKind(scopeFrameNodeValue))) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)] */;
                this.state_0_ = state_0;
                return doBoolean(scopeFrameNodeValue, rhsNodeValue_);
            }
        }
        {
            FrameSlotKind kind__ = null;
            if (((state_0 & 0b1010)) == 0 /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */ && rhsNodeValue instanceof Integer) {
                int rhsNodeValue_ = (int) rhsNodeValue;
                {
                    kind__ = (getFrameDescriptor(scopeFrameNodeValue).getSlotKind(slot));
                    if ((isIntegerKind(scopeFrameNodeValue, kind__) || isLongKind(scopeFrameNodeValue, kind__) || isDoubleKind(scopeFrameNodeValue, kind__))) {
                        state_0 = state_0 | 0b100 /* add SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)] */;
                        this.state_0_ = state_0;
                        return doInteger(scopeFrameNodeValue, rhsNodeValue_, kind__);
                    }
                }
            }
        }
        if (((state_0 & 0b1010)) == 0 /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] && SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */ && rhsNodeValue instanceof SafeInteger) {
            SafeInteger rhsNodeValue_ = (SafeInteger) rhsNodeValue;
            if ((isLongKind(scopeFrameNodeValue))) {
                state_0 = state_0 | 0b10000 /* add SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] */;
                this.state_0_ = state_0;
                return doSafeInteger(scopeFrameNodeValue, rhsNodeValue_);
            }
        }
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */ && rhsNodeValue instanceof Long) {
            long rhsNodeValue_ = (long) rhsNodeValue;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)] */;
            this.state_0_ = state_0;
            return doLong(scopeFrameNodeValue, rhsNodeValue_);
        }
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */) {
            int doubleCast1;
            if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(rhsNodeValue)) != 0) {
                double rhsNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rhsNodeValue);
                if ((isDoubleKind(scopeFrameNodeValue))) {
                    state_0 = state_0 & 0xffffffeb /* remove SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)], SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)] */;
                    state_0 = (state_0 | (doubleCast1 << 6) /* set-int ImplicitCast[type=double, index=1] */);
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] */;
                    this.state_0_ = state_0;
                    return doDouble(scopeFrameNodeValue, rhsNodeValue_);
                }
            }
        }
        state_0 = state_0 & 0xffffffc2 /* remove SpecializationActive[JSWriteScopeFrameSlotNode.doBoolean(Frame, boolean)], SpecializationActive[JSWriteScopeFrameSlotNode.doInteger(Frame, int, FrameSlotKind)], SpecializationActive[JSWriteScopeFrameSlotNode.doSafeInteger(Frame, SafeInteger)], SpecializationActive[JSWriteScopeFrameSlotNode.doLong(Frame, long)], SpecializationActive[JSWriteScopeFrameSlotNode.doDouble(Frame, double)] */;
        state_0 = state_0 | 0b10 /* add SpecializationActive[JSWriteScopeFrameSlotNode.doObject(Frame, Object)] */;
        this.state_0_ = state_0;
        return doObject(scopeFrameNodeValue, rhsNodeValue);
    }

    @NeverDefault
    public static JSWriteScopeFrameSlotNode create(int slot, Object identifier, ScopeFrameNode scopeFrameNode, JavaScriptNode rhsNode) {
        return new JSWriteScopeFrameSlotNodeGen(slot, identifier, scopeFrameNode, rhsNode);
    }

}
