// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link GlobalScopeTDZCheckNode#doCached}
 *     Activation probability: 0.65000
 *     With/without class size: 17/5 bytes
 *   Specialization {@link GlobalScopeTDZCheckNode#doUncached}
 *     Activation probability: 0.35000
 *     With/without class size: 12/5 bytes
 * </pre> */
@GeneratedBy(GlobalScopeTDZCheckNode.class)
@SuppressWarnings("javadoc")
final class GlobalScopeTDZCheckNodeGen extends GlobalScopeTDZCheckNode {

    private static final StateField STATE_0_GlobalScopeTDZCheckNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    static final ReferenceField<CachedData> CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);
    /**
     * Source Info: <pre>
     *   Specialization: {@link GlobalScopeTDZCheckNode#doUncached}
     *   Parameter: {@link InlinedBranchProfile} deadBranch
     *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
    private static final InlinedBranchProfile INLINED_UNCACHED_DEAD_BRANCH_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_GlobalScopeTDZCheckNode_UPDATER.subUpdater(2, 1)));

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link GlobalScopeTDZCheckNode#doCached}
     *   1: SpecializationActive {@link GlobalScopeTDZCheckNode#doUncached}
     *   2: InlinedCache
     *        Specialization: {@link GlobalScopeTDZCheckNode#doUncached}
     *        Parameter: {@link InlinedBranchProfile} deadBranch
     *        Inline method: {@link InlinedBranchProfile#inline}
     * </pre> */
    @CompilationFinal @UnsafeAccessedField private int state_0_;
    @UnsafeAccessedField @CompilationFinal private CachedData cached_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link GlobalScopeTDZCheckNode#doUncached}
     *   Parameter: {@link PropertyGetNode} getNode</pre> */
    @Child private PropertyGetNode uncached_getNode_;

    private GlobalScopeTDZCheckNodeGen(JSContext context, TruffleString varName) {
        super(context, varName);
    }

    @ExplodeLoop
    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object scopeNodeValue_ = super.scopeNode.execute(frameValue);
        if ((state_0 & 0b11) != 0 /* is SpecializationActive[GlobalScopeTDZCheckNode.doCached(JSDynamicObject, Shape, boolean)] || SpecializationActive[GlobalScopeTDZCheckNode.doUncached(Object, PropertyGetNode, InlinedBranchProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[GlobalScopeTDZCheckNode.doCached(JSDynamicObject, Shape, boolean)] */ && scopeNodeValue_ instanceof JSDynamicObject) {
                JSDynamicObject scopeNodeValue__ = (JSDynamicObject) scopeNodeValue_;
                CachedData s0_ = this.cached_cache;
                while (s0_ != null) {
                    if (!Assumption.isValidAssumption(s0_.assumption0_)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        removeCached_(s0_);
                        return executeAndSpecialize(scopeNodeValue__);
                    }
                    if ((scopeNodeValue__.getShape() == s0_.cachedShape_)) {
                        return doCached(scopeNodeValue__, s0_.cachedShape_, s0_.dead_);
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[GlobalScopeTDZCheckNode.doUncached(Object, PropertyGetNode, InlinedBranchProfile)] */) {
                {
                    PropertyGetNode getNode__ = this.uncached_getNode_;
                    if (getNode__ != null) {
                        return doUncached(scopeNodeValue_, getNode__, INLINED_UNCACHED_DEAD_BRANCH_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(scopeNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
        return;
    }

    @SuppressWarnings("unused")
    private Object executeAndSpecialize(Object scopeNodeValue) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[GlobalScopeTDZCheckNode.doUncached(Object, PropertyGetNode, InlinedBranchProfile)] */ && scopeNodeValue instanceof JSDynamicObject) {
            JSDynamicObject scopeNodeValue_ = (JSDynamicObject) scopeNodeValue;
            while (true) {
                int count0_ = 0;
                CachedData s0_ = CACHED_CACHE_UPDATER.getVolatile(this);
                CachedData s0_original = s0_;
                while (s0_ != null) {
                    if ((scopeNodeValue_.getShape() == s0_.cachedShape_) && Assumption.isValidAssumption(s0_.assumption0_)) {
                        break;
                    }
                    count0_++;
                    s0_ = s0_.next_;
                }
                if (s0_ == null) {
                    {
                        Shape cachedShape__ = (scopeNodeValue_.getShape());
                        if ((scopeNodeValue_.getShape() == cachedShape__)) {
                            Assumption assumption0 = (cachedShape__.getValidAssumption());
                            if (Assumption.isValidAssumption(assumption0)) {
                                if (count0_ < (context.getPropertyCacheLimit())) {
                                    s0_ = new CachedData(s0_original);
                                    Objects.requireNonNull(cachedShape__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.cachedShape_ = cachedShape__;
                                    s0_.dead_ = (isDead(cachedShape__));
                                    s0_.assumption0_ = assumption0;
                                    if (!CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[GlobalScopeTDZCheckNode.doCached(JSDynamicObject, Shape, boolean)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                    }
                }
                if (s0_ != null) {
                    return doCached(scopeNodeValue_, s0_.cachedShape_, s0_.dead_);
                }
                break;
            }
        }
        PropertyGetNode getNode__ = this.insert((PropertyGetNode.create(varName, context)));
        Objects.requireNonNull(getNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
        VarHandle.storeStoreFence();
        this.uncached_getNode_ = getNode__;
        this.cached_cache = null;
        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[GlobalScopeTDZCheckNode.doCached(JSDynamicObject, Shape, boolean)] */;
        state_0 = state_0 | 0b10 /* add SpecializationActive[GlobalScopeTDZCheckNode.doUncached(Object, PropertyGetNode, InlinedBranchProfile)] */;
        this.state_0_ = state_0;
        return doUncached(scopeNodeValue, getNode__, INLINED_UNCACHED_DEAD_BRANCH_);
    }

    void removeCached_(CachedData s0_) {
        while (true) {
            CachedData cur = this.cached_cache;
            CachedData original = cur;
            CachedData update = null;
            while (cur != null) {
                if (cur == s0_) {
                    if (cur == original) {
                        update = cur.next_;
                    } else {
                        update = original.remove(s0_);
                    }
                    break;
                }
                cur = cur.next_;
            }
            if (cur != null && !CACHED_CACHE_UPDATER.compareAndSet(this, original, update)) {
                continue;
            }
            break;
        }
    }

    @NeverDefault
    public static GlobalScopeTDZCheckNode create(JSContext context, TruffleString varName) {
        return new GlobalScopeTDZCheckNodeGen(context, varName);
    }

    @GeneratedBy(GlobalScopeTDZCheckNode.class)
    @DenyReplace
    private static final class CachedData implements SpecializationDataNode {

        @CompilationFinal final CachedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link GlobalScopeTDZCheckNode#doCached}
         *   Parameter: {@link Shape} cachedShape</pre> */
        @CompilationFinal Shape cachedShape_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link GlobalScopeTDZCheckNode#doCached}
         *   Parameter: boolean dead</pre> */
        @CompilationFinal boolean dead_;
        @CompilationFinal Assumption assumption0_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        CachedData remove(CachedData search) {
            CachedData newNext = this.next_;
            if (newNext != null) {
                if (search == newNext) {
                    newNext = newNext.next_;
                } else {
                    newNext = newNext.remove(search);
                }
            }
            CachedData copy = new CachedData(newNext);
            copy.cachedShape_ = this.cachedShape_;
            copy.dead_ = this.dead_;
            copy.assumption0_ = this.assumption0_;
            return copy;
        }

    }
}
