// CheckStyle: start generated
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleString.EqualNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSIdenticalNode#doInt}
 *     Activation probability: 0.07323
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doDouble}
 *     Activation probability: 0.07046
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doBoolean}
 *     Activation probability: 0.06769
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doBigInt}
 *     Activation probability: 0.06492
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doBigIntDouble}
 *     Activation probability: 0.06215
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doDoubleBigInt}
 *     Activation probability: 0.05938
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doUndefinedA}
 *     Activation probability: 0.05662
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doUndefinedB}
 *     Activation probability: 0.05385
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doJSObjectA}
 *     Activation probability: 0.05108
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doJSObjectB}
 *     Activation probability: 0.04831
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doNullNull}
 *     Activation probability: 0.04554
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doNullUndefined}
 *     Activation probability: 0.04277
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doUndefinedNull}
 *     Activation probability: 0.04000
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doNullA}
 *     Activation probability: 0.03723
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doNullB}
 *     Activation probability: 0.03446
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doTruffleStringIdentity}
 *     Activation probability: 0.03169
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doTruffleString}
 *     Activation probability: 0.02892
 *     With/without class size: 4/4 bytes
 *   Specialization {@link JSIdenticalNode#doSymbol}
 *     Activation probability: 0.02615
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doBooleanNotBoolean}
 *     Activation probability: 0.02338
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doSymbolNotSymbol}
 *     Activation probability: 0.02062
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doStringNotString}
 *     Activation probability: 0.01785
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doLong}
 *     Activation probability: 0.01508
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doForeignObject}
 *     Activation probability: 0.01231
 *     With/without class size: 4/8 bytes
 *   Specialization {@link JSIdenticalNode#doForeignObject}
 *     Activation probability: 0.00954
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSIdenticalNode#doFallback}
 *     Activation probability: 0.00677
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(JSIdenticalNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class JSIdenticalNodeGen extends JSIdenticalNode {

    static final ReferenceField<ForeignObject0Data> FOREIGN_OBJECT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreignObject0_cache", ForeignObject0Data.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSIdenticalNode#doInt}
     *   1: SpecializationActive {@link JSIdenticalNode#doDouble}
     *   2: SpecializationActive {@link JSIdenticalNode#doBoolean}
     *   3: SpecializationActive {@link JSIdenticalNode#doBigInt}
     *   4: SpecializationActive {@link JSIdenticalNode#doBigIntDouble}
     *   5: SpecializationActive {@link JSIdenticalNode#doDoubleBigInt}
     *   6: SpecializationActive {@link JSIdenticalNode#doUndefinedA}
     *   7: SpecializationActive {@link JSIdenticalNode#doUndefinedB}
     *   8: SpecializationActive {@link JSIdenticalNode#doJSObjectA}
     *   9: SpecializationActive {@link JSIdenticalNode#doJSObjectB}
     *   10: SpecializationActive {@link JSIdenticalNode#doNullNull}
     *   11: SpecializationActive {@link JSIdenticalNode#doNullUndefined}
     *   12: SpecializationActive {@link JSIdenticalNode#doUndefinedNull}
     *   13: SpecializationActive {@link JSIdenticalNode#doNullA}
     *   14: SpecializationActive {@link JSIdenticalNode#doNullB}
     *   15: SpecializationActive {@link JSIdenticalNode#doTruffleStringIdentity}
     *   16: SpecializationActive {@link JSIdenticalNode#doTruffleString}
     *   17: SpecializationActive {@link JSIdenticalNode#doSymbol}
     *   18: SpecializationActive {@link JSIdenticalNode#doBooleanNotBoolean}
     *   19: SpecializationActive {@link JSIdenticalNode#doSymbolNotSymbol}
     *   20: SpecializationActive {@link JSIdenticalNode#doStringNotString}
     *   21: SpecializationActive {@link JSIdenticalNode#doLong}
     *   22: SpecializationActive {@link JSIdenticalNode#doForeignObject}
     *   23: SpecializationActive {@link JSIdenticalNode#doForeignObject}
     *   24: SpecializationActive {@link JSIdenticalNode#doFallback}
     *   25-27: ImplicitCast[type=double, index=0]
     *   28-30: ImplicitCast[type=double, index=1]
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSIdenticalNode#doNullA}
     *   Parameter: {@link InteropLibrary} nullInterop</pre>
     */
    @Child private InteropLibrary nullInterop;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSIdenticalNode#doTruffleString}
     *   Parameter: {@link EqualNode} equalsNode</pre>
     */
    @Child private EqualNode truffleString_equalsNode_;
    @UnsafeAccessedField @Child private ForeignObject0Data foreignObject0_cache;

    private JSIdenticalNodeGen(JavaScriptNode left, JavaScriptNode right, int type) {
        super(left, right, type);
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object leftNodeValue, Object rightNodeValue) {
        if (JSTypesGen.isImplicitDouble(leftNodeValue) && JSTypesGen.isImplicitDouble(rightNodeValue)) {
            return false;
        }
        if (!((state_0 & 0b100) != 0 /* is SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] */) && leftNodeValue instanceof Boolean && rightNodeValue instanceof Boolean) {
            return false;
        }
        if (leftNodeValue instanceof BigInt) {
            if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] */) && rightNodeValue instanceof BigInt) {
                return false;
            }
            if (JSTypesGen.isImplicitDouble(rightNodeValue)) {
                return false;
            }
        }
        if (JSTypesGen.isImplicitDouble(leftNodeValue) && rightNodeValue instanceof BigInt) {
            return false;
        }
        if (!((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] */) && (JSGuards.isUndefined(leftNodeValue))) {
            return false;
        }
        if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] */) && (JSGuards.isUndefined(rightNodeValue))) {
            return false;
        }
        if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] */) && leftNodeValue instanceof JSObject) {
            return false;
        }
        if (!((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] */) && rightNodeValue instanceof JSObject) {
            return false;
        }
        if (!((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] */) && (JSGuards.isJSNull(leftNodeValue)) && (JSGuards.isJSNull(rightNodeValue))) {
            return false;
        }
        if (!((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] */) && (JSGuards.isJSNull(leftNodeValue)) && (JSGuards.isUndefined(rightNodeValue))) {
            return false;
        }
        if (!((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] */) && (JSGuards.isUndefined(leftNodeValue)) && (JSGuards.isJSNull(rightNodeValue))) {
            return false;
        }
        if (!((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] */) && (JSGuards.isJSNull(leftNodeValue)) && (!(JSRuntime.isNullOrUndefined(rightNodeValue)))) {
            return false;
        }
        if (!((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] */) && (!(JSRuntime.isNullOrUndefined(leftNodeValue))) && (JSGuards.isJSNull(rightNodeValue))) {
            return false;
        }
        if (!((state_0 & 0x10000) != 0 /* is SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] */) && leftNodeValue instanceof TruffleString && rightNodeValue instanceof TruffleString) {
            return false;
        }
        if (!((state_0 & 0x20000) != 0 /* is SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] */) && leftNodeValue instanceof Symbol && rightNodeValue instanceof Symbol) {
            return false;
        }
        if (!((state_0 & 0x40000) != 0 /* is SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] */) && (JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue))) {
            return false;
        }
        if (!((state_0 & 0x80000) != 0 /* is SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] */) && (JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue))) {
            return false;
        }
        if (!((state_0 & 0x100000) != 0 /* is SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] */) && (JSGuards.isString(leftNodeValue) != JSGuards.isString(rightNodeValue))) {
            return false;
        }
        if (!((state_0 & 0x200000) != 0 /* is SpecializationActive[JSIdenticalNode.doLong(long, long)] */) && leftNodeValue instanceof Long && rightNodeValue instanceof Long) {
            return false;
        }
        if (!((state_0 & 0x800000) != 0 /* is SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] */) && ((JSGuards.isForeignObjectOrNumber(leftNodeValue)) || (JSGuards.isForeignObjectOrNumber(rightNodeValue)))) {
            return false;
        }
        return true;
    }

    @ExplodeLoop
    @Override
    public boolean executeBoolean(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1ffffff) != 0 /* is SpecializationActive[JSIdenticalNode.doInt(int, int)] || SpecializationActive[JSIdenticalNode.doDouble(double, double)] || SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] || SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] || SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] || SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] || SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] || SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] || SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] || SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] || SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] || SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] || SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] || SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] || SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] || SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] || SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] || SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] || SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] || SpecializationActive[JSIdenticalNode.doLong(long, long)] || SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSIdenticalNode.doInt(int, int)] */ && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (int) leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (int) rightNodeValue;
                    return JSIdenticalNode.doInt(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSIdenticalNode.doDouble(double, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue)) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue);
                if (JSTypesGen.isImplicitDouble((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue)) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue);
                    return doDouble(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] */ && leftNodeValue instanceof Boolean) {
                boolean leftNodeValue_ = (boolean) leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_ = (boolean) rightNodeValue;
                    return JSIdenticalNode.doBoolean(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] || SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] */ && leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_ = (BigInt) leftNodeValue;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] */ && rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                    return JSIdenticalNode.doBigInt(leftNodeValue_, rightNodeValue_);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue)) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue);
                    return JSIdenticalNode.doBigIntDouble(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] */ && JSTypesGen.isImplicitDouble((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue)) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue);
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                    return JSIdenticalNode.doDoubleBigInt(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0b111000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] || SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] || SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] */) {
                if ((state_0 & 0b11000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] || SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] */) {
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] */) {
                        if ((JSGuards.isUndefined(leftNodeValue))) {
                            return JSIdenticalNode.doUndefinedA(leftNodeValue, rightNodeValue);
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] */) {
                        if ((JSGuards.isUndefined(rightNodeValue))) {
                            return JSIdenticalNode.doUndefinedB(leftNodeValue, rightNodeValue);
                        }
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] */ && leftNodeValue instanceof JSObject) {
                    JSObject leftNodeValue_ = (JSObject) leftNodeValue;
                    return JSIdenticalNode.doJSObjectA(leftNodeValue_, rightNodeValue);
                }
            }
            if ((state_0 & 0b111111000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] || SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] || SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] || SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] || SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] */) {
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] */ && rightNodeValue instanceof JSObject) {
                    JSObject rightNodeValue_ = (JSObject) rightNodeValue;
                    return JSIdenticalNode.doJSObjectB(leftNodeValue, rightNodeValue_);
                }
                if ((state_0 & 0b111110000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] || SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] || SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] || SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] */) {
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] */) {
                        if ((JSGuards.isJSNull(leftNodeValue)) && (JSGuards.isJSNull(rightNodeValue))) {
                            return JSIdenticalNode.doNullNull(leftNodeValue, rightNodeValue);
                        }
                    }
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] */) {
                        if ((JSGuards.isJSNull(leftNodeValue)) && (JSGuards.isUndefined(rightNodeValue))) {
                            return JSIdenticalNode.doNullUndefined(leftNodeValue, rightNodeValue);
                        }
                    }
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] */) {
                        if ((JSGuards.isUndefined(leftNodeValue)) && (JSGuards.isJSNull(rightNodeValue))) {
                            return JSIdenticalNode.doUndefinedNull(leftNodeValue, rightNodeValue);
                        }
                    }
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] */) {
                        {
                            InteropLibrary nullInterop_ = this.nullInterop;
                            if (nullInterop_ != null) {
                                if ((JSGuards.isJSNull(leftNodeValue)) && (!(JSRuntime.isNullOrUndefined(rightNodeValue)))) {
                                    return JSIdenticalNode.doNullA(leftNodeValue, rightNodeValue, nullInterop_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] */) {
                        {
                            InteropLibrary nullInterop_1 = this.nullInterop;
                            if (nullInterop_1 != null) {
                                if ((!(JSRuntime.isNullOrUndefined(leftNodeValue))) && (JSGuards.isJSNull(rightNodeValue))) {
                                    return JSIdenticalNode.doNullB(leftNodeValue, rightNodeValue, nullInterop_1);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0x18000) != 0 /* is SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] || SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] */ && leftNodeValue instanceof TruffleString) {
                TruffleString leftNodeValue_ = (TruffleString) leftNodeValue;
                if (rightNodeValue instanceof TruffleString) {
                    TruffleString rightNodeValue_ = (TruffleString) rightNodeValue;
                    if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] */) {
                        if ((JSGuards.isReferenceEquals(leftNodeValue_, rightNodeValue_))) {
                            return JSIdenticalNode.doTruffleStringIdentity(leftNodeValue_, rightNodeValue_);
                        }
                    }
                    if ((state_0 & 0x10000) != 0 /* is SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] */) {
                        {
                            EqualNode equalsNode__ = this.truffleString_equalsNode_;
                            if (equalsNode__ != null) {
                                return JSIdenticalNode.doTruffleString(leftNodeValue_, rightNodeValue_, equalsNode__);
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0x20000) != 0 /* is SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] */ && leftNodeValue instanceof Symbol) {
                Symbol leftNodeValue_ = (Symbol) leftNodeValue;
                if (rightNodeValue instanceof Symbol) {
                    Symbol rightNodeValue_ = (Symbol) rightNodeValue;
                    return JSIdenticalNode.doSymbol(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0x1c0000) != 0 /* is SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] || SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] || SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] */) {
                if ((state_0 & 0x40000) != 0 /* is SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] */) {
                    if ((JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue))) {
                        return JSIdenticalNode.doBooleanNotBoolean(leftNodeValue, rightNodeValue);
                    }
                }
                if ((state_0 & 0x80000) != 0 /* is SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] */) {
                    if ((JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue))) {
                        return JSIdenticalNode.doSymbolNotSymbol(leftNodeValue, rightNodeValue);
                    }
                }
                if ((state_0 & 0x100000) != 0 /* is SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] */) {
                    if ((JSGuards.isString(leftNodeValue) != JSGuards.isString(rightNodeValue))) {
                        return JSIdenticalNode.doStringNotString(leftNodeValue, rightNodeValue);
                    }
                }
            }
            if ((state_0 & 0x200000) != 0 /* is SpecializationActive[JSIdenticalNode.doLong(long, long)] */ && leftNodeValue instanceof Long) {
                long leftNodeValue_ = (long) leftNodeValue;
                if (rightNodeValue instanceof Long) {
                    long rightNodeValue_ = (long) rightNodeValue;
                    return JSIdenticalNode.doLong(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0x1c00000) != 0 /* is SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */) {
                if ((state_0 & 0x400000) != 0 /* is SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] */) {
                    ForeignObject0Data s22_ = this.foreignObject0_cache;
                    while (s22_ != null) {
                        if ((s22_.aInterop_.accepts(leftNodeValue)) && (s22_.bInterop_.accepts(rightNodeValue))) {
                            boolean isAForeign__ = (JSGuards.isForeignObjectOrNumber(leftNodeValue));
                            boolean isBForeign__ = (JSGuards.isForeignObjectOrNumber(rightNodeValue));
                            if ((isAForeign__ || isBForeign__)) {
                                return doForeignObject(leftNodeValue, rightNodeValue, isAForeign__, isBForeign__, s22_.aInterop_, s22_.bInterop_);
                            }
                        }
                        s22_ = s22_.next_;
                    }
                }
                if ((state_0 & 0x800000) != 0 /* is SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] */) {
                    {
                        boolean isAForeign__ = (JSGuards.isForeignObjectOrNumber(leftNodeValue));
                        boolean isBForeign__ = (JSGuards.isForeignObjectOrNumber(rightNodeValue));
                        if ((isAForeign__ || isBForeign__)) {
                            return this.foreignObject1Boundary(state_0, leftNodeValue, rightNodeValue);
                        }
                    }
                }
                if ((state_0 & 0x1000000) != 0 /* is SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */) {
                    if (fallbackGuard_(state_0, leftNodeValue, rightNodeValue)) {
                        return JSIdenticalNode.doFallback(leftNodeValue, rightNodeValue);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private boolean foreignObject1Boundary(int state_0, Object leftNodeValue, Object rightNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                boolean isAForeign__ = (JSGuards.isForeignObjectOrNumber(leftNodeValue));
                boolean isBForeign__ = (JSGuards.isForeignObjectOrNumber(rightNodeValue));
                InteropLibrary aInterop__ = (INTEROP_LIBRARY_.getUncached(leftNodeValue));
                InteropLibrary bInterop__ = (INTEROP_LIBRARY_.getUncached(rightNodeValue));
                return doForeignObject(leftNodeValue, rightNodeValue, isAForeign__, isBForeign__, aInterop__, bInterop__);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1fffffe) == 0 /* only-active SpecializationActive[JSIdenticalNode.doInt(int, int)] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
            return executeBoolean_int_int0(state_0, frameValue);
        } else if ((state_0 & 0x1fffffd) == 0 /* only-active SpecializationActive[JSIdenticalNode.doDouble(double, double)] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
            return executeBoolean_double_double1(state_0, frameValue);
        } else if ((state_0 & 0x1fffffb) == 0 /* only-active SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
            return executeBoolean_boolean_boolean2(state_0, frameValue);
        } else if ((state_0 & 0x1ffffef) == 0 /* only-active SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
            return executeBoolean_double3(state_0, frameValue);
        } else if ((state_0 & 0x1ffffdf) == 0 /* only-active SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
            return executeBoolean_double4(state_0, frameValue);
        } else {
            return executeBoolean_generic5(state_0, frameValue);
        }
    }

    private boolean executeBoolean_int_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSIdenticalNode.doInt(int, int)] */;
        return JSIdenticalNode.doInt(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int leftNodeValue_int = 0;
        double leftNodeValue_;
        try {
            if ((state_0 & 0xc000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else if ((state_0 & 0xa000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        double rightNodeValue_;
        try {
            if ((state_0 & 0x60000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else if ((state_0 & 0x50000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(((state_0 & 0xa000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), ex.getResult());
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[JSIdenticalNode.doDouble(double, double)] */;
        return doDouble(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_boolean2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeBoolean(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        boolean rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeBoolean(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] */;
        return JSIdenticalNode.doBoolean(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        int rightNodeValue_int = 0;
        double rightNodeValue_;
        try {
            if ((state_0 & 0x60000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else if ((state_0 & 0x50000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert (state_0 & 0b10000) != 0 /* is SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] */;
        if (leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt) leftNodeValue_;
            return JSIdenticalNode.doBigIntDouble(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, ((state_0 & 0x50000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */) ? (Object) rightNodeValue_int : (Object) rightNodeValue_));
    }

    private boolean executeBoolean_double4(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int leftNodeValue_int = 0;
        double leftNodeValue_;
        try {
            if ((state_0 & 0xc000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else if ((state_0 & 0xa000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */)) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        assert (state_0 & 0b100000) != 0 /* is SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] */;
        if (rightNodeValue_ instanceof BigInt) {
            BigInt rightNodeValue__ = (BigInt) rightNodeValue_;
            return JSIdenticalNode.doDoubleBigInt(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(((state_0 & 0xa000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0x1ffffff) != 0  /* is-not SpecializationActive[JSIdenticalNode.doInt(int, int)] && SpecializationActive[JSIdenticalNode.doDouble(double, double)] && SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] && SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] && SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] && SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] && SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] && SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] && SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] && SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] && SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] && SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] && SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] && SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] && SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] && SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] && SpecializationActive[JSIdenticalNode.doLong(long, long)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] && SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), rightNodeValue_);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private boolean foreignObject1Boundary0(int state_0, Object leftNodeValue_, Object rightNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                boolean isAForeign__ = (JSGuards.isForeignObjectOrNumber(leftNodeValue_));
                boolean isBForeign__ = (JSGuards.isForeignObjectOrNumber(rightNodeValue_));
                InteropLibrary aInterop__ = (INTEROP_LIBRARY_.getUncached(leftNodeValue_));
                InteropLibrary bInterop__ = (INTEROP_LIBRARY_.getUncached(rightNodeValue_));
                return doForeignObject(leftNodeValue_, rightNodeValue_, isAForeign__, isBForeign__, aInterop__, bInterop__);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    private boolean executeBoolean_generic5(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        if ((state_0 & 0x1ffffff) != 0 /* is SpecializationActive[JSIdenticalNode.doInt(int, int)] || SpecializationActive[JSIdenticalNode.doDouble(double, double)] || SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] || SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] || SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] || SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] || SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] || SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] || SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] || SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] || SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] || SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] || SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] || SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] || SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] || SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] || SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] || SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] || SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] || SpecializationActive[JSIdenticalNode.doLong(long, long)] || SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSIdenticalNode.doInt(int, int)] */ && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__ = (int) leftNodeValue_;
                if (rightNodeValue_ instanceof Integer) {
                    int rightNodeValue__ = (int) rightNodeValue_;
                    return JSIdenticalNode.doInt(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSIdenticalNode.doDouble(double, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue_)) {
                double leftNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue_);
                if (JSTypesGen.isImplicitDouble((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_)) {
                    double rightNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_);
                    return doDouble(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] */ && leftNodeValue_ instanceof Boolean) {
                boolean leftNodeValue__ = (boolean) leftNodeValue_;
                if (rightNodeValue_ instanceof Boolean) {
                    boolean rightNodeValue__ = (boolean) rightNodeValue_;
                    return JSIdenticalNode.doBoolean(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] || SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] */ && leftNodeValue_ instanceof BigInt) {
                BigInt leftNodeValue__ = (BigInt) leftNodeValue_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] */ && rightNodeValue_ instanceof BigInt) {
                    BigInt rightNodeValue__ = (BigInt) rightNodeValue_;
                    return JSIdenticalNode.doBigInt(leftNodeValue__, rightNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_)) {
                    double rightNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_);
                    return JSIdenticalNode.doBigIntDouble(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] */ && JSTypesGen.isImplicitDouble((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue_)) {
                double leftNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue_);
                if (rightNodeValue_ instanceof BigInt) {
                    BigInt rightNodeValue__ = (BigInt) rightNodeValue_;
                    return JSIdenticalNode.doDoubleBigInt(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b111000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] || SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] || SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] */) {
                if ((state_0 & 0b11000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] || SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] */) {
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] */) {
                        if ((JSGuards.isUndefined(leftNodeValue_))) {
                            return JSIdenticalNode.doUndefinedA(leftNodeValue_, rightNodeValue_);
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] */) {
                        if ((JSGuards.isUndefined(rightNodeValue_))) {
                            return JSIdenticalNode.doUndefinedB(leftNodeValue_, rightNodeValue_);
                        }
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] */ && leftNodeValue_ instanceof JSObject) {
                    JSObject leftNodeValue__ = (JSObject) leftNodeValue_;
                    return JSIdenticalNode.doJSObjectA(leftNodeValue__, rightNodeValue_);
                }
            }
            if ((state_0 & 0b111111000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] || SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] || SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] || SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] || SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] */) {
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] */ && rightNodeValue_ instanceof JSObject) {
                    JSObject rightNodeValue__ = (JSObject) rightNodeValue_;
                    return JSIdenticalNode.doJSObjectB(leftNodeValue_, rightNodeValue__);
                }
                if ((state_0 & 0b111110000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] || SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] || SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] || SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] */) {
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] */) {
                        if ((JSGuards.isJSNull(leftNodeValue_)) && (JSGuards.isJSNull(rightNodeValue_))) {
                            return JSIdenticalNode.doNullNull(leftNodeValue_, rightNodeValue_);
                        }
                    }
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] */) {
                        if ((JSGuards.isJSNull(leftNodeValue_)) && (JSGuards.isUndefined(rightNodeValue_))) {
                            return JSIdenticalNode.doNullUndefined(leftNodeValue_, rightNodeValue_);
                        }
                    }
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] */) {
                        if ((JSGuards.isUndefined(leftNodeValue_)) && (JSGuards.isJSNull(rightNodeValue_))) {
                            return JSIdenticalNode.doUndefinedNull(leftNodeValue_, rightNodeValue_);
                        }
                    }
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] */) {
                        {
                            InteropLibrary nullInterop_ = this.nullInterop;
                            if (nullInterop_ != null) {
                                if ((JSGuards.isJSNull(leftNodeValue_)) && (!(JSRuntime.isNullOrUndefined(rightNodeValue_)))) {
                                    return JSIdenticalNode.doNullA(leftNodeValue_, rightNodeValue_, nullInterop_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] */) {
                        {
                            InteropLibrary nullInterop_1 = this.nullInterop;
                            if (nullInterop_1 != null) {
                                if ((!(JSRuntime.isNullOrUndefined(leftNodeValue_))) && (JSGuards.isJSNull(rightNodeValue_))) {
                                    return JSIdenticalNode.doNullB(leftNodeValue_, rightNodeValue_, nullInterop_1);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0x18000) != 0 /* is SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] || SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] */ && leftNodeValue_ instanceof TruffleString) {
                TruffleString leftNodeValue__ = (TruffleString) leftNodeValue_;
                if (rightNodeValue_ instanceof TruffleString) {
                    TruffleString rightNodeValue__ = (TruffleString) rightNodeValue_;
                    if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] */) {
                        if ((JSGuards.isReferenceEquals(leftNodeValue__, rightNodeValue__))) {
                            return JSIdenticalNode.doTruffleStringIdentity(leftNodeValue__, rightNodeValue__);
                        }
                    }
                    if ((state_0 & 0x10000) != 0 /* is SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] */) {
                        {
                            EqualNode equalsNode__ = this.truffleString_equalsNode_;
                            if (equalsNode__ != null) {
                                return JSIdenticalNode.doTruffleString(leftNodeValue__, rightNodeValue__, equalsNode__);
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0x20000) != 0 /* is SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] */ && leftNodeValue_ instanceof Symbol) {
                Symbol leftNodeValue__ = (Symbol) leftNodeValue_;
                if (rightNodeValue_ instanceof Symbol) {
                    Symbol rightNodeValue__ = (Symbol) rightNodeValue_;
                    return JSIdenticalNode.doSymbol(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0x1c0000) != 0 /* is SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] || SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] || SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] */) {
                if ((state_0 & 0x40000) != 0 /* is SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] */) {
                    if ((JSGuards.isBoolean(leftNodeValue_) != JSGuards.isBoolean(rightNodeValue_))) {
                        return JSIdenticalNode.doBooleanNotBoolean(leftNodeValue_, rightNodeValue_);
                    }
                }
                if ((state_0 & 0x80000) != 0 /* is SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] */) {
                    if ((JSGuards.isSymbol(leftNodeValue_) != JSGuards.isSymbol(rightNodeValue_))) {
                        return JSIdenticalNode.doSymbolNotSymbol(leftNodeValue_, rightNodeValue_);
                    }
                }
                if ((state_0 & 0x100000) != 0 /* is SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] */) {
                    if ((JSGuards.isString(leftNodeValue_) != JSGuards.isString(rightNodeValue_))) {
                        return JSIdenticalNode.doStringNotString(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
            if ((state_0 & 0x200000) != 0 /* is SpecializationActive[JSIdenticalNode.doLong(long, long)] */ && leftNodeValue_ instanceof Long) {
                long leftNodeValue__ = (long) leftNodeValue_;
                if (rightNodeValue_ instanceof Long) {
                    long rightNodeValue__ = (long) rightNodeValue_;
                    return JSIdenticalNode.doLong(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0x1c00000) != 0 /* is SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] || SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */) {
                if ((state_0 & 0x400000) != 0 /* is SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] */) {
                    ForeignObject0Data s22_ = this.foreignObject0_cache;
                    while (s22_ != null) {
                        if ((s22_.aInterop_.accepts(leftNodeValue_)) && (s22_.bInterop_.accepts(rightNodeValue_))) {
                            boolean isAForeign__ = (JSGuards.isForeignObjectOrNumber(leftNodeValue_));
                            boolean isBForeign__ = (JSGuards.isForeignObjectOrNumber(rightNodeValue_));
                            if ((isAForeign__ || isBForeign__)) {
                                return doForeignObject(leftNodeValue_, rightNodeValue_, isAForeign__, isBForeign__, s22_.aInterop_, s22_.bInterop_);
                            }
                        }
                        s22_ = s22_.next_;
                    }
                }
                if ((state_0 & 0x800000) != 0 /* is SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] */) {
                    {
                        boolean isAForeign__ = (JSGuards.isForeignObjectOrNumber(leftNodeValue_));
                        boolean isBForeign__ = (JSGuards.isForeignObjectOrNumber(rightNodeValue_));
                        if ((isAForeign__ || isBForeign__)) {
                            return this.foreignObject1Boundary0(state_0, leftNodeValue_, rightNodeValue_);
                        }
                    }
                }
                if ((state_0 & 0x1000000) != 0 /* is SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */) {
                    if (fallbackGuard_(state_0, leftNodeValue_, rightNodeValue_)) {
                        return JSIdenticalNode.doFallback(leftNodeValue_, rightNodeValue_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        executeBoolean(frameValue);
        return;
    }

    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        if (leftNodeValue instanceof Integer) {
            int leftNodeValue_ = (int) leftNodeValue;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (int) rightNodeValue;
                state_0 = state_0 | 0b1 /* add SpecializationActive[JSIdenticalNode.doInt(int, int)] */;
                this.state_0_ = state_0;
                return JSIdenticalNode.doInt(leftNodeValue_, rightNodeValue_);
            }
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                int doubleCast1;
                if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state_0 = (state_0 | (doubleCast0 << 25) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = (state_0 | (doubleCast1 << 28) /* set-int ImplicitCast[type=double, index=1] */);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[JSIdenticalNode.doDouble(double, double)] */;
                    this.state_0_ = state_0;
                    return doDouble(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if (leftNodeValue instanceof Boolean) {
            boolean leftNodeValue_ = (boolean) leftNodeValue;
            if (rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_ = (boolean) rightNodeValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[JSIdenticalNode.doBoolean(boolean, boolean)] */;
                this.state_0_ = state_0;
                return JSIdenticalNode.doBoolean(leftNodeValue_, rightNodeValue_);
            }
        }
        if (leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_ = (BigInt) leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[JSIdenticalNode.doBigInt(BigInt, BigInt)] */;
                this.state_0_ = state_0;
                return JSIdenticalNode.doBigInt(leftNodeValue_, rightNodeValue_);
            }
            {
                int doubleCast1;
                if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state_0 = (state_0 | (doubleCast1 << 28) /* set-int ImplicitCast[type=double, index=1] */);
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[JSIdenticalNode.doBigIntDouble(BigInt, double)] */;
                    this.state_0_ = state_0;
                    return JSIdenticalNode.doBigIntDouble(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                    state_0 = (state_0 | (doubleCast0 << 25) /* set-int ImplicitCast[type=double, index=0] */);
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[JSIdenticalNode.doDoubleBigInt(double, BigInt)] */;
                    this.state_0_ = state_0;
                    return JSIdenticalNode.doDoubleBigInt(leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if ((JSGuards.isUndefined(leftNodeValue))) {
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[JSIdenticalNode.doUndefinedA(Object, Object)] */;
            this.state_0_ = state_0;
            return JSIdenticalNode.doUndefinedA(leftNodeValue, rightNodeValue);
        }
        if ((JSGuards.isUndefined(rightNodeValue))) {
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[JSIdenticalNode.doUndefinedB(Object, Object)] */;
            this.state_0_ = state_0;
            return JSIdenticalNode.doUndefinedB(leftNodeValue, rightNodeValue);
        }
        if (leftNodeValue instanceof JSObject) {
            JSObject leftNodeValue_ = (JSObject) leftNodeValue;
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[JSIdenticalNode.doJSObjectA(JSObject, Object)] */;
            this.state_0_ = state_0;
            return JSIdenticalNode.doJSObjectA(leftNodeValue_, rightNodeValue);
        }
        if (rightNodeValue instanceof JSObject) {
            JSObject rightNodeValue_ = (JSObject) rightNodeValue;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[JSIdenticalNode.doJSObjectB(Object, JSObject)] */;
            this.state_0_ = state_0;
            return JSIdenticalNode.doJSObjectB(leftNodeValue, rightNodeValue_);
        }
        if ((JSGuards.isJSNull(leftNodeValue)) && (JSGuards.isJSNull(rightNodeValue))) {
            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[JSIdenticalNode.doNullNull(Object, Object)] */;
            this.state_0_ = state_0;
            return JSIdenticalNode.doNullNull(leftNodeValue, rightNodeValue);
        }
        if ((JSGuards.isJSNull(leftNodeValue)) && (JSGuards.isUndefined(rightNodeValue))) {
            state_0 = state_0 | 0b100000000000 /* add SpecializationActive[JSIdenticalNode.doNullUndefined(Object, Object)] */;
            this.state_0_ = state_0;
            return JSIdenticalNode.doNullUndefined(leftNodeValue, rightNodeValue);
        }
        if ((JSGuards.isUndefined(leftNodeValue)) && (JSGuards.isJSNull(rightNodeValue))) {
            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[JSIdenticalNode.doUndefinedNull(Object, Object)] */;
            this.state_0_ = state_0;
            return JSIdenticalNode.doUndefinedNull(leftNodeValue, rightNodeValue);
        }
        if ((JSGuards.isJSNull(leftNodeValue)) && (!(JSRuntime.isNullOrUndefined(rightNodeValue)))) {
            InteropLibrary nullInterop_;
            InteropLibrary nullInterop__shared = this.nullInterop;
            if (nullInterop__shared != null) {
                nullInterop_ = nullInterop__shared;
            } else {
                nullInterop_ = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                if (nullInterop_ == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.nullInterop == null) {
                VarHandle.storeStoreFence();
                this.nullInterop = nullInterop_;
            }
            state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[JSIdenticalNode.doNullA(Object, Object, InteropLibrary)] */;
            this.state_0_ = state_0;
            return JSIdenticalNode.doNullA(leftNodeValue, rightNodeValue, nullInterop_);
        }
        if ((!(JSRuntime.isNullOrUndefined(leftNodeValue))) && (JSGuards.isJSNull(rightNodeValue))) {
            InteropLibrary nullInterop_1;
            InteropLibrary nullInterop_1_shared = this.nullInterop;
            if (nullInterop_1_shared != null) {
                nullInterop_1 = nullInterop_1_shared;
            } else {
                nullInterop_1 = this.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                if (nullInterop_1 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.nullInterop == null) {
                VarHandle.storeStoreFence();
                this.nullInterop = nullInterop_1;
            }
            state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[JSIdenticalNode.doNullB(Object, Object, InteropLibrary)] */;
            this.state_0_ = state_0;
            return JSIdenticalNode.doNullB(leftNodeValue, rightNodeValue, nullInterop_1);
        }
        if (leftNodeValue instanceof TruffleString) {
            TruffleString leftNodeValue_ = (TruffleString) leftNodeValue;
            if (rightNodeValue instanceof TruffleString) {
                TruffleString rightNodeValue_ = (TruffleString) rightNodeValue;
                if (((state_0 & 0x10000)) == 0 /* is-not SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] */) {
                    if ((JSGuards.isReferenceEquals(leftNodeValue_, rightNodeValue_))) {
                        state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] */;
                        this.state_0_ = state_0;
                        return JSIdenticalNode.doTruffleStringIdentity(leftNodeValue_, rightNodeValue_);
                    }
                }
                EqualNode equalsNode__ = this.insert((EqualNode.create()));
                Objects.requireNonNull(equalsNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.truffleString_equalsNode_ = equalsNode__;
                state_0 = state_0 & 0xffff7fff /* remove SpecializationActive[JSIdenticalNode.doTruffleStringIdentity(TruffleString, TruffleString)] */;
                state_0 = state_0 | 0x10000 /* add SpecializationActive[JSIdenticalNode.doTruffleString(TruffleString, TruffleString, EqualNode)] */;
                this.state_0_ = state_0;
                return JSIdenticalNode.doTruffleString(leftNodeValue_, rightNodeValue_, equalsNode__);
            }
        }
        if (leftNodeValue instanceof Symbol) {
            Symbol leftNodeValue_ = (Symbol) leftNodeValue;
            if (rightNodeValue instanceof Symbol) {
                Symbol rightNodeValue_ = (Symbol) rightNodeValue;
                state_0 = state_0 | 0x20000 /* add SpecializationActive[JSIdenticalNode.doSymbol(Symbol, Symbol)] */;
                this.state_0_ = state_0;
                return JSIdenticalNode.doSymbol(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue))) {
            state_0 = state_0 | 0x40000 /* add SpecializationActive[JSIdenticalNode.doBooleanNotBoolean(Object, Object)] */;
            this.state_0_ = state_0;
            return JSIdenticalNode.doBooleanNotBoolean(leftNodeValue, rightNodeValue);
        }
        if ((JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue))) {
            state_0 = state_0 | 0x80000 /* add SpecializationActive[JSIdenticalNode.doSymbolNotSymbol(Object, Object)] */;
            this.state_0_ = state_0;
            return JSIdenticalNode.doSymbolNotSymbol(leftNodeValue, rightNodeValue);
        }
        if ((JSGuards.isString(leftNodeValue) != JSGuards.isString(rightNodeValue))) {
            state_0 = state_0 | 0x100000 /* add SpecializationActive[JSIdenticalNode.doStringNotString(Object, Object)] */;
            this.state_0_ = state_0;
            return JSIdenticalNode.doStringNotString(leftNodeValue, rightNodeValue);
        }
        if (leftNodeValue instanceof Long) {
            long leftNodeValue_ = (long) leftNodeValue;
            if (rightNodeValue instanceof Long) {
                long rightNodeValue_ = (long) rightNodeValue;
                state_0 = state_0 | 0x200000 /* add SpecializationActive[JSIdenticalNode.doLong(long, long)] */;
                this.state_0_ = state_0;
                return JSIdenticalNode.doLong(leftNodeValue_, rightNodeValue_);
            }
        }
        {
            boolean isBForeign__ = false;
            boolean isAForeign__ = false;
            if (((state_0 & 0x800000)) == 0 /* is-not SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] */) {
                while (true) {
                    int count22_ = 0;
                    ForeignObject0Data s22_ = FOREIGN_OBJECT0_CACHE_UPDATER.getVolatile(this);
                    ForeignObject0Data s22_original = s22_;
                    while (s22_ != null) {
                        if ((s22_.aInterop_.accepts(leftNodeValue)) && (s22_.bInterop_.accepts(rightNodeValue))) {
                            isAForeign__ = (JSGuards.isForeignObjectOrNumber(leftNodeValue));
                            isBForeign__ = (JSGuards.isForeignObjectOrNumber(rightNodeValue));
                            if ((isAForeign__ || isBForeign__)) {
                                break;
                            }
                        }
                        count22_++;
                        s22_ = s22_.next_;
                    }
                    if (s22_ == null) {
                        {
                            isAForeign__ = (JSGuards.isForeignObjectOrNumber(leftNodeValue));
                            isBForeign__ = (JSGuards.isForeignObjectOrNumber(rightNodeValue));
                            // assert (s22_.aInterop_.accepts(leftNodeValue));
                            // assert (s22_.bInterop_.accepts(rightNodeValue));
                            if ((isAForeign__ || isBForeign__) && count22_ < (JSConfig.InteropLibraryLimit)) {
                                s22_ = this.insert(new ForeignObject0Data(s22_original));
                                InteropLibrary aInterop__ = s22_.insert((INTEROP_LIBRARY_.create(leftNodeValue)));
                                Objects.requireNonNull(aInterop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s22_.aInterop_ = aInterop__;
                                InteropLibrary bInterop__ = s22_.insert((INTEROP_LIBRARY_.create(rightNodeValue)));
                                Objects.requireNonNull(bInterop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s22_.bInterop_ = bInterop__;
                                if (!FOREIGN_OBJECT0_CACHE_UPDATER.compareAndSet(this, s22_original, s22_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0x400000 /* add SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                    }
                    if (s22_ != null) {
                        return doForeignObject(leftNodeValue, rightNodeValue, isAForeign__, isBForeign__, s22_.aInterop_, s22_.bInterop_);
                    }
                    break;
                }
            }
        }
        {
            InteropLibrary bInterop__ = null;
            InteropLibrary aInterop__ = null;
            boolean isBForeign__ = false;
            boolean isAForeign__ = false;
            {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        isAForeign__ = (JSGuards.isForeignObjectOrNumber(leftNodeValue));
                        isBForeign__ = (JSGuards.isForeignObjectOrNumber(rightNodeValue));
                        if ((isAForeign__ || isBForeign__)) {
                            aInterop__ = (INTEROP_LIBRARY_.getUncached(leftNodeValue));
                            bInterop__ = (INTEROP_LIBRARY_.getUncached(rightNodeValue));
                            this.foreignObject0_cache = null;
                            state_0 = state_0 & 0xffbfffff /* remove SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] */;
                            state_0 = state_0 | 0x800000 /* add SpecializationActive[JSIdenticalNode.doForeignObject(Object, Object, boolean, boolean, InteropLibrary, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return doForeignObject(leftNodeValue, rightNodeValue, isAForeign__, isBForeign__, aInterop__, bInterop__);
                        }
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        state_0 = state_0 | 0x1000000 /* add SpecializationActive[JSIdenticalNode.doFallback(Object, Object)] */;
        this.state_0_ = state_0;
        return JSIdenticalNode.doFallback(leftNodeValue, rightNodeValue);
    }

    @NeverDefault
    public static JSIdenticalNode create(JavaScriptNode left, JavaScriptNode right, int type) {
        return new JSIdenticalNodeGen(left, right, type);
    }

    @GeneratedBy(JSIdenticalNode.class)
    @DenyReplace
    private static final class ForeignObject0Data extends Node implements SpecializationDataNode {

        @Child ForeignObject0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSIdenticalNode#doForeignObject}
         *   Parameter: {@link InteropLibrary} aInterop</pre>
         */
        @Child InteropLibrary aInterop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSIdenticalNode#doForeignObject}
         *   Parameter: {@link InteropLibrary} bInterop</pre>
         */
        @Child InteropLibrary bInterop_;

        ForeignObject0Data(ForeignObject0Data next_) {
            this.next_ = next_;
        }

    }
}
