/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.management;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.ThreadMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.management.MBeanServer;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.graal.compiler.serviceprovider.JMXService;
import jdk.graal.compiler.serviceprovider.ServiceProvider;

@ServiceProvider(value=JMXService.class)
public class JMXServiceProvider
extends JMXService {
    private final ThreadMXBean threadMXBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private volatile HotSpotDiagnosticMXBean hotspotMXBean;

    protected long getThreadAllocatedBytes(long id) {
        return this.threadMXBean.getThreadAllocatedBytes(id);
    }

    protected long getCurrentThreadCpuTime() {
        long[] times = this.threadMXBean.getThreadCpuTime(new long[]{GraalServices.getCurrentThreadId()});
        return times[0];
    }

    protected boolean isThreadAllocatedMemorySupported() {
        return this.threadMXBean.isThreadAllocatedMemorySupported();
    }

    protected boolean isCurrentThreadCpuTimeSupported() {
        return this.threadMXBean.isThreadCpuTimeSupported();
    }

    protected List<String> getInputArguments() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }

    protected void dumpHeap(String outputFile, boolean live) throws IOException {
        this.initHotSpotMXBean();
        try {
            Path path = Path.of(outputFile, new String[0]);
            if (Files.exists(path, new LinkOption[0]) && Files.size(path) == 0L) {
                Files.delete(path);
            }
            this.hotspotMXBean.dumpHeap(outputFile, live);
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHotSpotMXBean() {
        if (this.hotspotMXBean == null) {
            JMXServiceProvider jMXServiceProvider = this;
            synchronized (jMXServiceProvider) {
                if (this.hotspotMXBean == null) {
                    this.hotspotMXBean = JMXServiceProvider.getHotSpotMXBean();
                }
            }
        }
    }

    private static HotSpotDiagnosticMXBean getHotSpotMXBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            return ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }
}

