/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.management;

import com.sun.management.ThreadMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.graal.compiler.serviceprovider.JMXService;
import jdk.graal.compiler.serviceprovider.ServiceProvider;

@ServiceProvider(value=JMXService.class)
public class JMXServiceProvider
extends JMXService {
    private final ThreadMXBean threadMXBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();

    protected long getThreadAllocatedBytes(long id) {
        return this.threadMXBean.getThreadAllocatedBytes(id);
    }

    protected long getCurrentThreadCpuTime() {
        long[] times = this.threadMXBean.getThreadCpuTime(new long[]{GraalServices.getCurrentThreadId()});
        return times[0];
    }

    protected boolean isThreadAllocatedMemorySupported() {
        return this.threadMXBean.isThreadAllocatedMemorySupported();
    }

    protected boolean isCurrentThreadCpuTimeSupported() {
        return this.threadMXBean.isThreadCpuTimeSupported();
    }

    protected List<String> getInputArguments() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }
}

