/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.management;

import com.sun.management.ThreadMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.graalvm.compiler.serviceprovider.JMXService;
import org.graalvm.compiler.serviceprovider.ServiceProvider;

@ServiceProvider(value=JMXService.class)
public class JMXServiceProvider
extends JMXService {
    private final ThreadMXBean threadMXBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();

    protected long getThreadAllocatedBytes(long id) {
        return this.threadMXBean.getThreadAllocatedBytes(id);
    }

    protected long getCurrentThreadCpuTime() {
        long[] times = this.threadMXBean.getThreadCpuTime(new long[]{Thread.currentThread().getId()});
        return times[0];
    }

    protected boolean isThreadAllocatedMemorySupported() {
        return this.threadMXBean.isThreadAllocatedMemorySupported();
    }

    protected boolean isCurrentThreadCpuTimeSupported() {
        return this.threadMXBean.isThreadCpuTimeSupported();
    }

    protected List<String> getInputArguments() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }
}

