/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.compiler.phases.common.jmx.HotSpotMBeanOperationProvider;
import org.graalvm.compiler.serviceprovider.GraalServices;

public final class HotSpotGraalRuntimeMBean
implements DynamicMBean {
    private final HotSpotGraalRuntime runtime;
    private final ObjectName objectName;
    private static final boolean DEBUG = HotSpotGraalRuntimeMBean.initDebug();

    public HotSpotGraalRuntimeMBean(ObjectName objectName, HotSpotGraalRuntime runtime) {
        this.objectName = objectName;
        this.runtime = runtime;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public HotSpotGraalRuntime getRuntime() {
        return this.runtime;
    }

    private static boolean initDebug() {
        try {
            return Boolean.parseBoolean((String)Services.getSavedProperties().get(HotSpotGraalRuntimeMBean.class.getSimpleName() + ".debug"));
        }
        catch (SecurityException e) {
            return false;
        }
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException {
        String[] result = this.runtime.getOptionValues(new String[]{name});
        String value = result[0];
        if (value == null) {
            throw new AttributeNotFoundException(name);
        }
        if (DEBUG) {
            System.out.printf("getAttribute: %s = %s (type: %s)%n", name, value, value == null ? "null" : value.getClass().getName());
        }
        return result[0];
    }

    @Override
    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="reference equality on the receiver is what we want")
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException {
        String[] result;
        String name = attribute.getName();
        Object value = attribute.getValue();
        String svalue = String.valueOf(value);
        if (DEBUG) {
            System.out.printf("setAttribute: %s = %s (type: %s)%n", name, svalue, value == null ? "null" : value.getClass().getName());
        }
        if ((result = this.runtime.setOptionValues(new String[]{name}, new String[]{svalue}))[0] != name) {
            if (result[0] == null) {
                throw new AttributeNotFoundException(name);
            }
            throw new InvalidAttributeValueException(result[0]);
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        String[] values = this.runtime.getOptionValues(names);
        AttributeList list = new AttributeList();
        for (int i = 0; i < names.length; ++i) {
            String value = values[i];
            String name = names[i];
            if (value == null) {
                TTY.printf((String)"No such option named %s%n", (Object[])new Object[]{name});
                continue;
            }
            if (DEBUG) {
                System.out.printf("getAttributes: %s = %s (type: %s)%n", name, value, value == null ? "null" : value.getClass().getName());
            }
            list.add(new Attribute(name, value));
        }
        return list;
    }

    @Override
    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="reference equality on the receiver is what we want")
    public AttributeList setAttributes(AttributeList attributes) {
        String[] names = new String[attributes.size()];
        String[] values = new String[attributes.size()];
        int i = 0;
        for (Attribute attr : attributes.asList()) {
            String svalue;
            String name;
            names[i] = name = attr.getName();
            Object value = attr.getValue();
            values[i] = svalue = String.valueOf(value);
            if (DEBUG) {
                System.out.printf("setAttributes: %s = %s (type: %s)%n", name, svalue, value == null ? "null" : value.getClass().getName());
            }
            ++i;
        }
        String[] result = this.runtime.setOptionValues(names, values);
        AttributeList setOk = new AttributeList();
        i = 0;
        for (Attribute attr : attributes.asList()) {
            if (names[i] == result[i]) {
                setOk.add(attr);
            } else if (result[i] == null) {
                TTY.printf((String)"Error setting %s to %s: unknown option%n", (Object[])new Object[]{attr.getName(), attr.getValue()});
            } else {
                TTY.printf((String)"Error setting %s to %s: %s%n", (Object[])new Object[]{attr.getName(), attr.getValue(), result[i]});
            }
            ++i;
        }
        return setOk;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            if (DEBUG) {
                System.out.printf("invoke: %s%s%n", actionName, Arrays.asList(params));
            }
            Object retvalue = null;
            if ("dumpMethod".equals(actionName)) {
                retvalue = this.runtime.invokeManagementAction(actionName, params);
            } else {
                boolean found = false;
                block3: for (HotSpotMBeanOperationProvider p : GraalServices.load(HotSpotMBeanOperationProvider.class)) {
                    ArrayList info = new ArrayList();
                    p.registerOperations(MBeanOperationInfo.class, info);
                    for (MBeanOperationInfo op : info) {
                        if (!actionName.equals(op.getName())) continue;
                        retvalue = p.invoke(actionName, params, signature);
                        found = true;
                        continue block3;
                    }
                }
                if (!found) {
                    throw new MBeanException(new IllegalStateException("Cannot find operation " + actionName));
                }
            }
            if (DEBUG) {
                System.out.printf("invoke: %s%s = %s%n", actionName, Arrays.asList(params), retvalue);
            }
            return retvalue;
        }
        catch (MBeanException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attrs = new ArrayList<MBeanAttributeInfo>();
        for (OptionDescriptor option : HotSpotGraalRuntimeMBean.getOptionDescriptors().getValues()) {
            Class<String> optionValueType = option.getOptionValueType();
            if (Enum.class.isAssignableFrom(optionValueType)) {
                optionValueType = String.class;
            }
            attrs.add(new MBeanAttributeInfo(option.getName(), optionValueType.getName(), option.getHelp(), true, true, false));
        }
        attrs.sort(new Comparator<MBeanAttributeInfo>(){

            @Override
            public int compare(MBeanAttributeInfo o1, MBeanAttributeInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<MBeanOperationInfo> opts = new ArrayList<MBeanOperationInfo>();
        opts.add(new MBeanOperationInfo("dumpMethod", "Enable IGV dumps for provided method", new MBeanParameterInfo[]{new MBeanParameterInfo("className", "java.lang.String", "Class to observe"), new MBeanParameterInfo("methodName", "java.lang.String", "Method to observe")}, "void", 1));
        opts.add(new MBeanOperationInfo("dumpMethod", "Enable IGV dumps for provided method", new MBeanParameterInfo[]{new MBeanParameterInfo("className", "java.lang.String", "Class to observe"), new MBeanParameterInfo("methodName", "java.lang.String", "Method to observe"), new MBeanParameterInfo("filter", "java.lang.String", "The parameter for Dump option")}, "void", 1));
        opts.add(new MBeanOperationInfo("dumpMethod", "Enable IGV dumps for provided method", new MBeanParameterInfo[]{new MBeanParameterInfo("className", "java.lang.String", "Class to observe"), new MBeanParameterInfo("methodName", "java.lang.String", "Method to observe"), new MBeanParameterInfo("filter", "java.lang.String", "The parameter for Dump option"), new MBeanParameterInfo("host", "java.lang.String", "The host where the IGV tool is running at"), new MBeanParameterInfo("port", "int", "The port where the IGV tool is listening at")}, "void", 1));
        for (HotSpotMBeanOperationProvider p : GraalServices.load(HotSpotMBeanOperationProvider.class)) {
            p.registerOperations(MBeanOperationInfo.class, opts);
        }
        return new MBeanInfo(HotSpotGraalRuntimeMBean.class.getName(), "Graal", attrs.toArray(new MBeanAttributeInfo[attrs.size()]), null, opts.toArray(new MBeanOperationInfo[opts.size()]), null);
    }

    private static EconomicMap<String, OptionDescriptor> getOptionDescriptors() {
        EconomicMap result = EconomicMap.create();
        for (OptionDescriptors set : OptionsParser.getOptionsLoader()) {
            for (OptionDescriptor option : set) {
                result.put((Object)option.getName(), (Object)option);
            }
        }
        return result;
    }
}

