/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.TreeSet;
import java.util.stream.Stream;

public class JarScanner {
    public static void scanJar(Path inputJar, Path outputFile) throws IOException {
        try (BufferedWriter fileWriter = Files.newBufferedWriter(outputFile, new OpenOption[0]);
             PrintWriter writer = new PrintWriter(fileWriter);){
            TreeSet packageList = new TreeSet();
            try (FileSystem jarFileSystem = FileSystems.newFileSystem(inputJar, (ClassLoader)null);){
                Path root = jarFileSystem.getPath("/", new String[0]);
                try (Stream<Path> files = Files.walk(root, new FileVisitOption[0]);){
                    files.forEach(path -> {
                        Path relativePath;
                        String className;
                        int lastDot;
                        if (path.toString().endsWith(".class") && !path.toString().contains("META-INF") && (lastDot = (className = (relativePath = root.relativize((Path)path)).toString().replace('/', '.').replace('\\', '.').replaceAll("[.]class$", "")).lastIndexOf(".")) > 0) {
                            String packageName = className.substring(0, lastDot);
                            packageList.add(packageName);
                        }
                    });
                }
            }
            writer.println("packages=" + String.join((CharSequence)",", packageList));
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write JAR analysis", ex);
        }
    }
}

