/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven.sbom;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

final class FileWalkerUtility {
    FileWalkerUtility() {
    }

    static Optional<Set<String>> collectPackageNamesFromDirectory(Path path) throws IOException {
        return FileWalkerUtility.walkFileTreeAndCollectPackageNames(path, path);
    }

    static Optional<Set<String>> collectPackageNamesFromFileSystem(FileSystem fileSystem, Path startPath) throws IOException {
        return FileWalkerUtility.walkFileTreeAndCollectPackageNames(fileSystem.getPath(startPath.toString(), new String[0]), fileSystem.getPath("/", new String[0]));
    }

    private static Optional<Set<String>> walkFileTreeAndCollectPackageNames(Path pathToSearchIn, Path basePathForPackageNameResolution) throws IOException {
        HashSet packageNames = new HashSet();
        FileWalkerUtility.walkFileTreeWithExtensions(pathToSearchIn, Set.of(".java", ".class"), file -> {
            Optional<String> optionalPackageName = FileWalkerUtility.extractPackageName(file, basePathForPackageNameResolution);
            optionalPackageName.ifPresent(packageNames::add);
        });
        return Optional.of(packageNames);
    }

    static void walkFileTreeWithExtensions(Path startPath, final Set<String> fileExtensions, final Consumer<Path> fileHandler) throws IOException {
        Files.walkFileTree(startPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                for (String extension : fileExtensions) {
                    if (!file.toString().endsWith(extension)) continue;
                    fileHandler.accept(file);
                    break;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static Optional<String> extractPackageName(Path filePath, Path basePath) {
        String relativePath = basePath.relativize(filePath).toString();
        int lastSeparatorIndex = relativePath.lastIndexOf(File.separator);
        if (lastSeparatorIndex == -1) {
            return Optional.empty();
        }
        String packageName = relativePath.substring(0, lastSeparatorIndex);
        packageName = packageName.replace(File.separatorChar, '.');
        return Optional.of(packageName);
    }

    static boolean containsClassFiles(Path directory) {
        boolean bl;
        block8: {
            DirectoryStream<Path> stream = Files.newDirectoryStream(directory, "*.class");
            try {
                bl = stream.iterator().hasNext();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }
}

