/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.process.CommandLineArgumentProvider;

public class NativeImageCommandLineProvider
implements CommandLineArgumentProvider {
    private static final Transformer<Boolean, Boolean> NEGATE = b -> b == false;
    private final Provider<NativeImageOptions> options;
    private final Provider<Boolean> agentEnabled;
    private final Provider<String> executableName;
    private final Provider<String> outputDirectory;
    private final Provider<RegularFile> classpathJar;

    public NativeImageCommandLineProvider(Provider<NativeImageOptions> options, Provider<Boolean> agentEnabled, Provider<String> executableName, Provider<String> outputDirectory, Provider<RegularFile> classpathJar) {
        this.options = options;
        this.agentEnabled = agentEnabled;
        this.executableName = executableName;
        this.outputDirectory = outputDirectory;
        this.classpathJar = classpathJar;
    }

    @Nested
    public Provider<NativeImageOptions> getOptions() {
        return this.options;
    }

    @Input
    public Provider<Boolean> getAgentEnabled() {
        return this.agentEnabled;
    }

    @Input
    public Provider<String> getExecutableName() {
        return this.executableName;
    }

    @Input
    public Provider<String> getOutputDirectory() {
        return this.outputDirectory;
    }

    @InputFile
    public Provider<RegularFile> getClasspathJar() {
        return this.classpathJar;
    }

    public List<String> asArguments() {
        NativeImageOptions options = (NativeImageOptions)this.getOptions().get();
        ArrayList<String> cliArgs = new ArrayList<String>(20);
        cliArgs.add("-cp");
        if (this.classpathJar.isPresent()) {
            cliArgs.add(((RegularFile)this.classpathJar.get()).getAsFile().getAbsolutePath());
        } else {
            cliArgs.add(options.getClasspath().getAsPath());
        }
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, options.getDebug(), "-H:GenerateDebugInfo=1");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getFallback().map(NEGATE), "--no-fallback");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, options.getVerbose(), "--verbose");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, options.getSharedLibrary(), "--shared");
        if (this.getOutputDirectory().isPresent()) {
            cliArgs.add("-H:Path=" + (String)this.getOutputDirectory().get());
        }
        cliArgs.add("-H:Name=" + (String)this.getExecutableName().get());
        ((Map)options.getSystemProperties().get()).forEach((n, v) -> {
            if (v != null) {
                cliArgs.add("-D" + n + "=\"" + v + "\"");
            }
        });
        ((List)options.getJvmArgs().get()).forEach(jvmArg -> cliArgs.add("-J" + jvmArg));
        String configFiles = ((Set)options.getConfigurationFileDirectories().getElements().get()).stream().map(FileSystemLocation::getAsFile).map(File::getAbsolutePath).collect(Collectors.joining(","));
        if (!configFiles.isEmpty()) {
            cliArgs.add("-H:ConfigurationFileDirectories=" + configFiles);
        }
        if (((Boolean)this.getAgentEnabled().get()).booleanValue()) {
            cliArgs.add("--allow-incomplete-classpath");
        }
        if (options.getMainClass().isPresent()) {
            cliArgs.add("-H:Class=" + (String)options.getMainClass().get());
        }
        cliArgs.addAll((Collection)options.getBuildArgs().get());
        return Collections.unmodifiableList(cliArgs);
    }

    private static void appendBooleanOption(List<String> cliArgs, Provider<Boolean> provider, String whenTrue) {
        if (((Boolean)provider.get()).booleanValue()) {
            cliArgs.add(whenTrue);
        }
    }
}

