/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.tasks;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.graalvm.buildtools.gradle.NativeImagePlugin;
import org.graalvm.buildtools.gradle.dsl.NativeImageCompileOptions;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.internal.ConfigurationCacheSupport;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.gradle.internal.NativeImageCommandLineProvider;
import org.graalvm.buildtools.gradle.internal.NativeImageExecutableLocator;
import org.graalvm.buildtools.gradle.tasks.CreateLayerOptions;
import org.graalvm.buildtools.utils.NativeImageUtils;
import org.graalvm.buildtools.utils.SharedConstants;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;

public abstract class BuildNativeImageTask
extends DefaultTask {
    private final Provider<String> graalvmHomeProvider;
    private final NativeImageExecutableLocator.Diagnostics diagnostics;
    private final boolean useColors;

    @Internal
    public abstract Property<NativeImageOptions> getOptions();

    @Nested
    protected NativeImageCompileOptions getCompileOptions() {
        this.getOptions().finalizeValue();
        return ((NativeImageOptions)this.getOptions().get()).asCompileOptions();
    }

    @Option(option="quick-build-native", description="Enables quick build mode")
    public void overrideQuickBuild(boolean quickBuild) {
        ((NativeImageOptions)this.getOptions().get()).getQuickBuild().set((Object)quickBuild);
    }

    @Option(option="debug-native", description="Enables debug mode")
    public void overrideDebugBuild(boolean debug) {
        ((NativeImageOptions)this.getOptions().get()).getDebug().set((Object)debug);
    }

    @Option(option="verbose", description="Enables verbose mode")
    public void overrideVerboseBuild(boolean verbose) {
        ((NativeImageOptions)this.getOptions().get()).getVerbose().set((Object)verbose);
    }

    @Option(option="fallback", description="Enables fallback mode")
    public void overrideFallbackBuild(boolean fallback) {
        ((NativeImageOptions)this.getOptions().get()).getFallback().set((Object)fallback);
    }

    @Option(option="pgo-instrument", description="Enables PGO instrumentation")
    public void overridePgoInstrument(boolean pgo) {
        ((NativeImageOptions)this.getOptions().get()).getPgoInstrument().set((Object)pgo);
    }

    @Option(option="main-class", description="The fully qualified name of the entry point for native image compilation")
    public void overrideMainClass(String mainClass) {
        this.getCompileOptions().getMainClass().set((Object)mainClass);
    }

    @Option(option="build-args", description="Adds arguments for the native-image compilation")
    public void appendBuildArgs(List<String> buildArgs) {
        ((NativeImageOptions)this.getOptions().get()).buildArgs(buildArgs);
    }

    @Option(option="force-build-args", description="Adds arguments for the native-image compilation")
    public void overrideBuildArgs(List<String> buildArgs) {
        ((NativeImageOptions)this.getOptions().get()).getBuildArgs().set(buildArgs);
    }

    @Option(option="rich-output", description="Enables rich output")
    public void overrideRichOutput(boolean richOutput) {
        ((NativeImageOptions)this.getOptions().get()).getRichOutput().set((Object)richOutput);
    }

    @Option(option="image-name", description="The name of the generated native image")
    public void overrideImageName(String imageName) {
        ((NativeImageOptions)this.getOptions().get()).getImageName().set((Object)imageName);
    }

    @Option(option="fatjar", description="Uses a fat jar as an input, instead of exploded classpath")
    public void overrideFatJar(boolean fatJar) {
        ((NativeImageOptions)this.getOptions().get()).getUseFatJar().set((Object)fatJar);
    }

    @Option(option="sysprop-native", description="Adds a system property to the native image build (format key=value)")
    public void addSystemProperty(String property) {
        String[] parts = property.split("=", 2);
        if (parts.length == 2) {
            ((NativeImageOptions)this.getOptions().get()).systemProperty(parts[0], parts[1]);
        } else {
            this.getLogger().warn("Ignoring invalid system property: " + property);
        }
    }

    @Option(option="env-native", description="Adds a environment variable to the native image build (format key=value)")
    public void addEnvVar(String property) {
        String[] parts = property.split("=", 2);
        if (parts.length == 2) {
            ((NativeImageOptions)this.getOptions().get()).getEnvironmentVariables().put((Object)parts[0], (Object)parts[1]);
        } else {
            this.getLogger().warn("Ignoring invalid environment variable: " + property);
        }
    }

    @Option(option="jvm-args-native", description="Adds arguments to the JVM used to build the native image")
    public void appendJvmArgs(List<String> jvmArgs) {
        ((NativeImageOptions)this.getOptions().get()).jvmArgs(jvmArgs);
    }

    @Option(option="force-jvm-args-native", description="Overrides arguments passed to the JVM used to build the native image")
    public void overrideJvmArgs(List<String> jvmArgs) {
        ((NativeImageOptions)this.getOptions().get()).getJvmArgs().set(jvmArgs);
    }

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Internal
    protected abstract DirectoryProperty getWorkingDirectory();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getTestListDirectory();

    @Optional
    @Input
    protected Provider<String> getGraalVMHome() {
        return this.graalvmHomeProvider;
    }

    @Internal
    public Provider<RegularFile> getCreatedLayerFile() {
        return this.getOptions().zip((Provider)this.getOutputDirectory(), (options, dir) -> dir.file(options.getLayers().stream().filter(CreateLayerOptions.class::isInstance).map(cl -> (String)cl.getLayerName().get() + ".nil").findFirst().orElseThrow()));
    }

    @Internal
    public Provider<String> getExecutableShortName() {
        return this.getOptions().flatMap(options -> options.getImageName().zip((Provider)options.getPgoInstrument(), ConfigurationCacheSupport.serializableBiFunctionOf((name, pgo) -> name + (Boolean.TRUE.equals(pgo) ? "-instrumented" : ""))));
    }

    @Internal
    public Provider<String> getExecutableName() {
        return this.getExecutableShortName().map(name -> name + SharedConstants.EXECUTABLE_EXTENSION);
    }

    @Internal
    public Provider<RegularFile> getOutputFile() {
        return this.getOutputDirectory().zip(this.getExecutableName(), Directory::file);
    }

    @Input
    public abstract Property<Boolean> getDisableToolchainDetection();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ObjectFactory getObjects();

    @InputFile
    @Optional
    public abstract RegularFileProperty getClasspathJar();

    @Input
    @Optional
    public abstract Property<Boolean> getUseArgFile();

    public BuildNativeImageTask() {
        DirectoryProperty buildDir = this.getProject().getLayout().getBuildDirectory();
        Provider outputDir = buildDir.dir("native/" + this.getName());
        this.getWorkingDirectory().set(outputDir);
        this.setDescription("Builds a native image.");
        this.setGroup("verification");
        this.getOutputDirectory().convention(outputDir);
        ProviderFactory providers = this.getProject().getProviders();
        this.diagnostics = new NativeImageExecutableLocator.Diagnostics();
        this.graalvmHomeProvider = NativeImageExecutableLocator.graalvmHomeProvider(providers, this.diagnostics);
        this.useColors = "plain".equals(this.getProject().getGradle().getStartParameter().getConsoleOutput());
        this.getDisableToolchainDetection().convention((Object)false);
    }

    private List<String> buildActualCommandLineArgs(int majorJDKVersion) {
        this.getOptions().finalizeValue();
        return new NativeImageCommandLineProvider((Provider<NativeImageOptions>)this.getOptions(), this.getExecutableShortName(), (Provider<String>)this.getProviders().provider(() -> ((Directory)this.getWorkingDirectory().get()).getAsFile().getAbsolutePath()), (Provider<String>)this.getProviders().provider(() -> ((File)this.getOutputDirectory().getAsFile().get()).getAbsolutePath()), (Provider<RegularFile>)this.getClasspathJar(), (Provider<Boolean>)this.getUseArgFile(), (Provider<Integer>)this.getProviders().provider(() -> majorJDKVersion), (Provider<Boolean>)this.getProviders().provider(() -> this.useColors)).asArguments();
    }

    @Internal
    public abstract Property<Object> getService();

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @TaskAction
    public void exec() {
        NativeImageOptions options = (NativeImageOptions)this.getOptions().get();
        GraalVMLogger logger = GraalVMLogger.of(this.getLogger());
        File executablePath = NativeImageExecutableLocator.findNativeImageExecutable((Property<JavaLauncher>)options.getJavaLauncher(), this.getDisableToolchainDetection(), this.getGraalVMHome(), this.getExecOperations(), logger, this.diagnostics);
        String versionString = BuildNativeImageTask.getVersionString(this.getExecOperations(), executablePath);
        if (options.getRequiredVersion().isPresent()) {
            NativeImageUtils.checkVersion((String)((String)options.getRequiredVersion().get()), (String)versionString);
        }
        int majorJDKVersion = NativeImageUtils.getMajorJDKVersion((String)versionString);
        List<String> args = this.buildActualCommandLineArgs(majorJDKVersion);
        if (((Boolean)options.getVerbose().get()).booleanValue()) {
            logger.lifecycle("Args are: " + String.valueOf(args));
        }
        for (String diagnostic : this.diagnostics.getDiagnostics()) {
            logger.lifecycle(diagnostic);
        }
        String executable = executablePath.getAbsolutePath();
        File outputDir = (File)this.getOutputDirectory().getAsFile().get();
        this.getFileSystemOperations().delete(d -> d.delete(new Object[]{outputDir}));
        if (outputDir.isDirectory() || outputDir.mkdirs()) {
            this.getExecOperations().exec(spec -> {
                MapProperty environmentVariables = options.getEnvironmentVariables();
                if (environmentVariables.isPresent() && !((Map)environmentVariables.get()).isEmpty()) {
                    spec.environment((Map)environmentVariables.get());
                }
                spec.setWorkingDir((Object)this.getWorkingDirectory());
                if (this.getTestListDirectory().isPresent()) {
                    NativeImagePlugin.TrackingDirectorySystemPropertyProvider directoryProvider = (NativeImagePlugin.TrackingDirectorySystemPropertyProvider)this.getObjects().newInstance(NativeImagePlugin.TrackingDirectorySystemPropertyProvider.class, new Object[0]);
                    directoryProvider.getDirectory().set((Provider)this.getTestListDirectory());
                    spec.getArgumentProviders().add(directoryProvider);
                }
                spec.args((Iterable)args);
                this.getService().get();
                spec.setExecutable(executable);
            });
            logger.lifecycle("Native Image written to: " + String.valueOf(outputDir));
        }
    }

    public static String getVersionString(ExecOperations execOperations, File executablePath) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ExecResult execResult = execOperations.exec(spec -> {
            spec.setStandardOutput((OutputStream)outputStream);
            spec.args(new Object[]{"--version"});
            spec.setExecutable(executablePath.getAbsolutePath());
        });
        execResult.assertNormalExitValue();
        return new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
    }
}

