/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger log = LoggerFactory.getLogger(IOUtils.class);
    private BufferedReader reader;
    private BufferedWriter writer;

    public IOUtils(String filePath, String mode) {
        try {
            if (mode.equals("read")) {
                this.reader = new BufferedReader(new FileReader(filePath));
            } else if (mode.equals("write")) {
                if (!new File(filePath).delete()) {
                    log.warn("Could not delete {}", (Object)filePath);
                }
                this.writer = new BufferedWriter(new FileWriter(filePath, true));
            }
        }
        catch (IOException e) {
            log.warn("IOUtils[path={}, mode={}] init error", new Object[]{filePath, mode, e});
        }
    }

    public String readLine() {
        String result = null;
        try {
            result = this.reader.readLine();
        }
        catch (IOException e) {
            log.warn("readLine  error", (Throwable)e);
        }
        return result;
    }

    public void writeLine(String line) {
        try {
            this.writer.write(line);
            this.writer.newLine();
        }
        catch (IOException e) {
            log.warn("writeLine  error", (Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            log.warn("close  error", (Throwable)e);
        }
    }

    public static void writeOutputTextLine(String prompt, String text) {
        log.info("{}: {}", (Object)prompt, (Object)text);
    }

    public static String readInputTextLine() {
        return IOUtils.readInputTextLine(null);
    }

    public static String readInputTextLine(String prompt) {
        if (prompt != null) {
            log.info("{}: ", (Object)prompt);
        }
        BufferedReader lineOfText = new BufferedReader(new InputStreamReader(System.in));
        String textLine = null;
        try {
            textLine = lineOfText.readLine();
        }
        catch (IOException e) {
            log.error("Error: ", (Throwable)e);
        }
        return textLine;
    }

    public static File[] listFiles(File dir) {
        return dir.listFiles();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String system(String evaluatedContents, String failedString) {
        Runtime runtime = Runtime.getRuntime();
        if (log.isDebugEnabled()) {
            log.debug("System = {}", (Object)evaluatedContents);
        }
        try {
            Process process = runtime.exec(evaluatedContents);
            try (InputStreamReader reader = new InputStreamReader(process.getInputStream());){
                BufferedReader buffer = new BufferedReader(reader);
                StringBuilder result = new StringBuilder();
                String data = "";
                while ((data = buffer.readLine()) != null) {
                    result.append(data).append("\n");
                }
                if (log.isDebugEnabled()) {
                    log.debug("Result = {}", (Object)failedString);
                }
                String string = result.toString();
                return string;
            }
        }
        catch (Exception e) {
            log.error("system command execution failed", (Throwable)e);
            return failedString;
        }
    }

    public static String evalScript(String engineName, String script) throws Exception {
        if (log.isDebugEnabled()) {
            log.info("Evaluating script = {}", (Object)script);
        }
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName(engineName);
        return "" + engine.eval(script);
    }
}

