/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DomUtils {
    private static final Logger log = LoggerFactory.getLogger(DomUtils.class);

    public static Node parseFile(String fileName) throws Exception {
        File file = new File(fileName);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(file);
        doc.getDocumentElement().normalize();
        return doc.getDocumentElement();
    }

    public static Node parseString(String string) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(string.getBytes("UTF-16"));
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(is);
        doc.getDocumentElement().normalize();
        return doc.getDocumentElement();
    }

    public static String nodeToString(Node node) {
        if (log.isTraceEnabled()) {
            log.trace("nodeToString(node: {})", (Object)node);
        }
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "no");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException e) {
            log.error("nodeToString Transformer Exception", (Throwable)e);
        }
        String result = sw.toString();
        if (log.isTraceEnabled()) {
            log.trace("nodeToString() returning: {}", (Object)result);
        }
        return result;
    }
}

