/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tuple
extends HashMap<String, String> {
    private static final Logger log = LoggerFactory.getLogger(Tuple.class);
    private static AtomicLong index = new AtomicLong();
    private Set<String> visibleVars = new HashSet<String>();
    private String name;

    protected Tuple(Set<String> varSet, Set<String> visibleVars, Tuple tuple) {
        if (visibleVars != null) {
            this.visibleVars.addAll(visibleVars);
        }
        if (varSet == null && tuple != null) {
            for (String key : tuple.keySet()) {
                this.put(key, tuple.get(key));
            }
            this.visibleVars.addAll(tuple.visibleVars);
        }
        if (varSet != null) {
            for (String key : varSet) {
                this.put(key, "unknown");
            }
        }
        this.name = "tuple" + index.incrementAndGet();
    }

    public Tuple(Tuple tuple) {
        this(null, null, tuple);
    }

    public Tuple(Set<String> varSet, Set<String> visibleVars) {
        this(varSet, visibleVars, null);
    }

    public Set<String> getVars() {
        return this.keySet();
    }

    public String getValue(String var) {
        String result = (String)this.get(var);
        if (result == null) {
            return "unknown";
        }
        return result;
    }

    public void bind(String var, String value) {
        if (this.get(var) != null && !((String)this.get(var)).equals("unknown")) {
            log.warn("{} already bound to {}", (Object)var, this.get(var));
        } else {
            this.put(var, value);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !Tuple.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        if (this.visibleVars.size() != tuple.visibleVars.size()) {
            return false;
        }
        for (String x : this.visibleVars) {
            if (!tuple.visibleVars.contains(x)) {
                return false;
            }
            if (this.get(x) == null || ((String)this.get(x)).equals(tuple.get(x))) continue;
            return false;
        }
        return !this.values().contains("unknown") && !tuple.values().contains("unknown");
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (String x : this.visibleVars) {
            result = 31 * result + x.hashCode();
            if (this.get(x) == null) continue;
            result = 31 * result + ((String)this.get(x)).hashCode();
        }
        return result;
    }

    public Set<String> getVisibleVars() {
        return this.visibleVars;
    }

    public String getName() {
        return this.name;
    }

    public void setVisibleVars(Set<String> visibleVars) {
        this.visibleVars = visibleVars;
    }

    public void setName(String name) {
        this.name = name;
    }
}

