/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Properties
extends HashMap<String, String> {
    private static final Logger log = LoggerFactory.getLogger(Properties.class);

    public String get(String key) {
        String result = (String)super.get(key);
        return result != null ? result : "unknown";
    }

    public int getPropertiesFromInputStream(InputStream in) {
        int cnt = 0;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF8"));){
            String strLine;
            while ((strLine = br.readLine()) != null) {
                if (!strLine.contains(":")) continue;
                String property = strLine.substring(0, strLine.indexOf(":"));
                String value = strLine.substring(strLine.indexOf(":") + 1);
                this.put(property, value);
                ++cnt;
            }
        }
        catch (Exception e) {
            log.error("Error:", (Throwable)e);
        }
        return cnt;
    }

    public int getProperties(String filename) {
        int cnt;
        block15: {
            cnt = 0;
            if (log.isTraceEnabled()) {
                log.trace("Get Properties: {}", (Object)filename);
            }
            try {
                File file = new File(filename);
                if (!file.exists()) break block15;
                try (FileInputStream fstream = new FileInputStream(filename);){
                    cnt = this.getPropertiesFromInputStream(fstream);
                }
            }
            catch (Exception e) {
                log.error("Error:", (Throwable)e);
            }
        }
        return cnt;
    }
}

