/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.model;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;
import org.alicebot.ab.AIMLProcessor;
import org.alicebot.ab.Bot;
import org.alicebot.ab.Graphmaster;
import org.alicebot.ab.model.AIMLSet;
import org.alicebot.ab.utils.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Category {
    private static final Logger log = LoggerFactory.getLogger(Category.class);
    private static AtomicLong categoryCnt = new AtomicLong();
    private Bot bot;
    private String pattern;
    private String that;
    private String topic;
    private String template;
    private String filename;
    private int activationCnt;
    private long categoryNumber;
    private AIMLSet matches;
    private String validationMessage = "";
    public static Comparator<Category> ACTIVATION_COMPARATOR = (c1, c2) -> c2.getActivationCnt() - c1.getActivationCnt();
    public static Comparator<Category> PATTERN_COMPARATOR = (c1, c2) -> String.CASE_INSENSITIVE_ORDER.compare(c1.inputThatTopic(), c2.inputThatTopic());
    public static Comparator<Category> CATEGORY_NUMBER_COMPARATOR = Comparator.comparingLong(Category::getCategoryNumber);

    public AIMLSet getMatches(Bot bot) {
        if (this.matches != null) {
            return this.matches;
        }
        return new AIMLSet("No Matches", bot);
    }

    public String getPattern() {
        return this.pattern == null ? "*" : this.pattern;
    }

    public String getThat() {
        return this.that == null ? "*" : this.that;
    }

    public String getTopic() {
        return this.topic == null ? "*" : this.topic;
    }

    public String getTemplate() {
        return this.template == null ? "" : this.template;
    }

    public String getFilename() {
        return this.filename == null ? "unknown_aiml_file.aiml" : this.filename;
    }

    public void incrementActivationCnt() {
        ++this.activationCnt;
    }

    public String inputThatTopic() {
        return Graphmaster.inputThatTopic(this.pattern, this.that, this.topic);
    }

    public void addMatch(String input, Bot bot) {
        if (this.matches == null) {
            String setName = this.inputThatTopic().replace("*", "STAR").replace("_", "UNDERSCORE").replace(" ", "-").replace("<THAT>", "THAT").replace("<TOPIC>", "TOPIC");
            this.matches = new AIMLSet(setName, bot);
        }
        this.matches.add(input);
    }

    public String getTemplateLine() {
        String result = this.template;
        result = result.replaceAll("(\r\n|\n\r|\r|\n)", "\\#Newline");
        result = result.replaceAll(this.bot.getConfiguration().getAimlifSplitChar(), this.bot.getConfiguration().getAimlifSplitCharName());
        return result;
    }

    private static String lineToTemplate(Bot bot, String line) {
        String result = line.replaceAll("\\#Newline", "\n");
        result = result.replaceAll(bot.getConfiguration().getAimlifSplitCharName(), bot.getConfiguration().getAimlifSplitChar());
        return result;
    }

    public static Category IFToCategory(Bot bot, String IF) {
        String[] split = IF.split(bot.getConfiguration().getAimlifSplitChar());
        return new Category(bot, Integer.parseInt(split[0]), split[1], split[2], split[3], Category.lineToTemplate(bot, split[4]), split[5]);
    }

    public static String categoryToIF(Category category) {
        String c = category.bot.getConfiguration().getAimlifSplitChar();
        return category.getActivationCnt() + c + category.getPattern() + c + category.getThat() + c + category.getTopic() + c + category.getTemplateLine() + c + category.getFilename();
    }

    public static String categoryToAIML(Category category) {
        String topicStart = "";
        String topicEnd = "";
        String thatStatement = "";
        String result = "";
        String pattern = category.getPattern();
        if (pattern.contains("<SET>") || pattern.contains("<BOT")) {
            String[] splitPattern = pattern.split(" ");
            StringBuilder rpattern = new StringBuilder();
            for (String w : splitPattern) {
                if (w.startsWith("<SET>") || w.startsWith("<BOT") || w.startsWith("NAME=")) {
                    w = w.toLowerCase();
                }
                rpattern.append(" ").append(w);
            }
            pattern = rpattern.toString().trim();
        }
        String NL = "\n";
        try {
            if (!category.getTopic().equals("*")) {
                topicStart = "<topic name=\"" + category.getTopic() + "\">" + NL;
                topicEnd = "</topic>" + NL;
            }
            if (!category.getThat().equals("*")) {
                thatStatement = "<that>" + category.getThat() + "</that>";
            }
            result = topicStart + "<category><pattern>" + pattern + "</pattern>" + thatStatement + NL + "<template>" + category.getTemplate() + "</template>" + NL + "</category>" + topicEnd;
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return result;
    }

    public boolean validPatternForm(String pattern) {
        if (pattern.length() < 1) {
            this.validationMessage = this.validationMessage + "Zero length. ";
            return false;
        }
        return true;
    }

    public boolean validate() {
        this.validationMessage = "";
        if (!this.validPatternForm(this.pattern)) {
            this.validationMessage = this.validationMessage + "Badly formatted <pattern>";
            return false;
        }
        if (!this.validPatternForm(this.that)) {
            this.validationMessage = this.validationMessage + "Badly formatted <that>";
            return false;
        }
        if (!this.validPatternForm(this.topic)) {
            this.validationMessage = this.validationMessage + "Badly formatted <topic>";
            return false;
        }
        if (!AIMLProcessor.validTemplate(this.template)) {
            this.validationMessage = this.validationMessage + "Badly formatted <template>";
            return false;
        }
        if (!this.filename.endsWith(".aiml")) {
            this.validationMessage = this.validationMessage + "Filename suffix should be .aiml";
            return false;
        }
        return true;
    }

    public Category(Bot bot, int activationCnt, String pattern, String that, String topic, String template, String filename) {
        this.bot = bot;
        if (bot != null && bot.getConfiguration().isFixExcelCsv()) {
            pattern = Utilities.fixCSV(pattern);
            that = Utilities.fixCSV(that);
            topic = Utilities.fixCSV(topic);
            template = Utilities.fixCSV(template);
            filename = Utilities.fixCSV(filename);
        }
        this.pattern = pattern.trim().toUpperCase();
        this.that = that.trim().toUpperCase();
        this.topic = topic.trim().toUpperCase();
        this.template = template.replace("& ", " and ");
        this.filename = filename;
        this.activationCnt = activationCnt;
        this.matches = null;
        this.categoryNumber = categoryCnt.incrementAndGet();
    }

    public Category(Bot bot, int activationCnt, String patternThatTopic, String template, String filename) {
        this(bot, activationCnt, patternThatTopic.substring(0, patternThatTopic.indexOf("<THAT>")), patternThatTopic.substring(patternThatTopic.indexOf("<THAT>") + "<THAT>".length(), patternThatTopic.indexOf("<TOPIC>")), patternThatTopic.substring(patternThatTopic.indexOf("<TOPIC>") + "<TOPIC>".length(), patternThatTopic.length()), template, filename);
    }

    public void setBot(Bot bot) {
        this.bot = bot;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setThat(String that) {
        this.that = that;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setActivationCnt(int activationCnt) {
        this.activationCnt = activationCnt;
    }

    public void setCategoryNumber(long categoryNumber) {
        this.categoryNumber = categoryNumber;
    }

    public void setMatches(AIMLSet matches) {
        this.matches = matches;
    }

    public void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }

    public Bot getBot() {
        return this.bot;
    }

    public int getActivationCnt() {
        return this.activationCnt;
    }

    public long getCategoryNumber() {
        return this.categoryNumber;
    }

    public AIMLSet getMatches() {
        return this.matches;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }
}

