/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.alicebot.ab.Bot;
import org.alicebot.ab.Sraix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIMLSet
extends HashSet<String> {
    private static final Logger log = LoggerFactory.getLogger(AIMLSet.class);
    private static final Pattern DIGITS_PATTERN = Pattern.compile("[0-9]+");
    private String setName;
    private int maxLength = 1;
    private String host;
    private String botId;
    private boolean isExternal = false;
    private Bot bot;
    private HashSet<String> inCache = new HashSet();
    private HashSet<String> outCache = new HashSet();

    public AIMLSet(String name, Bot bot) {
        this.bot = bot;
        this.setName = name.toLowerCase();
        if (this.setName.equals("number")) {
            this.maxLength = 1;
        }
    }

    public boolean contains(String s) {
        if (this.isExternal && this.bot.getConfiguration().isEnableExternalSets()) {
            if (this.inCache.contains(s)) {
                return true;
            }
            if (this.outCache.contains(s)) {
                return false;
            }
            String[] split = s.split(" ");
            if (split.length > this.maxLength) {
                return false;
            }
            String query = "ISA" + this.setName.toUpperCase() + " " + s;
            String response = Sraix.sraix(null, this.bot, query, "false", null, this.host, this.botId, null, "0");
            if ("true".equals(response)) {
                this.inCache.add(s);
                return true;
            }
            this.outCache.add(s);
            return false;
        }
        if (this.setName.equals("number")) {
            return DIGITS_PATTERN.matcher(s).matches();
        }
        return super.contains(s);
    }

    public void writeAIMLSet() {
        log.info("Writing AIML Set {}", (Object)this.setName);
        try (FileWriter stream = new FileWriter(this.bot.getSetsPath() + "/" + this.setName + ".txt");
             BufferedWriter out = new BufferedWriter(stream);){
            for (String p : this) {
                out.write(p.trim());
                out.newLine();
            }
        }
        catch (Exception e) {
            log.error("Write error", (Throwable)e);
        }
    }

    private int readAIMLSetFromInputStream(InputStream in, Bot bot) {
        int cnt = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String strLine;
            while ((strLine = reader.readLine()) != null && strLine.length() > 0) {
                String[] splitLine;
                ++cnt;
                if (strLine.startsWith("external")) {
                    splitLine = strLine.split(":");
                    if (splitLine.length < 4) continue;
                    this.host = splitLine[1];
                    this.botId = splitLine[2];
                    this.maxLength = Integer.parseInt(splitLine[3]);
                    this.isExternal = true;
                    log.info("Created external set at {} {}", (Object)this.host, (Object)this.botId);
                    continue;
                }
                splitLine = (strLine = strLine.toUpperCase().trim()).split(" ");
                int length = splitLine.length;
                if (length > this.maxLength) {
                    this.maxLength = length;
                }
                this.add(strLine.trim());
            }
        }
        catch (Exception e) {
            log.error("Read error", (Throwable)e);
        }
        return cnt;
    }

    public int readAIMLSet(Bot bot) {
        int count;
        block16: {
            count = 0;
            String fileName = bot.getSetsPath() + "/" + this.setName + ".txt";
            if (log.isTraceEnabled()) {
                log.trace("Reading AIML Set {}", (Object)fileName);
            }
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    try (FileInputStream fstream = new FileInputStream(fileName);){
                        count = this.readAIMLSetFromInputStream(fstream, bot);
                        break block16;
                    }
                }
                log.warn("{} not found", (Object)fileName);
            }
            catch (Exception e) {
                log.error("Read error", (Throwable)e);
            }
        }
        return count;
    }

    public int getMaxLength() {
        return this.maxLength;
    }
}

