/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.etc;

import org.alicebot.ab.Bot;
import org.alicebot.ab.Chat;
import org.alicebot.ab.etc.AB;
import org.alicebot.ab.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAB {
    private static final Logger log = LoggerFactory.getLogger(TestAB.class);
    public static String sample_file = "sample.random.txt";

    public static void testChat(Bot bot, boolean doWrites) {
        Chat chatSession = new Chat(bot, doWrites);
        bot.getBrain().nodeStats();
        String textLine = "";
        block10: while (true) {
            if ((textLine = IOUtils.readInputTextLine("Human")) == null || textLine.length() < 1) {
                textLine = "NORESP";
            }
            switch (textLine) {
                case "q": {
                    System.exit(0);
                    continue block10;
                }
                case "wq": {
                    bot.writeQuit();
                    System.exit(0);
                    continue block10;
                }
                case "ab": {
                    TestAB.testAB(bot, sample_file);
                    continue block10;
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("STATE={}:THAT={}:TOPIC={}", new Object[]{textLine, chatSession.getThatHistory().get(0).get(0), chatSession.getPredicates().get("topic")});
            }
            String response = chatSession.multisentenceRespond(textLine);
            while (response.contains("&lt;")) {
                response = response.replace("&lt;", "<");
            }
            while (response.contains("&gt;")) {
                response = response.replace("&gt;", ">");
            }
            IOUtils.writeOutputTextLine("Robot", response);
        }
    }

    public static void runTests(Bot bot) {
        bot.getConfiguration().setQaTestMode(true);
        Chat chatSession = new Chat(bot, false);
        bot.getBrain().nodeStats();
        IOUtils testInput = new IOUtils(bot.getRootPath() + "/data/lognormal-500.txt", "read");
        IOUtils testOutput = new IOUtils(bot.getRootPath() + "/data/lognormal-500-out.txt", "write");
        String textLine = testInput.readLine();
        while (textLine != null) {
            if (textLine.length() < 1) {
                textLine = "NORESP";
            }
            if (textLine.equals("q")) {
                System.exit(0);
            } else if (textLine.equals("wq")) {
                bot.writeQuit();
                System.exit(0);
            } else if (textLine.equals("ab")) {
                TestAB.testAB(bot, sample_file);
            } else if (textLine.equals("NORESP")) {
                testOutput.writeLine("");
            } else if (textLine.startsWith("#")) {
                testOutput.writeLine(textLine);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace("STATE={}:THAT={}:TOPIC={}", new Object[]{textLine, chatSession.getThatHistory().get(0).get(0), chatSession.getPredicates().get("topic")});
                }
                String response = chatSession.multisentenceRespond(textLine);
                while (response.contains("&lt;")) {
                    response = response.replace("&lt;", "<");
                }
                while (response.contains("&gt;")) {
                    response = response.replace("&gt;", ">");
                }
                testOutput.writeLine("Robot: " + response);
            }
            textLine = testInput.readLine();
        }
        testInput.close();
        testOutput.close();
    }

    public static void testAB(Bot bot, String sampleFile) {
        AB ab = new AB(bot, sampleFile);
        ab.ab();
        log.info("Begin Pattern Suggestor Terminal Interaction");
        ab.terminalInteraction();
    }
}

