/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.etc;

import org.alicebot.ab.Bot;
import org.alicebot.ab.configuration.BotConfiguration;
import org.alicebot.ab.etc.AB;
import org.alicebot.ab.etc.TestAB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App {
    private static final Logger log = LoggerFactory.getLogger(App.class);

    public static void main(String[] args) {
        BotConfiguration.BotConfigurationBuilder builder = BotConfiguration.builder().name("alice2").action("chat").jpTokenize(false).graphShortCuts(true);
        for (String s : args) {
            String[] splitArg = s.split("=");
            if (splitArg.length < 2) continue;
            String option = splitArg[0];
            String value = splitArg[1];
            if (option.equals("bot")) {
                builder.name(value);
            }
            if (option.equals("action")) {
                builder.action(value);
            }
            if (!option.equals("morph")) continue;
            builder.jpTokenize(value.equals("true"));
        }
        BotConfiguration configuration = builder.build();
        log.info(configuration.getProgramName());
        Bot bot = new Bot(configuration);
        if (bot.getBrain().getCategories().size() < AB.brain_print_size) {
            bot.getBrain().printGraph();
        }
        log.debug("Action = '{}'", (Object)configuration.getAction());
        switch (configuration.getAction()) {
            case "chat": 
            case "chat-app": {
                boolean doWrites = !configuration.getAction().equals("chat-app");
                TestAB.testChat(bot, doWrites);
                break;
            }
            case "ab": {
                TestAB.testAB(bot, TestAB.sample_file);
                break;
            }
            case "aiml2csv": {
                bot.writeAIMLIFFiles();
                break;
            }
            case "csv2aiml": {
                bot.writeAIMLFiles();
                break;
            }
            case "abwq": {
                AB ab = new AB(bot, TestAB.sample_file);
                ab.abwq();
                break;
            }
            case "test": {
                TestAB.runTests(bot);
                break;
            }
            case "shadow": {
                bot.shadowChecker();
                break;
            }
            default: {
                log.error("Unrecognized action {}", (Object)configuration.getAction());
            }
        }
    }
}

