/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alicebot.ab.Bot;
import org.alicebot.ab.NodemapperOperator;
import org.alicebot.ab.model.AIMLSet;
import org.alicebot.ab.model.Category;
import org.alicebot.ab.model.Nodemapper;
import org.alicebot.ab.model.Path;
import org.alicebot.ab.model.StarBindings;
import org.alicebot.ab.utils.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graphmaster {
    private static final Logger log = LoggerFactory.getLogger(Graphmaster.class);
    private static final String botPropRegex = "<bot name=\"(.*?)\"/>";
    private static final Pattern botPropPattern = Pattern.compile("<bot name=\"(.*?)\"/>", 2);
    private Bot bot;
    private String name;
    private final Nodemapper root;
    private int matchCount = 0;
    private int upgradeCnt = 0;
    private Set<String> vocabulary;
    private String resultNote = "";
    private int categoryCnt = 0;
    private int leafCnt;
    private int nodeCnt;
    private long nodeSize;
    private int singletonCnt;
    private int shortCutCnt;
    private int naryCnt;

    public Graphmaster(Bot bot) {
        this(bot, "brain");
    }

    public Graphmaster(Bot bot, String name) {
        this.root = new Nodemapper(bot.getConfiguration().getMaxGraphHeight());
        this.bot = bot;
        this.name = name;
        this.vocabulary = new HashSet<String>();
    }

    public static String inputThatTopic(String input, String that, String topic) {
        return input.trim() + " <THAT> " + that.trim() + " <TOPIC> " + topic.trim();
    }

    public String replaceBotProperties(String pattern) {
        if (pattern.contains("<B")) {
            Matcher matcher = botPropPattern.matcher(pattern);
            while (matcher.find()) {
                String propName = matcher.group(1).toLowerCase();
                String property = this.bot.getProperties().get(propName).toUpperCase();
                pattern = pattern.replaceFirst("(?i)<bot name=\"(.*?)\"/>", property);
            }
        }
        return pattern;
    }

    public void addCategory(Category category) {
        String inputThatTopic = Graphmaster.inputThatTopic(category.getPattern(), category.getThat(), category.getTopic());
        inputThatTopic = this.replaceBotProperties(inputThatTopic);
        Path p = Path.sentenceToPath(inputThatTopic);
        this.addPath(p, category);
        ++this.categoryCnt;
    }

    private boolean thatStarTopicStar(Path path) {
        String tail = Path.pathToSentence(path).trim();
        return tail.equals("<THAT> * <TOPIC> *");
    }

    private void addSets(String type, Bot bot, Nodemapper node, String filename) {
        String setName = Utilities.tagTrim(type, "SET").toLowerCase();
        if (bot.getSetMap().containsKey(setName)) {
            if (node.getSets() == null) {
                node.setSets(new ArrayList<String>());
            }
            if (!node.getSets().contains(setName)) {
                node.getSets().add(setName);
            }
        } else {
            log.warn("No AIML Set found for <set>{}</set> in {} {}", new Object[]{setName, bot.getName(), filename});
        }
    }

    private void addPath(Path path, Category category) {
        this.addPath(this.root, path, category);
    }

    private void addPath(Nodemapper node, Path path, Category category) {
        if (path == null) {
            node.setCategory(category);
            node.setHeight(0);
        } else if (this.bot.getConfiguration().isGraphShortCuts() && this.thatStarTopicStar(path)) {
            node.setCategory(category);
            node.setHeight(Math.min(4, node.getHeight()));
            node.setShortCut(true);
        } else if (NodemapperOperator.containsKey(node, path.getWord())) {
            if (path.getWord().startsWith("<SET>")) {
                this.addSets(path.getWord(), this.bot, node, category.getFilename());
            }
            Nodemapper nextNode = NodemapperOperator.get(node, path.getWord());
            this.addPath(nextNode, path.getNext(), category);
            int offset = 1;
            if (path.getWord().equals("#") || path.getWord().equals("^")) {
                offset = 0;
            }
            node.setHeight(Math.min(offset + (nextNode != null ? nextNode.getHeight() : 0), node.getHeight()));
        } else {
            Nodemapper nextNode = new Nodemapper(this.bot.getConfiguration().getMaxGraphHeight());
            if (path.getWord().startsWith("<SET>")) {
                this.addSets(path.getWord(), this.bot, node, category.getFilename());
            }
            if (node.getKey() != null) {
                NodemapperOperator.upgrade(node);
                ++this.upgradeCnt;
            }
            NodemapperOperator.put(node, path.getWord(), nextNode);
            this.addPath(nextNode, path.getNext(), category);
            int offset = 1;
            if (path.getWord().equals("#") || path.getWord().equals("^")) {
                offset = 0;
            }
            node.setHeight(Math.min(offset + nextNode.getHeight(), node.getHeight()));
        }
    }

    public boolean existsCategory(Category c) {
        return this.findNode(c) != null;
    }

    public Nodemapper findNode(Category c) {
        return this.findNode(c.getPattern(), c.getThat(), c.getTopic());
    }

    public Nodemapper findNode(String input, String that, String topic) {
        Nodemapper result = this.findNode(this.root, Path.sentenceToPath(Graphmaster.inputThatTopic(input, that, topic)));
        if (log.isTraceEnabled()) {
            log.trace("findNode " + Graphmaster.inputThatTopic(input, that, topic) + " " + result);
        }
        return result;
    }

    private Nodemapper findNode(Nodemapper node, Path path) {
        if (path == null && node != null) {
            if (log.isTraceEnabled()) {
                log.trace("findNode: path is null, returning node {}", (Object)node.getCategory().inputThatTopic());
            }
            return node;
        }
        if (node != null && Path.pathToSentence(path).trim().equals("<THAT> * <TOPIC> *") && node.isShortCut() && path.getWord().equals("<THAT>")) {
            if (log.isTraceEnabled()) {
                log.trace("findNode: shortcut, returning {}", (Object)node.getCategory().inputThatTopic());
            }
            return node;
        }
        if (path != null && NodemapperOperator.containsKey(node, path.getWord())) {
            if (log.isTraceEnabled()) {
                log.trace("findNode: node contains {}", (Object)path.getWord());
            }
            Nodemapper nextNode = NodemapperOperator.get(node, path.getWord().toUpperCase());
            return this.findNode(nextNode, path.getNext());
        }
        if (log.isTraceEnabled()) {
            log.trace("findNode: returning null");
        }
        return null;
    }

    public final Nodemapper match(String input, String that, String topic) {
        Nodemapper n;
        try {
            String inputThatTopic = Graphmaster.inputThatTopic(input, that, topic);
            Path p = Path.sentenceToPath(inputThatTopic);
            n = this.match(p, inputThatTopic);
            if (log.isTraceEnabled()) {
                if (n != null) {
                    log.trace("Matched: {} {}", (Object)n.getCategory().inputThatTopic(), (Object)n.getCategory().getFilename());
                } else {
                    log.trace("No match.");
                }
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            n = null;
        }
        return n;
    }

    private Nodemapper match(Path path, String inputThatTopic) {
        try {
            int maxStars = this.bot.getConfiguration().getMaxStars();
            String[] inputStars = new String[maxStars];
            String[] thatStars = new String[maxStars];
            String[] topicStars = new String[maxStars];
            String starState = "inputStar";
            String matchTrace = "";
            Nodemapper n = this.match(path, this.root, inputThatTopic, starState, 0, inputStars, thatStars, topicStars, matchTrace);
            if (n != null) {
                int i;
                StarBindings sb = new StarBindings();
                for (i = 0; inputStars[i] != null && i < maxStars; ++i) {
                    sb.getInputStars().add(inputStars[i]);
                }
                for (i = 0; thatStars[i] != null && i < maxStars; ++i) {
                    sb.getThatStars().add(thatStars[i]);
                }
                for (i = 0; topicStars[i] != null && i < maxStars; ++i) {
                    sb.getTopicStars().add(topicStars[i]);
                }
                n.setStarBindings(sb);
            }
            if (n != null) {
                n.getCategory().addMatch(inputThatTopic, this.bot);
            }
            return n;
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return null;
        }
    }

    private Nodemapper match(Path path, Nodemapper node, String inputThatTopic, String starState, int starIndex, String[] inputStars, String[] thatStars, String[] topicStars, String matchTrace) {
        ++this.matchCount;
        Nodemapper matchedNode = this.nullMatch(path, node, matchTrace);
        if (matchedNode != null) {
            return matchedNode;
        }
        if (path.getLength() < node.getHeight()) {
            return null;
        }
        matchedNode = this.dollarMatch(path, node, inputThatTopic, starState, starIndex, inputStars, thatStars, topicStars, matchTrace);
        if (matchedNode != null) {
            return matchedNode;
        }
        matchedNode = this.sharpMatch(path, node, inputThatTopic, starState, starIndex, inputStars, thatStars, topicStars, matchTrace);
        if (matchedNode != null) {
            return matchedNode;
        }
        matchedNode = this.underMatch(path, node, inputThatTopic, starState, starIndex, inputStars, thatStars, topicStars, matchTrace);
        if (matchedNode != null) {
            return matchedNode;
        }
        matchedNode = this.wordMatch(path, node, inputThatTopic, starState, starIndex, inputStars, thatStars, topicStars, matchTrace);
        if (matchedNode != null) {
            return matchedNode;
        }
        matchedNode = this.setMatch(path, node, inputThatTopic, starState, starIndex, inputStars, thatStars, topicStars, matchTrace);
        if (matchedNode != null) {
            return matchedNode;
        }
        matchedNode = this.shortCutMatch(path, node, inputThatTopic, starState, starIndex, inputStars, thatStars, topicStars, matchTrace);
        if (matchedNode != null) {
            return matchedNode;
        }
        matchedNode = this.caretMatch(path, node, inputThatTopic, starState, starIndex, inputStars, thatStars, topicStars, matchTrace);
        if (matchedNode != null) {
            return matchedNode;
        }
        matchedNode = this.starMatch(path, node, inputThatTopic, starState, starIndex, inputStars, thatStars, topicStars, matchTrace);
        if (matchedNode != null) {
            return matchedNode;
        }
        return null;
    }

    private void fail(String mode, String trace) {
        if (log.isTraceEnabled()) {
            log.trace("Match failed ({}) {}", (Object)mode, (Object)trace);
        }
    }

    private Nodemapper nullMatch(Path path, Nodemapper node, String matchTrace) {
        if (path == null && node != null && NodemapperOperator.isLeaf(node) && node.getCategory() != null) {
            return node;
        }
        this.fail("null", matchTrace);
        return null;
    }

    private Nodemapper shortCutMatch(Path path, Nodemapper node, String inputThatTopic, String starState, int starIndex, String[] inputStars, String[] thatStars, String[] topicStars, String matchTrace) {
        if (node != null && node.isShortCut() && path.getWord().equals("<THAT>") && node.getCategory() != null) {
            String tail = Path.pathToSentence(path).trim();
            String that = tail.substring(tail.indexOf("<THAT>") + "<THAT>".length(), tail.indexOf("<TOPIC>")).trim();
            String topic = tail.substring(tail.indexOf("<TOPIC>") + "<TOPIC>".length(), tail.length()).trim();
            thatStars[0] = that;
            topicStars[0] = topic;
            return node;
        }
        this.fail("shortCut", matchTrace);
        return null;
    }

    private Nodemapper wordMatch(Path path, Nodemapper node, String inputThatTopic, String starState, int starIndex, String[] inputStars, String[] thatStars, String[] topicStars, String matchTrace) {
        try {
            Nodemapper matchedNode;
            String uword = path.getWord().toUpperCase();
            if (uword.equals("<THAT>")) {
                starIndex = 0;
                starState = "thatStar";
            } else if (uword.equals("<TOPIC>")) {
                starIndex = 0;
                starState = "topicStar";
            }
            matchTrace = matchTrace + "[" + uword + "," + uword + "]";
            if (NodemapperOperator.containsKey(node, uword) && (matchedNode = this.match(path.getNext(), NodemapperOperator.get(node, uword), inputThatTopic, starState, starIndex, inputStars, thatStars, topicStars, matchTrace)) != null) {
                return matchedNode;
            }
            this.fail("word", matchTrace);
            return null;
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return null;
        }
    }

    private Nodemapper dollarMatch(Path path, Nodemapper node, String inputThatTopic, String starState, int starIndex, String[] inputStars, String[] thatStars, String[] topicStars, String matchTrace) {
        Nodemapper matchedNode;
        String uword = "$" + path.getWord().toUpperCase();
        if (NodemapperOperator.containsKey(node, uword) && (matchedNode = this.match(path.getNext(), NodemapperOperator.get(node, uword), inputThatTopic, starState, starIndex, inputStars, thatStars, topicStars, matchTrace)) != null) {
            return matchedNode;
        }
        this.fail("dollar", matchTrace);
        return null;
    }

    private Nodemapper starMatch(Path path, Nodemapper node, String input, String starState, int starIndex, String[] inputStars, String[] thatStars, String[] topicStars, String matchTrace) {
        return this.wildMatch(path, node, input, starState, starIndex, inputStars, thatStars, topicStars, "*", matchTrace);
    }

    private Nodemapper underMatch(Path path, Nodemapper node, String input, String starState, int starIndex, String[] inputStars, String[] thatStars, String[] topicStars, String matchTrace) {
        return this.wildMatch(path, node, input, starState, starIndex, inputStars, thatStars, topicStars, "_", matchTrace);
    }

    private Nodemapper caretMatch(Path path, Nodemapper node, String input, String starState, int starIndex, String[] inputStars, String[] thatStars, String[] topicStars, String matchTrace) {
        Nodemapper matchedNode = this.zeroMatch(path, node, input, starState, starIndex, inputStars, thatStars, topicStars, "^", matchTrace);
        if (matchedNode != null) {
            return matchedNode;
        }
        return this.wildMatch(path, node, input, starState, starIndex, inputStars, thatStars, topicStars, "^", matchTrace);
    }

    private Nodemapper sharpMatch(Path path, Nodemapper node, String input, String starState, int starIndex, String[] inputStars, String[] thatStars, String[] topicStars, String matchTrace) {
        Nodemapper matchedNode = this.zeroMatch(path, node, input, starState, starIndex, inputStars, thatStars, topicStars, "#", matchTrace);
        if (matchedNode != null) {
            return matchedNode;
        }
        return this.wildMatch(path, node, input, starState, starIndex, inputStars, thatStars, topicStars, "#", matchTrace);
    }

    private Nodemapper zeroMatch(Path path, Nodemapper node, String input, String starState, int starIndex, String[] inputStars, String[] thatStars, String[] topicStars, String wildcard, String matchTrace) {
        matchTrace = matchTrace + "[" + wildcard + ",]";
        if (path != null && NodemapperOperator.containsKey(node, wildcard)) {
            this.setStars(this.bot.getProperties().get("nullstar"), starIndex, starState, inputStars, thatStars, topicStars);
            Nodemapper nextNode = NodemapperOperator.get(node, wildcard);
            return this.match(path, nextNode, input, starState, starIndex + 1, inputStars, thatStars, topicStars, matchTrace);
        }
        this.fail("zero " + wildcard, matchTrace);
        return null;
    }

    private Nodemapper wildMatch(Path path, Nodemapper node, String input, String starState, int starIndex, String[] inputStars, String[] thatStars, String[] topicStars, String wildcard, String matchTrace) {
        if ("<THAT>".equals(path.getWord()) || "<TOPIC>".equals(path.getWord())) {
            this.fail("wild1 " + wildcard, matchTrace);
            return null;
        }
        try {
            if (NodemapperOperator.containsKey(node, wildcard)) {
                matchTrace = matchTrace + "[" + wildcard + "," + path.getWord() + "]";
                Nodemapper nextNode = NodemapperOperator.get(node, wildcard);
                if (nextNode != null) {
                    String currentWord = path.getWord();
                    String starWords = currentWord + " ";
                    Path pathStart = path.getNext();
                    if (NodemapperOperator.isLeaf(nextNode) && !nextNode.isShortCut()) {
                        Nodemapper matchedNode = nextNode;
                        starWords = Path.pathToSentence(path);
                        this.setStars(starWords, starIndex, starState, inputStars, thatStars, topicStars);
                        return matchedNode;
                    }
                    for (path = pathStart; path != null && !currentWord.equals("<THAT>") && !currentWord.equals("<TOPIC>"); path = path.getNext()) {
                        Nodemapper matchedNode = this.match(path, nextNode, input, starState, starIndex + 1, inputStars, thatStars, topicStars, matchTrace = matchTrace + "[" + wildcard + "," + path.getWord() + "]");
                        if (matchedNode != null) {
                            this.setStars(starWords, starIndex, starState, inputStars, thatStars, topicStars);
                            return matchedNode;
                        }
                        currentWord = path.getWord();
                        starWords = starWords + currentWord + " ";
                    }
                    this.fail("wild2 " + wildcard, matchTrace);
                    return null;
                }
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        this.fail("wild3 " + wildcard, matchTrace);
        return null;
    }

    private Nodemapper setMatch(Path path, Nodemapper node, String input, String starState, int starIndex, String[] inputStars, String[] thatStars, String[] topicStars, String matchTrace) {
        if (log.isDebugEnabled()) {
            log.debug("Graphmaster.setMatch(path: {}, node: {}, input: {}, starState: {}, starIndex: {}, inputStars, thatStars, topicStars, matchTrace: {})", new Object[]{path, node, input, starState, starIndex, matchTrace});
        }
        if (node.getSets() == null || path.getWord().equals("<THAT>") || path.getWord().equals("<TOPIC>")) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("in Graphmaster.setMatch, setMatch sets = {}", node.getSets());
        }
        for (String setName : node.getSets()) {
            if (log.isDebugEnabled()) {
                log.debug("in Graphmaster.setMatch, setMatch trying type {}", (Object)setName);
            }
            Nodemapper nextNode = NodemapperOperator.get(node, "<SET>" + setName.toUpperCase() + "</SET>");
            AIMLSet aimlSet = this.bot.getSetMap().get(setName);
            Nodemapper bestMatchedNode = null;
            String currentWord = path.getWord();
            String starWords = currentWord + " ";
            int length = 1;
            matchTrace = matchTrace + "[<set>" + setName + "</set>," + path.getWord() + "]";
            if (log.isDebugEnabled()) {
                log.debug("in Graphmaster.setMatch, setMatch starWords =\"{}\"", (Object)starWords);
            }
            for (Path qath = path.getNext(); qath != null && !currentWord.equals("<THAT>") && !currentWord.equals("<TOPIC>") && length <= aimlSet.getMaxLength(); ++length, qath = qath.getNext()) {
                Nodemapper matchedNode;
                if (log.isDebugEnabled()) {
                    log.debug("in Graphmaster.setMatch, qath.word = {}", (Object)qath.getWord());
                }
                String phrase = this.bot.getPreProcessor().normalize(starWords.trim()).toUpperCase();
                if (log.isDebugEnabled()) {
                    log.debug("in Graphmaster.setMatch, setMatch trying \"{}\" in {}", (Object)phrase, (Object)setName);
                }
                if (aimlSet.contains(phrase) && (matchedNode = this.match(qath, nextNode, input, starState, starIndex + 1, inputStars, thatStars, topicStars, matchTrace)) != null) {
                    this.setStars(starWords, starIndex, starState, inputStars, thatStars, topicStars);
                    if (log.isDebugEnabled()) {
                        log.debug("in Graphmaster.setMatch, setMatch found {} in {}", (Object)phrase, (Object)setName);
                    }
                    bestMatchedNode = matchedNode;
                }
                currentWord = qath.getWord();
                starWords = starWords + currentWord + " ";
            }
            if (bestMatchedNode == null) continue;
            return bestMatchedNode;
        }
        this.fail("set", matchTrace);
        return null;
    }

    private void setStars(String starWords, int starIndex, String starState, String[] inputStars, String[] thatStars, String[] topicStars) {
        if (starIndex < this.bot.getConfiguration().getMaxStars()) {
            starWords = starWords.trim();
            switch (starState) {
                case "inputStar": {
                    inputStars[starIndex] = starWords;
                    break;
                }
                case "thatStar": {
                    thatStars[starIndex] = starWords;
                    break;
                }
                case "topicStar": {
                    topicStars[starIndex] = starWords;
                }
            }
        }
    }

    public void printGraph() {
        this.printGraph(this.root, "");
    }

    private void printGraph(Nodemapper node, String partial) {
        if (node == null) {
            log.info("Null graph");
        } else {
            if (NodemapperOperator.isLeaf(node) || node.isShortCut()) {
                String template = node.getCategory().getTemplateLine();
                template = template.substring(0, Math.min(16, template.length()));
                if (node.isShortCut()) {
                    log.info("{}({}[{}])--<THAT>-->X(1)--*-->X(1)--<TOPIC>-->X(1)--*-->{}...", new Object[]{partial, NodemapperOperator.size(node), node.getHeight(), template});
                } else {
                    log.info("{}({}[{}]) {}...", new Object[]{partial, NodemapperOperator.size(node), node.getHeight(), template});
                }
            }
            for (String key : NodemapperOperator.keySet(node)) {
                this.printGraph(NodemapperOperator.get(node, key), partial + "(" + NodemapperOperator.size(node) + "[" + node.getHeight() + "])--" + key + "-->");
            }
        }
    }

    public ArrayList<Category> getCategories() {
        ArrayList<Category> categories = new ArrayList<Category>();
        this.getCategories(this.root, categories);
        return categories;
    }

    private void getCategories(Nodemapper node, ArrayList<Category> categories) {
        if (node != null) {
            if ((NodemapperOperator.isLeaf(node) || node.isShortCut()) && node.getCategory() != null) {
                categories.add(node.getCategory());
            }
            for (String key : NodemapperOperator.keySet(node)) {
                this.getCategories(NodemapperOperator.get(node, key), categories);
            }
        }
    }

    public void nodeStats() {
        this.leafCnt = 0;
        this.nodeCnt = 0;
        this.nodeSize = 0L;
        this.singletonCnt = 0;
        this.shortCutCnt = 0;
        this.naryCnt = 0;
        this.nodeStatsGraph(this.root);
        this.resultNote = this.bot.getName() + " (" + this.name + "): " + this.getCategories().size() + " categories " + this.nodeCnt + " nodes " + this.singletonCnt + " singletons " + this.leafCnt + " leaves " + this.shortCutCnt + " shortcuts " + this.naryCnt + " n-ary " + this.nodeSize + " branches " + (float)this.nodeSize / (float)this.nodeCnt + " average branching ";
        if (log.isTraceEnabled()) {
            log.trace(this.resultNote);
        }
    }

    private void nodeStatsGraph(Nodemapper node) {
        if (node != null) {
            ++this.nodeCnt;
            this.nodeSize += (long)NodemapperOperator.size(node);
            if (NodemapperOperator.size(node) == 1) {
                ++this.singletonCnt;
            }
            if (NodemapperOperator.isLeaf(node) && !node.isShortCut()) {
                ++this.leafCnt;
            }
            if (NodemapperOperator.size(node) > 1) {
                ++this.naryCnt;
            }
            if (node.isShortCut()) {
                ++this.shortCutCnt;
            }
            for (String key : NodemapperOperator.keySet(node)) {
                this.nodeStatsGraph(NodemapperOperator.get(node, key));
            }
        }
    }

    public Set<String> getVocabulary() {
        this.vocabulary = new HashSet<String>();
        this.getBrainVocabulary(this.root);
        for (String set : this.bot.getSetMap().keySet()) {
            this.vocabulary.addAll(this.bot.getSetMap().get(set));
        }
        return this.vocabulary;
    }

    public void getBrainVocabulary(Nodemapper node) {
        if (node != null) {
            for (String key : NodemapperOperator.keySet(node)) {
                this.vocabulary.add(key);
                this.getBrainVocabulary(NodemapperOperator.get(node, key));
            }
        }
    }

    public Bot getBot() {
        return this.bot;
    }

    public String getName() {
        return this.name;
    }

    public Nodemapper getRoot() {
        return this.root;
    }

    public int getMatchCount() {
        return this.matchCount;
    }

    public int getUpgradeCnt() {
        return this.upgradeCnt;
    }

    public String getResultNote() {
        return this.resultNote;
    }

    public int getCategoryCnt() {
        return this.categoryCnt;
    }

    public int getLeafCnt() {
        return this.leafCnt;
    }

    public int getNodeCnt() {
        return this.nodeCnt;
    }

    public long getNodeSize() {
        return this.nodeSize;
    }

    public int getSingletonCnt() {
        return this.singletonCnt;
    }

    public int getShortCutCnt() {
        return this.shortCutCnt;
    }

    public int getNaryCnt() {
        return this.naryCnt;
    }

    public void setBot(Bot bot) {
        this.bot = bot;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMatchCount(int matchCount) {
        this.matchCount = matchCount;
    }

    public void setUpgradeCnt(int upgradeCnt) {
        this.upgradeCnt = upgradeCnt;
    }

    public void setVocabulary(Set<String> vocabulary) {
        this.vocabulary = vocabulary;
    }

    public void setResultNote(String resultNote) {
        this.resultNote = resultNote;
    }

    public void setCategoryCnt(int categoryCnt) {
        this.categoryCnt = categoryCnt;
    }

    public void setLeafCnt(int leafCnt) {
        this.leafCnt = leafCnt;
    }

    public void setNodeCnt(int nodeCnt) {
        this.nodeCnt = nodeCnt;
    }

    public void setNodeSize(long nodeSize) {
        this.nodeSize = nodeSize;
    }

    public void setSingletonCnt(int singletonCnt) {
        this.singletonCnt = singletonCnt;
    }

    public void setShortCutCnt(int shortCutCnt) {
        this.shortCutCnt = shortCutCnt;
    }

    public void setNaryCnt(int naryCnt) {
        this.naryCnt = naryCnt;
    }
}

