/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.alicebot.ab.Bot;
import org.alicebot.ab.TripleStore;
import org.alicebot.ab.model.History;
import org.alicebot.ab.model.Predicates;
import org.alicebot.ab.utils.IOUtils;
import org.alicebot.ab.utils.JapaneseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chat {
    private static final Logger log = LoggerFactory.getLogger(Chat.class);
    private final Bot bot;
    private final TripleStore tripleStore;
    private boolean doWrites;
    private String customerId;
    private History<History> thatHistory;
    private History<String> requestHistory;
    private History<String> responseHistory;
    private History<String> inputHistory;
    private Predicates predicates;

    public Chat(Bot bot) {
        this(bot, true, "0");
    }

    public Chat(Bot bot, boolean doWrites) {
        this(bot, doWrites, "0");
    }

    public Chat(Bot bot, boolean doWrites, String customerId) {
        this.customerId = customerId;
        this.bot = bot;
        this.tripleStore = new TripleStore("anon", bot);
        this.doWrites = doWrites;
        int maxHistory = bot.getConfiguration().getMaxHistory();
        this.thatHistory = new History(maxHistory, "that");
        this.requestHistory = new History(maxHistory, "request");
        this.responseHistory = new History(maxHistory, "response");
        this.inputHistory = new History(maxHistory, "input");
        History<String> contextThatHistory = new History<String>(maxHistory);
        contextThatHistory.add("unknown");
        this.thatHistory.add(contextThatHistory);
        this.predicates = new Predicates(bot);
        this.predicates.put("topic", "unknown");
        this.predicates.put("jsenabled", "true");
        if (log.isTraceEnabled()) {
            log.trace("Chat Session Created for bot {}", (Object)bot.getName());
        }
        this.addPredicates();
        this.addTriples();
    }

    private void addPredicates() {
        try {
            this.predicates.getPredicateDefaults(this.bot.getConfigPath() + "/predicates.txt");
        }
        catch (Exception e) {
            log.warn("Error reading predicates", (Throwable)e);
        }
    }

    private int addTriples() {
        File f;
        int count = 0;
        String fileName = this.bot.getConfigPath() + "/triples.txt";
        if (log.isTraceEnabled()) {
            log.trace("Loading Triples from {}", (Object)fileName);
        }
        if ((f = new File(fileName)).exists()) {
            try (FileInputStream is = new FileInputStream(f);
                 BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String strLine;
                while ((strLine = br.readLine()) != null) {
                    String[] triple = strLine.split(":");
                    if (triple.length < 3) continue;
                    String subject = triple[0];
                    String predicate = triple[1];
                    String object = triple[2];
                    this.tripleStore.addTriple(subject, predicate, object);
                    ++count;
                }
            }
            catch (Exception e) {
                log.warn("Error reading triples", (Throwable)e);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Loaded {} triples", (Object)count);
        }
        return count;
    }

    public void chat() {
        try {
            String request = "SET PREDICATES";
            String response = this.multisentenceRespond(request);
            while (!"quit".equals(request)) {
                log.info("Human: ");
                request = IOUtils.readInputTextLine();
                response = this.multisentenceRespond(request);
                log.info("Robot: {}", (Object)response);
            }
        }
        catch (Exception e) {
            log.warn("Error: ", (Throwable)e);
        }
    }

    private String respond(String input, String that, String topic, History<String> contextThatHistory) {
        String[] sentences;
        boolean repetition = true;
        for (int i = 0; i < this.bot.getConfiguration().getRepetitionCount(); ++i) {
            if (this.inputHistory.get(i) != null && input.toUpperCase().equals(this.inputHistory.get(i).toUpperCase())) continue;
            repetition = false;
        }
        if (input.equals("NORESP")) {
            repetition = false;
        }
        this.inputHistory.add(input);
        if (repetition) {
            input = "REPETITIONDETECTED";
        }
        String response = this.bot.getProcessor().respond(input, that, topic, this);
        String normResponse = this.bot.getPreProcessor().normalize(response);
        if (this.bot.getConfiguration().isJpTokenize()) {
            normResponse = JapaneseUtils.tokenizeSentence(normResponse);
        }
        for (String s : sentences = this.bot.getPreProcessor().sentenceSplit(normResponse)) {
            if (s.trim().equals("")) {
                s = "unknown";
            }
            contextThatHistory.add(s);
        }
        return response.trim() + " ";
    }

    private String respond(String input, History<String> contextThatHistory) {
        History hist = this.thatHistory.get(0);
        String that = hist != null ? hist.getString(0) : "unknown";
        return this.respond(input, that, this.predicates.get("topic"), contextThatHistory);
    }

    public String multisentenceRespond(String request) {
        StringBuilder response = new StringBuilder();
        try {
            String normalized = this.bot.getPreProcessor().normalize(request);
            if (this.bot.getConfiguration().isJpTokenize()) {
                normalized = JapaneseUtils.tokenizeSentence(normalized);
            }
            String[] sentences = this.bot.getPreProcessor().sentenceSplit(normalized);
            History<String> contextThatHistory = new History<String>(this.bot.getConfiguration().getMaxHistory(), "contextThat");
            for (String sentence : sentences) {
                String reply = this.respond(sentence, contextThatHistory);
                response.append(" ").append(reply);
            }
            String result = response.toString();
            this.requestHistory.add(request);
            this.responseHistory.add(result);
            this.thatHistory.add(contextThatHistory);
            result = result.replaceAll("[\n]+", "\n");
            result = result.trim();
            if (this.doWrites) {
                this.bot.writeLearnfIFCategories();
            }
            return result;
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return this.bot.getConfiguration().getLanguage().getErrorResponse();
        }
    }

    public Bot getBot() {
        return this.bot;
    }

    public TripleStore getTripleStore() {
        return this.tripleStore;
    }

    public boolean isDoWrites() {
        return this.doWrites;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public History<History> getThatHistory() {
        return this.thatHistory;
    }

    public History<String> getRequestHistory() {
        return this.requestHistory;
    }

    public History<String> getResponseHistory() {
        return this.responseHistory;
    }

    public History<String> getInputHistory() {
        return this.inputHistory;
    }

    public Predicates getPredicates() {
        return this.predicates;
    }

    public void setDoWrites(boolean doWrites) {
        this.doWrites = doWrites;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public void setThatHistory(History<History> thatHistory) {
        this.thatHistory = thatHistory;
    }

    public void setRequestHistory(History<String> requestHistory) {
        this.requestHistory = requestHistory;
    }

    public void setResponseHistory(History<String> responseHistory) {
        this.responseHistory = responseHistory;
    }

    public void setInputHistory(History<String> inputHistory) {
        this.inputHistory = inputHistory;
    }

    public void setPredicates(Predicates predicates) {
        this.predicates = predicates;
    }
}

