/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.alicebot.ab.AIMLProcessor;
import org.alicebot.ab.Graphmaster;
import org.alicebot.ab.NodemapperOperator;
import org.alicebot.ab.PreProcessor;
import org.alicebot.ab.configuration.BotConfiguration;
import org.alicebot.ab.model.AIMLMap;
import org.alicebot.ab.model.AIMLSet;
import org.alicebot.ab.model.Category;
import org.alicebot.ab.model.Nodemapper;
import org.alicebot.ab.model.Properties;
import org.alicebot.ab.utils.IOUtils;
import org.alicebot.ab.utils.Timer;
import org.alicebot.ab.utils.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bot {
    private static final Logger log = LoggerFactory.getLogger(Bot.class);
    private final BotConfiguration configuration;
    private final Properties properties = new Properties();
    private final PreProcessor preProcessor;
    private final AIMLProcessor processor;
    private final Graphmaster brain;
    private Graphmaster learnfGraph;
    private Graphmaster learnGraph;
    private String name;
    private HashMap<String, AIMLSet> setMap = new HashMap();
    private HashMap<String, AIMLMap> mapMap = new HashMap();
    private HashSet<String> pronounSet = new HashSet();
    private String rootPath;
    private String aimlifPath;
    private String aimlPath;
    private String configPath;
    private String setsPath;
    private String mapsPath;

    public Bot() {
        this(BotConfiguration.builder().build());
    }

    public Bot(String name) {
        this(BotConfiguration.builder().name(name).build());
    }

    public Bot(BotConfiguration configuration) {
        this.configuration = configuration;
        this.name = configuration.getName();
        this.setAllPaths(configuration);
        this.brain = new Graphmaster(this);
        this.learnfGraph = new Graphmaster(this, "learnf");
        this.learnGraph = new Graphmaster(this, "learn");
        this.preProcessor = new PreProcessor(this);
        this.processor = new AIMLProcessor(this);
        this.addProperties();
        int count = this.addAIMLSets();
        if (log.isDebugEnabled()) {
            log.debug("Loaded {} set elements.", (Object)count);
        }
        count = this.addAIMLMaps();
        if (log.isDebugEnabled()) {
            log.debug("Loaded {} map elements.", (Object)count);
        }
        this.pronounSet = this.getPronouns();
        this.setMap.put("number", new AIMLSet("number", this));
        this.mapMap.put("successor", new AIMLMap("successor", this));
        this.mapMap.put("predecessor", new AIMLMap("predecessor", this));
        this.mapMap.put("singular", new AIMLMap("singular", this));
        this.mapMap.put("plural", new AIMLMap("plural", this));
        Date aimlDate = new Date(new File(this.aimlPath).lastModified());
        Date aimlIFDate = new Date(new File(this.aimlifPath).lastModified());
        if (log.isDebugEnabled()) {
            log.debug("AIML modified {} AIMLIF modified {}", (Object)aimlDate, (Object)aimlIFDate);
        }
        switch (configuration.getAction()) {
            case "aiml2csv": {
                this.addCategoriesFromAIML();
                break;
            }
            case "csv2aiml": 
            case "chat-app": {
                this.addCategoriesFromAIMLIF();
                break;
            }
            default: {
                if (aimlDate.after(aimlIFDate)) {
                    this.addCategoriesFromAIML();
                    this.writeAIMLIFFiles();
                    break;
                }
                this.addCategoriesFromAIMLIF();
                if (this.brain.getCategories().size() != 0) break;
                this.addCategoriesFromAIML();
            }
        }
        Category version = new Category(this, 0, "PROGRAM VERSION", "*", "*", configuration.getProgramName(), "update.aiml");
        this.brain.addCategory(version);
        this.brain.nodeStats();
        this.learnfGraph.nodeStats();
    }

    private void setAllPaths(BotConfiguration configuration) {
        this.rootPath = configuration.getPath();
        String botNamePath = this.rootPath + "/bots/" + this.name;
        if (log.isTraceEnabled()) {
            log.trace("Init bot: Name = {} Path = {}", (Object)this.name, (Object)botNamePath);
        }
        this.aimlPath = botNamePath + "/aiml";
        this.aimlifPath = botNamePath + "/aimlif";
        this.configPath = botNamePath + "/config";
        this.setsPath = botNamePath + "/sets";
        this.mapsPath = botNamePath + "/maps";
    }

    private HashSet<String> getPronouns() {
        String[] splitPronouns;
        HashSet<String> pronounSet = new HashSet<String>();
        String pronouns = Utilities.getFile(this.configPath + "/pronouns.txt");
        for (String p : splitPronouns = pronouns.split("\n")) {
            if (p.length() <= 0) continue;
            pronounSet.add(p);
        }
        return pronounSet;
    }

    private void addMoreCategories(String file, ArrayList<Category> moreCategories) {
        if (file.contains("learnf.aiml")) {
            for (Category c : moreCategories) {
                this.brain.addCategory(c);
                this.learnfGraph.addCategory(c);
            }
        } else {
            for (Category c : moreCategories) {
                this.brain.addCategory(c);
            }
        }
    }

    private void addCategoriesFromAIML() {
        Timer timer = new Timer();
        timer.start();
        int count = 0;
        try {
            File folder = new File(this.aimlPath);
            if (folder.exists()) {
                File[] listOfFiles = IOUtils.listFiles(folder);
                if (log.isTraceEnabled()) {
                    log.trace("Loading AIML files from {}", (Object)this.aimlPath);
                }
                for (File listOfFile : listOfFiles) {
                    String file;
                    if (!listOfFile.isFile() || !(file = listOfFile.getName()).endsWith(".aiml") && !file.endsWith(".AIML")) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("Reading AIML {}", (Object)file);
                    }
                    try {
                        ArrayList<Category> moreCategories = this.processor.AIMLToCategories(this.aimlPath, file);
                        this.addMoreCategories(file, moreCategories);
                        count += moreCategories != null ? moreCategories.size() : 0;
                    }
                    catch (Exception e) {
                        log.error("Problem loading {}", (Object)file, (Object)e);
                    }
                }
            } else {
                log.warn("addCategoriesFromAIML: {} does not exist.", (Object)this.aimlPath);
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        if (log.isTraceEnabled()) {
            log.trace("Loaded {} categories in {} sec", (Object)count, (Object)Float.valueOf(timer.elapsedTimeSecs()));
        }
    }

    private void addCategoriesFromAIMLIF() {
        Timer timer = new Timer();
        timer.start();
        int count = 0;
        try {
            File folder = new File(this.aimlifPath);
            if (folder.exists()) {
                File[] listOfFiles = IOUtils.listFiles(folder);
                if (log.isTraceEnabled()) {
                    log.trace("Loading AIML files from {}", (Object)this.aimlifPath);
                }
                for (File listOfFile : listOfFiles) {
                    String file;
                    if (!listOfFile.isFile() || !(file = listOfFile.getName()).endsWith(this.configuration.getAimlifFileSuffix()) && !file.endsWith(this.configuration.getAimlifFileSuffix().toUpperCase())) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("Reading AIML {}", (Object)file);
                    }
                    try {
                        ArrayList<Category> moreCategories = this.readIFCategories(this.aimlifPath + "/" + file);
                        count += moreCategories.size();
                        this.addMoreCategories(file, moreCategories);
                    }
                    catch (Exception e) {
                        log.error("Problem loading {}", (Object)file, (Object)e);
                    }
                }
            } else {
                log.warn("addCategoriesFromAIMLIF: {} does not exist.", (Object)this.aimlifPath);
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        if (log.isTraceEnabled()) {
            log.trace("Loaded {} categories in {} sec", (Object)count, (Object)Float.valueOf(timer.elapsedTimeSecs()));
        }
    }

    public void writeQuit() {
        this.writeAIMLIFFiles();
        this.writeAIMLFiles();
    }

    public void readCertainIFCategories(Graphmaster graph, String fileName) {
        String filePath = this.aimlifPath + "/" + fileName + this.configuration.getAimlifFileSuffix();
        File file = new File(filePath);
        if (file.exists()) {
            try {
                ArrayList<Category> certainCategories = this.readIFCategories(filePath);
                for (Category d : certainCategories) {
                    graph.addCategory(d);
                }
                int count = certainCategories.size();
                log.info("readCertainIFCategories {} categories from {}", (Object)count, (Object)filePath);
            }
            catch (Exception e) {
                log.error("Problem loading {}", (Object)file, (Object)e);
            }
        } else {
            log.warn("No {} file found", (Object)filePath);
        }
    }

    public boolean writeCertainIFCategories(Graphmaster graph, String file) {
        if (log.isTraceEnabled()) {
            log.trace("writeCertainIFCaegories {} size={}", (Object)file, (Object)graph.getCategories().size());
        }
        this.writeIFCategories(graph.getCategories(), file + this.configuration.getAimlifFileSuffix());
        File dir = new File(this.aimlifPath);
        return dir.setLastModified(new Date().getTime());
    }

    public boolean writeLearnfIFCategories() {
        return this.writeCertainIFCategories(this.learnfGraph, "learnf.aiml");
    }

    private void writeIFCategories(ArrayList<Category> cats, String filename) {
        File existsPath = new File(this.aimlifPath);
        if (existsPath.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.aimlifPath + "/" + filename));){
                for (Category category : cats) {
                    writer.write(Category.categoryToIF(category));
                    writer.newLine();
                }
            }
            catch (Exception e) {
                log.error("writeIFCategories problem {}", (Object)filename, (Object)e);
            }
        }
    }

    public boolean writeAIMLIFFiles() {
        if (log.isTraceEnabled()) {
            log.trace("writeAIMLIFFiles");
        }
        HashMap<String, BufferedWriter> fileMap = new HashMap<String, BufferedWriter>();
        Category build = new Category(this, 0, "BRAIN BUILD", "*", "*", new Date().toString(), "update.aiml");
        this.brain.addCategory(build);
        ArrayList<Category> brainCategories = this.brain.getCategories();
        brainCategories.sort(Category.CATEGORY_NUMBER_COMPARATOR);
        File existsPath = new File(this.aimlifPath);
        if (existsPath.exists()) {
            BufferedWriter bw;
            for (Category c : brainCategories) {
                try {
                    String fileName = c.getFilename();
                    if (fileMap.containsKey(fileName)) {
                        bw = (BufferedWriter)fileMap.get(fileName);
                    } else {
                        bw = new BufferedWriter(new FileWriter(this.aimlifPath + "/" + fileName + this.configuration.getAimlifFileSuffix()));
                        fileMap.put(fileName, bw);
                    }
                    bw.write(Category.categoryToIF(c));
                    bw.newLine();
                }
                catch (Exception e) {
                    log.error("Error: ", (Throwable)e);
                }
            }
            for (String set : fileMap.keySet()) {
                bw = (BufferedWriter)fileMap.get(set);
                try {
                    if (bw == null) continue;
                    bw.flush();
                    bw.close();
                }
                catch (IOException e) {
                    log.error("Error closing writer {}", (Object)set, (Object)e);
                }
            }
            return existsPath.setLastModified(new Date().getTime());
        }
        return false;
    }

    public boolean writeAIMLFiles() {
        BufferedWriter bw;
        if (log.isTraceEnabled()) {
            log.trace("writeAIMLFiles");
        }
        HashMap<String, BufferedWriter> fileMap = new HashMap<String, BufferedWriter>();
        Category build = new Category(this, 0, "BRAIN BUILD", "*", "*", new Date().toString(), "update.aiml");
        this.brain.addCategory(build);
        ArrayList<Category> brainCategories = this.brain.getCategories();
        brainCategories.sort(Category.CATEGORY_NUMBER_COMPARATOR);
        for (Category c : brainCategories) {
            if (c.getFilename().equals("null.aiml")) continue;
            try {
                String fileName = c.getFilename();
                if (fileMap.containsKey(fileName)) {
                    bw = (BufferedWriter)fileMap.get(fileName);
                } else {
                    String copyright = Utilities.getCopyright(this, fileName);
                    bw = new BufferedWriter(new FileWriter(this.aimlPath + "/" + fileName));
                    fileMap.put(fileName, bw);
                    bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<aiml>\n");
                    bw.write(copyright);
                }
                bw.write(Category.categoryToAIML(c) + "\n");
            }
            catch (Exception e) {
                log.error("Error: ", (Throwable)e);
            }
        }
        for (String set : fileMap.keySet()) {
            bw = (BufferedWriter)fileMap.get(set);
            try {
                if (bw == null) continue;
                bw.write("</aiml>\n");
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                log.error("Error closing writer {}", (Object)set, (Object)e);
            }
        }
        File dir = new File(this.aimlPath);
        return dir.setLastModified(new Date().getTime());
    }

    private void addProperties() {
        try {
            this.properties.getProperties(this.configPath + "/properties.txt");
        }
        catch (Exception e) {
            log.error("Error reading properties {}", (Throwable)e);
        }
    }

    private ArrayList<Category> readIFCategories(String filename) {
        ArrayList<Category> categories = new ArrayList<Category>();
        try (FileInputStream fstream = new FileInputStream(filename);
             BufferedReader br = new BufferedReader(new InputStreamReader(fstream));){
            String strLine;
            while ((strLine = br.readLine()) != null) {
                try {
                    Category c = Category.IFToCategory(this, strLine);
                    categories.add(c);
                }
                catch (Exception e) {
                    log.error("Invalid AIMLIF in {} line {}", (Object)filename, (Object)strLine);
                }
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return categories;
    }

    private int addAIMLSets() {
        int count = 0;
        Timer timer = new Timer();
        timer.start();
        try {
            File folder = new File(this.setsPath);
            if (folder.exists()) {
                File[] listOfFiles = IOUtils.listFiles(folder);
                if (log.isTraceEnabled()) {
                    log.trace("Loading AIML Sets files from {}", (Object)this.setsPath);
                }
                for (File listOfFile : listOfFiles) {
                    String file;
                    if (!listOfFile.isFile() || !(file = listOfFile.getName()).endsWith(".txt") && !file.endsWith(".TXT")) continue;
                    String setName = file.substring(0, file.length() - ".txt".length());
                    if (log.isTraceEnabled()) {
                        log.trace("Read AIML Set {} from {}", (Object)setName, (Object)file);
                    }
                    AIMLSet aimlSet = new AIMLSet(setName, this);
                    count += aimlSet.readAIMLSet(this);
                    this.setMap.put(setName, aimlSet);
                }
            } else {
                log.warn("addAIMLSets: {} does not exist.", (Object)this.setsPath);
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return count;
    }

    private int addAIMLMaps() {
        int cnt = 0;
        Timer timer = new Timer();
        timer.start();
        try {
            File folder = new File(this.mapsPath);
            if (folder.exists()) {
                File[] listOfFiles = IOUtils.listFiles(folder);
                if (log.isTraceEnabled()) {
                    log.trace("Loading AIML Map files from{}", (Object)this.mapsPath);
                }
                for (File listOfFile : listOfFiles) {
                    String file;
                    if (!listOfFile.isFile() || !(file = listOfFile.getName()).endsWith(".txt") && !file.endsWith(".TXT")) continue;
                    String mapName = file.substring(0, file.length() - ".txt".length());
                    if (log.isTraceEnabled()) {
                        log.trace("Read AIML Map {} from {}", (Object)mapName, (Object)file);
                    }
                    AIMLMap aimlMap = new AIMLMap(mapName, this);
                    cnt += aimlMap.readAIMLMap(this);
                    this.mapMap.put(mapName, aimlMap);
                }
            } else {
                log.warn("addAIMLMaps: {} does not exist.", (Object)this.mapsPath);
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return cnt;
    }

    public void deleteLearnfCategories() {
        ArrayList<Category> learnfCategories = this.learnfGraph.getCategories();
        this.deleteLearnCategories(learnfCategories);
        this.learnfGraph = new Graphmaster(this);
    }

    public void deleteLearnCategories() {
        ArrayList<Category> learnCategories = this.learnGraph.getCategories();
        this.deleteLearnCategories(learnCategories);
        this.learnGraph = new Graphmaster(this);
    }

    private void deleteLearnCategories(ArrayList<Category> learnCategories) {
        for (Category c : learnCategories) {
            Nodemapper n = this.brain.findNode(c);
            log.info("Found node {} for {}", (Object)n, (Object)c.inputThatTopic());
            if (n == null) continue;
            n.setCategory(null);
        }
    }

    public void shadowChecker() {
        this.shadowChecker(this.brain.getRoot());
    }

    private void shadowChecker(Nodemapper node) {
        if (NodemapperOperator.isLeaf(node)) {
            String input = node.getCategory().getPattern();
            input = this.brain.replaceBotProperties(input);
            input = input.replace("*", "XXX").replace("_", "XXX").replace("^", "").replace("#", "");
            String that = node.getCategory().getThat().replace("*", "XXX").replace("_", "XXX").replace("^", "").replace("#", "");
            String topic = node.getCategory().getTopic().replace("*", "XXX").replace("_", "XXX").replace("^", "").replace("#", "");
            input = this.instantiateSets(input);
            log.debug("shadowChecker: input={}", (Object)input);
            Nodemapper match = this.brain.match(input, that, topic);
            if (match != node) {
                log.debug("             {}", (Object)Graphmaster.inputThatTopic(input, that, topic));
                log.debug("MATCHED:     {}", (Object)match.getCategory().inputThatTopic());
                log.debug("SHOULD MATCH:{}", (Object)node.getCategory().inputThatTopic());
            }
        } else {
            for (String key : NodemapperOperator.keySet(node)) {
                this.shadowChecker(NodemapperOperator.get(node, key));
            }
        }
    }

    private String instantiateSets(String pattern) {
        String[] splitPattern = pattern.split(" ");
        StringBuilder builder = new StringBuilder();
        for (String x : splitPattern) {
            if (x.startsWith("<SET>")) {
                String setName = AIMLProcessor.trimTag(x, "SET");
                AIMLSet set = this.setMap.get(setName);
                x = set != null ? "FOUNDITEM" : "NOTFOUND";
            }
            builder.append(" ").append(x);
        }
        return builder.toString().trim();
    }

    public BotConfiguration getConfiguration() {
        return this.configuration;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public PreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public AIMLProcessor getProcessor() {
        return this.processor;
    }

    public Graphmaster getBrain() {
        return this.brain;
    }

    public Graphmaster getLearnfGraph() {
        return this.learnfGraph;
    }

    public Graphmaster getLearnGraph() {
        return this.learnGraph;
    }

    public String getName() {
        return this.name;
    }

    public HashMap<String, AIMLSet> getSetMap() {
        return this.setMap;
    }

    public HashMap<String, AIMLMap> getMapMap() {
        return this.mapMap;
    }

    public HashSet<String> getPronounSet() {
        return this.pronounSet;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getAimlifPath() {
        return this.aimlifPath;
    }

    public String getAimlPath() {
        return this.aimlPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getSetsPath() {
        return this.setsPath;
    }

    public String getMapsPath() {
        return this.mapsPath;
    }

    public void setLearnfGraph(Graphmaster learnfGraph) {
        this.learnfGraph = learnfGraph;
    }

    public void setLearnGraph(Graphmaster learnGraph) {
        this.learnGraph = learnGraph;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSetMap(HashMap<String, AIMLSet> setMap) {
        this.setMap = setMap;
    }

    public void setMapMap(HashMap<String, AIMLMap> mapMap) {
        this.mapMap = mapMap;
    }

    public void setPronounSet(HashSet<String> pronounSet) {
        this.pronounSet = pronounSet;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setAimlifPath(String aimlifPath) {
        this.aimlifPath = aimlifPath;
    }

    public void setAimlPath(String aimlPath) {
        this.aimlPath = aimlPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public void setSetsPath(String setsPath) {
        this.setsPath = setsPath;
    }

    public void setMapsPath(String mapsPath) {
        this.mapsPath = mapsPath;
    }
}

