/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.alicebot.ab.AIMLProcessorExtension;
import org.alicebot.ab.Bot;
import org.alicebot.ab.Chat;
import org.alicebot.ab.Sraix;
import org.alicebot.ab.TripleStore;
import org.alicebot.ab.model.AIMLMap;
import org.alicebot.ab.model.Category;
import org.alicebot.ab.model.Clause;
import org.alicebot.ab.model.History;
import org.alicebot.ab.model.Nodemapper;
import org.alicebot.ab.model.ParseState;
import org.alicebot.ab.model.Tuple;
import org.alicebot.ab.utils.CalendarUtils;
import org.alicebot.ab.utils.DomUtils;
import org.alicebot.ab.utils.IOUtils;
import org.alicebot.ab.utils.IntervalUtils;
import org.alicebot.ab.utils.JapaneseUtils;
import org.alicebot.ab.utils.Utilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AIMLProcessor {
    private static final Logger log = LoggerFactory.getLogger(AIMLProcessor.class);
    private Set<AIMLProcessorExtension> extensions = new HashSet<AIMLProcessorExtension>();
    private int sraiCount = 0;
    private Map<String, Tuple> tupleMap = new ConcurrentHashMap<String, Tuple>();
    private final Bot bot;

    public AIMLProcessor(Bot bot) {
        this.bot = bot;
    }

    private void categoryProcessor(Node n, ArrayList<Category> categories, String topic, String aimlFile, String language) {
        NodeList children = n.getChildNodes();
        String pattern = "*";
        String that = "*";
        String template = "";
        block14: for (int j = 0; j < children.getLength(); ++j) {
            String mName;
            if (log.isDebugEnabled()) {
                log.debug("CHILD: {}", (Object)children.item(j).getNodeName());
            }
            Node m = children.item(j);
            switch (mName = m.getNodeName()) {
                case "#text": {
                    continue block14;
                }
                case "pattern": {
                    pattern = DomUtils.nodeToString(m);
                    continue block14;
                }
                case "that": {
                    that = DomUtils.nodeToString(m);
                    continue block14;
                }
                case "topic": {
                    topic = DomUtils.nodeToString(m);
                    continue block14;
                }
                case "template": {
                    template = DomUtils.nodeToString(m);
                    continue block14;
                }
                default: {
                    log.warn("categoryProcessor: unexpected {} in {}", (Object)mName, (Object)DomUtils.nodeToString(m));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("categoryProcessor: pattern={}", (Object)pattern);
        }
        pattern = AIMLProcessor.trimTag(pattern, "pattern");
        that = AIMLProcessor.trimTag(that, "that");
        topic = AIMLProcessor.trimTag(topic, "topic");
        pattern = AIMLProcessor.cleanPattern(pattern);
        that = AIMLProcessor.cleanPattern(that);
        topic = AIMLProcessor.cleanPattern(topic);
        template = AIMLProcessor.trimTag(template, "template");
        if (this.bot.getConfiguration().isJpTokenize()) {
            pattern = JapaneseUtils.tokenizeSentence(pattern);
            that = JapaneseUtils.tokenizeSentence(that);
            topic = JapaneseUtils.tokenizeSentence(topic);
        }
        Category c = new Category(this.bot, 0, pattern, that, topic, template, aimlFile);
        if (StringUtils.isEmpty((CharSequence)template)) {
            log.info("Category {} discarded due to blank or missing <template>.", (Object)c.inputThatTopic());
        } else {
            categories.add(c);
        }
    }

    private static String cleanPattern(String pattern) {
        pattern = pattern.replaceAll("(\r\n|\n\r|\r|\n)", " ");
        pattern = pattern.replaceAll("  ", " ");
        return pattern.trim();
    }

    public static String trimTag(String s, String tagName) {
        String stag = "<" + tagName + ">";
        String etag = "</" + tagName + ">";
        if (s.startsWith(stag) && s.endsWith(etag)) {
            s = s.substring(stag.length());
            s = s.substring(0, s.length() - etag.length());
        }
        return s.trim();
    }

    public ArrayList<Category> AIMLToCategories(String directory, String aimlFile) {
        try {
            int i;
            ArrayList<Category> categories = new ArrayList<Category>();
            Node root = DomUtils.parseFile(directory + "/" + aimlFile);
            String language = this.bot.getConfiguration().getDefaultLanguage();
            if (root.hasAttributes()) {
                NamedNodeMap XMLAttributes = root.getAttributes();
                for (i = 0; i < XMLAttributes.getLength(); ++i) {
                    if (!"language".equals(XMLAttributes.item(i).getNodeName())) continue;
                    language = XMLAttributes.item(i).getNodeValue();
                }
            }
            NodeList nodelist = root.getChildNodes();
            for (i = 0; i < nodelist.getLength(); ++i) {
                Node n = nodelist.item(i);
                if (log.isTraceEnabled()) {
                    log.trace("AIML child: {}", (Object)n.getNodeName());
                }
                if ("category".equals(n.getNodeName())) {
                    this.categoryProcessor(n, categories, "*", aimlFile, language);
                    continue;
                }
                if (!"topic".equals(n.getNodeName())) continue;
                String topic = n.getAttributes().getNamedItem("name").getTextContent();
                if (log.isTraceEnabled()) {
                    log.trace("topic: {}", (Object)topic);
                }
                NodeList children = n.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node m = children.item(j);
                    if (log.isTraceEnabled()) {
                        log.trace("Topic child: {}", (Object)m.getNodeName());
                    }
                    if (!"category".equals(m.getNodeName())) continue;
                    this.categoryProcessor(m, categories, topic, aimlFile, language);
                }
            }
            return categories;
        }
        catch (Exception e) {
            log.error("AIMLToCategories Error:", (Throwable)e);
            return null;
        }
    }

    public String respond(String input, String that, String topic, Chat chatSession) {
        return this.respond(input, that, topic, chatSession, 0);
    }

    public String respond(String input, String that, String topic, Chat chatSession, int srCnt) {
        if (log.isTraceEnabled()) {
            log.trace("input: {}, that: {}, topic: {}, chatSession: {}, srCnt: {}", new Object[]{input, that, topic, chatSession, srCnt});
        }
        if (input == null || input.length() == 0) {
            input = "NORESP";
        }
        this.sraiCount = srCnt;
        String response = chatSession.getBot().getConfiguration().getLanguage().getDefaultResponse();
        try {
            Nodemapper leaf = chatSession.getBot().getBrain().match(input, that, topic);
            if (leaf == null) {
                return response;
            }
            ParseState ps = new ParseState(0, chatSession, input, that, topic, leaf);
            String template = leaf.getCategory().getTemplate();
            response = this.evalTemplate(template, ps);
            if (log.isTraceEnabled()) {
                log.trace("in AIMLProcessor.respond(), template={}, trat={}", (Object)template, (Object)that);
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return response;
    }

    private static String capitalizeString(String string) {
        char[] chars = string.toLowerCase().toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(chars[i])) continue;
            found = false;
        }
        return String.valueOf(chars);
    }

    private static String explode(String input) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            builder.append(" ").append(input.charAt(i));
        }
        String result = builder.toString();
        while (result.contains("  ")) {
            result = result.replace("  ", " ");
        }
        return result.trim();
    }

    public String evalTagContent(Node node, ParseState ps, Set<String> ignoreAttributes) {
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.evalTagContent(node: {}, ps: {}, ignoreAttributes: {}", new Object[]{node, ps, ignoreAttributes});
            log.trace("in AIMLProcessor.evalTagContent, node string: {}", (Object)DomUtils.nodeToString(node));
        }
        StringBuilder result = new StringBuilder();
        try {
            NodeList childList = node.getChildNodes();
            for (int i = 0; i < childList.getLength(); ++i) {
                Node child = childList.item(i);
                if (log.isTraceEnabled()) {
                    log.trace("in AIMLProcessor.evalTagContent(), child: {}", (Object)child);
                }
                if (ignoreAttributes == null || !ignoreAttributes.contains(child.getNodeName())) {
                    result.append(this.recursEval(child, ps));
                }
                if (!log.isTraceEnabled()) continue;
                log.trace("in AIMLProcessor.evalTagContent(), result: ", (Object)result);
            }
        }
        catch (Exception e) {
            log.error("Something went wrong with evalTagContent", (Throwable)e);
        }
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.evalTagContent() returning: {}", (Object)result);
        }
        return result.toString();
    }

    public String genericXML(Node node, ParseState ps) {
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.genericXML(node: {}, ps: {}", (Object)node, (Object)ps);
        }
        String evalResult = this.evalTagContent(node, ps, null);
        String result = AIMLProcessor.unevaluatedXML(evalResult, node, ps);
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.genericXML(), returning: {}", (Object)result);
        }
        return result;
    }

    private static String unevaluatedXML(String resultIn, Node node, ParseState ps) {
        String nodeName = node.getNodeName();
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.unevaluatedXML(resultIn: {}, node: {}, nodeName: {}, ps: {}", new Object[]{resultIn, node, nodeName, ps});
        }
        StringBuilder attributes = new StringBuilder();
        if (node.hasAttributes()) {
            NamedNodeMap XMLAttributes = node.getAttributes();
            for (int i = 0; i < XMLAttributes.getLength(); ++i) {
                attributes.append(" ").append(XMLAttributes.item(i).getNodeName()).append("=\"").append(XMLAttributes.item(i).getNodeValue()).append("\"");
            }
        }
        String result = "<" + nodeName + attributes + "/>";
        if (!"".equals(resultIn)) {
            result = "<" + nodeName + attributes + ">" + resultIn + "</" + nodeName + ">";
        }
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.unevaluatedXML() returning: {}", (Object)result);
        }
        return result;
    }

    private String srai(Node node, ParseState ps) {
        String result;
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.srai(node: {}, ps: {}", (Object)node, (Object)ps);
        }
        ++this.sraiCount;
        if (this.sraiCount > this.bot.getConfiguration().getMaxRecursionCount() || ps.getDepth() > this.bot.getConfiguration().getMaxRecursionDepth()) {
            return this.bot.getConfiguration().getLanguage().getTooMuchRecursion();
        }
        String response = this.bot.getConfiguration().getLanguage().getDefaultResponse();
        try {
            Nodemapper leaf;
            result = this.evalTagContent(node, ps, null);
            result = result.trim();
            result = result.replaceAll("(\r\n|\n\r|\r|\n)", " ");
            result = ps.getChatSession().getBot().getPreProcessor().normalize(result);
            if (this.bot.getConfiguration().isJpTokenize()) {
                result = JapaneseUtils.tokenizeSentence(result);
            }
            String topic = ps.getChatSession().getPredicates().get("topic");
            if (log.isTraceEnabled()) {
                log.trace("<srai>{}</srai> from {} topic={}", new Object[]{result, ps.getLeaf().getCategory().inputThatTopic(), topic});
            }
            if ((leaf = ps.getChatSession().getBot().getBrain().match(result, ps.getThat(), topic)) == null) {
                return response;
            }
            if (log.isTraceEnabled()) {
                log.trace("Srai returned {}:{}, that=", (Object)leaf.getCategory().inputThatTopic(), (Object)leaf.getCategory().getTemplate());
            }
            response = this.evalTemplate(leaf.getCategory().getTemplate(), new ParseState(ps.getDepth() + 1, ps.getChatSession(), ps.getInput(), ps.getThat(), topic, leaf));
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        result = response.trim();
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.srai(), returning: {}", (Object)result);
        }
        return result;
    }

    private String getAttributeOrTagValue(Node node, ParseState ps, String attributeName) {
        String result;
        Node m;
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.getAttributeOrTagValue (node: {}, attributeName: {})", (Object)node, (Object)attributeName);
        }
        if ((m = node.getAttributes().getNamedItem(attributeName)) == null) {
            NodeList childList = node.getChildNodes();
            result = null;
            for (int i = 0; i < childList.getLength(); ++i) {
                Node child = childList.item(i);
                if (log.isTraceEnabled()) {
                    log.trace("getAttributeOrTagValue child = {}", (Object)child.getNodeName());
                }
                if (!child.getNodeName().equals(attributeName)) continue;
                result = this.evalTagContent(child, ps, null);
                if (!log.isTraceEnabled()) continue;
                log.trace("getAttributeOrTagValue result from child = {}", (Object)result);
            }
        } else {
            result = m.getNodeValue();
        }
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.getAttributeOrTagValue (), returning: {}", (Object)result);
        }
        return result;
    }

    private String sraix(Node node, ParseState ps) {
        Set<String> attributeNames = Utilities.stringSet("botid", "host");
        String host = this.getAttributeOrTagValue(node, ps, "host");
        String botid = this.getAttributeOrTagValue(node, ps, "botid");
        String hint = this.getAttributeOrTagValue(node, ps, "hint");
        String limit = this.getAttributeOrTagValue(node, ps, "limit");
        String defaultResponse = this.getAttributeOrTagValue(node, ps, "default");
        String evalResult = this.evalTagContent(node, ps, attributeNames);
        return Sraix.sraix(ps.getChatSession(), ps.getChatSession().getBot(), evalResult, defaultResponse, hint, host, botid, null, limit);
    }

    private String map(Node node, ParseState ps) {
        String result = "unknown";
        Set<String> attributeNames = Utilities.stringSet("name");
        String mapName = this.getAttributeOrTagValue(node, ps, "name");
        String contents = this.evalTagContent(node, ps, attributeNames);
        contents = contents.trim();
        if (mapName == null) {
            result = "<map>" + contents + "</map>";
        } else {
            AIMLMap map = ps.getChatSession().getBot().getMapMap().get(mapName);
            if (map != null) {
                result = map.get(contents.toUpperCase());
            }
            if (log.isTraceEnabled()) {
                log.trace("AIMLProcessor map {} ", (Object)result);
            }
            if (result == null) {
                result = "unknown";
            }
            result = result.trim();
        }
        return result;
    }

    private String set(Node node, ParseState ps) {
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.set(node: {}, ps: {})", (Object)node, (Object)ps);
        }
        Set<String> attributeNames = Utilities.stringSet("name", "var");
        String predicateName = this.getAttributeOrTagValue(node, ps, "name");
        String varName = this.getAttributeOrTagValue(node, ps, "var");
        String result = this.evalTagContent(node, ps, attributeNames).trim();
        result = result.replaceAll("(\r\n|\n\r|\r|\n)", " ");
        String value = result.trim();
        if (predicateName != null) {
            ps.getChatSession().getPredicates().put(predicateName, result);
            if (log.isTraceEnabled()) {
                log.trace("Set predicate {} to {} in {}", new Object[]{predicateName, result, ps.getLeaf().getCategory().inputThatTopic()});
            }
        }
        if (varName != null) {
            ps.getVars().put(varName, result);
            if (log.isTraceEnabled()) {
                log.trace("Set var {} to {} in {}", new Object[]{varName, value, ps.getLeaf().getCategory().inputThatTopic()});
            }
        }
        if (ps.getChatSession().getBot().getPronounSet().contains(predicateName)) {
            result = predicateName;
        }
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.set, returning: {}", (Object)result);
        }
        return result;
    }

    private String get(Node node, ParseState ps) {
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.get(node: {}, ps: {})", (Object)node, (Object)ps);
        }
        String result = "unknown";
        String predicateName = this.getAttributeOrTagValue(node, ps, "name");
        String varName = this.getAttributeOrTagValue(node, ps, "var");
        String tupleName = this.getAttributeOrTagValue(node, ps, "tuple");
        if (predicateName != null) {
            result = ps.getChatSession().getPredicates().get(predicateName).trim();
        } else if (varName != null && tupleName != null) {
            result = this.tupleGet(tupleName, varName);
        } else if (varName != null) {
            result = ps.getVars().get(varName).trim();
        }
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.get, returning: {}", (Object)result);
        }
        return result;
    }

    private String tupleGet(String tupleName, String varName) {
        Tuple tuple = this.tupleMap.get(tupleName);
        return tuple == null ? "unknown" : tuple.getValue(varName);
    }

    private String bot(Node node, ParseState ps) {
        String result = "unknown";
        String propertyName = this.getAttributeOrTagValue(node, ps, "name");
        if (propertyName != null) {
            result = ps.getChatSession().getBot().getProperties().get(propertyName).trim();
        }
        return result;
    }

    private String date(Node node, ParseState ps) {
        String jformat = this.getAttributeOrTagValue(node, ps, "jformat");
        String locale = this.getAttributeOrTagValue(node, ps, "locale");
        String timezone = this.getAttributeOrTagValue(node, ps, "timezone");
        return CalendarUtils.date(jformat, locale, timezone);
    }

    private String interval(Node node, ParseState ps) {
        String style = this.getAttributeOrTagValue(node, ps, "style");
        String jformat = this.getAttributeOrTagValue(node, ps, "jformat");
        String from = this.getAttributeOrTagValue(node, ps, "from");
        String to = this.getAttributeOrTagValue(node, ps, "to");
        if (style == null) {
            style = "years";
        }
        if (jformat == null) {
            jformat = "MMMMMMMMM dd, yyyy";
        }
        if (from == null) {
            from = "January 1, 1970";
        }
        if (to == null) {
            to = CalendarUtils.date(jformat, null, null);
        }
        String result = "unknown";
        if ("years".equals(style)) {
            result = "" + IntervalUtils.getYearsBetween(from, to, jformat);
        }
        if ("months".equals(style)) {
            result = "" + IntervalUtils.getMonthsBetween(from, to, jformat);
        }
        if ("days".equals(style)) {
            result = "" + IntervalUtils.getDaysBetween(from, to, jformat);
        }
        if ("hours".equals(style)) {
            result = "" + IntervalUtils.getHoursBetween(from, to, jformat);
        }
        return result;
    }

    private int getIndexValue(Node node, ParseState ps) {
        String value = this.getAttributeOrTagValue(node, ps, "index");
        if (value != null) {
            try {
                return Integer.parseInt(value) - 1;
            }
            catch (Exception e) {
                log.error("Error: ", (Throwable)e);
            }
        }
        return 0;
    }

    private String inputStar(Node node, ParseState ps) {
        int index = this.getIndexValue(node, ps);
        if (ps.getStarBindings().getInputStars().star(index) == null) {
            return "";
        }
        return ps.getStarBindings().getInputStars().star(index).trim();
    }

    private String thatStar(Node node, ParseState ps) {
        int index = this.getIndexValue(node, ps);
        if (ps.getStarBindings().getThatStars().star(index) == null) {
            return "";
        }
        return ps.getStarBindings().getThatStars().star(index).trim();
    }

    private String topicStar(Node node, ParseState ps) {
        int index = this.getIndexValue(node, ps);
        if (ps.getStarBindings().getTopicStars().star(index) == null) {
            return "";
        }
        return ps.getStarBindings().getTopicStars().star(index).trim();
    }

    private static String id(ParseState ps) {
        return ps.getChatSession().getCustomerId();
    }

    private static String size(ParseState ps) {
        int size = ps.getChatSession().getBot().getBrain().getCategories().size();
        return String.valueOf(size);
    }

    private static String vocabulary(ParseState ps) {
        int size = ps.getChatSession().getBot().getBrain().getVocabulary().size();
        return String.valueOf(size);
    }

    private String program() {
        return this.bot.getConfiguration().getProgramName();
    }

    private String that(Node node, ParseState ps) {
        int index = 0;
        int jndex = 0;
        String value = this.getAttributeOrTagValue(node, ps, "index");
        if (value != null) {
            try {
                String[] spair = value.split(",");
                index = Integer.parseInt(spair[0]) - 1;
                jndex = Integer.parseInt(spair[1]) - 1;
                log.debug("That index={},{}", (Object)index, (Object)jndex);
            }
            catch (Exception e) {
                log.error("Error: ", (Throwable)e);
            }
        }
        String that = "unknown";
        History hist = ps.getChatSession().getThatHistory().get(index);
        if (hist != null) {
            that = (String)hist.get(jndex);
        }
        return that.trim();
    }

    private String input(Node node, ParseState ps) {
        int index = this.getIndexValue(node, ps);
        return ps.getChatSession().getInputHistory().getString(index);
    }

    private String request(Node node, ParseState ps) {
        int index = this.getIndexValue(node, ps);
        return ps.getChatSession().getRequestHistory().getString(index).trim();
    }

    private String response(Node node, ParseState ps) {
        int index = this.getIndexValue(node, ps);
        return ps.getChatSession().getResponseHistory().getString(index).trim();
    }

    private String system(Node node, ParseState ps) {
        if (!this.bot.getConfiguration().isEnableSystemTag()) {
            return "";
        }
        Set<String> attributeNames = Utilities.stringSet("timeout");
        String evaluatedContents = this.evalTagContent(node, ps, attributeNames);
        return IOUtils.system(evaluatedContents, this.bot.getConfiguration().getLanguage().getSystemFailed());
    }

    private String think(Node node, ParseState ps) {
        this.evalTagContent(node, ps, null);
        return "";
    }

    private String explode(Node node, ParseState ps) {
        String result = this.evalTagContent(node, ps, null);
        return AIMLProcessor.explode(result);
    }

    private String normalize(Node node, ParseState ps) {
        String result = this.evalTagContent(node, ps, null);
        return ps.getChatSession().getBot().getPreProcessor().normalize(result);
    }

    private String denormalize(Node node, ParseState ps) {
        String result = this.evalTagContent(node, ps, null);
        return ps.getChatSession().getBot().getPreProcessor().denormalize(result);
    }

    private String uppercase(Node node, ParseState ps) {
        String result = this.evalTagContent(node, ps, null);
        return result.toUpperCase();
    }

    private String lowercase(Node node, ParseState ps) {
        String result = this.evalTagContent(node, ps, null);
        return result.toLowerCase();
    }

    private String formal(Node node, ParseState ps) {
        String result = this.evalTagContent(node, ps, null);
        return AIMLProcessor.capitalizeString(result);
    }

    private String sentence(Node node, ParseState ps) {
        String result = this.evalTagContent(node, ps, null);
        if (result.length() > 1) {
            return result.substring(0, 1).toUpperCase() + result.substring(1, result.length());
        }
        return "";
    }

    private String person(Node node, ParseState ps) {
        String result = node.hasChildNodes() ? this.evalTagContent(node, ps, null) : ps.getStarBindings().getInputStars().star(0);
        result = " " + result + " ";
        result = ps.getChatSession().getBot().getPreProcessor().person(result);
        return result.trim();
    }

    private String person2(Node node, ParseState ps) {
        String result = node.hasChildNodes() ? this.evalTagContent(node, ps, null) : ps.getStarBindings().getInputStars().star(0);
        result = " " + result + " ";
        result = ps.getChatSession().getBot().getPreProcessor().person2(result);
        return result.trim();
    }

    private String gender(Node node, ParseState ps) {
        String result = this.evalTagContent(node, ps, null);
        result = " " + result + " ";
        result = ps.getChatSession().getBot().getPreProcessor().gender(result);
        return result.trim();
    }

    private String random(Node node, ParseState ps) {
        NodeList childList = node.getChildNodes();
        ArrayList<Node> liList = new ArrayList<Node>();
        for (int i = 0; i < childList.getLength(); ++i) {
            if (!childList.item(i).getNodeName().equals("li")) continue;
            liList.add(childList.item(i));
        }
        int index = (int)(Math.random() * (double)liList.size());
        if (ps.getChatSession() != null && ps.getChatSession().getBot().getConfiguration().isQaTestMode()) {
            index = 0;
        }
        return this.evalTagContent((Node)liList.get(index), ps, null);
    }

    private String unevaluatedAIML(Node node, ParseState ps) {
        String result = this.learnEvalTagContent(node, ps);
        return AIMLProcessor.unevaluatedXML(result, node, ps);
    }

    private String recursLearn(Node node, ParseState ps) {
        String nodeName = node.getNodeName();
        if ("#text".equals(nodeName)) {
            return node.getNodeValue();
        }
        if ("eval".equals(nodeName)) {
            return this.evalTagContent(node, ps, null);
        }
        return this.unevaluatedAIML(node, ps);
    }

    private String learnEvalTagContent(Node node, ParseState ps) {
        NodeList childList = node.getChildNodes();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            result.append(this.recursLearn(child, ps));
        }
        return result.toString();
    }

    private String learn(Node node, ParseState ps) {
        NodeList childList = node.getChildNodes();
        String pattern = "";
        String that = "*";
        String template = "";
        for (int i = 0; i < childList.getLength(); ++i) {
            Category c;
            if (!childList.item(i).getNodeName().equals("category")) continue;
            NodeList grandChildList = childList.item(i).getChildNodes();
            for (int j = 0; j < grandChildList.getLength(); ++j) {
                if (grandChildList.item(j).getNodeName().equals("pattern")) {
                    pattern = this.recursLearn(grandChildList.item(j), ps);
                    continue;
                }
                if (grandChildList.item(j).getNodeName().equals("that")) {
                    that = this.recursLearn(grandChildList.item(j), ps);
                    continue;
                }
                if (!grandChildList.item(j).getNodeName().equals("template")) continue;
                template = this.recursLearn(grandChildList.item(j), ps);
            }
            pattern = pattern.substring("<pattern>".length(), pattern.length() - "</pattern>".length());
            if (log.isTraceEnabled()) {
                log.trace("Learn Pattern = {}", (Object)pattern);
            }
            if (template.length() >= "<template></template>".length()) {
                template = template.substring("<template>".length(), template.length() - "</template>".length());
            }
            if (that.length() >= "<that></that>".length()) {
                that = that.substring("<that>".length(), that.length() - "</that>".length());
            }
            pattern = pattern.toUpperCase();
            pattern = pattern.replaceAll("\n", " ");
            pattern = pattern.replaceAll("[ ]+", " ");
            that = that.toUpperCase();
            that = that.replaceAll("\n", " ");
            that = that.replaceAll("[ ]+", " ");
            if (log.isTraceEnabled()) {
                log.trace("Learn Pattern = {}", (Object)pattern);
                log.trace("Learn That = {}", (Object)that);
                log.trace("Learn Template = {}", (Object)template);
            }
            if (node.getNodeName().equals("learn")) {
                c = new Category(this.bot, 0, pattern, that, "*", template, "null.aiml");
                ps.getChatSession().getBot().getLearnGraph().addCategory(c);
            } else {
                c = new Category(this.bot, 0, pattern, that, "*", template, "learnf.aiml");
                ps.getChatSession().getBot().getLearnfGraph().addCategory(c);
            }
            ps.getChatSession().getBot().getBrain().addCategory(c);
        }
        return "";
    }

    private String loopCondition(Node node, ParseState ps) {
        boolean loop = true;
        StringBuilder result = new StringBuilder();
        int loopCnt = 0;
        while (loop && loopCnt < this.bot.getConfiguration().getMaxLoops()) {
            String loopResult = this.condition(node, ps);
            String tooMuch = this.bot.getConfiguration().getLanguage().getTooMuchRecursion();
            if (loopResult.trim().equals(tooMuch)) {
                return tooMuch;
            }
            if (loopResult.contains("<loop/>")) {
                loopResult = loopResult.replace("<loop/>", "");
                loop = true;
            } else {
                loop = false;
            }
            result.append(loopResult);
        }
        return loopCnt >= this.bot.getConfiguration().getMaxLoops() ? this.bot.getConfiguration().getLanguage().getTooMuchLooping() : result.toString();
    }

    private String condition(Node node, ParseState ps) {
        String value;
        NodeList childList = node.getChildNodes();
        ArrayList<Node> liList = new ArrayList<Node>();
        Set<String> attributeNames = Utilities.stringSet("name", "var", "value");
        String predicate = this.getAttributeOrTagValue(node, ps, "name");
        String varName = this.getAttributeOrTagValue(node, ps, "var");
        for (int i = 0; i < childList.getLength(); ++i) {
            if (!childList.item(i).getNodeName().equals("li")) continue;
            liList.add(childList.item(i));
        }
        if (liList.size() == 0 && (value = this.getAttributeOrTagValue(node, ps, "value")) != null && predicate != null && ps.getChatSession().getPredicates().get(predicate).equalsIgnoreCase(value)) {
            return this.evalTagContent(node, ps, attributeNames);
        }
        if (liList.size() == 0 && (value = this.getAttributeOrTagValue(node, ps, "value")) != null && varName != null && ps.getVars().get(varName).equalsIgnoreCase(value)) {
            return this.evalTagContent(node, ps, attributeNames);
        }
        for (Node n : liList) {
            String liPredicate = predicate;
            String liVarName = varName;
            if (liPredicate == null) {
                liPredicate = this.getAttributeOrTagValue(n, ps, "name");
            }
            if (liVarName == null) {
                liVarName = this.getAttributeOrTagValue(n, ps, "var");
            }
            if ((value = this.getAttributeOrTagValue(n, ps, "value")) != null) {
                if (liPredicate != null && (ps.getChatSession().getPredicates().get(liPredicate).equalsIgnoreCase(value) || ps.getChatSession().getPredicates().containsKey(liPredicate) && value.equals("*"))) {
                    return this.evalTagContent(n, ps, attributeNames);
                }
                if (liVarName == null || !ps.getVars().get(liVarName).equalsIgnoreCase(value) && (!ps.getVars().containsKey(liPredicate) || !value.equals("*"))) continue;
                return this.evalTagContent(n, ps, attributeNames);
            }
            return this.evalTagContent(n, ps, attributeNames);
        }
        return "";
    }

    public static boolean evalTagForLoop(Node node) {
        NodeList childList = node.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            if (!childList.item(i).getNodeName().equals("loop")) continue;
            return true;
        }
        return false;
    }

    private String deleteTriple(Node node, ParseState ps) {
        String subject = this.getAttributeOrTagValue(node, ps, "subj");
        String predicate = this.getAttributeOrTagValue(node, ps, "pred");
        String object = this.getAttributeOrTagValue(node, ps, "obj");
        return ps.getChatSession().getTripleStore().deleteTriple(subject, predicate, object);
    }

    private String addTriple(Node node, ParseState ps) {
        String subject = this.getAttributeOrTagValue(node, ps, "subj");
        String predicate = this.getAttributeOrTagValue(node, ps, "pred");
        String object = this.getAttributeOrTagValue(node, ps, "obj");
        return ps.getChatSession().getTripleStore().addTriple(subject, predicate, object);
    }

    private String uniq(Node node, ParseState ps) {
        HashSet<String> vars = new HashSet<String>();
        HashSet<String> visibleVars = new HashSet<String>();
        String subj = "?subject";
        String pred = "?predicate";
        String obj = "?object";
        NodeList childList = node.getChildNodes();
        for (int j = 0; j < childList.getLength(); ++j) {
            Node childNode = childList.item(j);
            String contents = this.evalTagContent(childNode, ps, null);
            if (childNode.getNodeName().equals("subj")) {
                subj = contents;
            } else if (childNode.getNodeName().equals("pred")) {
                pred = contents;
            } else if (childNode.getNodeName().equals("obj")) {
                obj = contents;
            }
            if (!contents.startsWith("?")) continue;
            visibleVars.add(contents);
            vars.add(contents);
        }
        Tuple partial = this.storeTuple(new Tuple(vars, visibleVars));
        Clause clause = new Clause(subj, pred, obj);
        Set<Tuple> tuples = ps.getChatSession().getTripleStore().selectFromSingleClause(partial, clause, true);
        String tupleList = tuples.stream().map(Tuple::getName).collect(Collectors.joining(" "));
        if (tupleList.length() == 0) {
            tupleList = "NIL";
        }
        String var = "";
        Iterator<String> iterator = visibleVars.iterator();
        while (iterator.hasNext()) {
            String x;
            var = x = iterator.next();
        }
        String firstTuple = AIMLProcessor.firstWord(tupleList);
        return this.tupleGet(firstTuple, var);
    }

    public Tuple storeTuple(Tuple tuple) {
        this.tupleMap.put(tuple.getName(), tuple);
        return tuple;
    }

    public String select(Node node, ParseState ps) {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        NodeList childList = node.getChildNodes();
        HashSet<String> vars = new HashSet<String>();
        HashSet<String> visibleVars = new HashSet<String>();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node childNode = childList.item(i);
            if (childNode.getNodeName().equals("vars")) {
                String[] splitVars;
                String contents = this.evalTagContent(childNode, ps, null);
                for (String var : splitVars = contents.split(" ")) {
                    if ((var = var.trim()).length() <= 0) continue;
                    visibleVars.add(var);
                }
                continue;
            }
            if (!childNode.getNodeName().equals("q") && !childNode.getNodeName().equals("notq")) continue;
            Boolean affirm = !childNode.getNodeName().equals("notq");
            NodeList grandChildList = childNode.getChildNodes();
            String subj = null;
            String pred = null;
            String obj = null;
            for (int j = 0; j < grandChildList.getLength(); ++j) {
                Node grandChildNode = grandChildList.item(j);
                String contents = this.evalTagContent(grandChildNode, ps, null);
                if (grandChildNode.getNodeName().equals("subj")) {
                    subj = contents;
                } else if (grandChildNode.getNodeName().equals("pred")) {
                    pred = contents;
                } else if (grandChildNode.getNodeName().equals("obj")) {
                    obj = contents;
                }
                if (!contents.startsWith("?")) continue;
                vars.add(contents);
            }
            clauses.add(new Clause(subj, pred, obj, affirm));
        }
        Set<Tuple> tuples = ps.getChatSession().getTripleStore().select(vars, visibleVars, clauses);
        String result = tuples.stream().map(Tuple::getName).collect(Collectors.joining(" "));
        if (result.length() == 0) {
            result = "NIL";
        }
        return result;
    }

    public String subject(Node node, ParseState ps) {
        String id = this.evalTagContent(node, ps, null);
        TripleStore ts = ps.getChatSession().getTripleStore();
        String subject = "unknown";
        if (ts.getIdTriple().containsKey(id)) {
            subject = ts.getIdTriple().get(id).getSubject();
        }
        return subject;
    }

    public String predicate(Node node, ParseState ps) {
        String id = this.evalTagContent(node, ps, null);
        TripleStore ts = ps.getChatSession().getTripleStore();
        if (ts.getIdTriple().containsKey(id)) {
            return ts.getIdTriple().get(id).getPredicate();
        }
        return "unknown";
    }

    public String object(Node node, ParseState ps) {
        String id = this.evalTagContent(node, ps, null);
        TripleStore ts = ps.getChatSession().getTripleStore();
        if (ts.getIdTriple().containsKey(id)) {
            return ts.getIdTriple().get(id).getObject();
        }
        return "unknown";
    }

    public String javascript(Node node, ParseState ps) {
        String result = "JSFAILED";
        String script = this.evalTagContent(node, ps, null);
        try {
            result = IOUtils.evalScript("JavaScript", script);
        }
        catch (Exception e) {
            log.error("JavaScript error:", (Throwable)e);
        }
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.javascript, returning result: {}", (Object)result);
        }
        return result;
    }

    private static String firstWord(String sentence) {
        String content = sentence == null ? "" : sentence;
        if ((content = content.trim()).contains(" ")) {
            return content.substring(0, content.indexOf(" "));
        }
        if (content.length() > 0) {
            return content;
        }
        return "NIL";
    }

    private static String restWords(String sentence) {
        String content = sentence == null ? "" : sentence;
        if ((content = content.trim()).contains(" ")) {
            return content.substring(content.indexOf(" ") + 1, content.length());
        }
        return "NIL";
    }

    public String first(Node node, ParseState ps) {
        String content = this.evalTagContent(node, ps, null);
        return AIMLProcessor.firstWord(content);
    }

    public String rest(Node node, ParseState ps) {
        String content = this.evalTagContent(node, ps, null);
        content = ps.getChatSession().getBot().getPreProcessor().normalize(content);
        return AIMLProcessor.restWords(content);
    }

    private static String resetlearnf(ParseState ps) {
        ps.getChatSession().getBot().deleteLearnfCategories();
        return "Deleted Learnf Categories";
    }

    private static String resetlearn(ParseState ps) {
        ps.getChatSession().getBot().deleteLearnCategories();
        return "Deleted Learn Categories";
    }

    private String recursEval(Node node, ParseState ps) {
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.recursEval(node: {}, ps: {})", (Object)node, (Object)ps);
        }
        try {
            String nodeName;
            switch (nodeName = node.getNodeName()) {
                case "#text": {
                    return node.getNodeValue();
                }
                case "#comment": {
                    return "";
                }
                case "template": {
                    return this.evalTagContent(node, ps, null);
                }
                case "random": {
                    return this.random(node, ps);
                }
                case "condition": {
                    return this.loopCondition(node, ps);
                }
                case "srai": {
                    return this.srai(node, ps);
                }
                case "sr": {
                    return this.respond(ps.getStarBindings().getInputStars().star(0), ps.getThat(), ps.getTopic(), ps.getChatSession(), this.sraiCount);
                }
                case "sraix": {
                    return this.sraix(node, ps);
                }
                case "set": {
                    return this.set(node, ps);
                }
                case "get": {
                    return this.get(node, ps);
                }
                case "map": {
                    return this.map(node, ps);
                }
                case "bot": {
                    return this.bot(node, ps);
                }
                case "id": {
                    return AIMLProcessor.id(ps);
                }
                case "size": {
                    return AIMLProcessor.size(ps);
                }
                case "vocabulary": {
                    return AIMLProcessor.vocabulary(ps);
                }
                case "program": {
                    return this.program();
                }
                case "date": {
                    return this.date(node, ps);
                }
                case "interval": {
                    return this.interval(node, ps);
                }
                case "think": {
                    return this.think(node, ps);
                }
                case "system": {
                    return this.system(node, ps);
                }
                case "explode": {
                    return this.explode(node, ps);
                }
                case "normalize": {
                    return this.normalize(node, ps);
                }
                case "denormalize": {
                    return this.denormalize(node, ps);
                }
                case "uppercase": {
                    return this.uppercase(node, ps);
                }
                case "lowercase": {
                    return this.lowercase(node, ps);
                }
                case "formal": {
                    return this.formal(node, ps);
                }
                case "sentence": {
                    return this.sentence(node, ps);
                }
                case "person": {
                    return this.person(node, ps);
                }
                case "person2": {
                    return this.person2(node, ps);
                }
                case "gender": {
                    return this.gender(node, ps);
                }
                case "star": {
                    return this.inputStar(node, ps);
                }
                case "thatstar": {
                    return this.thatStar(node, ps);
                }
                case "topicstar": {
                    return this.topicStar(node, ps);
                }
                case "that": {
                    return this.that(node, ps);
                }
                case "input": {
                    return this.input(node, ps);
                }
                case "request": {
                    return this.request(node, ps);
                }
                case "response": {
                    return this.response(node, ps);
                }
                case "learn": 
                case "learnf": {
                    return this.learn(node, ps);
                }
                case "addtriple": {
                    return this.addTriple(node, ps);
                }
                case "deletetriple": {
                    return this.deleteTriple(node, ps);
                }
                case "javascript": {
                    return this.javascript(node, ps);
                }
                case "select": {
                    return this.select(node, ps);
                }
                case "uniq": {
                    return this.uniq(node, ps);
                }
                case "first": {
                    return this.first(node, ps);
                }
                case "rest": {
                    return this.rest(node, ps);
                }
                case "resetlearnf": {
                    return AIMLProcessor.resetlearnf(ps);
                }
                case "resetlearn": {
                    return AIMLProcessor.resetlearn(ps);
                }
            }
            if (this.extensions != null) {
                for (AIMLProcessorExtension extension : this.extensions) {
                    if (extension == null || !extension.extensionTagSet().contains(nodeName)) continue;
                    return extension.recursEval(node, ps);
                }
            }
            return this.genericXML(node, ps);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return "";
        }
    }

    private String evalTemplate(String template, ParseState ps) {
        try {
            template = "<template>" + template + "</template>";
            Node root = DomUtils.parseString(template);
            return this.recursEval(root, ps);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return this.bot.getConfiguration().getLanguage().getTemplateFailed();
        }
    }

    public static boolean validTemplate(String template) {
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.validTemplate(template: {})", (Object)template);
        }
        try {
            template = "<template>" + template + "</template>";
            DomUtils.parseString(template);
            return true;
        }
        catch (Exception e) {
            log.error("Invalid Template {}", (Object)template, (Object)e);
            return false;
        }
    }

    public void registerExtension(AIMLProcessorExtension extension) {
        this.extensions.add(extension);
        extension.setProcessor(this);
    }
}

