// Generated by delombok at Sun Feb 11 15:14:05 SAMT 2018
/* Program AB Reference AIML 2.0 implementation
        Copyright (C) 2013 ALICE A.I. Foundation
        Contact: info@alicebot.org

        This library is free software; you can redistribute it and/or
        modify it under the terms of the GNU Library General Public
        License as published by the Free Software Foundation; either
        version 2 of the License, or (at your option) any later version.

        This library is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
        Library General Public License for more details.

        You should have received a copy of the GNU Library General Public
        License along with this library; if not, write to the
        Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
        Boston, MA  02110-1301, USA.
*/
package org.alicebot.ab.model;

import org.alicebot.ab.Chat;

/**
 * ParseState is a helper class for AIMLProcessor
 */
public class ParseState {
    private Nodemapper leaf;
    private String input;
    private String that;
    private String topic;
    private Chat chatSession;
    private int depth;
    private Predicates vars;
    private StarBindings starBindings;

    /**
     * Constructor - class has public members

     *

     * @param depth       depth in parse tree

     * @param chatSession client session

     * @param input       client input

     * @param that        bot's last sentence

     * @param topic       current topic

     * @param leaf        node containing the category processed
     */
    public ParseState(int depth, Chat chatSession, String input, String that, String topic, Nodemapper leaf) {
        this.chatSession = chatSession;
        this.input = input;
        this.that = that;
        this.topic = topic;
        this.leaf = leaf;
        this.depth = depth; // to prevent runaway recursion
        this.vars = new Predicates(chatSession.getBot());
        this.starBindings = leaf.getStarBindings();
    }

    @java.lang.SuppressWarnings("all")
    public Nodemapper getLeaf() {
        return this.leaf;
    }

    @java.lang.SuppressWarnings("all")
    public String getInput() {
        return this.input;
    }

    @java.lang.SuppressWarnings("all")
    public String getThat() {
        return this.that;
    }

    @java.lang.SuppressWarnings("all")
    public String getTopic() {
        return this.topic;
    }

    @java.lang.SuppressWarnings("all")
    public Chat getChatSession() {
        return this.chatSession;
    }

    @java.lang.SuppressWarnings("all")
    public int getDepth() {
        return this.depth;
    }

    @java.lang.SuppressWarnings("all")
    public Predicates getVars() {
        return this.vars;
    }

    @java.lang.SuppressWarnings("all")
    public StarBindings getStarBindings() {
        return this.starBindings;
    }

    @java.lang.SuppressWarnings("all")
    public void setLeaf(final Nodemapper leaf) {
        this.leaf = leaf;
    }

    @java.lang.SuppressWarnings("all")
    public void setInput(final String input) {
        this.input = input;
    }

    @java.lang.SuppressWarnings("all")
    public void setThat(final String that) {
        this.that = that;
    }

    @java.lang.SuppressWarnings("all")
    public void setTopic(final String topic) {
        this.topic = topic;
    }

    @java.lang.SuppressWarnings("all")
    public void setChatSession(final Chat chatSession) {
        this.chatSession = chatSession;
    }

    @java.lang.SuppressWarnings("all")
    public void setDepth(final int depth) {
        this.depth = depth;
    }

    @java.lang.SuppressWarnings("all")
    public void setVars(final Predicates vars) {
        this.vars = vars;
    }

    @java.lang.SuppressWarnings("all")
    public void setStarBindings(final StarBindings starBindings) {
        this.starBindings = starBindings;
    }
}
