/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.utils;

import java.util.stream.Collectors;
import net.reduls.sanmoku.Tagger;
import org.alicebot.ab.AIMLProcessor;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.utils.DomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JapaneseUtils {
    private static final Logger log = LoggerFactory.getLogger(JapaneseUtils.class);

    private static String tokenizeFragment(String fragment) {
        if (log.isDebugEnabled()) {
            log.debug("buildFragment: {}", (Object)fragment);
        }
        return Tagger.parse((String)fragment).stream().map(e -> e.surface).collect(Collectors.joining(" "));
    }

    public static String tokenizeSentence(String sentence) {
        if (log.isDebugEnabled()) {
            log.debug("tokenizeSentence: {}", (Object)sentence);
        }
        if (!MagicBooleans.jp_tokenize) {
            return sentence;
        }
        String result = "";
        result = JapaneseUtils.tokenizeXML(sentence);
        while (result.contains("$ ")) {
            result = result.replace("$ ", "$");
        }
        while (result.contains("  ")) {
            result = result.replace("  ", " ");
        }
        while (result.contains("anon ")) {
            result = result.replace("anon ", "anon");
        }
        result = result.trim();
        if (log.isTraceEnabled()) {
            log.trace("tokenizeSentence: {} --> result: {}", (Object)sentence, (Object)result);
        }
        return result;
    }

    private static String tokenizeXML(String xmlExpression) {
        if (log.isDebugEnabled()) {
            log.debug("tokenizeXML: {}", (Object)xmlExpression);
        }
        String response = MagicStrings.template_failed;
        try {
            xmlExpression = "<sentence>" + xmlExpression + "</sentence>";
            Node root = DomUtils.parseString(xmlExpression);
            response = JapaneseUtils.recursEval(root);
        }
        catch (Exception e) {
            log.error("Error:", (Throwable)e);
        }
        return AIMLProcessor.trimTag(response, "sentence");
    }

    private static String recursEval(Node node) {
        try {
            String nodeName = node.getNodeName();
            if (log.isDebugEnabled()) {
                log.debug("recursEval: {}", (Object)nodeName);
            }
            switch (nodeName) {
                case "#text": {
                    return JapaneseUtils.tokenizeFragment(node.getNodeValue());
                }
                case "sentence": {
                    return JapaneseUtils.evalTagContent(node);
                }
            }
            return JapaneseUtils.genericXML(node);
        }
        catch (Exception e) {
            log.debug("recursEval failed", (Throwable)e);
            return "JP Morph Error";
        }
    }

    private static String genericXML(Node node) {
        if (log.isDebugEnabled()) {
            log.debug("genericXML: {}", (Object)node.getNodeName());
        }
        String result = JapaneseUtils.evalTagContent(node);
        return JapaneseUtils.unevaluatedXML(result, node);
    }

    private static String evalTagContent(Node node) {
        if (log.isDebugEnabled()) {
            log.debug("evalTagContent: {}", (Object)node.getNodeName());
        }
        StringBuilder result = new StringBuilder();
        try {
            NodeList childList = node.getChildNodes();
            for (int i = 0; i < childList.getLength(); ++i) {
                Node child = childList.item(i);
                result.append(JapaneseUtils.recursEval(child));
            }
        }
        catch (Exception e) {
            log.warn("Something went wrong with evalTagContent", (Throwable)e);
        }
        return result.toString();
    }

    private static String unevaluatedXML(String result, Node node) {
        String nodeName = node.getNodeName();
        StringBuilder attributes = new StringBuilder();
        if (node.hasAttributes()) {
            NamedNodeMap XMLAttributes = node.getAttributes();
            for (int i = 0; i < XMLAttributes.getLength(); ++i) {
                attributes.append(" ").append(XMLAttributes.item(i).getNodeName()).append("=\"").append(XMLAttributes.item(i).getNodeValue()).append("\"");
            }
        }
        if ("".equals(result)) {
            return " <" + nodeName + attributes + "/> ";
        }
        return " <" + nodeName + attributes + ">" + result + "</" + nodeName + "> ";
    }
}

