/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab.utils;

import org.joda.time.Chronology;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.chrono.LenientChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalUtils {
    private static final Logger log = LoggerFactory.getLogger(IntervalUtils.class);

    public static int getHoursBetween(String date1, String date2, String format) {
        try {
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)format).withChronology((Chronology)LenientChronology.getInstance((Chronology)GregorianChronology.getInstance()));
            return Hours.hoursBetween((ReadableInstant)fmt.parseDateTime(date1), (ReadableInstant)fmt.parseDateTime(date2)).getHours();
        }
        catch (Exception e) {
            log.error("getHoursBetween(date1=[{}], date2=[{}], format=[{}]) caused error", new Object[]{date1, date2, format, e});
            return 0;
        }
    }

    public static int getYearsBetween(String date1, String date2, String format) {
        try {
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)format).withChronology((Chronology)LenientChronology.getInstance((Chronology)GregorianChronology.getInstance()));
            return Years.yearsBetween((ReadableInstant)fmt.parseDateTime(date1), (ReadableInstant)fmt.parseDateTime(date2)).getYears();
        }
        catch (Exception e) {
            log.error("getYearsBetween(date1=[{}], date2=[{}], format=[{}]) caused error", new Object[]{date1, date2, format, e});
            return 0;
        }
    }

    public static int getMonthsBetween(String date1, String date2, String format) {
        try {
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)format).withChronology((Chronology)LenientChronology.getInstance((Chronology)GregorianChronology.getInstance()));
            return Months.monthsBetween((ReadableInstant)fmt.parseDateTime(date1), (ReadableInstant)fmt.parseDateTime(date2)).getMonths();
        }
        catch (Exception e) {
            log.error("getMonthsBetween(date1=[{}], date2=[{}], format=[{}]) caused error", new Object[]{date1, date2, format, e});
            return 0;
        }
    }

    public static int getDaysBetween(String date1, String date2, String format) {
        try {
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)format).withChronology((Chronology)LenientChronology.getInstance((Chronology)GregorianChronology.getInstance()));
            return Days.daysBetween((ReadableInstant)fmt.parseDateTime(date1), (ReadableInstant)fmt.parseDateTime(date2)).getDays();
        }
        catch (Exception e) {
            log.error("getDaysBetween(date1=[{}], date2=[{}], format=[{}]) caused error", new Object[]{date1, date2, format, e});
            return 0;
        }
    }
}

