/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.alicebot.ab.Bot;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.utils.CalendarUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utilities {
    private static final Logger log = LoggerFactory.getLogger(Utilities.class);

    public static String fixCSV(String line) {
        while (line.endsWith(";")) {
            line = line.substring(0, line.length() - 1);
        }
        if (line.startsWith("\"")) {
            line = line.substring(1, line.length());
        }
        if (line.endsWith("\"")) {
            line = line.substring(0, line.length() - 1);
        }
        return line.replaceAll("\"\"", "\"");
    }

    public static String tagTrim(String xmlExpression, String tagName) {
        String stag = "<" + tagName + ">";
        String etag = "</" + tagName + ">";
        if (xmlExpression.length() >= (stag + etag).length()) {
            xmlExpression = xmlExpression.substring(stag.length());
            xmlExpression = xmlExpression.substring(0, xmlExpression.length() - etag.length());
        }
        return xmlExpression;
    }

    public static Set<String> stringSet(String ... strings) {
        return new HashSet<String>(Arrays.asList(strings));
    }

    public static String getFileFromInputStream(InputStream in) {
        StringBuilder contents = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String strLine;
            while ((strLine = reader.readLine()) != null) {
                if (strLine.startsWith(MagicStrings.text_comment_mark)) continue;
                if (strLine.length() != 0) {
                    contents.append(strLine);
                }
                contents.append("\n");
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return contents.toString().trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFile(String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) return "";
            try (FileInputStream stream = new FileInputStream(filename);){
                String string = Utilities.getFileFromInputStream(stream);
                return string;
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return "";
    }

    public static String getCopyrightFromInputStream(InputStream in) {
        StringBuilder copyright = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String strLine;
            while ((strLine = reader.readLine()) != null) {
                if (strLine.length() != 0) {
                    copyright.append("<!-- ").append(strLine).append(" -->");
                }
                copyright.append("\n");
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return copyright.toString();
    }

    public static String getCopyright(Bot bot, String AIMLFilename) {
        String copyright = "";
        String year = CalendarUtils.year();
        String date = CalendarUtils.date();
        try {
            copyright = Utilities.getFile(bot.getConfigPath() + "/copyright.txt");
            String[] splitCopyright = copyright.split("\n");
            copyright = "";
            StringBuilder builder = new StringBuilder();
            for (String part : splitCopyright) {
                builder.append("<!-- ").append(part).append(" -->\n");
            }
            copyright = builder.toString();
            copyright = copyright.replace("[url]", bot.getProperties().get("url"));
            copyright = copyright.replace("[date]", date);
            copyright = copyright.replace("[YYYY]", year);
            copyright = copyright.replace("[version]", bot.getProperties().get("version"));
            copyright = copyright.replace("[botname]", bot.getName().toUpperCase());
            copyright = copyright.replace("[filename]", AIMLFilename);
            copyright = copyright.replace("[botmaster]", bot.getProperties().get("botmaster"));
            copyright = copyright.replace("[organization]", bot.getProperties().get("organization"));
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return copyright;
    }

    public static String getPannousAPIKey(Bot bot) {
        String apiKey = Utilities.getFile(bot.getConfigPath() + "/pannous-apikey.txt");
        return StringUtils.isEmpty((CharSequence)apiKey) ? MagicStrings.pannous_api_key : apiKey;
    }

    public static String getPannousLogin(Bot bot) {
        String login = Utilities.getFile(bot.getConfigPath() + "/pannous-login.txt");
        return StringUtils.isEmpty((CharSequence)login) ? MagicStrings.pannous_login : login;
    }

    public static boolean isCharCJK(char c) {
        return Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT || Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || Character.UnicodeBlock.of(c) == Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS;
    }
}

