/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alicebot.ab.Bot;
import org.alicebot.ab.Chat;
import org.alicebot.ab.Clause;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.TestAB;
import org.alicebot.ab.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripleStore {
    private static final Logger log = LoggerFactory.getLogger(TestAB.class);
    private int idCnt = 0;
    private String name = "unknown";
    private Chat chatSession;
    private Bot bot;
    private Map<String, Triple> idTriple = new HashMap<String, Triple>();
    private Map<String, String> tripleStringId = new HashMap<String, String>();
    private Map<String, Set<String>> subjectTriples = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> predicateTriples = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> objectTriples = new HashMap<String, Set<String>>();

    public TripleStore(String name, Chat chatSession) {
        this.name = name;
        this.chatSession = chatSession;
        this.bot = chatSession.getBot();
    }

    public String mapTriple(Triple triple) {
        String id = triple.id;
        this.idTriple.put(id, triple);
        String subject = triple.subject.toUpperCase();
        String predicate = triple.predicate.toUpperCase();
        String object = triple.object.toUpperCase();
        String tripleString = subject + ":" + predicate + ":" + object;
        tripleString = tripleString.toUpperCase();
        if (this.tripleStringId.keySet().contains(tripleString)) {
            return this.tripleStringId.get(tripleString);
        }
        this.tripleStringId.put(tripleString, id);
        Set existingTriples = this.subjectTriples.getOrDefault(subject, new HashSet());
        existingTriples.add(id);
        this.subjectTriples.put(subject, existingTriples);
        existingTriples = this.predicateTriples.getOrDefault(predicate, new HashSet());
        existingTriples.add(id);
        this.predicateTriples.put(predicate, existingTriples);
        existingTriples = this.objectTriples.getOrDefault(object, new HashSet());
        existingTriples.add(id);
        this.objectTriples.put(object, existingTriples);
        return id;
    }

    public String unMapTriple(Triple triple) {
        String subject = triple.subject.toUpperCase();
        String predicate = triple.predicate.toUpperCase();
        String object = triple.object.toUpperCase();
        String tripleString = subject + ":" + predicate + ":" + object;
        log.debug("unMapTriple {}", (Object)tripleString);
        tripleString = tripleString.toUpperCase();
        triple = this.idTriple.get(this.tripleStringId.get(tripleString));
        log.debug("unMapTriple {}", (Object)triple);
        if (triple != null) {
            String id = triple.id;
            this.idTriple.remove(id);
            this.tripleStringId.remove(tripleString);
            Set existingTriples = this.subjectTriples.getOrDefault(subject, new HashSet());
            existingTriples.remove(id);
            this.subjectTriples.put(subject, existingTriples);
            existingTriples = this.predicateTriples.getOrDefault(predicate, new HashSet());
            existingTriples.remove(id);
            this.predicateTriples.put(predicate, existingTriples);
            existingTriples = this.objectTriples.getOrDefault(object, new HashSet());
            existingTriples.remove(id);
            this.objectTriples.put(object, existingTriples);
            return id;
        }
        return MagicStrings.undefined_triple;
    }

    public Set<String> allTriples() {
        return new HashSet<String>(this.idTriple.keySet());
    }

    public String addTriple(String subject, String predicate, String object) {
        if (subject == null || predicate == null || object == null) {
            return MagicStrings.undefined_triple;
        }
        Triple triple = new Triple(subject, predicate, object);
        return this.mapTriple(triple);
    }

    public String deleteTriple(String subject, String predicate, String object) {
        if (subject == null || predicate == null || object == null) {
            return MagicStrings.undefined_triple;
        }
        if (log.isTraceEnabled()) {
            log.trace("Deleting {}:{}:{}", new Object[]{subject, predicate, object});
        }
        Triple triple = new Triple(subject, predicate, object);
        return this.unMapTriple(triple);
    }

    public void printTriples() {
        for (String x : this.idTriple.keySet()) {
            Triple triple = this.idTriple.get(x);
            log.info("{}:{}:{}:{}", new Object[]{x, triple.subject, triple.predicate, triple.object});
        }
    }

    private Set<String> emptySet() {
        return new HashSet<String>();
    }

    public Set<String> getTriples(String s, String p, String o) {
        if (log.isTraceEnabled()) {
            log.trace("TripleStore: getTriples [{}] {}:{}:{}", new Object[]{this.idTriple.size(), s, p, o});
        }
        Set<String> subjectSet = s == null || s.startsWith("?") ? this.allTriples() : this.subjectTriples.getOrDefault(s.toUpperCase(), this.emptySet());
        Set<String> predicateSet = p == null || p.startsWith("?") ? this.allTriples() : this.predicateTriples.getOrDefault(p.toUpperCase(), this.emptySet());
        Set<String> objectSet = o == null || o.startsWith("?") ? this.allTriples() : this.objectTriples.getOrDefault(o.toUpperCase(), this.emptySet());
        HashSet<String> resultSet = new HashSet<String>(subjectSet);
        resultSet.retainAll(predicateSet);
        resultSet.retainAll(objectSet);
        return resultSet;
    }

    public Set<String> getSubjects(Set<String> triples) {
        HashSet<String> resultSet = new HashSet<String>();
        for (String id : triples) {
            Triple triple = this.idTriple.get(id);
            resultSet.add(triple.subject);
        }
        return resultSet;
    }

    public Set<String> getPredicates(Set<String> triples) {
        HashSet<String> resultSet = new HashSet<String>();
        for (String id : triples) {
            Triple triple = this.idTriple.get(id);
            resultSet.add(triple.predicate);
        }
        return resultSet;
    }

    public Set<String> getObjects(Set<String> triples) {
        HashSet<String> resultSet = new HashSet<String>();
        for (String id : triples) {
            Triple triple = this.idTriple.get(id);
            resultSet.add(triple.object);
        }
        return resultSet;
    }

    public String getSubject(String id) {
        if (this.idTriple.containsKey(id)) {
            return this.idTriple.get(id).subject;
        }
        return "Unknown subject";
    }

    public String getPredicate(String id) {
        if (this.idTriple.containsKey(id)) {
            return this.idTriple.get(id).predicate;
        }
        return "Unknown predicate";
    }

    public String getObject(String id) {
        if (this.idTriple.containsKey(id)) {
            return this.idTriple.get(id).object;
        }
        return "Unknown object";
    }

    public String stringTriple(String id) {
        Triple triple = this.idTriple.get(id);
        return id + " " + triple.subject + " " + triple.predicate + " " + triple.object;
    }

    public void printAllTriples() {
        for (String id : this.idTriple.keySet()) {
            log.info("{}", (Object)this.stringTriple(id));
        }
    }

    public Set<Tuple> select(Set<String> vars, Set<String> visibleVars, List<Clause> clauses) {
        Set<Tuple> result = new HashSet<Tuple>();
        try {
            Tuple tuple = new Tuple(vars, visibleVars);
            result = this.selectFromRemainingClauses(tuple, clauses);
        }
        catch (Exception e) {
            log.error("Error", (Throwable)e);
        }
        return result;
    }

    public Clause adjustClause(Tuple tuple, Clause clause) {
        String value;
        Set<String> vars = tuple.getVars();
        String subj = clause.getSubj();
        String pred = clause.getPred();
        String obj = clause.getObj();
        Clause newClause = new Clause(clause);
        if (vars.contains(subj) && !(value = tuple.getValue(subj)).equals(MagicStrings.unbound_variable)) {
            newClause.setSubj(value);
        }
        if (vars.contains(pred) && !(value = tuple.getValue(pred)).equals(MagicStrings.unbound_variable)) {
            newClause.setPred(value);
        }
        if (vars.contains(obj) && !(value = tuple.getValue(obj)).equals(MagicStrings.unbound_variable)) {
            newClause.setObj(value);
        }
        return newClause;
    }

    public Tuple bindTuple(Tuple partial, String triple, Clause clause) {
        Tuple tuple = new Tuple(partial);
        if (clause.getSubj().startsWith("?")) {
            tuple.bind(clause.getSubj(), this.getSubject(triple));
        }
        if (clause.getPred().startsWith("?")) {
            tuple.bind(clause.getPred(), this.getPredicate(triple));
        }
        if (clause.getObj().startsWith("?")) {
            tuple.bind(clause.getObj(), this.getObject(triple));
        }
        return tuple;
    }

    public Set<Tuple> selectFromSingleClause(Tuple partial, Clause clause, Boolean affirm) {
        HashSet<Tuple> result = new HashSet<Tuple>();
        Set<String> triples = this.getTriples(clause.getSubj(), clause.getPred(), clause.getObj());
        if (affirm.booleanValue()) {
            for (String triple : triples) {
                Tuple tuple = this.bindTuple(partial, triple, clause);
                result.add(tuple);
            }
        } else if (triples.size() == 0) {
            result.add(partial);
        }
        return result;
    }

    public Set<Tuple> selectFromRemainingClauses(Tuple partial, List<Clause> clauses) {
        HashSet<Tuple> result = new HashSet();
        Clause clause = clauses.get(0);
        clause = this.adjustClause(partial, clause);
        Set<Tuple> tuples = this.selectFromSingleClause(partial, clause, clause.getAffirm());
        if (clauses.size() > 1) {
            ArrayList<Clause> remainingClauses = new ArrayList<Clause>(clauses);
            remainingClauses.remove(0);
            for (Tuple tuple : tuples) {
                result.addAll(this.selectFromRemainingClauses(tuple, remainingClauses));
            }
        } else {
            result = tuples;
        }
        return result;
    }

    public int getIdCnt() {
        return this.idCnt;
    }

    public String getName() {
        return this.name;
    }

    public Chat getChatSession() {
        return this.chatSession;
    }

    public Bot getBot() {
        return this.bot;
    }

    public Map<String, Triple> getIdTriple() {
        return this.idTriple;
    }

    public Map<String, String> getTripleStringId() {
        return this.tripleStringId;
    }

    public Map<String, Set<String>> getSubjectTriples() {
        return this.subjectTriples;
    }

    public Map<String, Set<String>> getPredicateTriples() {
        return this.predicateTriples;
    }

    public Map<String, Set<String>> getObjectTriples() {
        return this.objectTriples;
    }

    public void setIdCnt(int idCnt) {
        this.idCnt = idCnt;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setChatSession(Chat chatSession) {
        this.chatSession = chatSession;
    }

    public void setBot(Bot bot) {
        this.bot = bot;
    }

    public void setIdTriple(Map<String, Triple> idTriple) {
        this.idTriple = idTriple;
    }

    public void setTripleStringId(Map<String, String> tripleStringId) {
        this.tripleStringId = tripleStringId;
    }

    public void setSubjectTriples(Map<String, Set<String>> subjectTriples) {
        this.subjectTriples = subjectTriples;
    }

    public void setPredicateTriples(Map<String, Set<String>> predicateTriples) {
        this.predicateTriples = predicateTriples;
    }

    public void setObjectTriples(Map<String, Set<String>> objectTriples) {
        this.objectTriples = objectTriples;
    }

    public class Triple {
        private String id;
        private String subject;
        private String predicate;
        private String object;

        public Triple(String s, String p, String o) {
            Bot bot = TripleStore.this.bot;
            if (bot != null) {
                s = bot.getPreProcessor().normalize(s);
                p = bot.getPreProcessor().normalize(p);
                o = bot.getPreProcessor().normalize(o);
            }
            if (s != null && p != null && o != null) {
                this.subject = s;
                this.predicate = p;
                this.object = o;
                this.id = TripleStore.this.name + TripleStore.this.idCnt++;
            }
        }

        public String getId() {
            return this.id;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getPredicate() {
            return this.predicate;
        }

        public String getObject() {
            return this.object;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public void setPredicate(String predicate) {
            this.predicate = predicate;
        }

        public void setObject(String object) {
            this.object = object;
        }
    }
}

