/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.utils.JapaneseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Predicates
extends HashMap<String, String> {
    private static final Logger log = LoggerFactory.getLogger(Predicates.class);

    @Override
    public String put(String key, String value) {
        if (MagicBooleans.jp_tokenize && key.equals("topic")) {
            value = JapaneseUtils.tokenizeSentence(value);
        }
        if (key.equals("topic") && value.length() == 0) {
            value = MagicStrings.default_get;
        }
        if (value.equals(MagicStrings.too_much_recursion)) {
            value = MagicStrings.default_list_item;
        }
        return super.put(key, value);
    }

    public String get(String key) {
        String result = (String)super.get(key);
        if (result == null) {
            result = MagicStrings.default_get;
        }
        return result != null ? result : MagicStrings.default_get;
    }

    private void getPredicateDefaultsFromInputStream(InputStream in) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String strLine;
            while ((strLine = br.readLine()) != null) {
                if (!strLine.contains(":")) continue;
                String property = strLine.substring(0, strLine.indexOf(":"));
                String value = strLine.substring(strLine.indexOf(":") + 1);
                this.put(property, value);
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
    }

    public void getPredicateDefaults(String filename) {
        block14: {
            try {
                File file = new File(filename);
                if (!file.exists()) break block14;
                try (FileInputStream stream = new FileInputStream(filename);){
                    this.getPredicateDefaultsFromInputStream(stream);
                }
            }
            catch (Exception e) {
                log.error("Error: ", (Throwable)e);
            }
        }
    }
}

