/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alicebot.ab.Bot;
import org.alicebot.ab.MagicNumbers;
import org.alicebot.ab.MagicStrings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreProcessor {
    private static final Logger log = LoggerFactory.getLogger(PreProcessor.class);
    private int normalCount = 0;
    private int denormalCount = 0;
    private int personCount = 0;
    private int person2Count = 0;
    private int genderCount = 0;
    private String[] normalSubs = new String[MagicNumbers.max_substitutions];
    private Pattern[] normalPatterns = new Pattern[MagicNumbers.max_substitutions];
    private String[] denormalSubs = new String[MagicNumbers.max_substitutions];
    private Pattern[] denormalPatterns = new Pattern[MagicNumbers.max_substitutions];
    private String[] personSubs = new String[MagicNumbers.max_substitutions];
    private Pattern[] personPatterns = new Pattern[MagicNumbers.max_substitutions];
    private String[] person2Subs = new String[MagicNumbers.max_substitutions];
    private Pattern[] person2Patterns = new Pattern[MagicNumbers.max_substitutions];
    private String[] genderSubs = new String[MagicNumbers.max_substitutions];
    private Pattern[] genderPatterns = new Pattern[MagicNumbers.max_substitutions];

    public PreProcessor(Bot bot) {
        this.normalCount = this.readSubstitutions(bot.getConfigPath() + "/normal.txt", this.normalPatterns, this.normalSubs);
        this.denormalCount = this.readSubstitutions(bot.getConfigPath() + "/denormal.txt", this.denormalPatterns, this.denormalSubs);
        this.personCount = this.readSubstitutions(bot.getConfigPath() + "/person.txt", this.personPatterns, this.personSubs);
        this.person2Count = this.readSubstitutions(bot.getConfigPath() + "/person2.txt", this.person2Patterns, this.person2Subs);
        this.genderCount = this.readSubstitutions(bot.getConfigPath() + "/gender.txt", this.genderPatterns, this.genderSubs);
        if (log.isTraceEnabled()) {
            log.trace("Preprocessor: {} norms {} persons {} person2 ", new Object[]{this.normalCount, this.personCount, this.person2Count});
        }
    }

    public String normalize(String request) {
        if (log.isDebugEnabled()) {
            log.debug("PreProcessor.normalize(request: {})", (Object)request);
        }
        String result = this.substitute(request, this.normalPatterns, this.normalSubs, this.normalCount);
        result = result.replaceAll("(\r\n|\n\r|\r|\n)", " ");
        if (log.isDebugEnabled()) {
            log.debug("PreProcessor.normalize() returning: {}", (Object)result);
        }
        return result;
    }

    public String denormalize(String request) {
        return this.substitute(request, this.denormalPatterns, this.denormalSubs, this.denormalCount);
    }

    public String person(String input) {
        return this.substitute(input, this.personPatterns, this.personSubs, this.personCount);
    }

    public String person2(String input) {
        return this.substitute(input, this.person2Patterns, this.person2Subs, this.person2Count);
    }

    public String gender(String input) {
        return this.substitute(input, this.genderPatterns, this.genderSubs, this.genderCount);
    }

    private String substitute(String request, Pattern[] patterns, String[] subs, int count) {
        String result = " " + request + " ";
        int index = 0;
        try {
            for (int i = 0; i < count; ++i) {
                index = i;
                String replacement = subs[i];
                Pattern p = patterns[i];
                Matcher m = p.matcher(result);
                if (!m.find()) continue;
                result = m.replaceAll(replacement);
            }
            while (result.contains("  ")) {
                result = result.replace("  ", " ");
            }
            result = result.trim();
        }
        catch (Exception e) {
            log.error("Request {} Result {} at {} {} {}", new Object[]{request, result, index, patterns[index], subs[index], e});
        }
        return result.trim();
    }

    public int readSubstitutionsFromInputStream(InputStream in, Pattern[] patterns, String[] subs) {
        int subCount = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String strLine;
            while ((strLine = reader.readLine()) != null) {
                Pattern pattern;
                Matcher matcher;
                if ((strLine = strLine.trim()).startsWith(MagicStrings.text_comment_mark) || !(matcher = (pattern = Pattern.compile("\"(.*?)\",\"(.*?)\"", 32)).matcher(strLine)).find() || subCount >= MagicNumbers.max_substitutions) continue;
                subs[subCount] = matcher.group(2);
                String quotedPattern = Pattern.quote(matcher.group(1));
                patterns[subCount] = Pattern.compile(quotedPattern, 2);
                ++subCount;
            }
        }
        catch (Exception e) {
            log.error("Error:", (Throwable)e);
        }
        return subCount;
    }

    private int readSubstitutions(String filename, Pattern[] patterns, String[] subs) {
        int subCount;
        block14: {
            subCount = 0;
            try {
                File file = new File(filename);
                if (!file.exists()) break block14;
                try (FileInputStream stream = new FileInputStream(filename);){
                    subCount = this.readSubstitutionsFromInputStream(stream, patterns, subs);
                }
            }
            catch (Exception e) {
                log.error("Error:", (Throwable)e);
            }
        }
        return subCount;
    }

    public String[] sentenceSplit(String line) {
        line = line.replace("\u3002", ".");
        line = line.replace("\uff1f", "?");
        line = line.replace("\uff01", "!");
        String[] result = line.split("[\\.!\\?]");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    public void normalizeFile(String infile, String outfile) {
        try (FileInputStream stream = new FileInputStream(infile);
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
             BufferedWriter writer = new BufferedWriter(new FileWriter(outfile));){
            String strLine;
            while ((strLine = reader.readLine()) != null) {
                if ((strLine = strLine.trim()).length() <= 0) continue;
                String norm = this.normalize(strLine).toUpperCase();
                String[] sentences = this.sentenceSplit(norm);
                if (sentences.length > 1) {
                    for (String s : sentences) {
                        log.info("{}-->{}", (Object)norm, (Object)s);
                    }
                }
                for (String sentence : sentences) {
                    if ((sentence = sentence.trim()).length() <= 0) continue;
                    writer.write(sentence);
                    writer.newLine();
                }
            }
        }
        catch (Exception e) {
            log.error("Error:", (Throwable)e);
        }
    }
}

