/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.util.Set;
import java.util.function.BiFunction;
import org.alicebot.ab.AIMLProcessor;
import org.alicebot.ab.AIMLProcessorExtension;
import org.alicebot.ab.Contact;
import org.alicebot.ab.ParseState;
import org.alicebot.ab.Path;
import org.alicebot.ab.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PCAIMLProcessorExtension
implements AIMLProcessorExtension {
    private static final Logger log = LoggerFactory.getLogger(Path.class);
    private Set<String> extensionTagNames = Utilities.stringSet("contactid", "multipleids", "displayname", "dialnumber", "emailaddress", "contactbirthday", "addinfo");

    @Override
    public Set<String> extensionTagSet() {
        return this.extensionTagNames;
    }

    private String newContact(Node node, ParseState ps) {
        NodeList childList = node.getChildNodes();
        String emailAddress = "unknown";
        String displayName = "unknown";
        String dialNumber = "unknown";
        String emailType = "unknown";
        String phoneType = "unknown";
        String birthday = "unknown";
        for (int i = 0; i < childList.getLength(); ++i) {
            if (childList.item(i).getNodeName().equals("birthday")) {
                birthday = AIMLProcessor.evalTagContent(childList.item(i), ps, null);
            }
            if (childList.item(i).getNodeName().equals("phonetype")) {
                phoneType = AIMLProcessor.evalTagContent(childList.item(i), ps, null);
            }
            if (childList.item(i).getNodeName().equals("emailtype")) {
                emailType = AIMLProcessor.evalTagContent(childList.item(i), ps, null);
            }
            if (childList.item(i).getNodeName().equals("dialnumber")) {
                dialNumber = AIMLProcessor.evalTagContent(childList.item(i), ps, null);
            }
            if (childList.item(i).getNodeName().equals("displayname")) {
                displayName = AIMLProcessor.evalTagContent(childList.item(i), ps, null);
            }
            if (!childList.item(i).getNodeName().equals("emailaddress")) continue;
            emailAddress = AIMLProcessor.evalTagContent(childList.item(i), ps, null);
        }
        Contact contact = new Contact(displayName, phoneType, dialNumber, emailType, emailAddress, birthday);
        return "";
    }

    private String contactId(Node node, ParseState ps) {
        String displayName = AIMLProcessor.evalTagContent(node, ps, null);
        return Contact.contactId(displayName);
    }

    private String multipleIds(Node node, ParseState ps) {
        String contactName = AIMLProcessor.evalTagContent(node, ps, null);
        return Contact.multipleIds(contactName);
    }

    private String displayName(Node node, ParseState ps) {
        String id = AIMLProcessor.evalTagContent(node, ps, null);
        return Contact.displayName(id);
    }

    private String dialNumber(Node node, ParseState ps) {
        return this.getDetails(node, ps, Contact::dialNumber);
    }

    private String emailAddress(Node node, ParseState ps) {
        return this.getDetails(node, ps, Contact::emailAddress);
    }

    private String getDetails(Node node, ParseState ps, BiFunction<String, String, String> getter) {
        NodeList childList = node.getChildNodes();
        String id = "unknown";
        String type = "unknown";
        for (int i = 0; i < childList.getLength(); ++i) {
            if (childList.item(i).getNodeName().equals("id")) {
                id = AIMLProcessor.evalTagContent(childList.item(i), ps, null);
            }
            if (!childList.item(i).getNodeName().equals("type")) continue;
            type = AIMLProcessor.evalTagContent(childList.item(i), ps, null);
        }
        return getter.apply(type, id);
    }

    private String contactBirthday(Node node, ParseState ps) {
        String id = AIMLProcessor.evalTagContent(node, ps, null);
        return Contact.birthday(id);
    }

    @Override
    public String recursEval(Node node, ParseState ps) {
        try {
            String nodeName;
            switch (nodeName = node.getNodeName()) {
                case "contactid": {
                    return this.contactId(node, ps);
                }
                case "multipleids": {
                    return this.multipleIds(node, ps);
                }
                case "dialnumber": {
                    return this.dialNumber(node, ps);
                }
                case "addinfo": {
                    return this.newContact(node, ps);
                }
                case "displayname": {
                    return this.displayName(node, ps);
                }
                case "emailaddress": {
                    return this.emailAddress(node, ps);
                }
                case "contactbirthday": {
                    return this.contactBirthday(node, ps);
                }
            }
            return AIMLProcessor.genericXML(node, ps);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return "";
        }
    }
}

