/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.alicebot.ab.Nodemapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodemapperOperator {
    private static final Logger log = LoggerFactory.getLogger(NodemapperOperator.class);

    public static int size(Nodemapper node) {
        HashSet<String> set = new HashSet<String>();
        if (node.isShortCut()) {
            set.add("<THAT>");
        }
        if (node.getKey() != null) {
            set.add(node.getKey());
        }
        if (node.getMap() != null) {
            set.addAll(node.getMap().keySet());
        }
        return set.size();
    }

    public static void put(Nodemapper node, String key, Nodemapper value) {
        if (node.getMap() != null) {
            node.getMap().put(key, value);
        } else {
            node.setKey(key);
            node.setValue(value);
        }
    }

    public static Nodemapper get(Nodemapper node, String key) {
        if (node.getMap() != null) {
            return node.getMap().get(key);
        }
        if (key.equals(node.getKey())) {
            return node.getValue();
        }
        return null;
    }

    public static boolean containsKey(Nodemapper node, String key) {
        if (node.getMap() != null) {
            return node.getMap().containsKey(key);
        }
        return key.equals(node.getKey());
    }

    public static void printKeys(Nodemapper node) {
        NodemapperOperator.keySet(node).forEach(e -> log.info("{}", e));
    }

    public static Set<String> keySet(Nodemapper node) {
        if (node.getMap() != null) {
            return node.getMap().keySet();
        }
        HashSet<String> set = new HashSet<String>();
        if (node.getKey() != null) {
            set.add(node.getKey());
        }
        return set;
    }

    public static boolean isLeaf(Nodemapper node) {
        return node.getCategory() != null;
    }

    public static void upgrade(Nodemapper node) {
        node.setMap(new HashMap<String, Nodemapper>());
        node.getMap().put(node.getKey(), node.getValue());
        node.setKey(null);
        node.setValue(null);
    }
}

