/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Contact {
    private static AtomicLong contactCount = new AtomicLong();
    private static Map<String, Contact> idContactMap = new ConcurrentHashMap<String, Contact>();
    private static Map<String, String> nameIdMap = new ConcurrentHashMap<String, String>();
    private String contactId = "ID" + contactCount.incrementAndGet();
    private String displayName;
    private String birthday;
    private Map<String, String> phones = new HashMap<String, String>();
    private Map<String, String> emails = new HashMap<String, String>();

    public static String multipleIds(String contactName) {
        String patternString = " (" + contactName.toUpperCase() + ") ";
        while (patternString.contains(" ")) {
            patternString = patternString.replace(" ", "(.*)");
        }
        Pattern pattern = Pattern.compile(patternString);
        Set<String> keys = nameIdMap.keySet();
        StringBuilder result = new StringBuilder();
        int idCount = 0;
        for (String key : keys) {
            Matcher m = pattern.matcher(key);
            if (!m.find()) continue;
            result.append(nameIdMap.get(key.toUpperCase())).append(" ");
            ++idCount;
        }
        if (idCount <= 1) {
            return "false";
        }
        return result.toString().trim();
    }

    public static String contactId(String contactName) {
        String patternString = " " + contactName.toUpperCase() + " ";
        while (patternString.contains(" ")) {
            patternString = patternString.replace(" ", ".*");
        }
        Pattern pattern = Pattern.compile(patternString);
        Set<String> keys = nameIdMap.keySet();
        for (String key : keys) {
            Matcher m = pattern.matcher(key);
            if (!m.find()) continue;
            return nameIdMap.get(key.toUpperCase()).trim();
        }
        return "unknown";
    }

    public static String displayName(String id) {
        Contact c = idContactMap.get(id.toUpperCase());
        String result = "unknown";
        if (c != null) {
            result = c.displayName;
        }
        return result;
    }

    public static String dialNumber(String type, String id) {
        String dialNumber;
        String result = "unknown";
        Contact c = idContactMap.get(id.toUpperCase());
        if (c != null && (dialNumber = c.phones.get(type.toUpperCase())) != null) {
            result = dialNumber;
        }
        return result;
    }

    public static String emailAddress(String type, String id) {
        String emailAddress;
        String result = "unknown";
        Contact c = idContactMap.get(id.toUpperCase());
        if (c != null && (emailAddress = c.emails.get(type.toUpperCase())) != null) {
            result = emailAddress;
        }
        return result;
    }

    public static String birthday(String id) {
        Contact c = idContactMap.get(id.toUpperCase());
        if (c == null) {
            return "unknown";
        }
        return c.birthday;
    }

    public Contact(String displayName, String phoneType, String dialNumber, String emailType, String emailAddress, String birthday) {
        idContactMap.put(this.contactId.toUpperCase(), this);
        this.addPhone(phoneType, dialNumber);
        this.addEmail(emailType, emailAddress);
        this.addName(displayName);
        this.addBirthday(birthday);
    }

    public void addPhone(String type, String dialNumber) {
        this.phones.put(type.toUpperCase(), dialNumber);
    }

    public void addEmail(String type, String emailAddress) {
        this.emails.put(type.toUpperCase(), emailAddress);
    }

    public void addName(String name) {
        this.displayName = name;
        nameIdMap.put(this.displayName.toUpperCase(), this.contactId);
    }

    public void addBirthday(String birthday) {
        this.birthday = birthday;
    }
}

