/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.alicebot.ab.AIMLProcessor;
import org.alicebot.ab.Bot;
import org.alicebot.ab.History;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicNumbers;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.Predicates;
import org.alicebot.ab.TripleStore;
import org.alicebot.ab.utils.IOUtils;
import org.alicebot.ab.utils.JapaneseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chat {
    private static final Logger log = LoggerFactory.getLogger(Chat.class);
    private final Bot bot;
    private boolean doWrites;
    private String customerId = MagicStrings.default_Customer_id;
    private History<History> thatHistory = new History("that");
    private History<String> requestHistory = new History("request");
    private History<String> responseHistory = new History("response");
    private History<String> inputHistory = new History("input");
    private Predicates predicates = new Predicates();
    private TripleStore tripleStore = new TripleStore("anon", this);

    public Chat(Bot bot) {
        this(bot, true, "0");
    }

    public Chat(Bot bot, boolean doWrites) {
        this(bot, doWrites, "0");
    }

    public Chat(Bot bot, boolean doWrites, String customerId) {
        this.customerId = customerId;
        this.bot = bot;
        this.doWrites = doWrites;
        History<String> contextThatHistory = new History<String>();
        contextThatHistory.add(MagicStrings.default_that);
        this.thatHistory.add(contextThatHistory);
        this.addPredicates();
        this.addTriples();
        this.predicates.put("topic", MagicStrings.default_topic);
        this.predicates.put("jsenabled", MagicStrings.js_enabled);
        if (log.isTraceEnabled()) {
            log.trace("Chat Session Created for bot {}", (Object)bot.getName());
        }
    }

    private void addPredicates() {
        try {
            this.predicates.getPredicateDefaults(this.bot.getConfigPath() + "/predicates.txt");
        }
        catch (Exception e) {
            log.warn("Error reading predicates", (Throwable)e);
        }
    }

    private int addTriples() {
        File f;
        int count = 0;
        String fileName = this.bot.getConfigPath() + "/triples.txt";
        if (log.isTraceEnabled()) {
            log.trace("Loading Triples from {}", (Object)fileName);
        }
        if ((f = new File(fileName)).exists()) {
            try (FileInputStream is = new FileInputStream(f);
                 BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String strLine;
                while ((strLine = br.readLine()) != null) {
                    String[] triple = strLine.split(":");
                    if (triple.length < 3) continue;
                    String subject = triple[0];
                    String predicate = triple[1];
                    String object = triple[2];
                    this.tripleStore.addTriple(subject, predicate, object);
                    ++count;
                }
            }
            catch (Exception e) {
                log.warn("Error reading triples", (Throwable)e);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Loaded {} triples", (Object)count);
        }
        return count;
    }

    public void chat() {
        try {
            String request = "SET PREDICATES";
            String response = this.multisentenceRespond(request);
            while (!"quit".equals(request)) {
                log.info("Human: ");
                request = IOUtils.readInputTextLine();
                response = this.multisentenceRespond(request);
                log.info("Robot: {}", (Object)response);
            }
        }
        catch (Exception e) {
            log.warn("Error: ", (Throwable)e);
        }
    }

    private String respond(String input, String that, String topic, History<String> contextThatHistory) {
        String[] sentences;
        boolean repetition = true;
        for (int i = 0; i < MagicNumbers.repetition_count; ++i) {
            if (this.inputHistory.get(i) != null && input.toUpperCase().equals(this.inputHistory.get(i).toUpperCase())) continue;
            repetition = false;
        }
        if (input.equals(MagicStrings.null_input)) {
            repetition = false;
        }
        this.inputHistory.add(input);
        if (repetition) {
            input = MagicStrings.repetition_detected;
        }
        String response = AIMLProcessor.respond(input, that, topic, this);
        String normResponse = this.bot.getPreProcessor().normalize(response);
        if (MagicBooleans.jp_tokenize) {
            normResponse = JapaneseUtils.tokenizeSentence(normResponse);
        }
        for (String s : sentences = this.bot.getPreProcessor().sentenceSplit(normResponse)) {
            if (s.trim().equals("")) {
                s = MagicStrings.default_that;
            }
            contextThatHistory.add(s);
        }
        return response.trim() + " ";
    }

    private String respond(String input, History<String> contextThatHistory) {
        History hist = this.thatHistory.get(0);
        String that = hist != null ? hist.getString(0) : MagicStrings.default_that;
        return this.respond(input, that, this.predicates.get("topic"), contextThatHistory);
    }

    public String multisentenceRespond(String request) {
        StringBuilder response = new StringBuilder();
        try {
            String normalized = this.bot.getPreProcessor().normalize(request);
            if (MagicBooleans.jp_tokenize) {
                normalized = JapaneseUtils.tokenizeSentence(normalized);
            }
            String[] sentences = this.bot.getPreProcessor().sentenceSplit(normalized);
            History<String> contextThatHistory = new History<String>("contextThat");
            for (String sentence : sentences) {
                String reply = this.respond(sentence, contextThatHistory);
                response.append(" ").append(reply);
            }
            String result = response.toString();
            this.requestHistory.add(request);
            this.responseHistory.add(result);
            this.thatHistory.add(contextThatHistory);
            result = result.replaceAll("[\n]+", "\n");
            result = result.trim();
            if (this.doWrites) {
                this.bot.writeLearnfIFCategories();
            }
            return result;
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return MagicStrings.error_bot_response;
        }
    }

    public Bot getBot() {
        return this.bot;
    }

    public boolean isDoWrites() {
        return this.doWrites;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public History<History> getThatHistory() {
        return this.thatHistory;
    }

    public History<String> getRequestHistory() {
        return this.requestHistory;
    }

    public History<String> getResponseHistory() {
        return this.responseHistory;
    }

    public History<String> getInputHistory() {
        return this.inputHistory;
    }

    public Predicates getPredicates() {
        return this.predicates;
    }

    public TripleStore getTripleStore() {
        return this.tripleStore;
    }

    public void setDoWrites(boolean doWrites) {
        this.doWrites = doWrites;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public void setThatHistory(History<History> thatHistory) {
        this.thatHistory = thatHistory;
    }

    public void setRequestHistory(History<String> requestHistory) {
        this.requestHistory = requestHistory;
    }

    public void setResponseHistory(History<String> responseHistory) {
        this.responseHistory = responseHistory;
    }

    public void setInputHistory(History<String> inputHistory) {
        this.inputHistory = inputHistory;
    }

    public void setPredicates(Predicates predicates) {
        this.predicates = predicates;
    }

    public void setTripleStore(TripleStore tripleStore) {
        this.tripleStore = tripleStore;
    }
}

